/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.test.tools;

import com.questdb.model.Quote;
import com.questdb.model.TestEntity;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.printer.JournalPrinter;
import com.questdb.printer.appender.AssertingAppender;
import com.questdb.printer.converter.DateConverter;
import com.questdb.ql.RecordSource;
import com.questdb.std.BinarySequence;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.std.NumericException;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.Dates;
import com.questdb.store.Interval;
import com.questdb.store.Journal;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.KVIndex;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.store.Partition;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.RecordMetadata;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.query.OrderedResultSet;
import com.questdb.store.query.ResultSet;
import com.questdb.store.query.iter.JournalIterator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;

public final class TestUtils {
    private TestUtils() {
    }

    public static void assertContains(CharSequence _this, CharSequence that) {
        if (Chars.contains((CharSequence)_this, (CharSequence)that)) {
            return;
        }
        Assert.fail((String)("'" + _this.toString() + "' does not contain: " + that));
    }

    public static void assertCounter(AtomicInteger counter, int value, long timeout, TimeUnit unit) {
        long t = System.currentTimeMillis();
        while (counter.get() < value && System.currentTimeMillis() - t < unit.toMillis(timeout)) {
            LockSupport.parkNanos(10000L);
        }
        Assert.assertEquals((long)value, (long)counter.get());
    }

    public static <T> void assertDataEquals(Journal<T> expected, Journal<T> actual) throws JournalException {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        OrderedResultSet er = expected.query().all().asResultSet();
        OrderedResultSet ar = actual.query().all().asResultSet();
        for (int i = 0; i < er.size(); ++i) {
            Assert.assertEquals((Object)er.read(i), (Object)ar.read(i));
        }
    }

    public static <T> void assertEquals(String expected, ResultSet<T> rs) {
        TestUtils.assertEquals(expected, rs.bufferedIterator());
    }

    public static <T> void assertEquals(String expected, JournalIterator<T> actual) {
        try (JournalPrinter p = new JournalPrinter();){
            p.setAppender(new AssertingAppender(expected));
            TestUtils.configure(p, actual.getJournal().getMetadata());
            TestUtils.out(p, actual);
        }
    }

    public static <T> void assertEquals(Journal<T> expected, Journal<T> actual) throws JournalException {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Assert.assertEquals((long)expected.getPartitionCount(), (long)actual.getPartitionCount());
        IntList colKeyCount = new IntList();
        for (int k = 0; k < expected.getMetadata().getColumnCount(); ++k) {
            MMappedSymbolTable et = expected.getMetadata().getColumnQuick((int)k).symbolTable;
            MMappedSymbolTable at = actual.getMetadata().getColumnQuick((int)k).symbolTable;
            if (et == null && at == null) continue;
            if (et == null || at == null) {
                Assert.fail((String)"SymbolTable mismatch");
            }
            Assert.assertEquals((long)et.size(), (long)at.size());
            colKeyCount.extendAndSet(k, et.size());
            for (int i = 0; i < et.size(); ++i) {
                String ev = et.value(i);
                String av = at.value(i);
                Assert.assertEquals((Object)ev, (Object)av);
                Assert.assertEquals((long)et.getQuick((CharSequence)ev), (long)at.getQuick((CharSequence)av));
            }
        }
        LongList ev = new LongList();
        LongList av = new LongList();
        for (int i = 0; i < expected.getPartitionCount(); ++i) {
            int k;
            Partition ep = expected.getPartition(i, true);
            Partition ap = actual.getPartition(i, true);
            Assert.assertEquals((Object)ep.getName(), (Object)ap.getName());
            Assert.assertEquals((long)ep.size(), (long)ap.size());
            if (ep != expected.getIrregularPartition() || ap != actual.getIrregularPartition()) {
                Assert.assertEquals((String)("Interval mismatch. partition=" + i), (Object)ep.getInterval(), (Object)ap.getInterval());
            }
            for (k = 0; k < expected.getMetadata().getColumnCount(); ++k) {
                if (!expected.getMetadata().getColumnQuick((int)k).indexed) continue;
                KVIndex ei = ep.getIndexForColumn(k);
                KVIndex ai = ap.getIndexForColumn(k);
                int count = colKeyCount.getQuick(k);
                for (int j = 0; j < count; ++j) {
                    ev.clear();
                    av.clear();
                    ei.getValues(j, ev);
                    ai.getValues(j, av);
                    Assert.assertEquals((String)("Values mismatch. partition=" + i + ",column=" + expected.getMetadata().getColumnQuick((int)k).name + ", key=" + j + ": "), (long)ev.size(), (long)av.size());
                    for (int l = 0; l < ev.size(); ++l) {
                        Assert.assertEquals((long)ev.get(l), (long)av.get(l));
                    }
                }
            }
            k = 0;
            while ((long)k < ep.size()) {
                Assert.assertEquals((Object)ep.read((long)k), (Object)ap.read((long)k));
                ++k;
            }
        }
    }

    public static <T> void assertEquals(Iterator<T> expected, Iterator<T> actual) {
        while (true) {
            boolean expectedHasNext = expected.hasNext();
            boolean actualHasNext = actual.hasNext();
            Assert.assertEquals((Object)expectedHasNext, (Object)actualHasNext);
            if (!expectedHasNext) break;
            Assert.assertEquals(expected.next(), actual.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertEquals(File a, File b) throws IOException {
        try (RandomAccessFile rafA = new RandomAccessFile(a, "r");
             RandomAccessFile rafB = new RandomAccessFile(b, "r");
             FileChannel chA = rafA.getChannel();
             FileChannel chB = rafB.getChannel();){
            Assert.assertEquals((long)chA.size(), (long)chB.size());
            MappedByteBuffer bufA = chA.map(FileChannel.MapMode.READ_ONLY, 0L, chA.size());
            try {
                MappedByteBuffer bufB = chB.map(FileChannel.MapMode.READ_ONLY, 0L, chB.size());
                try {
                    long pa = ByteBuffers.getAddress((ByteBuffer)bufA);
                    long pb = ByteBuffers.getAddress((ByteBuffer)bufB);
                    long lim = pa + (long)bufA.limit();
                    while (pa + 8L < lim) {
                        if (Unsafe.getUnsafe().getLong(pa) != Unsafe.getUnsafe().getLong(pb)) {
                            Assert.fail();
                        }
                        pa += 8L;
                        pb += 8L;
                    }
                    while (pa < lim) {
                        if (Unsafe.getUnsafe().getByte(pa++) == Unsafe.getUnsafe().getByte(pb++)) continue;
                        Assert.fail();
                    }
                }
                finally {
                    ByteBuffers.release((ByteBuffer)bufB);
                }
            }
            finally {
                ByteBuffers.release((ByteBuffer)bufA);
            }
        }
    }

    public static void assertEquals(CharSequence expected, CharSequence actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && actual == null) {
            Assert.fail((String)("Expected: \n`" + expected + "`but have NULL"));
        }
        if (expected == null) {
            Assert.fail((String)("Expected: NULL but have \n`" + actual + "`\n"));
        }
        if (expected.length() != actual.length()) {
            Assert.fail((String)("Expected: \n`" + expected + "`\n but have \n`" + actual + "`\n (length: " + expected.length() + " vs " + actual.length() + ")"));
        }
        Assert.assertEquals((long)expected.length(), (long)actual.length());
        for (int i = 0; i < expected.length(); ++i) {
            if (expected.charAt(i) == actual.charAt(i)) continue;
            Assert.fail((String)("At: " + i + ". Expected: `" + expected + "`, actual: `" + actual + '`'));
        }
    }

    public static void assertEquals(BinarySequence bs, BinarySequence actBs, long actualLen) {
        if (bs == null) {
            Assert.assertNull((Object)actBs);
            Assert.assertEquals((long)-1L, (long)actualLen);
        } else {
            Assert.assertEquals((long)bs.length(), (long)actBs.length());
            Assert.assertEquals((long)bs.length(), (long)actualLen);
            long z = bs.length();
            for (long l = 0L; l < z; ++l) {
                byte b2;
                byte b1 = bs.byteAt(l);
                if (b1 != (b2 = actBs.byteAt(l))) {
                    Assert.fail((String)("Failed comparison at [" + l + "], expected: " + b1 + ", actual: " + b2));
                }
                Assert.assertEquals((long)bs.byteAt(l), (long)actBs.byteAt(l));
            }
        }
    }

    public static void assertMemoryLeak(LeakProneCode runnable) throws Exception {
        long mem = Unsafe.getMemUsed();
        long fileCount = Files.getOpenFileCount();
        runnable.run();
        Assert.assertEquals((long)mem, (long)Unsafe.getMemUsed());
        Assert.assertEquals((long)fileCount, (long)Files.getOpenFileCount());
    }

    public static <T> void assertOrder(JournalIterator<T> rs) {
        ColumnMetadata meta = rs.getJournal().getMetadata().getTimestampMetadata();
        long max = 0L;
        for (Object obj : rs) {
            long timestamp = Unsafe.getUnsafe().getLong(obj, meta.offset);
            if (timestamp < max) {
                throw new AssertionError((Object)("Timestamp out of order. [ " + Dates.toString((long)timestamp) + " < " + Dates.toString((long)max) + "]"));
            }
            max = timestamp;
        }
    }

    public static <T> void assertOrderDesc(JournalIterator<T> rs) {
        ColumnMetadata meta = rs.getJournal().getMetadata().getTimestampMetadata();
        long max = Long.MAX_VALUE;
        for (Object obj : rs) {
            long timestamp = Unsafe.getUnsafe().getLong(obj, meta.offset);
            if (timestamp > max) {
                throw new AssertionError((Object)("Timestamp out of order. [ " + Dates.toString((long)timestamp) + " > " + Dates.toString((long)max) + "]"));
            }
            max = timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertStrings(RecordSource src, ReaderFactory factory) {
        RecordCursor cursor = src.prepareCursor(factory);
        try {
            RecordMetadata metadata = src.getMetadata();
            int len = metadata.getColumnCount();
            Assert.assertTrue((boolean)cursor.hasNext());
            do {
                Record r = (Record)cursor.next();
                for (int i = 0; i < len; ++i) {
                    if (metadata.getColumnQuick(i).getType() != 7) continue;
                    CharSequence s = r.getFlyweightStr(i);
                    TestUtils.assertEquals(s, r.getFlyweightStrB(i));
                    if (s != null) {
                        Assert.assertEquals((long)s.length(), (long)r.getStrLen(i));
                        continue;
                    }
                    Assert.assertEquals((long)-1L, (long)r.getStrLen(i));
                }
            } while (cursor.hasNext());
        }
        finally {
            cursor.releaseCursor();
        }
    }

    public static void compareSymbolTables(Journal a, Journal b) {
        for (int i = 0; i < a.getMetadata().getColumnCount(); ++i) {
            MMappedSymbolTable m = a.getMetadata().getColumnQuick((int)i).symbolTable;
            if (m == null) continue;
            MMappedSymbolTable s = b.getMetadata().getColumnQuick((int)i).symbolTable;
            for (MMappedSymbolTable.Entry e : m.values()) {
                Assert.assertEquals((long)m.getQuick(e.value), (long)s.getQuick(e.value));
            }
        }
    }

    public static void generateQuoteData(JournalWriter<Quote> w, int count) throws JournalException, NumericException {
        String[] symbols = new String[]{"AGK.L", "BP.L", "TLW.L", "ABF.L", "LLOY.L", "BT-A.L", "WTB.L", "RRS.L", "ADM.L", "GKN.L", "HSBA.L"};
        long[] timestamps = new long[]{DateFormatUtils.parseDateTime((CharSequence)"2013-09-04T10:00:00.000Z"), DateFormatUtils.parseDateTime((CharSequence)"2013-10-04T10:00:00.000Z"), DateFormatUtils.parseDateTime((CharSequence)"2013-11-04T10:00:00.000Z")};
        Quote q = new Quote();
        Rnd r = new Rnd();
        for (int i = 0; i < count; ++i) {
            q.clear();
            q.setSym(symbols[Math.abs(r.nextInt() % symbols.length)]);
            q.setAsk(Math.abs(r.nextDouble()));
            q.setBid(Math.abs(r.nextDouble()));
            q.setAskSize(Math.abs(r.nextInt()));
            q.setBidSize(Math.abs(r.nextInt()));
            q.setEx("LXE");
            q.setMode("Fast trading");
            q.setTimestamp(timestamps[i * timestamps.length / count]);
            w.append((Object)q);
        }
        w.commit();
    }

    public static void generateQuoteData(JournalWriter<Quote> w, int count, long timestamp) throws JournalException {
        TestUtils.generateQuoteData(w, count, timestamp, 0L);
    }

    public static void generateQuoteData(JournalWriter<Quote> w, int count, long timestamp, long increment) throws JournalException {
        String[] symbols = new String[]{"AGK.L", "BP.L", "TLW.L", "ABF.L", "LLOY.L", "BT-A.L", "WTB.L", "RRS.L", "ADM.L", "GKN.L", "HSBA.L"};
        Quote q = new Quote();
        Rnd r = new Rnd();
        for (int i = 0; i < count; ++i) {
            q.clear();
            q.setSym(symbols[Math.abs(r.nextInt() % (symbols.length - 1))]);
            q.setAsk(Math.abs(r.nextDouble()));
            q.setBid(Math.abs(r.nextDouble()));
            q.setAskSize(Math.abs(r.nextInt()));
            q.setBidSize(Math.abs(r.nextInt()));
            q.setEx("LXE");
            q.setMode("Fast trading");
            q.setTimestamp(timestamp);
            timestamp += increment;
            w.append((Object)q);
        }
    }

    public static void generateQuoteData(JournalWriter<Quote> w, int count, Interval interval) throws JournalException {
        TestUtils.generateQuoteData(w, count, interval, true);
    }

    public static void generateQuoteData(JournalWriter<Quote> w, int count, Interval interval, boolean commit) throws JournalException {
        long span = interval.getHi() - interval.getLo();
        long inc = span / (long)count;
        long lo = interval.getLo();
        Rnd r = new Rnd();
        for (int i = 0; i < count; ++i) {
            String[] symbols = new String[]{"AGK.L", "BP.L", "TLW.L", "ABF.L", "LLOY.L", "BT-A.L", "WTB.L", "RRS.L", "ADM.L", "GKN.L", "HSBA.L"};
            Quote q = new Quote();
            q.clear();
            q.setSym(symbols[Math.abs(r.nextInt() % (symbols.length - 1))]);
            q.setAsk(Math.abs(r.nextDouble()));
            q.setBid(Math.abs(r.nextDouble()));
            q.setAskSize(Math.abs(r.nextInt()));
            q.setBidSize(Math.abs(r.nextInt()));
            q.setEx("LXE");
            q.setMode("Fast trading");
            q.setTimestamp(lo);
            w.append((Object)q);
            lo += inc;
        }
        if (commit) {
            w.commit();
        }
    }

    public static void generateQuoteData2(JournalWriter<Quote> w, int count, long timestamp, long increment) throws JournalException {
        String[] symbols = new String[]{"AGK.L", "BP.L", "TLW.L", "ABF.L", "LLOY.L", "BT-A.L", "WTB.L", "RRS.L", "ADM.L", "GKN.L", "HSBA.L"};
        Rnd r = new Rnd();
        int n = symbols.length - 1;
        for (int i = 0; i < count; ++i) {
            JournalEntryWriter ew = w.entryWriter();
            ew.putDate(0, timestamp);
            ew.putSym(1, (CharSequence)symbols[Math.abs(r.nextInt() % n)]);
            ew.putDouble(2, Math.abs(r.nextDouble()));
            ew.putDouble(3, Math.abs(r.nextDouble()));
            ew.putInt(4, Math.abs(r.nextInt()));
            ew.putInt(5, Math.abs(r.nextInt()));
            ew.putSym(6, (CharSequence)"LXE");
            ew.putSym(7, (CharSequence)"Fast trading");
            ew.append();
            timestamp += increment;
        }
    }

    public static void generateQuoteDataGeneric(JournalWriter w, int count, long timestamp, long increment) throws JournalException {
        String[] symbols = new String[]{"AGK.L", "BP.L", "TLW.L", "ABF.L", "LLOY.L", "BT-A.L", "WTB.L", "RRS.L", "ADM.L", "GKN.L", "HSBA.L"};
        Rnd r = new Rnd();
        for (int i = 0; i < count; ++i) {
            JournalEntryWriter ew = w.entryWriter(timestamp);
            ew.putSym(0, (CharSequence)symbols[Math.abs(r.nextInt() % (symbols.length - 1))]);
            ew.putDouble(1, Math.abs(r.nextDouble()));
            ew.putDouble(2, Math.abs(r.nextDouble()));
            ew.putInt(3, Math.abs(r.nextInt()));
            ew.putInt(4, Math.abs(r.nextInt()));
            ew.putSym(5, (CharSequence)"LXE");
            ew.putSym(6, (CharSequence)"Fast trading");
            ew.append();
            timestamp += increment;
        }
    }

    public static void generateTestEntityData(JournalWriter<TestEntity> w, int count, long timetamp, int increment) throws JournalException {
        String[] symbols = new String[]{"AGK.L", "BP.L", "TLW.L", "ABF.L", "LLOY.L", "BT-A.L", "WTB.L", "RRS.L", "ADM.L", "GKN.L", "HSBA.L", null};
        Rnd r = new Rnd();
        for (int i = 0; i < count; ++i) {
            TestEntity e = new TestEntity();
            e.setSym(symbols[Math.abs(r.nextInt() % symbols.length)]);
            e.setAnInt(Math.abs(r.nextInt()));
            e.setADouble(Math.abs(r.nextDouble()));
            e.setBStr(UUID.randomUUID().toString());
            e.setDStr(UUID.randomUUID().toString());
            e.setDwStr(UUID.randomUUID().toString());
            e.setTimestamp(timetamp);
            timetamp += (long)increment;
            w.append((Object)e);
        }
        w.commit();
    }

    public static void generateTestEntityData(JournalWriter<TestEntity> w, int count) throws JournalException, NumericException {
        TestUtils.generateTestEntityData(w, count, DateFormatUtils.parseDateTime((CharSequence)"2012-05-15T10:55:00.000Z"), count * 100);
    }

    public static long toMemory(CharSequence sequence) {
        long ptr = Unsafe.malloc((long)sequence.length());
        Chars.strcpy((CharSequence)sequence, (int)sequence.length(), (long)ptr);
        return ptr;
    }

    public static String toRpn(ExprNode node) {
        switch (node.paramCount) {
            case 0: {
                return node.token;
            }
            case 1: {
                return TestUtils.toRpn(node.rhs) + node.token;
            }
            case 2: {
                return TestUtils.toRpn(node.lhs) + TestUtils.toRpn(node.rhs) + node.token;
            }
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < node.paramCount; ++i) {
            result.insert(0, TestUtils.toRpn((ExprNode)node.args.getQuick(i)));
        }
        return result + node.token;
    }

    private static void configure(JournalPrinter p, JournalMetadata meta) {
        p.types(meta.getModelClass());
        for (int i = 0; i < meta.getColumnCount(); ++i) {
            ColumnMetadata m = meta.getColumnQuick(i);
            if (m.offset == 0L) continue;
            JournalPrinter.Field f = p.f(m.name);
            if (m.type != 10) continue;
            f.c(new DateConverter(p));
        }
    }

    private static <T> void out(JournalPrinter p, JournalIterator<T> iterator) {
        for (Object o : iterator) {
            p.out(o);
        }
    }

    @FunctionalInterface
    public static interface LeakProneCode {
        public void run() throws Exception;
    }
}

