/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.test.tools;

import com.questdb.std.ByteBuffers;
import com.questdb.std.NetworkChannel;
import com.questdb.std.Unsafe;
import com.questdb.test.tools.TestUtils;
import java.nio.ByteBuffer;

public class TestChannel
implements NetworkChannel {
    private final long reqAddress;
    private final int reqLen;
    private final StringBuilder sb = new StringBuilder();
    private final StringBuilder lenBuilder = new StringBuilder();
    private boolean fullyRead = false;
    private boolean contentStarted = false;
    private int newLineCount = 0;
    private long contentLen = 0L;
    private long contentReadLen = 0L;
    private boolean outOfChunk = true;
    private boolean ignoreNext = false;

    public TestChannel(CharSequence request) {
        this.reqAddress = TestUtils.toMemory(request);
        this.reqLen = request.length();
    }

    public void free() {
        Unsafe.free((long)this.reqAddress, (long)this.reqLen);
    }

    public long getFd() {
        return 0L;
    }

    public long getIp() {
        return 0L;
    }

    public long getTotalWrittenAndReset() {
        return 0L;
    }

    public CharSequence getOutput() {
        return this.sb;
    }

    public boolean isOpen() {
        return false;
    }

    public void close() {
        this.reset();
    }

    public int read(ByteBuffer dst) {
        if (!this.fullyRead) {
            Unsafe.getUnsafe().copyMemory(this.reqAddress, ByteBuffers.getAddress((ByteBuffer)dst), this.reqLen);
            dst.position(this.reqLen);
            this.fullyRead = true;
            return this.reqLen;
        }
        return 0;
    }

    public void reset() {
        this.sb.setLength(0);
        this.lenBuilder.setLength(0);
        this.fullyRead = false;
        this.contentStarted = false;
        this.newLineCount = 0;
        this.contentLen = 0L;
        this.contentReadLen = 0L;
        this.outOfChunk = true;
        this.ignoreNext = false;
    }

    public int write(ByteBuffer src) {
        int count = src.remaining();
        block8: while (src.hasRemaining()) {
            char c = (char)src.get();
            switch (c) {
                case '\r': {
                    break;
                }
                case '\n': {
                    if (!this.contentStarted) {
                        ++this.newLineCount;
                    }
                    if (this.newLineCount != 2) break;
                    this.contentStarted = true;
                    break;
                }
                default: {
                    if (this.contentStarted) break;
                    this.newLineCount = 0;
                }
            }
            if (!this.contentStarted) continue;
            if (this.ignoreNext) {
                this.ignoreNext = false;
                continue;
            }
            switch (c) {
                case '\r': {
                    if (this.outOfChunk) {
                        this.contentReadLen = 0L;
                        this.contentLen = Long.parseLong(this.lenBuilder.toString().toUpperCase(), 16);
                        this.ignoreNext = true;
                        this.outOfChunk = false;
                        continue block8;
                    }
                    if (this.contentReadLen < this.contentLen) break;
                    this.lenBuilder.setLength(0);
                    this.outOfChunk = true;
                    this.ignoreNext = true;
                    continue block8;
                }
                case '\n': {
                    if (!this.outOfChunk) break;
                    continue block8;
                }
            }
            if (this.outOfChunk) {
                this.lenBuilder.append(c);
                continue;
            }
            this.sb.append(c);
            ++this.contentReadLen;
        }
        return count;
    }
}

