/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.test.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;

public class HttpTestUtils {
    public static HttpClientBuilder clientBuilder(boolean ssl) throws Exception {
        return ssl ? HttpTestUtils.createHttpClient_AcceptsUntrustedCerts() : HttpClientBuilder.create();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int l;
        byte[] buf = new byte[4096];
        while ((l = is.read(buf)) > 0) {
            os.write(buf, 0, l);
        }
    }

    public static void download(HttpClientBuilder b, String url, File out) throws IOException {
        try (CloseableHttpClient client = b.build();
             CloseableHttpResponse r = client.execute((HttpUriRequest)new HttpGet(url));
             FileOutputStream fos = new FileOutputStream(out);){
            HttpTestUtils.copy(r.getEntity().getContent(), fos);
        }
    }

    public static Header findHeader(String name, Header[] headers) {
        for (Header h : headers) {
            if (!name.equals(h.getName())) continue;
            return h;
        }
        return null;
    }

    public static int upload(String resource, String url, String schema, StringBuilder response) throws IOException {
        HttpPost post = new HttpPost(url);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            MultipartEntityBuilder b = MultipartEntityBuilder.create();
            if (schema != null) {
                b.addPart("schema", (ContentBody)new StringBody(schema, ContentType.TEXT_PLAIN));
            }
            b.addPart("data", (ContentBody)new FileBody(HttpTestUtils.resourceFile(resource)));
            post.setEntity(b.build());
            CloseableHttpResponse r = client.execute((HttpUriRequest)post);
            if (response != null) {
                int n;
                InputStream is = r.getEntity().getContent();
                while ((n = is.read()) > 0) {
                    response.append((char)n);
                }
                is.close();
            }
            int n = r.getStatusLine().getStatusCode();
            return n;
        }
    }

    private static HttpClientBuilder createHttpClient_AcceptsUntrustedCerts() throws Exception {
        HttpClientBuilder b = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
        b.setSSLContext(sslContext);
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (s, sslSession) -> true);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        b.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(socketFactoryRegistry));
        return b;
    }

    private static File resourceFile(String resource) {
        return new File(HttpTestUtils.class.getResource(resource).getFile());
    }
}

