/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.test.tools;

import com.questdb.store.Files;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.configuration.JournalConfiguration;
import com.questdb.store.factory.configuration.JournalConfigurationBuilder;
import java.io.File;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class FactoryContainer
implements TestRule {
    private final JournalConfigurationBuilder builder;
    private JournalConfiguration configuration;
    private Factory factory;

    public FactoryContainer(JournalConfigurationBuilder builder) {
        this.builder = builder;
    }

    public FactoryContainer() {
        this.builder = new JournalConfigurationBuilder();
    }

    public Statement apply(final Statement base, Description desc) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Throwable throwable = null;
                File tmp = Files.makeTempDir();
                FactoryContainer.this.factory = null;
                try {
                    FactoryContainer.this.configuration = FactoryContainer.this.builder.build(tmp);
                    base.evaluate();
                }
                catch (Throwable e) {
                    throwable = e;
                }
                finally {
                    if (FactoryContainer.this.factory != null) {
                        FactoryContainer.this.factory.close();
                    }
                    Files.deleteOrException((File)tmp);
                }
                if (throwable != null) {
                    throw throwable;
                }
            }
        };
    }

    public JournalConfiguration getConfiguration() {
        return this.configuration;
    }

    public Factory getFactory() {
        if (this.factory == null) {
            this.factory = new Factory(this.configuration);
        }
        return this.factory;
    }
}

