/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.test.tools;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.ex.ParserException;
import com.questdb.model.configuration.ModelConfiguration;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.std.Sinkable;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocaleFactory;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.SymbolTable;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.test.tools.FactoryContainer;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractTest {
    @Rule
    public final FactoryContainer factoryContainer = new FactoryContainer(ModelConfiguration.MAIN);
    protected final StringSink sink = new StringSink();
    protected final RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)this.sink);
    private final QueryCompiler compiler;

    public AbstractTest() {
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.dateFormatFactory = new DateFormatFactory();
        env.dateLocaleFactory = DateLocaleFactory.INSTANCE;
        this.compiler = new QueryCompiler(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertSymbol(String query) throws ParserException {
        try (RecordSource src = this.compiler.compile(this.getFactory(), (CharSequence)query);){
            RecordCursor cursor = src.prepareCursor((ReaderFactory)this.getFactory());
            try {
                SymbolTable tab = cursor.getStorageFacade().getSymbolTable(0);
                while (cursor.hasNext()) {
                    Record r = (Record)cursor.next();
                    TestUtils.assertEquals(r.getSym(0), tab.value(r.getInt(0)));
                }
            }
            finally {
                cursor.releaseCursor();
            }
        }
    }

    public Factory getFactory() {
        return this.factoryContainer.getFactory();
    }

    @Before
    public void setUp2() {
        this.factoryContainer.getConfiguration().exists((CharSequence)"none");
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertEquals((long)0L, (long)this.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.getFactory().getBusyReaderCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertEmpty(String query) throws ParserException {
        try (RecordSource src = this.compiler.compile(this.getFactory(), (CharSequence)query);){
            RecordCursor cursor = src.prepareCursor((ReaderFactory)this.getFactory());
            try {
                Assert.assertFalse((boolean)cursor.hasNext());
            }
            finally {
                cursor.releaseCursor();
            }
        }
    }

    protected void assertPlan(CharSequence plan, CharSequence query) throws ParserException {
        long memUsed = Unsafe.getMemUsed();
        try (RecordSource recordSource = this.compile(query);){
            this.sink.clear();
            this.sink.put((Sinkable)recordSource);
            TestUtils.assertEquals(plan, (CharSequence)this.sink);
        }
        Assert.assertEquals((long)memUsed, (long)Unsafe.getMemUsed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertThat(String expected, String query, boolean header) throws ParserException, IOException {
        long memUsed = Unsafe.getMemUsed();
        try (RecordSource src = this.compiler.compile(this.getFactory(), (CharSequence)query);){
            RecordCursor cursor = src.prepareCursor((ReaderFactory)this.getFactory());
            try {
                this.sink.clear();
                this.printer.print(cursor, header, src.getMetadata());
                TestUtils.assertEquals((CharSequence)expected, (CharSequence)this.sink);
                cursor.toTop();
                this.sink.clear();
                this.printer.print(cursor, header, src.getMetadata());
                TestUtils.assertEquals((CharSequence)expected, (CharSequence)this.sink);
            }
            finally {
                cursor.releaseCursor();
            }
            TestUtils.assertStrings(src, (ReaderFactory)this.getFactory());
        }
        catch (ParserException e) {
            System.out.println(QueryError.getMessage());
            System.out.println(QueryError.getPosition());
            throw e;
        }
        Assert.assertEquals((long)memUsed, (long)Unsafe.getMemUsed());
    }

    protected void assertThat(String expected, String query) throws ParserException, IOException {
        this.assertThat(expected, query, false);
        this.assertThat(expected, query, false);
    }

    protected RecordSource compile(CharSequence query) throws ParserException {
        return this.compiler.compile(this.getFactory(), query);
    }

    protected void expectFailure(CharSequence query) throws ParserException {
        long memUsed = Unsafe.getMemUsed();
        try {
            this.compile(query);
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)memUsed, (long)Unsafe.getMemUsed());
            throw e;
        }
    }
}

