/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory;

import com.questdb.ex.FactoryClosedException;
import com.questdb.ex.JournalLockedException;
import com.questdb.ex.WriterBusyException;
import com.questdb.std.ex.JournalException;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.CachingWriterFactory;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.test.tools.AbstractTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingWriterFactoryTest
extends AbstractTest {
    private CachingWriterFactory wf;

    @Before
    public void setUp() {
        this.wf = new CachingWriterFactory(this.factoryContainer.getConfiguration(), 0L);
    }

    @Override
    @After
    public void tearDown() {
        this.wf.close();
    }

    @Test
    public void testAllocateAndClear() throws Exception {
        JournalMetadata m = new JournalStructure("z").$date("ts").$().build();
        int n = 2;
        CyclicBarrier barrier = new CyclicBarrier(n);
        CountDownLatch halt = new CountDownLatch(n);
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger writerCount = new AtomicInteger();
        new Thread(() -> {
            try {
                for (int i = 0; i < 1000; ++i) {
                    try (JournalWriter ignored = this.wf.writer(m);){
                        writerCount.incrementAndGet();
                    }
                    catch (WriterBusyException writerBusyException) {
                        // empty catch block
                    }
                    if (i == 1) {
                        barrier.await();
                    }
                    LockSupport.parkNanos(10L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.incrementAndGet();
            }
            finally {
                halt.countDown();
            }
        }).start();
        new Thread(() -> {
            try {
                barrier.await();
                for (int i = 0; i < 1000; ++i) {
                    this.wf.releaseInactive();
                    LockSupport.parkNanos(10L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.incrementAndGet();
            }
            finally {
                halt.countDown();
            }
        }).start();
        halt.await();
        Assert.assertTrue((writerCount.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)errors.get());
    }

    @Test
    public void testFactoryCloseBeforeRelease() throws Exception {
        JournalMetadata m = new JournalStructure("x").$date("ts").$().build();
        try (JournalWriter x = this.wf.writer(m);){
            Assert.assertEquals((long)0L, (long)this.wf.countFreeWriters());
            Assert.assertNotNull((Object)x);
            Assert.assertTrue((boolean)x.isOpen());
            Assert.assertSame((Object)x, (Object)this.wf.writer(m));
            this.wf.close();
        }
        Assert.assertFalse((boolean)x.isOpen());
        try {
            this.wf.writer(m);
        }
        catch (FactoryClosedException factoryClosedException) {
            // empty catch block
        }
    }

    @Test
    public void testLockNonExisting() throws Exception {
        JournalMetadata x = new JournalStructure("x").$date("ts").$().build();
        this.wf.lock(x.getName());
        try {
            this.wf.writer(x);
            Assert.fail();
        }
        catch (JournalLockedException journalLockedException) {
            // empty catch block
        }
        this.wf.unlock(x.getName());
        try (JournalWriter wx = this.wf.writer(x);){
            Assert.assertNotNull((Object)wx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockUnlock() throws Exception {
        JournalMetadata x = new JournalStructure("x").$date("ts").$().build();
        JournalMetadata y = new JournalStructure("y").$date("ts").$().build();
        JournalWriter wx = this.wf.writer(x);
        Assert.assertNotNull((Object)wx);
        Assert.assertTrue((boolean)wx.isOpen());
        JournalWriter wy = this.wf.writer(y);
        Assert.assertNotNull((Object)wy);
        Assert.assertTrue((boolean)wy.isOpen());
        try {
            this.wf.lock(x.getName());
            Assert.assertFalse((boolean)wx.isOpen());
            Assert.assertTrue((boolean)wy.isOpen());
            try {
                this.wf.writer(x);
            }
            catch (JournalLockedException journalLockedException) {
                // empty catch block
            }
            CountDownLatch done = new CountDownLatch(1);
            AtomicBoolean result = new AtomicBoolean();
            new Thread(() -> {
                try (JournalWriter ignored = this.wf.writer(x);){
                    result.set(false);
                }
                catch (WriterBusyException ignored2) {
                    result.set(true);
                }
                catch (JournalException e) {
                    e.printStackTrace();
                    result.set(false);
                }
                done.countDown();
            }).start();
            Assert.assertTrue((boolean)done.await(1L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)result.get());
            this.wf.unlock(x.getName());
            wx = this.wf.writer(x);
            Assert.assertNotNull((Object)wx);
            Assert.assertTrue((boolean)wx.isOpen());
            try {
                this.wf.unlock(wx.getName());
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)wx.isOpen());
        }
        finally {
            wx.close();
            wy.close();
        }
    }

    @Test
    public void testNewLock() throws Exception {
        JournalMetadata m = new JournalStructure("x").$date("ts").$().build();
        this.wf.lock("x");
        try {
            this.wf.writer(m);
            Assert.fail();
        }
        catch (JournalException journalException) {
            // empty catch block
        }
        this.wf.unlock("x");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneThreadGetRelease() throws Exception {
        JournalMetadata m = new JournalStructure("x").$date("ts").$().build();
        try (JournalWriter x = this.wf.writer(m);){
            Assert.assertEquals((long)0L, (long)this.wf.countFreeWriters());
            Assert.assertNotNull((Object)x);
            Assert.assertTrue((boolean)x.isOpen());
            Assert.assertSame((Object)x, (Object)this.wf.writer(m));
        }
        Assert.assertEquals((long)1L, (long)this.wf.countFreeWriters());
        try (JournalWriter y = this.wf.writer(m);){
            Assert.assertNotNull((Object)y);
            Assert.assertTrue((boolean)y.isOpen());
            Assert.assertSame((Object)y, (Object)x);
        }
        Assert.assertEquals((long)1L, (long)this.wf.countFreeWriters());
    }

    @Test
    public void testTwoThreadsRaceToAllocate() throws Exception {
        JournalMetadata m = new JournalStructure("x").$date("ts").$().build();
        int n = 2;
        CyclicBarrier barrier = new CyclicBarrier(n);
        CountDownLatch halt = new CountDownLatch(n);
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger writerCount = new AtomicInteger();
        for (int i = 0; i < n; ++i) {
            new Thread(() -> {
                try {
                    barrier.await();
                    try (JournalWriter ignored2 = this.wf.writer(m);){
                        writerCount.incrementAndGet();
                    }
                    catch (WriterBusyException ignored2) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    halt.countDown();
                }
            }).start();
        }
        halt.await();
        Assert.assertEquals((long)0L, (long)errors.get());
        Assert.assertEquals((long)1L, (long)this.wf.countFreeWriters());
    }
}

