/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory;

import com.questdb.ex.FactoryFullException;
import com.questdb.ex.JournalLockedException;
import com.questdb.ex.RetryLockException;
import com.questdb.std.LongList;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.factory.CachingReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.test.tools.AbstractTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Test;

public class CachingReaderFactoryTest
extends AbstractTest {
    @Test
    public void testAllocateAndClear() throws Exception {
        JournalMetadata m = new JournalStructure("z").$date("ts").$().build();
        this.getFactory().writer(m).close();
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1L, 2);){
            int n = 2;
            CyclicBarrier barrier = new CyclicBarrier(n);
            CountDownLatch halt = new CountDownLatch(n);
            AtomicInteger errors = new AtomicInteger();
            AtomicInteger readerCount = new AtomicInteger();
            new Thread(() -> {
                try {
                    for (int i = 0; i < 1000; ++i) {
                        try (Journal ignored = rf.reader(m);){
                            readerCount.incrementAndGet();
                        }
                        catch (FactoryFullException factoryFullException) {
                            // empty catch block
                        }
                        if (i == 1) {
                            barrier.await();
                        }
                        LockSupport.parkNanos(10L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    halt.countDown();
                }
            }).start();
            new Thread(() -> {
                try {
                    barrier.await();
                    for (int i = 0; i < 1000; ++i) {
                        rf.releaseInactive();
                        LockSupport.parkNanos(10L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    halt.countDown();
                }
            }).start();
            halt.await();
            Assert.assertTrue((readerCount.get() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)errors.get());
        }
    }

    @Test
    public void testCloseWithActiveReader() throws Exception {
        JournalMetadata m = new JournalStructure("x").$date("ts").$().build();
        this.getFactory().writer(m).close();
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1000L, 2);){
            Journal reader = rf.reader(m);
            Assert.assertNotNull((Object)reader);
            rf.close();
            Assert.assertTrue((boolean)reader.isOpen());
            reader.close();
            Assert.assertFalse((boolean)reader.isOpen());
        }
    }

    @Test
    public void testCloseWithInactiveReader() throws Exception {
        JournalMetadata m = new JournalStructure("x").$date("ts").$().build();
        this.getFactory().writer(m).close();
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1000L, 2);){
            Journal reader = rf.reader(m);
            Assert.assertNotNull((Object)reader);
            reader.close();
            Assert.assertTrue((boolean)reader.isOpen());
            rf.close();
            Assert.assertFalse((boolean)reader.isOpen());
        }
    }

    @Test
    public void testConcurrentOpenAndClose() throws Exception {
        int readerCount = 5;
        int threadCount = 2;
        int iterations = 1000;
        JournalMetadata[] meta = new JournalMetadata[5];
        for (int i = 0; i < 5; ++i) {
            JournalMetadata m = new JournalStructure("x" + i).$date("ts").$().build();
            this.getFactory().writer(m).close();
            meta[i] = m;
        }
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1000L, 2);){
            CyclicBarrier barrier = new CyclicBarrier(threadCount);
            CountDownLatch halt = new CountDownLatch(threadCount);
            AtomicInteger errors = new AtomicInteger();
            int i = 0;
            while (i < threadCount) {
                int x = i++;
                new Thread(() -> {
                    Rnd rnd = new Rnd((long)x, (long)(-x));
                    try {
                        barrier.await();
                        for (int i1 = 0; i1 < 1000; ++i1) {
                            JournalMetadata m = meta[rnd.nextPositiveInt() % 5];
                            try (Journal ignored = rf.reader(m);){
                                LockSupport.parkNanos(100L);
                                continue;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                    finally {
                        halt.countDown();
                    }
                }).start();
            }
            halt.await();
            Assert.assertEquals((long)0L, (long)errors.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetReadersBeforeFailure() throws Exception {
        JournalMetadata m = new JournalStructure("x").$date("ts").$().build();
        this.getFactory().writer(m).close();
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1000L, 2);){
            ObjList readers = new ObjList();
            try {
                try {
                    while (true) {
                        readers.add((Object)rf.reader(m));
                    }
                }
                catch (FactoryFullException e) {
                    Assert.assertEquals((long)rf.getMaxEntries(), (long)readers.size());
                    int n = readers.size();
                    for (int i = 0; i < n; ++i) {
                        ((Journal)readers.getQuick(i)).close();
                    }
                }
            }
            catch (Throwable throwable) {
                int n = readers.size();
                for (int i = 0; i < n; ++i) {
                    ((Journal)readers.getQuick(i)).close();
                }
                throw throwable;
            }
        }
    }

    @Test
    public void testLockBusyReader() throws Exception {
        int readerCount = 5;
        int threadCount = 2;
        int iterations = 10000;
        JournalMetadata[] meta = new JournalMetadata[5];
        for (int i = 0; i < 5; ++i) {
            JournalMetadata m = new JournalStructure("x" + i).$date("ts").$().build();
            this.getFactory().writer(m).close();
            meta[i] = m;
        }
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1000L, 2);){
            CyclicBarrier barrier = new CyclicBarrier(threadCount);
            CountDownLatch halt = new CountDownLatch(threadCount);
            AtomicInteger errors = new AtomicInteger();
            LongList lockTimes = new LongList();
            LongList workerTimes = new LongList();
            new Thread(() -> {
                Rnd rnd = new Rnd();
                try {
                    barrier.await();
                    String name = null;
                    for (int i = 0; i < 10000; ++i) {
                        if (name == null) {
                            name = meta[rnd.nextPositiveInt() % 5].getName();
                        }
                        while (true) {
                            try {
                                rf.lock(name);
                                lockTimes.add(System.currentTimeMillis());
                                LockSupport.parkNanos(100L);
                                rf.unlock(name);
                                name = null;
                            }
                            catch (JournalException e) {
                                if (e instanceof RetryLockException) continue;
                                e.printStackTrace();
                                errors.incrementAndGet();
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                halt.countDown();
            }).start();
            new Thread(() -> {
                Rnd rnd = new Rnd();
                workerTimes.add(System.currentTimeMillis());
                for (int i = 0; i < 10000; ++i) {
                    JournalMetadata metadata = meta[rnd.nextPositiveInt() % 5];
                    try (Journal ignored2 = rf.reader(metadata);){
                        if (metadata == meta[4] && barrier.getNumberWaiting() > 0) {
                            barrier.await();
                        }
                        LockSupport.parkNanos(10L);
                        continue;
                    }
                    catch (JournalLockedException ignored2) {
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
                workerTimes.add(System.currentTimeMillis());
                halt.countDown();
            }).start();
            halt.await();
            Assert.assertEquals((long)0L, (long)errors.get());
            int count = 0;
            Assert.assertEquals((long)2L, (long)workerTimes.size());
            long lo = workerTimes.get(0);
            long hi = workerTimes.get(1);
            Assert.assertTrue((lockTimes.size() > 0 ? 1 : 0) != 0);
            int n = lockTimes.size();
            for (int i = 0; i < n; ++i) {
                long t = lockTimes.getQuick(i);
                if (t <= lo || t >= hi) continue;
                ++count;
            }
            Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testLockUnlock() throws Exception {
        Journal y;
        Journal x;
        JournalMetadata m1 = new JournalStructure("x").$date("ts").$().build();
        this.getFactory().writer(m1).close();
        JournalMetadata m2 = new JournalStructure("y").$date("ts").$().build();
        this.getFactory().writer(m2).close();
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1000L, 2);){
            x = rf.reader(m1);
            Assert.assertNotNull((Object)x);
            y = rf.reader(m2);
            Assert.assertNotNull((Object)y);
            try {
                rf.lock(m1.getName());
                Assert.fail();
            }
            catch (RetryLockException retryLockException) {
                // empty catch block
            }
            x.close();
            rf.lock(m1.getName());
            Assert.assertFalse((boolean)x.isOpen());
            try {
                Assert.assertNull((Object)rf.reader(m1));
            }
            catch (JournalLockedException journalLockedException) {
                // empty catch block
            }
            rf.unlock(m1.getName());
            x = rf.reader(m1);
            Assert.assertNotNull((Object)x);
            x.close();
            Assert.assertTrue((boolean)x.isOpen());
        }
        Assert.assertTrue((boolean)y.isOpen());
        y.close();
        Assert.assertFalse((boolean)y.isOpen());
        Assert.assertFalse((boolean)x.isOpen());
    }

    @Test
    public void testLockUnlockMultiple() throws Exception {
        JournalMetadata m1 = new JournalStructure("x").$date("ts").$().build();
        this.getFactory().writer(m1).close();
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1000L, 2);){
            Journal r1 = rf.reader(m1);
            Journal r2 = rf.reader(m1);
            r1.close();
            try {
                rf.lock(m1.getName());
            }
            catch (RetryLockException e) {
                e.printStackTrace();
            }
            r2.close();
            rf.lock(m1.getName());
            rf.unlock(m1.getName());
        }
    }

    @Test
    public void testSerialOpenClose() throws Exception {
        JournalMetadata m = new JournalStructure("x").$date("ts").$().build();
        this.getFactory().writer(m).close();
        try (CachingReaderFactory rf = new CachingReaderFactory(this.factoryContainer.getConfiguration(), 1000L, 2);){
            Journal firstReader = null;
            for (int i = 0; i < 1000; ++i) {
                try (Journal reader = rf.reader(m);){
                    if (firstReader == null) {
                        firstReader = reader;
                    }
                    Assert.assertNotNull((Object)reader);
                    Assert.assertSame((Object)firstReader, (Object)reader);
                    continue;
                }
            }
        }
    }
}

