/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.ByteBuffers;
import com.questdb.std.DirectInputStream;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.store.MemoryFile;
import com.questdb.store.VariableColumn;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class VariableColumnTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private MemoryFile file;
    private MemoryFile file2;
    private MemoryFile indexFile;
    private MemoryFile indexFile2;

    @After
    public void cleanup() {
        this.file.close();
        this.file2.close();
        this.indexFile.close();
        this.indexFile2.close();
    }

    @Before
    public void setUp() throws JournalException {
        this.file = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col.d"), 22, 2, false);
        this.file2 = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col2.d"), 18, 2, false);
        this.indexFile = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col.i"), 22, 2, false);
        this.indexFile2 = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col2.i"), 18, 2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBin1() throws Exception {
        int N = 1000;
        int SZ = 4096;
        ByteBuffer buf = ByteBuffer.allocateDirect(SZ);
        long addr = ByteBuffers.getAddress((ByteBuffer)buf);
        try {
            Rnd rnd = new Rnd();
            try (MemoryFile smallFile = new MemoryFile(new File(this.temporaryFolder.getRoot(), "small.d"), 8, 2, false);
                 VariableColumn col = new VariableColumn(smallFile, this.indexFile);){
                int i;
                for (i = 0; i < N; ++i) {
                    long p = addr;
                    int n = rnd.nextPositiveInt() % (SZ - 1) / 8;
                    for (int j = 0; j < n; ++j) {
                        Unsafe.getUnsafe().putLong(p, rnd.nextLong());
                        p += 8L;
                    }
                    buf.limit(n * 8);
                    col.putBin(buf);
                    col.commit();
                    buf.clear();
                }
                Assert.assertEquals((long)N, (long)col.size());
                rnd = new Rnd();
                for (i = 0; i < N; ++i) {
                    long len = col.getBinLen((long)i);
                    DirectInputStream is = col.getBin((long)i);
                    is.copyTo(addr, 0L, len);
                    long p = addr;
                    int n = rnd.nextPositiveInt() % (SZ - 1) / 8;
                    for (int j = 0; j < n; ++j) {
                        Assert.assertEquals((long)rnd.nextLong(), (long)Unsafe.getUnsafe().getLong(p));
                        p += 8L;
                    }
                }
            }
        }
        finally {
            ByteBuffers.release((ByteBuffer)buf);
        }
    }

    @Test
    public void testCopyBinaryColumnData() throws Exception {
        int bitHint = 8;
        try (MemoryFile smallFile = new MemoryFile(new File(this.temporaryFolder.getRoot(), "small.d"), bitHint, 2, false);){
            VariableColumn col1 = new VariableColumn(smallFile, this.indexFile);
            int max = (int)Math.pow(2.0, bitHint) * 10 + 1;
            OutputStream writeStream = col1.putBin();
            for (int i = 0; i < max; ++i) {
                writeStream.write(i % 255);
            }
            writeStream.flush();
            col1.commit();
            int shift = (int)Math.ceil((double)max / 4.0);
            for (int offset = 0; offset < max; offset += shift) {
                int readLen = max - offset;
                DirectInputStream readStream = col1.getBin(0L);
                long readAddress = Unsafe.malloc((long)readLen);
                readStream.copyTo(readAddress, (long)offset, (long)readLen);
                for (int i = 0; i < readLen; ++i) {
                    byte expected = (byte)((offset + i) % 255);
                    byte actual = Unsafe.getUnsafe().getByte(readAddress + (long)i);
                    Assert.assertEquals((String)String.format("difference at index %d with read offset %d", i, offset), (long)expected, (long)actual);
                }
                Unsafe.free((long)readAddress, (long)readLen);
            }
        }
    }

    @Test
    public void testReadBinaryColumnData() throws Exception {
        int bitHint = 8;
        try (MemoryFile smallFile = new MemoryFile(new File(this.temporaryFolder.getRoot(), "small.d"), bitHint, 2, false);){
            byte b;
            VariableColumn col1 = new VariableColumn(smallFile, this.indexFile);
            int max = (int)Math.pow(2.0, bitHint) * 10 + 1;
            Rnd rnd = new Rnd();
            OutputStream writeStream = col1.putBin();
            for (int i = 0; i < max; ++i) {
                writeStream.write(rnd.nextInt());
            }
            writeStream.flush();
            col1.commit();
            DirectInputStream readStream = col1.getBin(0L);
            int count = 0;
            Rnd exp = new Rnd();
            while ((b = (byte)readStream.read()) != -1) {
                Assert.assertEquals((String)String.format("difference at index %d", count), (long)((byte)exp.nextInt()), (long)b);
                ++count;
            }
        }
    }
}

