/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.std.Rows;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DelimitedCharSink;
import com.questdb.std.str.StringSink;
import com.questdb.store.JournalWriter;
import com.questdb.store.Tx;
import com.questdb.store.TxLog;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TxLogTest
extends AbstractTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testTx() throws Exception {
        File dir = this.temp.newFolder();
        try (TxLog txLog = new TxLog(dir, 2, 2);){
            Assert.assertFalse((boolean)txLog.hasNext());
            Tx tx = new Tx();
            tx.prevTxAddress = 99999L;
            tx.command = 0;
            tx.journalMaxRowID = 10L;
            tx.lagSize = 12L;
            tx.lagName = "abcrrrrrrrrrrrrrrrrrrrrrrrrrrr";
            tx.timestamp = 1000001L;
            tx.lastPartitionTimestamp = 200002L;
            tx.symbolTableSizes = new int[]{10, 12};
            tx.symbolTableIndexPointers = new long[]{2L, 15L, 18L};
            tx.indexPointers = new long[]{36L, 48L};
            tx.lagIndexPointers = new long[]{55L, 67L};
            txLog.write(tx, true);
            Assert.assertFalse((boolean)txLog.hasNext());
            try (TxLog r = new TxLog(dir, 0, 2);){
                Assert.assertTrue((boolean)r.hasNext());
                Tx tx1 = new Tx();
                r.head(tx1);
                Assert.assertEquals((long)0L, (long)tx1.command);
                Assert.assertEquals((long)10L, (long)tx1.journalMaxRowID);
                Assert.assertEquals((long)12L, (long)tx1.lagSize);
                Assert.assertEquals((Object)"abcrrrrrrrrrrrrrrrrrrrrrrrrrrr", (Object)tx.lagName);
                Assert.assertEquals((long)99999L, (long)tx.prevTxAddress);
                Assert.assertEquals((long)1000001L, (long)tx.timestamp);
                Assert.assertEquals((long)200002L, (long)tx.lastPartitionTimestamp);
                Assert.assertEquals((long)1000001L, (long)tx.timestamp);
                Assert.assertArrayEquals((int[])new int[]{10, 12}, (int[])tx.symbolTableSizes);
                Assert.assertArrayEquals((long[])new long[]{2L, 15L, 18L}, (long[])tx.symbolTableIndexPointers);
                Assert.assertArrayEquals((long[])new long[]{36L, 48L}, (long[])tx.indexPointers);
                Assert.assertArrayEquals((long[])new long[]{55L, 67L}, (long[])tx.lagIndexPointers);
                Assert.assertFalse((boolean)r.hasNext());
            }
        }
    }

    @Test
    public void testTxLogIterator() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            for (int i = 0; i < 10; ++i) {
                TestUtils.generateQuoteData((JournalWriter<Quote>)w, 100, w.getMaxTimestamp());
                w.commit();
            }
            String expected = "10\t0\t1000\n9\t0\t900\n8\t0\t800\n7\t0\t700\n6\t0\t600\n5\t0\t500\n4\t0\t400\n3\t0\t300\n2\t0\t200\n1\t0\t100\n0\t0\t0\n";
            DelimitedCharSink sink = new DelimitedCharSink((CharSink)new StringSink(), '\t', "\n");
            for (Tx tx : w.transactions()) {
                sink.put(tx.txn);
                sink.put(tx.journalMaxRowID == -1L ? 0 : Rows.toPartitionIndex((long)tx.journalMaxRowID));
                sink.put(tx.journalMaxRowID == -1L ? 0L : Rows.toLocalRowID((long)tx.journalMaxRowID));
                sink.eol();
            }
            sink.flush();
            Assert.assertEquals((Object)"10\t0\t1000\n9\t0\t900\n8\t0\t800\n7\t0\t700\n6\t0\t600\n5\t0\t500\n4\t0\t400\n3\t0\t300\n2\t0\t200\n1\t0\t100\n0\t0\t0\n", (Object)sink.toString());
        }
    }
}

