/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.std.NumericException;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.Dates;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.AbstractTest;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class TimestampTest
extends AbstractTest {
    @Test
    public void testHardAndSoftTimestamps() throws JournalException, NumericException {
        try (JournalWriter journal = this.getFactory().writer(Quote.class);){
            Assert.assertEquals((long)0L, (long)journal.getAppendTimestampLo());
            Assert.assertEquals((long)0L, (long)journal.getMaxTimestamp());
            Quote quote21 = new Quote().setSym("123").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2011-09-10T10:00:00.000Z"));
            Quote quote22 = new Quote().setSym("345").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2011-09-11T10:00:00.000Z"));
            journal.append((Object[])new Quote[]{quote21, quote22});
            journal.commit();
            Assert.assertEquals((long)DateFormatUtils.parseDateTime((CharSequence)"2011-09-11T10:00:00.000Z"), (long)journal.getAppendTimestampLo());
            Assert.assertEquals((long)journal.getMaxTimestamp(), (long)journal.getAppendTimestampLo());
        }
        ArrayList<Quote> data = new ArrayList<Quote>();
        try (JournalWriter journal = this.getFactory().writer(Quote.class);){
            Assert.assertEquals((long)DateFormatUtils.parseDateTime((CharSequence)"2011-09-11T10:00:00.000Z"), (long)journal.getAppendTimestampLo());
            Assert.assertEquals((long)journal.getMaxTimestamp(), (long)journal.getAppendTimestampLo());
            Quote quote23 = new Quote().setSym("333").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-08-11T10:00:00.000Z"));
            journal.append((Object)quote23);
            Assert.assertEquals((long)DateFormatUtils.parseDateTime((CharSequence)"2012-08-11T10:00:00.000Z"), (long)journal.getAppendTimestampLo());
            Assert.assertEquals((long)journal.getMaxTimestamp(), (long)journal.getAppendTimestampLo());
            Quote quote24 = new Quote().setSym("444").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-08-11T15:00:00.000Z"));
            data.add(quote24);
            journal.mergeAppend(data);
            journal.commit();
            Assert.assertEquals((long)DateFormatUtils.parseDateTime((CharSequence)"2012-08-11T10:00:00.000Z"), (long)journal.getAppendTimestampLo());
            Assert.assertEquals((long)DateFormatUtils.parseDateTime((CharSequence)"2012-08-11T15:00:00.000Z"), (long)journal.getMaxTimestamp());
        }
        journal = this.getFactory().writer(Quote.class);
        var3_3 = null;
        try {
            Assert.assertEquals((long)DateFormatUtils.parseDateTime((CharSequence)"2012-08-11T10:00:00.000Z"), (long)journal.getAppendTimestampLo());
            Assert.assertEquals((long)DateFormatUtils.parseDateTime((CharSequence)"2012-08-11T15:00:00.000Z"), (long)journal.getMaxTimestamp());
            Quote quote25 = new Quote().setSym("555").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-08-12T16:00:00.000Z"));
            data.clear();
            data.add(quote25);
            journal.mergeAppend(data);
            Assert.assertEquals((Object)"2012-08-11T10:00:00.000Z", (Object)Dates.toString((long)journal.getAppendTimestampLo()));
            Assert.assertEquals((Object)"2012-08-12T16:00:00.000Z", (Object)Dates.toString((long)journal.getMaxTimestamp()));
            journal.getAppendPartition(DateFormatUtils.parseDateTime((CharSequence)"2013-08-12T16:00:00.000Z"));
            Assert.assertEquals((Object)"2012-08-11T10:00:00.000Z", (Object)Dates.toString((long)journal.getAppendTimestampLo()));
            Assert.assertEquals((Object)"2012-08-12T16:00:00.000Z", (Object)Dates.toString((long)journal.getMaxTimestamp()));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (journal != null) {
                if (var3_3 != null) {
                    try {
                        journal.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    journal.close();
                }
            }
        }
    }

    @Test
    public void testLagOnEmptyJournal() throws JournalException, NumericException {
        Quote quote21 = new Quote().setSym("123").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2011-09-10T10:00:00.000Z"));
        Quote quote22 = new Quote().setSym("345").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2011-09-11T10:00:00.000Z"));
        ArrayList<Quote> data = new ArrayList<Quote>();
        data.add(quote21);
        data.add(quote22);
        try (JournalWriter journal = this.getFactory().writer(Quote.class);){
            journal.mergeAppend(data);
            journal.mergeAppend(data);
        }
    }
}

