/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.TestEntity;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalRuntimeException;
import com.questdb.store.JournalWriter;
import com.questdb.store.query.OrderedResultSet;
import com.questdb.store.query.ResultSet;
import com.questdb.store.query.api.Query;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SortTest
extends AbstractTest {
    private Query<TestEntity> q;
    private JournalWriter<TestEntity> w;

    @Before
    public void setUp() throws Exception {
        this.w = this.getFactory().writer(TestEntity.class);
        TestUtils.generateTestEntityData(this.w, 1000, DateFormatUtils.parseDateTime((CharSequence)"2012-05-15T10:55:00.000Z"), 100000);
        this.q = this.w.query();
    }

    @Override
    @After
    public void tearDown() {
        this.w.close();
    }

    @Test
    public void testDefaultSort() throws JournalException {
        long last = 0L;
        for (TestEntity p : this.q.all().asResultSet().sort(new String[]{"anInt"}).sort().bufferedIterator()) {
            Assert.assertTrue((String)"Journal records are out of order", (last <= p.getTimestamp() ? 1 : 0) != 0);
            last = p.getTimestamp();
        }
    }

    @Test
    public void testMaxResultSetTimestamp() throws JournalException {
        OrderedResultSet rs = this.q.all().asResultSet();
        Assert.assertEquals((long)rs.getMaxTimestamp(), (long)((TestEntity)rs.readLast()).getTimestamp());
    }

    @Test
    public void testReadSortedTimestamps() throws JournalException {
        long[] result = this.q.all().asResultSet().sort(new String[]{"anInt"}).sort().readTimestamps();
        long last = 0L;
        for (long t : result) {
            Assert.assertTrue((String)"Journal records are out of order", (last <= t ? 1 : 0) != 0);
            last = t;
        }
    }

    @Test
    public void testSortDouble() throws JournalException {
        double last = -1.0;
        for (TestEntity p : this.q.all().asResultSet().sort(new String[]{"aDouble"}).bufferedIterator()) {
            Assert.assertTrue((String)"Journal records are out of order", (last <= p.getADouble() ? 1 : 0) != 0);
            last = p.getADouble();
        }
    }

    @Test
    public void testSortDoubleDesc() throws JournalException {
        double last = Double.MAX_VALUE;
        for (TestEntity p : this.q.all().asResultSet().sort(ResultSet.Order.DESC, new String[]{"aDouble"}).bufferedIterator()) {
            Assert.assertTrue((String)"Journal records are out of order", (last >= p.getADouble() ? 1 : 0) != 0);
            last = p.getADouble();
        }
    }

    @Test
    public void testSortInt() throws JournalException {
        int last = -1;
        for (TestEntity p : this.q.all().asResultSet().sort(new String[]{"anInt"}).bufferedIterator()) {
            Assert.assertTrue((String)"Journal records are out of order", (last <= p.getAnInt() ? 1 : 0) != 0);
            last = p.getAnInt();
        }
    }

    @Test(expected=JournalRuntimeException.class)
    public void testSortInvalidColumn() throws JournalException {
        this.q.all().asResultSet().sort(new String[]{"badColumn"}).read();
    }

    @Test
    public void testSortStrings() throws Exception {
        String last = "";
        for (TestEntity v : this.q.all().asResultSet().sort(new String[]{"bStr"}).bufferedIterator()) {
            Assert.assertTrue((String)"Journal records are out of order", (last.compareTo(v.getBStr()) <= 0 ? 1 : 0) != 0);
            last = v.getBStr();
        }
    }

    @Test
    public void testSortSymbol() throws Exception {
        String last = "";
        for (TestEntity v : this.q.all().asResultSet().sort(new String[]{"sym"}).bufferedIterator()) {
            Assert.assertTrue((String)"Journal records are out of order", (last.compareTo(v.getSym() == null ? "" : v.getSym().toString()) <= 0 ? 1 : 0) != 0);
            last = v.getSym() == null ? "" : v.getSym().toString();
        }
    }
}

