/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.TestEntity;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.store.query.OrderedResultSet;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ResultSetTest
extends AbstractTest {
    @Test
    public void testReadColumns() throws Exception {
        try (JournalWriter w = this.getFactory().writer(TestEntity.class);){
            w.append((Object)new TestEntity().setBStr("test1").setAnInt(10));
            w.append((Object)new TestEntity().setDStr("test2").setADouble(55.0));
            w.append((Object)new TestEntity().setDwStr("test3").setSym("xyz"));
            w.commit();
        }
        var2_2 = null;
        try (Journal r = this.getFactory().reader(TestEntity.class);){
            OrderedResultSet rs = r.query().all().asResultSet();
            Assert.assertEquals((long)3L, (long)rs.size());
            Assert.assertNull((Object)rs.getSymbol(0, 4));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testReadPrimitive() throws Exception {
        try (JournalWriter w = this.getFactory().writer(TestEntity.class);){
            TestUtils.generateTestEntityData((JournalWriter<TestEntity>)w, 10000, DateFormatUtils.parseDateTime((CharSequence)"2012-05-15T10:55:00.000Z"), 100000);
            OrderedResultSet rs = w.query().all().asResultSet();
            int symIndex = w.getMetadata().getColumnIndex((CharSequence)"sym");
            int doubleIndex = w.getMetadata().getColumnIndex((CharSequence)"aDouble");
            int intIndex = w.getMetadata().getColumnIndex((CharSequence)"anInt");
            int tsIndex = w.getMetadata().getColumnIndex((CharSequence)"timestamp");
            int bStrIndex = w.getMetadata().getColumnIndex((CharSequence)"bStr");
            int dStrIndex = w.getMetadata().getColumnIndex((CharSequence)"dStr");
            int dwStrIndex = w.getMetadata().getColumnIndex((CharSequence)"dwStr");
            for (int i = 0; i < rs.size(); ++i) {
                TestEntity e = (TestEntity)rs.read(i);
                Assert.assertEquals((Object)e.getSym(), (Object)rs.getSymbol(i, symIndex));
                Assert.assertEquals((double)e.getADouble(), (double)rs.getDouble(i, doubleIndex), (double)10.0);
                Assert.assertEquals((long)e.getAnInt(), (long)rs.getInt(i, intIndex));
                Assert.assertEquals((long)e.getTimestamp(), (long)rs.getLong(i, tsIndex));
                Assert.assertEquals((Object)e.getBStr(), (Object)rs.getString(i, bStrIndex));
                Assert.assertEquals((Object)e.getDStr(), (Object)rs.getString(i, dStrIndex));
                Assert.assertEquals((Object)e.getDwStr(), (Object)rs.getString(i, dwStrIndex));
            }
        }
    }
}

