/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.Dates;
import com.questdb.store.Interval;
import com.questdb.store.Journal;
import com.questdb.store.JournalIterators;
import com.questdb.store.JournalWriter;
import com.questdb.store.query.UnorderedResultSet;
import com.questdb.store.query.api.Query;
import com.questdb.store.query.api.QueryAllBuilder;
import com.questdb.store.query.api.QueryHeadBuilder;
import com.questdb.store.query.iter.ConcurrentIterator;
import com.questdb.store.query.iter.JournalIterator;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestData;
import com.questdb.test.tools.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryTest
extends AbstractTest {
    private final long ts1 = DateFormatUtils.parseDateTimeQuiet((CharSequence)"2013-04-28T17:20:00.000Z");
    private final long ts2 = DateFormatUtils.parseDateTimeQuiet((CharSequence)"2013-05-03T23:43:20.000Z");
    private Query<Quote> q;
    private JournalWriter<Quote> w;

    @Before
    public void setUp() throws Exception {
        this.w = this.getFactory().writer(Quote.class);
        this.q = this.w.query();
        TestData.appendQuoteData2(this.w);
    }

    @Override
    @After
    public void tearDown() {
        this.w.close();
    }

    @Test
    public void testAll() {
        Assert.assertEquals((long)1000L, (long)this.q.all().size());
    }

    @Test
    public void testAllByKeyOverInterval() throws Exception {
        String expected = "2013-05-03T15:23:20.000Z\tGKN.L\t0.5275167947685228\t0.5630377869323533\t1843235138\t1122238976\tFast trading\tGR\n2013-05-02T21:20:00.000Z\tGKN.L\t0.4057095419320843\t0.2930651074363966\t970097888\t1768370800\tFast trading\tGR\n2013-05-02T11:36:40.000Z\tGKN.L\t0.7299258007491024\t0.6912012922060378\t980854034\t1765743108\tFast trading\tLXE\n2013-05-02T08:50:00.000Z\tGKN.L\t0.3679378100903369\t0.9382300968477628\t1388063503\t1125355543\tFast trading\tSK\n2013-05-02T01:53:20.000Z\tGKN.L\t0.6061689700945626\t0.3112527710614069\t765148442\t1939054544\tFast trading\tGR\n2013-05-01T12:00:00.000Z\tGKN.L\t0.5962940647708228\t0.8037097062216977\t1034412808\t1681490823\tFast trading\tLXE\n2013-05-01T02:16:40.000Z\tGKN.L\t0.8979439248915824\t0.2195123104786394\t1682785535\t1705950772\tFast trading\tLXE\n2013-04-30T17:56:40.000Z\tGKN.L\t0.9957244238271116\t0.22502876454673404\t1074244114\t1402712074\tFast trading\tLXE\n2013-04-29T11:23:20.000Z\tGKN.L\t0.4466437532316928\t0.32495899970572273\t2015090903\t1376158663\tFast trading\tLXE\n2013-04-29T05:50:00.000Z\tGKN.L\t0.17560585850669297\t0.6791795548403247\t2114761437\t561608998\tFast trading\tLXE";
        UnorderedResultSet rs = this.q.all().withKeys(new String[]{"GKN.L"}).slice(new Interval(this.ts2, this.ts1)).asResultSet();
        TestUtils.assertOrderDesc(rs.bufferedIterator());
        TestUtils.assertEquals(expected, rs);
    }

    @Test
    public void testAllBySymbolValueOverInterval() throws Exception {
        String expected = "2013-05-03T09:50:00.000Z\tRRS.L\t0.5590262812936236\t0.13652035496254744\t1522957952\t1962377774\tFast trading\tLXE\n2013-05-02T04:40:00.000Z\tRRS.L\t0.6061643091896248\t0.9812017566926329\t183363356\t965895392\tFast trading\tSK\n2013-05-01T23:06:40.000Z\tRRS.L\t0.6115265337537894\t0.85752616310559\t2014391952\t782784264\tFast trading\tGR\n2013-05-01T03:40:00.000Z\tRRS.L\t0.02214511956698062\t0.4197114107915003\t546860253\t131966276\tFast trading\tGR\n2013-04-30T06:50:00.000Z\tRRS.L\t0.9224740894383063\t0.4182944098171566\t958319102\t842755864\tFast trading\tLXE\n2013-04-29T21:06:40.000Z\tRRS.L\t0.27005559955766234\t0.8615598067123645\t657091681\t801271858\tFast trading\tGR\n2013-04-29T10:00:00.000Z\tRRS.L\t0.11597222374313398\t0.5192320969480931\t1317970912\t546140855\tFast trading\tGR\n2013-04-28T22:53:20.000Z\tRRS.L\t0.7787230809761455\t0.25803443163774886\t857471455\t190622110\tFast trading\tLXE\n2013-04-28T18:43:20.000Z\tRRS.L\t0.18670502698896196\t0.0885706583279452\t505468688\t2038459861\tFast trading\tGR";
        UnorderedResultSet rs = this.q.all().withKeys(new String[]{"RRS.L"}).slice(new Interval(this.ts2, this.ts1)).asResultSet();
        TestUtils.assertOrderDesc(rs.bufferedIterator());
        TestUtils.assertEquals(expected, rs);
    }

    @Test
    public void testAllBySymbolValueOverInterval2() throws Exception {
        String expected = "2013-05-03T09:50:00.000Z\tRRS.L\t0.5590262812936236\t0.13652035496254744\t1522957952\t1962377774\tFast trading\tLXE\n2013-05-02T04:40:00.000Z\tRRS.L\t0.6061643091896248\t0.9812017566926329\t183363356\t965895392\tFast trading\tSK\n2013-05-01T23:06:40.000Z\tRRS.L\t0.6115265337537894\t0.85752616310559\t2014391952\t782784264\tFast trading\tGR\n2013-05-01T03:40:00.000Z\tRRS.L\t0.02214511956698062\t0.4197114107915003\t546860253\t131966276\tFast trading\tGR\n2013-04-30T06:50:00.000Z\tRRS.L\t0.9224740894383063\t0.4182944098171566\t958319102\t842755864\tFast trading\tLXE\n2013-04-29T21:06:40.000Z\tRRS.L\t0.27005559955766234\t0.8615598067123645\t657091681\t801271858\tFast trading\tGR\n2013-04-29T10:00:00.000Z\tRRS.L\t0.11597222374313398\t0.5192320969480931\t1317970912\t546140855\tFast trading\tGR\n2013-04-28T22:53:20.000Z\tRRS.L\t0.7787230809761455\t0.25803443163774886\t857471455\t190622110\tFast trading\tLXE\n2013-04-28T18:43:20.000Z\tRRS.L\t0.18670502698896196\t0.0885706583279452\t505468688\t2038459861\tFast trading\tGR";
        UnorderedResultSet rs = this.q.all().withKeys(new String[]{"RRS.L"}).slice(new Interval(this.ts2, this.ts1)).asResultSet();
        TestUtils.assertOrderDesc(rs.bufferedIterator());
        TestUtils.assertEquals(expected, rs);
    }

    @Test
    public void testAllBySymbolValues() throws Exception {
        UnorderedResultSet rs = this.q.all().withKeys(new String[]{"TLW.L", "BT-A.L"}).asResultSet();
        Assert.assertEquals((long)220L, (long)rs.size());
    }

    @Test
    public void testAllBySymbolValuesFilter() throws Exception {
        String expected = "2013-03-10T14:10:00.000Z\tTLW.L\t0.02573810532215992\t0.8046430932427715\t1934497178\t682206619\tFast trading\tGR\n2013-03-11T09:36:40.000Z\tTLW.L\t0.7879210696731439\t0.5920114420682137\t1339357799\t774444461\tFast trading\tGR\n2013-03-11T13:46:40.000Z\tBP.L\t0.7776613443144346\t0.971849190665415\t1738046224\t1147970274\tFast trading\tSK\n2013-03-12T13:23:20.000Z\tBP.L\t0.7544945925939783\t0.06938553306251616\t1360360213\t403082481\tFast trading\tSK\n2013-03-12T14:46:40.000Z\tBP.L\t0.3726091203770484\t0.2766475274911777\t1803621151\t860888793\tFast trading\tSK\n2013-03-13T07:26:40.000Z\tBP.L\t0.4768618333809057\t0.5810041741880181\t1297421187\t2035188818\tFast trading\tGR\n2013-03-13T08:50:00.000Z\tTLW.L\t0.3035326969711406\t0.6177751796081616\t1426391064\t1570913417\tFast trading\tGR\n2013-03-13T17:10:00.000Z\tTLW.L\t0.4077291036925258\t0.43511047173084305\t1752886076\t1353522476\tFast trading\tGR\n2013-03-13T21:20:00.000Z\tBP.L\t0.8246817532514437\t0.7396704671251504\t1605061824\t1139426\tFast trading\tGR\n2013-03-13T22:43:20.000Z\tBP.L\t0.5661078613845335\t0.2921397632988618\t268790793\t671911462\tFast trading\tGR\n2013-03-14T00:06:40.000Z\tTLW.L\t0.5264746413873387\t0.38344046390360875\t1766923340\t2001083865\tFast trading\tSK\n2013-03-14T12:36:40.000Z\tBP.L\t0.655503453216916\t0.564446918383671\t1419046110\t950920455\tFast trading\tSK\n2013-03-14T19:33:20.000Z\tTLW.L\t0.06397775551233298\t0.9858439732492763\t1057856100\t846789630\tFast trading\tSK\n2013-03-15T01:06:40.000Z\tBP.L\t0.9185428014593233\t0.11280069602498888\t115757403\t204075527\tFast trading\tSK\n2013-03-15T03:53:20.000Z\tTLW.L\t0.6513621430076917\t0.06852315875315618\t208474338\t268030719\tFast trading\tSK\n2013-03-15T08:03:20.000Z\tBP.L\t0.28122406831515157\t0.6739722844587949\t1691795945\t913273960\tFast trading\tGR\n2013-03-16T02:06:40.000Z\tTLW.L\t0.0415789158676787\t0.5231992701463453\t1506323187\t175078323\tFast trading\tSK\n2013-03-16T11:50:00.000Z\tTLW.L\t0.3048276337712752\t0.19196516994439694\t294191333\t2055469927\tFast trading\tSK\n2013-03-17T00:20:00.000Z\tTLW.L\t0.35027099593564126\t0.2427077607846766\t1982885700\t245478464\tFast trading\tSK\n2013-03-18T04:06:40.000Z\tBP.L\t0.7492500555583897\t0.7797669416509228\t640490114\t25124124\tFast trading\tGR\n2013-03-18T05:30:00.000Z\tTLW.L\t0.41614225451585274\t0.46823434185765545\t372638780\t1054711573\tFast trading\tGR\n2013-03-18T13:50:00.000Z\tTLW.L\t0.1110082918779215\t0.2984050606725305\t1667997234\t93423667\tFast trading\tGR\n2013-03-19T05:06:40.000Z\tTLW.L\t0.27447175308602834\t0.30430294889915077\t1829330556\t313878542\tFast trading\tGR\n2013-03-19T12:03:20.000Z\tBP.L\t0.12198632739778481\t0.7447508860576895\t1482887299\t191485873\tFast trading\tSK\n2013-03-19T21:46:40.000Z\tBP.L\t0.5786072732475921\t0.5011381935323668\t470331436\t1192310283\tFast trading\tSK\n2013-03-20T01:56:40.000Z\tBP.L\t0.5793943854979288\t0.20217715668602454\t168652784\t626562180\tFast trading\tGR\n2013-03-21T07:06:40.000Z\tBP.L\t0.5008143292597959\t0.8299639473973414\t169356728\t644926697\tFast trading\tGR\n2013-03-21T09:53:20.000Z\tTLW.L\t0.7597985735641305\t0.5443583025674583\t106002917\t1388357221\tFast trading\tSK\n2013-03-21T21:00:00.000Z\tBP.L\t0.858055231335059\t0.46626368051642864\t540034088\t1597811300\tFast trading\tGR\n2013-03-22T03:56:40.000Z\tBP.L\t0.09698730910488784\t0.8939599300306726\t1027361765\t1038896840\tFast trading\tGR\n2013-03-22T13:40:00.000Z\tBP.L\t0.6865751402400707\t0.9359468427204359\t2095550332\t1459558532\tFast trading\tGR\n2013-03-22T20:36:40.000Z\tTLW.L\t0.47639480883516394\t0.6717122254103416\t519893276\t777487386\tFast trading\tGR\n2013-03-23T03:33:20.000Z\tTLW.L\t0.9682640148466458\t0.5936103168573834\t1928034560\t1283450972\tFast trading\tSK\n2013-03-23T18:50:00.000Z\tBP.L\t0.02678072440259227\t0.1642004109324513\t1583833534\t692114983\tFast trading\tSK\n2013-03-23T21:36:40.000Z\tTLW.L\t0.4593199430596897\t0.5785653560306447\t850447473\t1967707594\tFast trading\tSK\n2013-03-24T08:43:20.000Z\tTLW.L\t0.14241097736679398\t0.8400338866805241\t1036657171\t89200398\tFast trading\tGR\n2013-03-24T11:30:00.000Z\tBP.L\t0.6042198261408042\t0.6964699689546785\t427181608\t468956835\tFast trading\tGR\n2013-03-24T15:40:00.000Z\tTLW.L\t0.6277100303499593\t0.8141560678977439\t1725978941\t628771670\tFast trading\tGR\n2013-03-24T18:26:40.000Z\tBP.L\t0.3719310896013851\t0.09053955942452607\t2108625550\t354810581\tFast trading\tSK\n2013-03-24T22:36:40.000Z\tBP.L\t0.3350470801634893\t0.6598161690029788\t62050136\t883539384\tFast trading\tGR\n2013-03-25T09:43:20.000Z\tTLW.L\t0.5582093762332455\t0.418433930190135\t1040611232\t1242107013\tFast trading\tSK\n2013-03-25T12:30:00.000Z\tTLW.L\t0.11933732146334308\t0.25074059908409796\t1973456119\t484425474\tFast trading\tSK\n2013-03-25T15:16:40.000Z\tBP.L\t0.08350743160531637\t0.7914450322532709\t517685409\t1361347163\tFast trading\tSK\n2013-03-26T03:46:40.000Z\tTLW.L\t0.1624757825817965\t0.6144517527316762\t234521653\t1465237414\tFast trading\tSK\n2013-03-26T09:20:00.000Z\tTLW.L\t0.7461220877769164\t0.8595667293913083\t1253127447\t379312803\tFast trading\tSK\n2013-03-26T10:43:20.000Z\tBP.L\t0.7272541496606841\t0.6875146381597406\t444169170\t1091708277\tFast trading\tGR\n2013-03-26T19:03:20.000Z\tBP.L\t0.3580896941992219\t0.29443019210646626\t1501699702\t301912993\tFast trading\tGR\n2013-03-27T10:20:00.000Z\tTLW.L\t0.0160549992114305\t0.017084092297913855\t1801377912\t1095953414\tFast trading\tSK\n2013-03-27T21:26:40.000Z\tTLW.L\t0.5368626714439451\t0.7653901146220236\t1670832930\t1726275701\tFast trading\tGR\n2013-03-28T07:10:00.000Z\tTLW.L\t0.3930821025897562\t0.31661441291568004\t2101195847\t2144158252\tFast trading\tSK\n2013-03-28T15:30:00.000Z\tTLW.L\t0.29482967372464797\t0.5873615200302273\t799307072\t1526052338\tFast trading\tGR\n2013-03-29T23:26:40.000Z\tBP.L\t0.8997394376510751\t0.04960285882321813\t2048778343\t931472698\tFast trading\tSK\n2013-03-30T13:20:00.000Z\tBP.L\t0.3900874810951068\t0.9968624312755486\t1451371961\t1560656371\tFast trading\tGR\n2013-03-31T01:50:00.000Z\tBP.L\t0.9012182420081971\t0.9473175045908997\t982939694\t1949967100\tFast trading\tSK\n2013-03-31T19:53:20.000Z\tBP.L\t0.2795619420594939\t0.6343677720801747\t1561888489\t1263084773\tFast trading\tSK\n2013-03-31T21:16:40.000Z\tTLW.L\t0.273856536904752\t0.6376792314305924\t367417475\t717165093\tFast trading\tGR\n2013-04-01T12:33:20.000Z\tBP.L\t0.1346951297665162\t0.7567326311103831\t1964697407\t939893902\tFast trading\tGR\n2013-04-01T16:43:20.000Z\tBP.L\t0.2154107884728791\t0.5981302787003379\t902046946\t69177332\tFast trading\tSK\n2013-04-02T09:23:20.000Z\tTLW.L\t0.8216653163701158\t0.49072378239093717\t2091785922\t279874465\tFast trading\tGR\n2013-04-02T17:43:20.000Z\tTLW.L\t0.4861729984027724\t0.04410715916301444\t1090393828\t649334537\tFast trading\tGR\n2013-04-03T15:56:40.000Z\tBP.L\t0.47283691102573155\t0.9907568794280603\t443492390\t583853341\tFast trading\tGR\n2013-04-03T17:20:00.000Z\tTLW.L\t0.7233451934123044\t0.8535823949163824\t1536687509\t948865952\tFast trading\tGR\n2013-04-04T21:06:40.000Z\tTLW.L\t0.9028093202250096\t0.8334916452593404\t1504952266\t1066732744\tFast trading\tSK\n2013-04-05T01:16:40.000Z\tTLW.L\t0.4510753428162907\t0.274819992700826\t1498606786\t1554688374\tFast trading\tSK\n2013-04-05T02:40:00.000Z\tTLW.L\t0.028621681049465497\t0.19264069587487842\t1074106471\t1830571190\tFast trading\tGR\n2013-04-05T08:13:20.000Z\tBP.L\t0.4540461350986704\t0.7203007863521225\t1152713211\t636141246\tFast trading\tGR\n2013-04-05T15:10:00.000Z\tTLW.L\t0.9818740330595295\t0.9735159571259978\t1332273161\t1045909946\tFast trading\tSK\n2013-04-05T16:33:20.000Z\tTLW.L\t0.6477352654812574\t0.1349270238888649\t1859516881\t405919643\tFast trading\tGR\n2013-04-05T22:06:40.000Z\tTLW.L\t0.8755970841726556\t0.40601088731161794\t1745515693\t2080606926\tFast trading\tGR\n2013-04-06T16:10:00.000Z\tTLW.L\t0.35560921415594904\t0.9172386201102186\t1499912642\t1265370018\tFast trading\tSK\n2013-04-06T18:56:40.000Z\tTLW.L\t0.23015105422730142\t0.9261844752564334\t297992017\t833849767\tFast trading\tSK\n2013-04-07T03:16:40.000Z\tBP.L\t0.8335581117125144\t0.6805542672889585\t71576921\t945785235\tFast trading\tGR\n2013-04-07T19:56:40.000Z\tBP.L\t0.8665462798175759\t0.1670643770612965\t1529262014\t819780821\tFast trading\tSK\n2013-04-07T22:43:20.000Z\tTLW.L\t0.08445562540026363\t0.8057010845622595\t348639110\t662998688\tFast trading\tSK\n2013-04-08T16:46:40.000Z\tBP.L\t0.6080917787848515\t0.29242869695299356\t118958135\t20439620\tFast trading\tGR\n2013-04-09T02:30:00.000Z\tBP.L\t0.16081138530571393\t0.6017039053008107\t1761016960\t1138404246\tFast trading\tSK\n2013-04-09T09:26:40.000Z\tTLW.L\t0.13928312971286616\t0.9982236783093859\t22869879\t489232925\tFast trading\tGR\n2013-04-09T10:50:00.000Z\tBP.L\t0.7985782327350075\t0.8474252137435443\t1486806485\t1304709849\tFast trading\tSK\n2013-04-09T21:56:40.000Z\tBP.L\t0.03917674348745892\t0.9231285908497984\t1108175273\t590518608\tFast trading\tSK\n2013-04-10T22:56:40.000Z\tTLW.L\t0.1682827026141166\t0.42350294379902675\t1145541597\t1817032875\tFast trading\tGR\n2013-04-11T01:43:20.000Z\tTLW.L\t0.23734674310031678\t0.11400658125202778\t1019237415\t1998857059\tFast trading\tGR\n2013-04-11T04:30:00.000Z\tBP.L\t0.7420486594780815\t0.9827620705089128\t1816697444\t480637661\tFast trading\tGR\n2013-04-11T18:23:20.000Z\tBP.L\t0.9727900666691593\t0.7204557795721664\t1847116612\t1556996629\tFast trading\tSK\n2013-04-11T23:56:40.000Z\tTLW.L\t0.14495186453770403\t0.4524669309867406\t161433987\t2039521367\tFast trading\tGR\n2013-04-12T12:26:40.000Z\tBP.L\t0.8301255802811823\t0.35918901657596136\t1456345630\t657431940\tFast trading\tSK\n2013-04-13T06:30:00.000Z\tBP.L\t0.11129849285823601\t0.9838643139591695\t796068953\t630659425\tFast trading\tGR\n2013-04-13T09:16:40.000Z\tTLW.L\t0.6744357940661624\t0.8918402257218604\t27272954\t1256412492\tFast trading\tSK\n2013-04-14T03:20:00.000Z\tTLW.L\t0.7674719870869265\t0.7875726246210093\t667277015\t1819485115\tFast trading\tGR\n2013-04-14T06:06:40.000Z\tBP.L\t0.8715841039589816\t0.8314518567719068\t2027503140\t1599810249\tFast trading\tSK\n2013-04-14T15:50:00.000Z\tBP.L\t0.45691954124725853\t0.22879127530143317\t1965609204\t455678191\tFast trading\tGR\n2013-04-14T22:46:40.000Z\tBP.L\t0.026265089951411746\t0.45651599223832307\t470102385\t2033513892\tFast trading\tSK\n2013-04-15T04:20:00.000Z\tBP.L\t0.8510330708910628\t0.7256227259580637\t1984376557\t1936805688\tFast trading\tSK\n2013-04-15T23:46:40.000Z\tTLW.L\t0.4463347300950432\t0.6925161438197618\t1814510926\t2115486826\tFast trading\tGR\n2013-04-16T02:33:20.000Z\tBP.L\t0.9088068169199539\t0.15827882958352824\t1332695233\t1500198110\tFast trading\tSK\n2013-04-16T13:40:00.000Z\tBP.L\t0.5599122986402687\t0.976978238622683\t35665855\t1332306990\tFast trading\tSK\n2013-04-16T16:26:40.000Z\tTLW.L\t0.5066409396705072\t0.034125065735139515\t1777252481\t74739908\tFast trading\tSK\n2013-04-16T22:00:00.000Z\tBP.L\t0.13798638481152692\t0.3003941419492133\t2140126175\t1401757932\tFast trading\tSK\n2013-04-17T00:46:40.000Z\tBP.L\t0.12224131348041978\t0.42185069743193215\t2112121645\t742449192\tFast trading\tGR\n2013-04-17T02:10:00.000Z\tBP.L\t0.12333773300880568\t0.8522298943856105\t117018443\t1055256290\tFast trading\tGR\n2013-04-17T07:43:20.000Z\tTLW.L\t0.2764047457507224\t0.5953695369451356\t1934650112\t866281182\tFast trading\tSK\n2013-04-17T09:06:40.000Z\tTLW.L\t0.5888007518329997\t0.9546767618443591\t1073083495\t915766639\tFast trading\tGR\n2013-04-17T11:53:20.000Z\tTLW.L\t0.9681946530885687\t0.6826349256252374\t384417589\t625961973\tFast trading\tSK\n2013-04-17T23:00:00.000Z\tTLW.L\t0.9073565639007614\t0.31883968341033864\t1413755303\t1567927064\tFast trading\tGR\n2013-04-18T10:06:40.000Z\tBP.L\t0.17575246023679592\t0.1786890492951242\t1632037271\t780570766\tFast trading\tSK\n2013-04-18T11:30:00.000Z\tBP.L\t0.08380196743033497\t0.219662767248613\t360544308\t729726243\tFast trading\tSK\n2013-04-18T17:03:20.000Z\tBP.L\t0.11031265298416937\t0.502554745910034\t243354467\t1649522468\tFast trading\tGR\n2013-04-19T04:10:00.000Z\tTLW.L\t0.07032290099232896\t0.20202807591590044\t1384838795\t1369058291\tFast trading\tSK\n2013-04-19T06:56:40.000Z\tBP.L\t0.5155117298701682\t0.402711516247675\t25299361\t2002745344\tFast trading\tGR\n2013-04-20T14:53:20.000Z\tBP.L\t0.27995624652932327\t0.5483832427860625\t2067197976\t227530321\tFast trading\tGR\n2013-04-20T20:26:40.000Z\tTLW.L\t0.6296008155868514\t0.4977774257783619\t1985109735\t73318806\tFast trading\tGR\n2013-04-21T08:56:40.000Z\tBP.L\t0.9688797862712805\t0.32323139690022873\t373363492\t633988729\tFast trading\tSK\n2013-04-22T12:43:20.000Z\tTLW.L\t0.06485468407887174\t0.03427185454063508\t1892658103\t667160078\tFast trading\tSK\n2013-04-23T10:56:40.000Z\tTLW.L\t0.658249687746105\t0.9055382651404992\t1793432152\t1645914238\tFast trading\tSK\n2013-04-23T16:30:00.000Z\tBP.L\t0.2728019583809025\t0.01278763720267706\t993459551\t2025068147\tFast trading\tGR\n2013-04-23T20:40:00.000Z\tBP.L\t0.9772426869120343\t0.9250167208388378\t1680887683\t817388605\tFast trading\tSK\n2013-04-24T00:50:00.000Z\tTLW.L\t0.9561668372080154\t0.3914970174237439\t455564972\t1267023813\tFast trading\tGR\n2013-04-24T07:46:40.000Z\tTLW.L\t0.12455007168082621\t0.445138006254728\t1005737026\t1533560167\tFast trading\tSK\n2013-04-25T06:00:00.000Z\tTLW.L\t0.8596057934205292\t0.8030632446611555\t540749257\t724460336\tFast trading\tSK\n2013-04-25T11:33:20.000Z\tTLW.L\t0.2911293878254695\t0.7399693239677205\t1129164985\t1749026215\tFast trading\tSK\n2013-04-25T17:06:40.000Z\tTLW.L\t0.022846203323476755\t0.3294743481612157\t1572302605\t814850383\tFast trading\tSK\n2013-04-26T22:16:40.000Z\tTLW.L\t0.4204073472425597\t0.8766346253312641\t360336969\t1800751392\tFast trading\tSK\n2013-04-26T23:40:00.000Z\tTLW.L\t0.8327357836429247\t0.16352449257113777\t231845639\t2131809484\tFast trading\tGR\n2013-04-27T08:00:00.000Z\tBP.L\t0.25790654277476655\t0.2731181132242275\t1204373939\t579257911\tFast trading\tGR\n2013-04-27T14:56:40.000Z\tBP.L\t0.9816971539215531\t0.43853444535937625\t1460978675\t895177238\tFast trading\tGR\n2013-04-27T19:06:40.000Z\tBP.L\t0.8077063004176618\t0.16510231805096875\t2038626242\t1240355820\tFast trading\tGR\n2013-04-28T21:30:00.000Z\tBP.L\t0.31430399958862776\t0.7442052266426017\t1902801116\t1526668764\tFast trading\tGR\n2013-04-29T03:03:20.000Z\tTLW.L\t0.3924674980643327\t0.42759642071766735\t325469131\t1148755905\tFast trading\tGR\n2013-04-29T16:56:40.000Z\tBP.L\t0.24254498312457362\t0.450812713380639\t955560446\t2063318120\tFast trading\tSK\n2013-04-30T05:26:40.000Z\tTLW.L\t0.21542235902826057\t0.42857329503151054\t774479136\t91697613\tFast trading\tSK\n2013-04-30T12:23:20.000Z\tTLW.L\t0.46114243553817713\t0.7116424005305213\t1322718319\t1067901381\tFast trading\tSK\n2013-04-30T19:20:00.000Z\tBP.L\t0.34602616547919973\t0.11209766463974158\t838659555\t2089640349\tFast trading\tGR\n2013-05-01T18:56:40.000Z\tTLW.L\t0.7134551426883604\t0.36652513994805036\t1614561742\t1432439927\tFast trading\tGR\n2013-05-03T05:40:00.000Z\tTLW.L\t0.7180950271706947\t0.7189931302044412\t683609150\t1494093736\tFast trading\tGR\n2013-05-03T16:46:40.000Z\tBP.L\t0.800516898126557\t0.17852653385834039\t39877735\t1842395295\tFast trading\tGR\n2013-05-04T08:03:20.000Z\tTLW.L\t0.1010967065651025\t0.4990044037517981\t2070623667\t2060273453\tFast trading\tSK\n2013-05-04T15:00:00.000Z\tTLW.L\t0.771415760128552\t0.5917118717316834\t1448724735\t398777129\tFast trading\tGR\n2013-05-04T16:23:20.000Z\tTLW.L\t0.07723630752860178\t0.577867303192654\t1918206534\t261966598\tFast trading\tGR\n2013-05-05T17:23:20.000Z\tTLW.L\t0.312007395214155\t0.5316391740370102\t872516781\t358245103\tFast trading\tGR\n2013-05-06T03:06:40.000Z\tTLW.L\t0.31235312790637193\t0.4865957036424433\t385983022\t706111640\tFast trading\tSK\n2013-05-06T08:40:00.000Z\tTLW.L\t0.48739321264904534\t0.8440157580321933\t2087928281\t127404501\tFast trading\tSK\n2013-05-06T18:23:20.000Z\tBP.L\t0.45621034230309654\t0.1747016272521107\t1179616540\t908015035\tFast trading\tGR\n2013-05-06T22:33:20.000Z\tBP.L\t0.46114752131469783\t0.8979723557722048\t1579801637\t2117833235\tFast trading\tGR\n";
        UnorderedResultSet rs = this.q.all().withKeys(new String[]{"TLW.L", "BP.L", "NON_EXISTING"}).filter("ex", (CharSequence)"SK").filter("ex", (CharSequence)"GR").asResultSet();
        TestUtils.assertEquals(expected, rs.sort());
    }

    @Test
    public void testAllBySymbolValuesFilterOverInterval() throws Exception {
        String expected = "2013-04-28T21:30:00.000Z\tBP.L\t0.31430399958862776\t0.7442052266426017\t1902801116\t1526668764\tFast trading\tGR\n2013-04-29T03:03:20.000Z\tTLW.L\t0.3924674980643327\t0.42759642071766735\t325469131\t1148755905\tFast trading\tGR\n2013-04-29T16:56:40.000Z\tBP.L\t0.24254498312457362\t0.450812713380639\t955560446\t2063318120\tFast trading\tSK\n2013-04-30T05:26:40.000Z\tTLW.L\t0.21542235902826057\t0.42857329503151054\t774479136\t91697613\tFast trading\tSK\n2013-04-30T12:23:20.000Z\tTLW.L\t0.46114243553817713\t0.7116424005305213\t1322718319\t1067901381\tFast trading\tSK\n2013-04-30T19:20:00.000Z\tBP.L\t0.34602616547919973\t0.11209766463974158\t838659555\t2089640349\tFast trading\tGR\n2013-05-01T18:56:40.000Z\tTLW.L\t0.7134551426883604\t0.36652513994805036\t1614561742\t1432439927\tFast trading\tGR\n2013-05-03T05:40:00.000Z\tTLW.L\t0.7180950271706947\t0.7189931302044412\t683609150\t1494093736\tFast trading\tGR\n2013-05-03T16:46:40.000Z\tBP.L\t0.800516898126557\t0.17852653385834039\t39877735\t1842395295\tFast trading\tGR\n";
        UnorderedResultSet rs = this.q.all().withKeys(new String[]{"TLW.L", "BP.L"}).filter("ex", (CharSequence)"SK").filter("ex", (CharSequence)"GR").slice(new Interval(this.ts2, this.ts1)).asResultSet();
        TestUtils.assertEquals(expected, rs.sort());
    }

    @Test
    public void testAllBySymbolValuesOverInterval() throws Exception {
        UnorderedResultSet rs = this.q.all().withKeys(new String[0]).slice(new Interval(this.ts2, this.ts1)).asResultSet();
        Assert.assertEquals((long)0L, (long)rs.size());
        String expected = "2013-04-29T01:40:00.000Z\tWTB.L\t0.154905273744959\t0.3463641298845208\t1190004376\t548681062\tFast trading\tSK\n2013-04-29T07:13:20.000Z\tWTB.L\t0.94782183700974\t0.6385933398879912\t507408673\t477022979\tFast trading\tSK\n2013-04-29T12:46:40.000Z\tBT-A.L\t0.3542490655977256\t0.19109723285077962\t1111156559\t746276626\tFast trading\tSK\n2013-04-30T04:03:20.000Z\tWTB.L\t0.47797848524672126\t0.6430092838094059\t1405625919\t753070187\tFast trading\tLXE\n2013-04-30T11:00:00.000Z\tBT-A.L\t0.7630002744048395\t0.5655301296325983\t170034893\t555018287\tFast trading\tGR\n2013-04-30T22:06:40.000Z\tBT-A.L\t0.7147870329232192\t0.5047251666299352\t1632653036\t1459199712\tFast trading\tGR\n2013-05-01T10:36:40.000Z\tBT-A.L\t0.6561113751342125\t0.47910748281262994\t514913551\t831670347\tFast trading\tLXE\n2013-05-01T14:46:40.000Z\tWTB.L\t0.9460194923216076\t0.09048831254437362\t1231092052\t1026180063\tFast trading\tLXE\n2013-05-02T07:26:40.000Z\tBT-A.L\t0.9029266635624776\t0.4400626920975901\t188866311\t1663084154\tFast trading\tSK\n2013-05-02T13:00:00.000Z\tBT-A.L\t0.4129219991106413\t0.5025269563465262\t944280080\t148476167\tFast trading\tLXE\n2013-05-02T14:23:20.000Z\tWTB.L\t0.7858327043313086\t0.7679013186397453\t150870909\t427886371\tFast trading\tGR\n2013-05-02T18:33:20.000Z\tBT-A.L\t0.9296374772157955\t0.19088899950218174\t980203892\t1476326981\tFast trading\tLXE\n2013-05-02T22:43:20.000Z\tBT-A.L\t0.12282110119740142\t0.822933043281861\t997442403\t430556502\tFast trading\tSK\n2013-05-03T01:30:00.000Z\tWTB.L\t0.6696457609278927\t0.7177695674107006\t1859909396\t1567568718\tFast trading\tSK\n2013-05-03T07:03:20.000Z\tBT-A.L\t0.008144226019699663\t0.8149620429664706\t1492076657\t2143247261\tFast trading\tLXE\n";
        rs = this.q.all().withKeys(new String[]{"WTB.L", "BT-A.L"}).slice(new Interval(this.ts2, this.ts1)).asResultSet();
        TestUtils.assertEquals(expected, rs.sort());
    }

    @Test
    public void testAllOverInterval() {
        String expected = "2013-04-28T17:20:00.000Z\tADM.L\t0.9991330212896724\t0.2543630254606476\t1427291982\t1788924502\tFast trading\tGR\n2013-04-28T18:43:20.000Z\tRRS.L\t0.18670502698896196\t0.0885706583279452\t505468688\t2038459861\tFast trading\tGR\n2013-04-28T20:06:40.000Z\tAGK.L\t0.915779154884911\t0.1072445825833257\t659123462\t1516991412\tFast trading\tGR\n2013-04-28T21:30:00.000Z\tBP.L\t0.31430399958862776\t0.7442052266426017\t1902801116\t1526668764\tFast trading\tGR\n2013-04-28T22:53:20.000Z\tRRS.L\t0.7787230809761455\t0.25803443163774886\t857471455\t190622110\tFast trading\tLXE\n2013-04-29T00:16:40.000Z\tLLOY.L\t0.17078848195089802\t0.031422297574265734\t791371928\t1142552242\tFast trading\tSK\n2013-04-29T01:40:00.000Z\tWTB.L\t0.154905273744959\t0.3463641298845208\t1190004376\t548681062\tFast trading\tSK\n2013-04-29T03:03:20.000Z\tTLW.L\t0.3924674980643327\t0.42759642071766735\t325469131\t1148755905\tFast trading\tGR\n2013-04-29T04:26:40.000Z\tBP.L\t0.0723426168916399\t0.30154348935233677\t483391973\t1635859661\tFast trading\tLXE\n2013-04-29T05:50:00.000Z\tGKN.L\t0.17560585850669297\t0.6791795548403247\t2114761437\t561608998\tFast trading\tLXE\n2013-04-29T07:13:20.000Z\tWTB.L\t0.94782183700974\t0.6385933398879912\t507408673\t477022979\tFast trading\tSK\n2013-04-29T08:36:40.000Z\tAGK.L\t0.28361580324662805\t0.3566755365918044\t2099258677\t368954223\tFast trading\tSK\n2013-04-29T10:00:00.000Z\tRRS.L\t0.11597222374313398\t0.5192320969480931\t1317970912\t546140855\tFast trading\tGR\n2013-04-29T11:23:20.000Z\tGKN.L\t0.4466437532316928\t0.32495899970572273\t2015090903\t1376158663\tFast trading\tLXE\n2013-04-29T12:46:40.000Z\tBT-A.L\t0.3542490655977256\t0.19109723285077962\t1111156559\t746276626\tFast trading\tSK\n2013-04-29T14:10:00.000Z\tLLOY.L\t0.17308313956148713\t0.36721951744987336\t1526462256\t842116069\tFast trading\tSK\n2013-04-29T15:33:20.000Z\tABF.L\t0.04835893598200669\t0.6684826049193934\t272519515\t1459187837\tFast trading\tGR\n2013-04-29T16:56:40.000Z\tBP.L\t0.24254498312457362\t0.450812713380639\t955560446\t2063318120\tFast trading\tSK\n2013-04-29T18:20:00.000Z\tADM.L\t0.8926581614910641\t0.7678734619427338\t1006057945\t1923705917\tFast trading\tLXE\n2013-04-29T19:43:20.000Z\tAGK.L\t0.3998170370357713\t0.3732992994215891\t136700330\t578060629\tFast trading\tGR\n2013-04-29T21:06:40.000Z\tRRS.L\t0.27005559955766234\t0.8615598067123645\t657091681\t801271858\tFast trading\tGR\n2013-04-29T22:30:00.000Z\tAGK.L\t0.019343142400739755\t0.7769531679242314\t169194785\t2110727937\tFast trading\tSK\n2013-04-29T23:53:20.000Z\tADM.L\t0.7059511990460272\t0.9626098243028786\t353760630\t1852387051\tFast trading\tLXE\n2013-04-30T01:16:40.000Z\tTLW.L\t0.7597536320961927\t0.7700203386464268\t1200935293\t1616239737\tFast trading\tLXE\n2013-04-30T02:40:00.000Z\tAGK.L\t0.04074132935092767\t0.004484255021279582\t764755954\t1707042982\tFast trading\tSK\n2013-04-30T04:03:20.000Z\tWTB.L\t0.47797848524672126\t0.6430092838094059\t1405625919\t753070187\tFast trading\tLXE\n2013-04-30T05:26:40.000Z\tTLW.L\t0.21542235902826057\t0.42857329503151054\t774479136\t91697613\tFast trading\tSK\n2013-04-30T06:50:00.000Z\tRRS.L\t0.9224740894383063\t0.4182944098171566\t958319102\t842755864\tFast trading\tLXE\n2013-04-30T08:13:20.000Z\tTLW.L\t0.8148234471679948\t0.4429368812285467\t2005241955\t1521333140\tFast trading\tLXE\n2013-04-30T09:36:40.000Z\tADM.L\t0.9750950674803412\t0.22131379249382566\t1483122450\t1981068860\tFast trading\tLXE\n2013-04-30T11:00:00.000Z\tBT-A.L\t0.7630002744048395\t0.5655301296325983\t170034893\t555018287\tFast trading\tGR\n2013-04-30T12:23:20.000Z\tTLW.L\t0.46114243553817713\t0.7116424005305213\t1322718319\t1067901381\tFast trading\tSK\n2013-04-30T13:46:40.000Z\tLLOY.L\t0.8153204011060089\t0.31519462741564885\t1605402601\t166305656\tFast trading\tLXE\n2013-04-30T15:10:00.000Z\tLLOY.L\t0.7971190949625937\t0.062221941250062196\t1174242989\t1681071393\tFast trading\tLXE\n2013-04-30T16:33:20.000Z\tLLOY.L\t0.7417718380704188\t0.1636972956768088\t563945975\t1566126176\tFast trading\tGR\n2013-04-30T17:56:40.000Z\tGKN.L\t0.9957244238271116\t0.22502876454673404\t1074244114\t1402712074\tFast trading\tLXE\n2013-04-30T19:20:00.000Z\tBP.L\t0.34602616547919973\t0.11209766463974158\t838659555\t2089640349\tFast trading\tGR\n2013-04-30T20:43:20.000Z\tAGK.L\t0.7976185011129686\t0.4714611453741183\t2084037958\t817810247\tFast trading\tLXE\n2013-04-30T22:06:40.000Z\tBT-A.L\t0.7147870329232192\t0.5047251666299352\t1632653036\t1459199712\tFast trading\tGR\n2013-04-30T23:30:00.000Z\tLLOY.L\t0.9494879307183522\t0.445726792042184\t1942723379\t1447697900\tFast trading\tGR\n2013-05-01T00:53:20.000Z\tADM.L\t0.34195577112827147\t0.9440475343742334\t1548749696\t755946340\tFast trading\tGR\n2013-05-01T02:16:40.000Z\tGKN.L\t0.8979439248915824\t0.2195123104786394\t1682785535\t1705950772\tFast trading\tLXE\n2013-05-01T03:40:00.000Z\tRRS.L\t0.02214511956698062\t0.4197114107915003\t546860253\t131966276\tFast trading\tGR\n2013-05-01T05:03:20.000Z\tLLOY.L\t0.41878435349451426\t0.08621549406747886\t1129009178\t1386081146\tFast trading\tLXE\n2013-05-01T06:26:40.000Z\tADM.L\t0.6580721374764023\t0.015036771906895785\t1811518812\t70409996\tFast trading\tSK\n2013-05-01T07:50:00.000Z\tAGK.L\t0.9511507241696612\t0.08302202765868905\t652144090\t848553399\tFast trading\tLXE\n2013-05-01T09:13:20.000Z\tAGK.L\t0.3763621294848153\t0.804246112596439\t1954040330\t1791045465\tFast trading\tGR\n2013-05-01T10:36:40.000Z\tBT-A.L\t0.6561113751342125\t0.47910748281262994\t514913551\t831670347\tFast trading\tLXE\n2013-05-01T12:00:00.000Z\tGKN.L\t0.5962940647708228\t0.8037097062216977\t1034412808\t1681490823\tFast trading\tLXE\n2013-05-01T13:23:20.000Z\tAGK.L\t0.46920237466566783\t0.7182462450271192\t338737405\t2031458901\tFast trading\tSK\n2013-05-01T14:46:40.000Z\tWTB.L\t0.9460194923216076\t0.09048831254437362\t1231092052\t1026180063\tFast trading\tLXE\n2013-05-01T16:10:00.000Z\tTLW.L\t0.6664569545168485\t0.5541082723624778\t1520797094\t114683911\tFast trading\tLXE\n2013-05-01T17:33:20.000Z\tAGK.L\t0.17078558767565122\t0.45145442891378285\t1255386212\t1530900317\tFast trading\tGR\n2013-05-01T18:56:40.000Z\tTLW.L\t0.7134551426883604\t0.36652513994805036\t1614561742\t1432439927\tFast trading\tGR\n2013-05-01T20:20:00.000Z\tTLW.L\t0.4276939984406388\t0.17627351127106772\t56813425\t1343523717\tFast trading\tLXE\n2013-05-01T21:43:20.000Z\tBP.L\t0.4169245941596208\t0.8970066646662288\t1089760189\t632670746\tFast trading\tLXE\n2013-05-01T23:06:40.000Z\tRRS.L\t0.6115265337537894\t0.85752616310559\t2014391952\t782784264\tFast trading\tGR\n2013-05-02T00:30:00.000Z\tADM.L\t0.6484238901257546\t0.891789154715561\t839056671\t73991037\tFast trading\tLXE\n2013-05-02T01:53:20.000Z\tGKN.L\t0.6061689700945626\t0.3112527710614069\t765148442\t1939054544\tFast trading\tGR\n2013-05-02T03:16:40.000Z\tADM.L\t0.1596397886292107\t0.39069663050303693\t908049170\t504998471\tFast trading\tLXE\n2013-05-02T04:40:00.000Z\tRRS.L\t0.6061643091896248\t0.9812017566926329\t183363356\t965895392\tFast trading\tSK\n2013-05-02T06:03:20.000Z\tADM.L\t0.25882921284566274\t0.6500964117444217\t163768705\t810757175\tFast trading\tLXE\n2013-05-02T07:26:40.000Z\tBT-A.L\t0.9029266635624776\t0.4400626920975901\t188866311\t1663084154\tFast trading\tSK\n2013-05-02T08:50:00.000Z\tGKN.L\t0.3679378100903369\t0.9382300968477628\t1388063503\t1125355543\tFast trading\tSK\n2013-05-02T10:13:20.000Z\tTLW.L\t0.7801469788077624\t0.8509654712822936\t1231551112\t1554816591\tFast trading\tLXE\n2013-05-02T11:36:40.000Z\tGKN.L\t0.7299258007491024\t0.6912012922060378\t980854034\t1765743108\tFast trading\tLXE\n2013-05-02T13:00:00.000Z\tBT-A.L\t0.4129219991106413\t0.5025269563465262\t944280080\t148476167\tFast trading\tLXE\n2013-05-02T14:23:20.000Z\tWTB.L\t0.7858327043313086\t0.7679013186397453\t150870909\t427886371\tFast trading\tGR\n2013-05-02T15:46:40.000Z\tBP.L\t0.9151375584313991\t0.7807261040785343\t1688917476\t1220320444\tFast trading\tLXE\n2013-05-02T17:10:00.000Z\tBP.L\t0.9911120865317999\t0.7921542600659871\t149123703\t1990756409\tFast trading\tLXE\n2013-05-02T18:33:20.000Z\tBT-A.L\t0.9296374772157955\t0.19088899950218174\t980203892\t1476326981\tFast trading\tLXE\n2013-05-02T19:56:40.000Z\tAGK.L\t0.09076750471715689\t0.820362305963362\t1136677964\t262489859\tFast trading\tLXE\n2013-05-02T21:20:00.000Z\tGKN.L\t0.4057095419320843\t0.2930651074363966\t970097888\t1768370800\tFast trading\tGR\n2013-05-02T22:43:20.000Z\tBT-A.L\t0.12282110119740142\t0.822933043281861\t997442403\t430556502\tFast trading\tSK\n2013-05-03T00:06:40.000Z\tLLOY.L\t0.4584193481063288\t0.6640757886311363\t1934524011\t2000528632\tFast trading\tGR\n2013-05-03T01:30:00.000Z\tWTB.L\t0.6696457609278927\t0.7177695674107006\t1859909396\t1567568718\tFast trading\tSK\n2013-05-03T02:53:20.000Z\tADM.L\t0.45432377472957375\t0.24951632448448258\t1602041565\t1679979058\tFast trading\tSK\n2013-05-03T04:16:40.000Z\tAGK.L\t0.12669255867413365\t0.9441049113910885\t356218872\t1299555260\tFast trading\tLXE\n2013-05-03T05:40:00.000Z\tTLW.L\t0.7180950271706947\t0.7189931302044412\t683609150\t1494093736\tFast trading\tGR\n2013-05-03T07:03:20.000Z\tBT-A.L\t0.008144226019699663\t0.8149620429664706\t1492076657\t2143247261\tFast trading\tLXE\n2013-05-03T08:26:40.000Z\tADM.L\t0.5045865023784246\t0.6878766777137407\t1616308889\t163602422\tFast trading\tGR\n2013-05-03T09:50:00.000Z\tRRS.L\t0.5590262812936236\t0.13652035496254744\t1522957952\t1962377774\tFast trading\tLXE\n2013-05-03T11:13:20.000Z\tAGK.L\t0.1308718381894728\t0.9188520987338477\t1037118922\t4589843\tFast trading\tLXE\n2013-05-03T12:36:40.000Z\tBP.L\t0.19330691787589716\t0.8326703977785086\t195394189\t827458680\tFast trading\tLXE\n2013-05-03T14:00:00.000Z\tLLOY.L\t0.4127885420872661\t0.8665482054133304\t1506109341\t539672448\tFast trading\tGR\n2013-05-03T15:23:20.000Z\tGKN.L\t0.5275167947685228\t0.5630377869323533\t1843235138\t1122238976\tFast trading\tGR\n2013-05-03T16:46:40.000Z\tBP.L\t0.800516898126557\t0.17852653385834039\t39877735\t1842395295\tFast trading\tGR\n2013-05-03T18:10:00.000Z\tBP.L\t0.02942030917851568\t0.572757460747041\t683641977\t1362036057\tFast trading\tLXE\n2013-05-03T19:33:20.000Z\tADM.L\t0.8577260763596468\t0.01591134909601677\t901921998\t767627517\tFast trading\tSK\n2013-05-03T20:56:40.000Z\tAGK.L\t0.5512691746253235\t0.2622798544196908\t523767429\t834063697\tFast trading\tSK\n2013-05-03T22:20:00.000Z\tAGK.L\t0.9788182552381814\t0.3069421348721998\t2053761104\t1032198554\tFast trading\tLXE\n2013-05-03T23:43:20.000Z\tLLOY.L\t0.26716989176964423\t0.21548997929605662\t1042166874\t578687855\tFast trading\tSK\n";
        TestUtils.assertOrder(this.q.all().bufferedIterator(new Interval(this.ts2, this.ts1)));
        TestUtils.assertEquals(expected, this.q.all().bufferedIterator(new Interval(this.ts2, this.ts1)));
    }

    @Test
    public void testAllSinceRowid() {
        String expected = "2013-05-06T17:00:00.000Z\tABF.L\t0.9643251238886018\t0.8129177499445661\t1945548281\t499978914\tFast trading\tSK\n2013-05-06T18:23:20.000Z\tBP.L\t0.45621034230309654\t0.1747016272521107\t1179616540\t908015035\tFast trading\tGR\n2013-05-06T19:46:40.000Z\tLLOY.L\t0.7193355196302277\t0.9404701555734597\t704067095\t1668582762\tFast trading\tGR\n2013-05-06T21:10:00.000Z\tBT-A.L\t0.5802553772318062\t0.42527010055682646\t1089603881\t1629058050\tFast trading\tGR\n2013-05-06T22:33:20.000Z\tBP.L\t0.46114752131469783\t0.8979723557722048\t1579801637\t2117833235\tFast trading\tGR\n2013-05-06T23:56:40.000Z\tBT-A.L\t0.8883345886748325\t0.7737938544972554\t1750740931\t1514907397\tFast trading\tGR\n2013-05-07T01:20:00.000Z\tAGK.L\t0.5217691943089976\t0.28956673106743125\t681718809\t1972465127\tFast trading\tLXE\n2013-05-07T02:43:20.000Z\tRRS.L\t0.7051458116683191\t0.40922139034207683\t631143150\t997183581\tFast trading\tLXE\n2013-05-07T04:06:40.000Z\tADM.L\t0.861499400556018\t0.5243336208514339\t648366676\t698699955\tFast trading\tSK\n2013-05-07T05:30:00.000Z\tTLW.L\t0.5405954330001682\t0.23821846687340553\t1057951361\t1833806187\tFast trading\tLXE\n";
        TestUtils.assertEquals(expected, this.q.all().bufferedIterator(0x200000000062L));
    }

    @Test
    public void testFindWithSearchSymbols() throws JournalException {
        long millis = System.currentTimeMillis();
        Quote q1 = new Quote().setSym("S1").setEx("EX1").setTimestamp(millis);
        Quote q2 = new Quote().setSym("S2").setEx("EX1").setTimestamp(millis);
        Quote q3 = new Quote().setSym("S3").setEx("EX1").setTimestamp(millis);
        Quote q4 = new Quote().setSym("S4").setEx("EX3").setTimestamp(millis);
        this.w.append((Object[])new Quote[]{q1, q2, q3, q4});
        QueryAllBuilder builder = this.q.all().withSymValues("ex", new String[]{"EX1"});
        Assert.assertEquals((long)3L, (long)builder.asResultSet().size());
        builder.filter("sym", q1.getSym()).filter("sym", q2.getSym());
        Assert.assertEquals((long)2L, (long)builder.asResultSet().size());
        builder.resetFilter();
        try {
            builder.filter("sym", (CharSequence)"S7");
            Assert.fail((String)"Expect exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder.resetFilter();
        builder.filter("sym", q1.getSym()).filter("sym", q2.getSym()).filter("sym", q4.getSym());
        Assert.assertEquals((long)2L, (long)builder.asResultSet().size());
    }

    @Test
    public void testIterate() {
        int count = 0;
        long timestamp = 0L;
        for (Quote a : this.q.all().bufferedIterator()) {
            ++count;
            Assert.assertTrue((timestamp <= a.getTimestamp() ? 1 : 0) != 0);
            timestamp = a.getTimestamp();
        }
        Assert.assertEquals((long)1000L, (long)count);
    }

    @Test
    public void testIterateOverInterval() {
        int count = 0;
        long timestamp = 0L;
        for (Quote a : this.q.all().bufferedIterator(new Interval(this.ts2, this.ts1))) {
            ++count;
            Assert.assertTrue((timestamp <= a.getTimestamp() ? 1 : 0) != 0);
            timestamp = a.getTimestamp();
        }
        Assert.assertEquals((long)92L, (long)count);
    }

    @Test
    public void testLatestByKey() throws Exception {
        String expected = "2013-05-06T01:43:20.000Z\tWTB.L\t0.4191390374952899\t0.601628162260468\t2104114979\t1431449453\tFast trading\tLXE\n2013-05-06T05:53:20.000Z\tGKN.L\t0.6692538497726956\t0.38655868492682444\t1851982635\t389597203\tFast trading\tSK\n2013-05-06T17:00:00.000Z\tABF.L\t0.9643251238886018\t0.8129177499445661\t1945548281\t499978914\tFast trading\tSK\n2013-05-06T19:46:40.000Z\tLLOY.L\t0.7193355196302277\t0.9404701555734597\t704067095\t1668582762\tFast trading\tGR\n2013-05-06T22:33:20.000Z\tBP.L\t0.46114752131469783\t0.8979723557722048\t1579801637\t2117833235\tFast trading\tGR\n2013-05-06T23:56:40.000Z\tBT-A.L\t0.8883345886748325\t0.7737938544972554\t1750740931\t1514907397\tFast trading\tGR\n2013-05-07T01:20:00.000Z\tAGK.L\t0.5217691943089976\t0.28956673106743125\t681718809\t1972465127\tFast trading\tLXE\n2013-05-07T02:43:20.000Z\tRRS.L\t0.7051458116683191\t0.40922139034207683\t631143150\t997183581\tFast trading\tLXE\n2013-05-07T04:06:40.000Z\tADM.L\t0.861499400556018\t0.5243336208514339\t648366676\t698699955\tFast trading\tSK\n2013-05-07T05:30:00.000Z\tTLW.L\t0.5405954330001682\t0.23821846687340553\t1057951361\t1833806187\tFast trading\tLXE\n";
        UnorderedResultSet rs = this.q.head().withKeys(new String[0]).asResultSet();
        TestUtils.assertEquals(expected, rs.sort());
    }

    @Test
    public void testLatestByKeyFilter() throws Exception {
        String expected = "2013-05-06T19:46:40.000Z\tLLOY.L\t0.7193355196302277\t0.9404701555734597\t704067095\t1668582762\tFast trading\tGR\n2013-05-06T22:33:20.000Z\tBP.L\t0.46114752131469783\t0.8979723557722048\t1579801637\t2117833235\tFast trading\tGR\n2013-05-06T23:56:40.000Z\tBT-A.L\t0.8883345886748325\t0.7737938544972554\t1750740931\t1514907397\tFast trading\tGR\n";
        UnorderedResultSet rs = this.q.head().withKeys(new String[0]).filter("ex", "GR").strict(true).asResultSet();
        TestUtils.assertEquals(expected, rs.sort());
    }

    @Test
    public void testLatestByKeyFilterNonStrict() throws Exception {
        String expected = "2013-05-02T14:23:20.000Z\tWTB.L\t0.7858327043313086\t0.7679013186397453\t150870909\t427886371\tFast trading\tGR\n2013-05-04T13:36:40.000Z\tGKN.L\t0.5485152099626798\t0.3847951638258288\t543254483\t1530188749\tFast trading\tGR\n2013-05-05T06:16:40.000Z\tADM.L\t0.32183591222731356\t0.9190720816969892\t1035899527\t1133552627\tFast trading\tGR\n2013-05-05T13:13:20.000Z\tAGK.L\t0.38085166997373454\t0.11179154015541148\t1241766823\t1944335528\tFast trading\tGR\n2013-05-05T17:23:20.000Z\tTLW.L\t0.312007395214155\t0.5316391740370102\t872516781\t358245103\tFast trading\tGR\n2013-05-06T04:30:00.000Z\tABF.L\t0.6642987021593373\t0.6390097534838051\t288643332\t844966286\tFast trading\tGR\n2013-05-06T15:36:40.000Z\tRRS.L\t0.1944696111340929\t0.9477868235286393\t823976883\t1563711959\tFast trading\tGR\n2013-05-06T19:46:40.000Z\tLLOY.L\t0.7193355196302277\t0.9404701555734597\t704067095\t1668582762\tFast trading\tGR\n2013-05-06T22:33:20.000Z\tBP.L\t0.46114752131469783\t0.8979723557722048\t1579801637\t2117833235\tFast trading\tGR\n2013-05-06T23:56:40.000Z\tBT-A.L\t0.8883345886748325\t0.7737938544972554\t1750740931\t1514907397\tFast trading\tGR\n";
        UnorderedResultSet rs = this.q.head().withKeys(new String[0]).filter("ex", "GR").strict(false).asResultSet();
        TestUtils.assertEquals(expected, rs.sort());
    }

    @Test
    public void testLatestByKeyNewerThanRowid() throws Exception {
        try (JournalWriter w2 = this.getFactory().writer(Quote.class, "W2");){
            TestData.appendQuoteData1((JournalWriter<Quote>)w2);
            TestData.appendQuoteData2((JournalWriter<Quote>)w2);
            Query q = w2.query();
            String expected = "2013-05-06T01:43:20.000Z\tWTB.L\t0.4191390374952899\t0.601628162260468\t2104114979\t1431449453\tFast trading\tLXE\n2013-05-06T05:53:20.000Z\tGKN.L\t0.6692538497726956\t0.38655868492682444\t1851982635\t389597203\tFast trading\tSK\n2013-05-06T17:00:00.000Z\tABF.L\t0.9643251238886018\t0.8129177499445661\t1945548281\t499978914\tFast trading\tSK\n2013-05-06T19:46:40.000Z\tLLOY.L\t0.7193355196302277\t0.9404701555734597\t704067095\t1668582762\tFast trading\tGR\n2013-05-06T22:33:20.000Z\tBP.L\t0.46114752131469783\t0.8979723557722048\t1579801637\t2117833235\tFast trading\tGR\n2013-05-06T23:56:40.000Z\tBT-A.L\t0.8883345886748325\t0.7737938544972554\t1750740931\t1514907397\tFast trading\tGR\n2013-05-07T01:20:00.000Z\tAGK.L\t0.5217691943089976\t0.28956673106743125\t681718809\t1972465127\tFast trading\tLXE\n2013-05-07T02:43:20.000Z\tRRS.L\t0.7051458116683191\t0.40922139034207683\t631143150\t997183581\tFast trading\tLXE\n2013-05-07T04:06:40.000Z\tADM.L\t0.861499400556018\t0.5243336208514339\t648366676\t698699955\tFast trading\tSK\n2013-05-07T05:30:00.000Z\tTLW.L\t0.5405954330001682\t0.23821846687340553\t1057951361\t1833806187\tFast trading\tLXE\n";
            QueryHeadBuilder b = q.head().withKeys(new String[0]).limit(0x200000000062L);
            UnorderedResultSet rs = b.asResultSet();
            TestUtils.assertEquals(expected, rs.sort());
            Assert.assertEquals((long)13L, (long)b.limit(-1L).asResultSet().size());
        }
    }

    @Test
    public void testLatestByKeyOverInterval() throws Exception {
        String expected = "2013-04-29T15:33:20.000Z\tABF.L\t0.04835893598200669\t0.6684826049193934\t272519515\t1459187837\tFast trading\tGR\n2013-05-03T01:30:00.000Z\tWTB.L\t0.6696457609278927\t0.7177695674107006\t1859909396\t1567568718\tFast trading\tSK\n2013-05-03T05:40:00.000Z\tTLW.L\t0.7180950271706947\t0.7189931302044412\t683609150\t1494093736\tFast trading\tGR\n2013-05-03T07:03:20.000Z\tBT-A.L\t0.008144226019699663\t0.8149620429664706\t1492076657\t2143247261\tFast trading\tLXE\n2013-05-03T09:50:00.000Z\tRRS.L\t0.5590262812936236\t0.13652035496254744\t1522957952\t1962377774\tFast trading\tLXE\n2013-05-03T15:23:20.000Z\tGKN.L\t0.5275167947685228\t0.5630377869323533\t1843235138\t1122238976\tFast trading\tGR\n2013-05-03T18:10:00.000Z\tBP.L\t0.02942030917851568\t0.572757460747041\t683641977\t1362036057\tFast trading\tLXE\n2013-05-03T19:33:20.000Z\tADM.L\t0.8577260763596468\t0.01591134909601677\t901921998\t767627517\tFast trading\tSK\n2013-05-03T22:20:00.000Z\tAGK.L\t0.9788182552381814\t0.3069421348721998\t2053761104\t1032198554\tFast trading\tLXE\n2013-05-03T23:43:20.000Z\tLLOY.L\t0.26716989176964423\t0.21548997929605662\t1042166874\t578687855\tFast trading\tSK\n";
        UnorderedResultSet rs = this.q.head().withKeys(new String[0]).limit(new Interval(this.ts2, this.ts1)).asResultSet();
        TestUtils.assertEquals(expected, rs.sort());
    }

    @Test
    public void testLatestByKeyValueOverInterval() throws JournalException {
        Quote Quote2 = (Quote)this.q.head().withKeys(new String[]{"RRS.L"}).limit(new Interval(this.ts2, this.ts1)).asResultSet().readFirst();
        Assert.assertNotNull((Object)Quote2);
        Assert.assertEquals((double)0.5590262812936236, (double)Quote2.getBid(), (double)1.0E-11);
    }

    @Test
    public void testLatestByKeyValues() throws Exception {
        String expected = "2013-05-06T22:33:20.000Z\tBP.L\t0.46114752131469783\t0.8979723557722048\t1579801637\t2117833235\tFast trading\tGR\n2013-05-07T01:20:00.000Z\tAGK.L\t0.5217691943089976\t0.28956673106743125\t681718809\t1972465127\tFast trading\tLXE\n";
        UnorderedResultSet rs = this.q.head().withKeys(new String[]{"BP.L", "AGK.L"}).asResultSet();
        TestUtils.assertEquals(expected, rs.sort());
    }

    @Test
    public void testLatestByKeyValuesFilter() throws Exception {
        String expected = "2013-05-06T01:43:20.000Z\tWTB.L\t0.4191390374952899\t0.601628162260468\t2104114979\t1431449453\tFast trading\tLXE\n2013-05-07T01:20:00.000Z\tAGK.L\t0.5217691943089976\t0.28956673106743125\t681718809\t1972465127\tFast trading\tLXE\n";
        UnorderedResultSet rs = this.q.head().withKeys(new String[]{"WTB.L", "AGK.L"}).filter("ex", "LXE").asResultSet();
        TestUtils.assertEquals(expected, rs);
    }

    @Test
    public void testLatestByKeyValuesOverInterval() throws Exception {
        String expected = "2013-05-03T18:10:00.000Z\tBP.L\t0.02942030917851568\t0.572757460747041\t683641977\t1362036057\tFast trading\tLXE\n2013-05-03T22:20:00.000Z\tAGK.L\t0.9788182552381814\t0.3069421348721998\t2053761104\t1032198554\tFast trading\tLXE\n";
        UnorderedResultSet rs = this.q.head().withKeys(new String[]{"BP.L", "AGK.L", "BAD"}).limit(new Interval(this.ts2, this.ts1)).asResultSet();
        TestUtils.assertEquals(expected, rs);
    }

    @Test
    public void testLatestByKeyWithinMonths() throws Exception {
        long max = this.w.getAppendTimestampLo();
        long inc = System.currentTimeMillis() - max;
        try (JournalWriter w2 = this.getFactory().writer(Quote.class, "w2");){
            for (Quote a : JournalIterators.bufferedIterator((Journal)this.q.getJournal())) {
                a.setTimestamp(a.getTimestamp() + inc);
                w2.append((Object)a);
            }
            Query q = w2.query();
            long millis = System.currentTimeMillis();
            Interval interval = new Interval(Dates.addMonths((long)millis, (int)-1), millis);
            UnorderedResultSet rs = q.getJournal().query().head().withKeys(new String[0]).limit(interval).asResultSet();
            Assert.assertEquals((long)10L, (long)rs.size());
        }
    }

    @Test
    public void testLatestBySymbol() throws Exception {
        String expected = "2013-05-06T23:56:40.000Z\tBT-A.L\t0.8883345886748325\t0.7737938544972554\t1750740931\t1514907397\tFast trading\tGR\n2013-05-07T04:06:40.000Z\tADM.L\t0.861499400556018\t0.5243336208514339\t648366676\t698699955\tFast trading\tSK\n2013-05-07T05:30:00.000Z\tTLW.L\t0.5405954330001682\t0.23821846687340553\t1057951361\t1833806187\tFast trading\tLXE\n";
        try (Journal r = this.getFactory().reader(Quote.class);){
            Query qq = r.query();
            UnorderedResultSet rs = qq.head().withSymValues("ex", new String[0]).asResultSet();
            TestUtils.assertEquals(expected, rs.sort());
        }
    }

    @Test
    public void testLatestBySymbolFilter() throws Exception {
        String expected = "2013-02-10T11:22:30.000Z\tHSBA.L\t0.30903524429086027\t0.10792189935863805\t954532266\t632039501\tFast trading\tLN";
        try (JournalWriter w2 = this.getFactory().writer(Quote.class, "W2");){
            TestData.appendQuoteData1((JournalWriter<Quote>)w2);
            TestData.appendQuoteData2((JournalWriter<Quote>)w2);
            Query q = w2.query();
            QueryHeadBuilder builder = q.head().withSymValues("sym", new String[0]).filter("ex", "LN");
            UnorderedResultSet rs = builder.asResultSet();
            TestUtils.assertEquals(expected, rs);
            builder.resetFilter();
            try {
                builder.filter("ex", "NOP");
                Assert.fail((String)"Expected exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLatestBySymbolOverInterval() throws Exception {
        String expected = "2013-05-03T22:20:00.000Z\tAGK.L\t0.9788182552381814\t0.3069421348721998\t2053761104\t1032198554\tFast trading\tLXE\n2013-05-03T16:46:40.000Z\tBP.L\t0.800516898126557\t0.17852653385834039\t39877735\t1842395295\tFast trading\tGR\n2013-05-03T23:43:20.000Z\tLLOY.L\t0.26716989176964423\t0.21548997929605662\t1042166874\t578687855\tFast trading\tSK\n";
        UnorderedResultSet rs = this.q.head().withSymValues("ex", new String[0]).limit(new Interval(this.ts2, this.ts1)).asResultSet();
        TestUtils.assertEquals(expected, rs);
    }

    @Test
    public void testLatestBySymbolValues() throws Exception {
        try (JournalWriter w2 = this.getFactory().writer(Quote.class, "W2");){
            TestData.appendQuoteData1((JournalWriter<Quote>)w2);
            TestData.appendQuoteData2((JournalWriter<Quote>)w2);
            Query q = w2.query();
            String expected = "2013-02-10T11:22:30.000Z\tHSBA.L\t0.30903524429086027\t0.10792189935863805\t954532266\t632039501\tFast trading\tLN\n2013-05-06T23:56:40.000Z\tBT-A.L\t0.8883345886748325\t0.7737938544972554\t1750740931\t1514907397\tFast trading\tGR\n2013-05-07T05:30:00.000Z\tTLW.L\t0.5405954330001682\t0.23821846687340553\t1057951361\t1833806187\tFast trading\tLXE\n";
            UnorderedResultSet rs = q.getJournal().query().head().withSymValues("ex", new String[]{"LXE", "GR", "LN"}).asResultSet();
            TestUtils.assertEquals(expected, rs.sort());
        }
    }

    @Test
    public void testLatestBySymbolValuesFilter() throws Exception {
        try (JournalWriter w2 = this.getFactory().writer(Quote.class, "W2");){
            TestData.appendQuoteData1((JournalWriter<Quote>)w2);
            TestData.appendQuoteData2((JournalWriter<Quote>)w2);
            Query q = w2.query();
            String expected = "2013-05-06T01:43:20.000Z\tWTB.L\t0.4191390374952899\t0.601628162260468\t2104114979\t1431449453\tFast trading\tLXE\n2013-05-07T01:20:00.000Z\tAGK.L\t0.5217691943089976\t0.28956673106743125\t681718809\t1972465127\tFast trading\tLXE\n";
            UnorderedResultSet rs = q.getJournal().query().head().withKeys(new String[]{"WTB.L", "AGK.L", "HSBA.L"}).filter("ex", "LXE").asResultSet();
            TestUtils.assertEquals(expected, rs);
        }
    }

    @Test
    public void testParallelIteratorInterval() throws Exception {
        Interval interval = new Interval((CharSequence)"2013-05-04T06:40:00.000Z", (CharSequence)"2013-05-05T17:23:20.000Z");
        try (Journal r = this.getFactory().reader(Quote.class);){
            Query q2 = r.query();
            JournalIterator expected = this.q.all().iterator(interval);
            try (ConcurrentIterator actual = q2.all().concurrentIterator(interval);){
                TestUtils.assertEquals(expected, actual);
            }
        }
    }

    @Test
    public void testParallelIteratorRowid() throws Exception {
        String expected = "2013-04-06T16:10:00.000Z\tTLW.L\t0.35560921415594904\t0.9172386201102186\t1499912642\t1265370018\tFast trading\tSK\n2013-04-06T17:33:20.000Z\tWTB.L\t0.09318693145536094\t0.462052142027227\t1376280465\t1902140281\tFast trading\tSK\n2013-04-06T18:56:40.000Z\tTLW.L\t0.23015105422730142\t0.9261844752564334\t297992017\t833849767\tFast trading\tSK\n2013-04-06T20:20:00.000Z\tLLOY.L\t0.591117341585881\t0.5452557879563172\t299131275\t1439565722\tFast trading\tSK\n2013-04-06T21:43:20.000Z\tRRS.L\t0.4434952169269565\t0.39835749608347526\t619814536\t317683291\tFast trading\tLXE\n2013-04-06T23:06:40.000Z\tBT-A.L\t0.5739925348641143\t0.6596992778098775\t216861646\t404014281\tFast trading\tSK\n2013-04-07T00:30:00.000Z\tRRS.L\t0.7907767978190797\t0.9093274249414792\t179668237\t44851565\tFast trading\tSK\n2013-04-07T01:53:20.000Z\tAGK.L\t0.44958980653320546\t0.40370219100109794\t2001010971\t1122933616\tFast trading\tSK\n2013-04-07T03:16:40.000Z\tBP.L\t0.8335581117125144\t0.6805542672889585\t71576921\t945785235\tFast trading\tGR\n2013-04-07T04:40:00.000Z\tWTB.L\t0.6041370472325764\t0.252323120735614\t1587793084\t2092278888\tFast trading\tGR\n2013-04-07T06:03:20.000Z\tGKN.L\t0.08457162841593502\t0.42861337596982696\t717486434\t1034798442\tFast trading\tGR\n2013-04-07T07:26:40.000Z\tBP.L\t0.8374522381795418\t0.5004874239595963\t1875990706\t2028067587\tFast trading\tLXE\n2013-04-07T08:50:00.000Z\tGKN.L\t0.854389213320831\t0.618046030684742\t1310416631\t1278104325\tFast trading\tGR\n2013-04-07T10:13:20.000Z\tAGK.L\t0.6885250685259713\t0.697630966035547\t1438294841\t1079791549\tFast trading\tSK\n2013-04-07T11:36:40.000Z\tABF.L\t0.029548779446849638\t0.6061166914687964\t1601197502\t1918901047\tFast trading\tGR\n2013-04-07T13:00:00.000Z\tWTB.L\t0.5460716492767211\t0.6871411451286055\t1363237666\t1140462709\tFast trading\tLXE\n2013-04-07T14:23:20.000Z\tABF.L\t0.30166981893719325\t0.41775812361404374\t1390773164\t68558445\tFast trading\tSK\n2013-04-07T15:46:40.000Z\tGKN.L\t0.6885935253992717\t0.6138767085288782\t1585802486\t1396641743\tFast trading\tLXE\n2013-04-07T17:10:00.000Z\tWTB.L\t0.6170888535833703\t0.13898614654359087\t1015843\t709260396\tFast trading\tLXE\n2013-04-07T18:33:20.000Z\tWTB.L\t0.6484725044036787\t0.5130472808141452\t1334770047\t1689763134\tFast trading\tSK\n2013-04-07T19:56:40.000Z\tBP.L\t0.8665462798175759\t0.1670643770612965\t1529262014\t819780821\tFast trading\tSK\n2013-04-07T21:20:00.000Z\tWTB.L\t0.5446322124496282\t0.34373406392439276\t1010571836\t1338735829\tFast trading\tGR\n2013-04-07T22:43:20.000Z\tTLW.L\t0.08445562540026363\t0.8057010845622595\t348639110\t662998688\tFast trading\tSK\n2013-04-08T00:06:40.000Z\tABF.L\t0.2782979037102863\t0.5803329643286541\t669084431\t519944510\tFast trading\tSK\n2013-04-08T01:30:00.000Z\tADM.L\t0.6772866261859543\t0.9435589086077454\t643122313\t1718982754\tFast trading\tGR\n2013-04-08T02:53:20.000Z\tGKN.L\t0.7363856352154096\t0.7252011230678672\t411457815\t1587206675\tFast trading\tGR\n2013-04-08T04:16:40.000Z\tWTB.L\t0.4505932817558773\t0.8043587443364488\t544814688\t2124731244\tFast trading\tGR\n2013-04-08T05:40:00.000Z\tGKN.L\t0.39705202742960066\t0.3557886626477764\t955591452\t1886694505\tFast trading\tGR\n2013-04-08T07:03:20.000Z\tRRS.L\t0.45421824614642514\t0.006859209217415785\t1632156898\t1047784493\tFast trading\tGR\n2013-04-08T08:26:40.000Z\tWTB.L\t0.9819360431631439\t0.5695361273766868\t756583855\t2003081809\tFast trading\tSK\n2013-04-08T09:50:00.000Z\tADM.L\t0.9152046603079531\t0.42299282525316784\t583479335\t190732392\tFast trading\tGR\n2013-04-08T11:13:20.000Z\tBP.L\t0.049623774103303986\t0.9398196769912591\t351405844\t2095858279\tFast trading\tLXE\n2013-04-08T12:36:40.000Z\tWTB.L\t0.7779468644792912\t0.5724402034784827\t1942116613\t1118304959\tFast trading\tLXE\n2013-04-08T14:00:00.000Z\tADM.L\t0.6748677495199101\t0.34622453251689445\t1106426717\t1888042318\tFast trading\tLXE\n2013-04-08T15:23:20.000Z\tABF.L\t0.6211109853537905\t0.5419234021162765\t52494124\t1067786452\tFast trading\tSK\n2013-04-08T16:46:40.000Z\tBP.L\t0.6080917787848515\t0.29242869695299356\t118958135\t20439620\tFast trading\tGR\n2013-04-08T18:10:00.000Z\tBP.L\t0.9708568883763371\t0.6674998420935889\t1259146070\t1824086848\tFast trading\tLXE\n2013-04-08T19:33:20.000Z\tTLW.L\t0.5597127305005968\t0.5749773230697712\t2035509958\t2038361999\tFast trading\tLXE\n2013-04-08T20:56:40.000Z\tGKN.L\t0.27989264650934564\t0.4681379885320214\t2108852897\t1375524175\tFast trading\tSK\n2013-04-08T22:20:00.000Z\tLLOY.L\t0.5038104908453604\t0.4162298179621343\t430837498\t1104692281\tFast trading\tLXE\n2013-04-08T23:43:20.000Z\tRRS.L\t0.09189276993800843\t0.568855831738339\t2130421641\t299821716\tFast trading\tSK\n2013-04-09T01:06:40.000Z\tWTB.L\t0.1456773027643552\t0.424760421725754\t430883984\t1363096866\tFast trading\tGR\n2013-04-09T02:30:00.000Z\tBP.L\t0.16081138530571393\t0.6017039053008107\t1761016960\t1138404246\tFast trading\tSK\n2013-04-09T03:53:20.000Z\tRRS.L\t0.9477776913618496\t0.9964936271945233\t1948046906\t362644359\tFast trading\tGR\n2013-04-09T05:16:40.000Z\tAGK.L\t0.5446218399179089\t0.3228735097385492\t138689190\t1569588133\tFast trading\tGR\n2013-04-09T06:40:00.000Z\tADM.L\t0.35865034848682154\t0.01985572199691299\t43529894\t1579917514\tFast trading\tGR\n2013-04-09T08:03:20.000Z\tWTB.L\t0.9430136140315148\t0.43421188676000366\t2033361681\t586818068\tFast trading\tGR\n2013-04-09T09:26:40.000Z\tTLW.L\t0.13928312971286616\t0.9982236783093859\t22869879\t489232925\tFast trading\tGR\n2013-04-09T10:50:00.000Z\tBP.L\t0.7985782327350075\t0.8474252137435443\t1486806485\t1304709849\tFast trading\tSK\n2013-04-09T12:13:20.000Z\tBT-A.L\t0.9314924845510815\t0.9529528578288986\t22012732\t1327307984\tFast trading\tLXE\n2013-04-09T13:36:40.000Z\tWTB.L\t0.9310150530856935\t0.37925093252829445\t597069980\t1901350938\tFast trading\tLXE\n2013-04-09T15:00:00.000Z\tGKN.L\t0.46283846564601216\t0.72026413894446\t1815186260\t863073247\tFast trading\tGR\n2013-04-09T16:23:20.000Z\tADM.L\t0.7238882678320021\t0.1158806174042738\t896187570\t193873766\tFast trading\tGR\n2013-04-09T17:46:40.000Z\tRRS.L\t0.03260668994743732\t0.5052726861384157\t1851255858\t28096868\tFast trading\tLXE\n2013-04-09T19:10:00.000Z\tWTB.L\t0.13346661978551455\t0.9349144121022714\t133340010\t37428088\tFast trading\tSK\n2013-04-09T20:33:20.000Z\tTLW.L\t0.1733884348609862\t0.8064386631236243\t749354149\t414445013\tFast trading\tLXE\n2013-04-09T21:56:40.000Z\tBP.L\t0.03917674348745892\t0.9231285908497984\t1108175273\t590518608\tFast trading\tSK\n2013-04-09T23:20:00.000Z\tABF.L\t0.6327901008093363\t0.07372177447106776\t478323144\t661688215\tFast trading\tLXE\n2013-04-10T00:43:20.000Z\tLLOY.L\t0.7052015164756813\t0.6783373850522496\t459759041\t1832922722\tFast trading\tGR\n2013-04-10T02:06:40.000Z\tRRS.L\t0.0698033200645255\t0.7137206301380554\t540386994\t555749586\tFast trading\tSK\n2013-04-10T03:30:00.000Z\tGKN.L\t0.3727548210845594\t0.7336301165755634\t392898673\t2081000801\tFast trading\tLXE\n2013-04-10T04:53:20.000Z\tABF.L\t0.11036704014068188\t0.3050781545498934\t787714018\t359939368\tFast trading\tLXE\n2013-04-10T06:16:40.000Z\tABF.L\t0.25256361479613265\t0.5922652634772446\t337130986\t122724805\tFast trading\tSK\n2013-04-10T07:40:00.000Z\tGKN.L\t0.6566526008373786\t0.13743448913059375\t291088579\t40953681\tFast trading\tLXE\n2013-04-10T09:03:20.000Z\tRRS.L\t0.43708900064755685\t0.11150247681030112\t1999403204\t1729726775\tFast trading\tGR\n2013-04-10T10:26:40.000Z\tBT-A.L\t0.5946033790920804\t0.43720839386865773\t614374612\t709597001\tFast trading\tLXE\n2013-04-10T11:50:00.000Z\tGKN.L\t0.5020170988556102\t0.22365364535573595\t1780660690\t782224540\tFast trading\tLXE\n2013-04-10T13:13:20.000Z\tLLOY.L\t0.294259908973179\t0.8934885297582834\t145057312\t362158502\tFast trading\tSK\n2013-04-10T14:36:40.000Z\tABF.L\t0.8165513441081333\t0.23263479431794531\t1903421864\t1834997049\tFast trading\tGR\n2013-04-10T16:00:00.000Z\tGKN.L\t0.5474020584226647\t0.3473159033735128\t1236974762\t1876426668\tFast trading\tGR\n2013-04-10T17:23:20.000Z\tABF.L\t0.8320372555522894\t0.17429938584744442\t1611303725\t2098284316\tFast trading\tGR\n2013-04-10T18:46:40.000Z\tBT-A.L\t0.8370391775305112\t0.7576386691511541\t22854126\t357786218\tFast trading\tGR\n2013-04-10T20:10:00.000Z\tRRS.L\t0.8684509686534004\t0.9788347701723669\t1205536537\t2020478416\tFast trading\tLXE\n2013-04-10T21:33:20.000Z\tABF.L\t0.08327985210388555\t0.8072204588812859\t413877728\t1563376784\tFast trading\tLXE\n2013-04-10T22:56:40.000Z\tTLW.L\t0.1682827026141166\t0.42350294379902675\t1145541597\t1817032875\tFast trading\tGR\n2013-04-11T00:20:00.000Z\tLLOY.L\t0.2601120804557151\t0.7617836798503381\t1858794463\t2085003640\tFast trading\tLXE\n2013-04-11T01:43:20.000Z\tTLW.L\t0.23734674310031678\t0.11400658125202778\t1019237415\t1998857059\tFast trading\tGR\n2013-04-11T03:06:40.000Z\tWTB.L\t0.5276255146262986\t0.44566894368497534\t764152855\t1495971477\tFast trading\tGR\n2013-04-11T04:30:00.000Z\tBP.L\t0.7420486594780815\t0.9827620705089128\t1816697444\t480637661\tFast trading\tGR\n2013-04-11T05:53:20.000Z\tRRS.L\t0.7742067404246902\t0.44729165755984635\t1265852112\t1189288932\tFast trading\tGR\n2013-04-11T07:16:40.000Z\tWTB.L\t0.4826414331656841\t0.04236024292835727\t1826383918\t412460454\tFast trading\tLXE\n2013-04-11T08:40:00.000Z\tBT-A.L\t0.7132390214367057\t0.9176774986109685\t720265365\t1952119555\tFast trading\tSK\n2013-04-11T10:03:20.000Z\tBT-A.L\t0.21200164098803476\t0.3824966097832866\t1598370272\t1347033932\tFast trading\tLXE\n2013-04-11T11:26:40.000Z\tBT-A.L\t0.9288376378484703\t0.575357572249812\t758859218\t135501549\tFast trading\tGR\n2013-04-11T12:50:00.000Z\tAGK.L\t0.3194567815416579\t0.6486519079566281\t1629589602\t991212771\tFast trading\tGR\n2013-04-11T14:13:20.000Z\tWTB.L\t0.5151521483748106\t0.7809047442518566\t1712183459\t269489570\tFast trading\tSK\n2013-04-11T15:36:40.000Z\tAGK.L\t0.6491952684372455\t0.4908045359430817\t562288418\t469942724\tFast trading\tSK\n2013-04-11T17:00:00.000Z\tABF.L\t0.20376680299895877\t0.7943922974919717\t995459777\t156390020\tFast trading\tSK\n2013-04-11T18:23:20.000Z\tBP.L\t0.9727900666691593\t0.7204557795721664\t1847116612\t1556996629\tFast trading\tSK\n2013-04-11T19:46:40.000Z\tLLOY.L\t0.12373027835067774\t0.5790563063428439\t2101497226\t1540729519\tFast trading\tLXE\n2013-04-11T21:10:00.000Z\tRRS.L\t0.8853674289236996\t0.1642494458488284\t43792805\t739998397\tFast trading\tLXE\n2013-04-11T22:33:20.000Z\tRRS.L\t0.5887462241995965\t0.7644426933442917\t2042979149\t1116677255\tFast trading\tSK\n2013-04-11T23:56:40.000Z\tTLW.L\t0.14495186453770403\t0.4524669309867406\t161433987\t2039521367\tFast trading\tGR\n2013-04-12T01:20:00.000Z\tRRS.L\t0.5560554725158996\t0.6323206219300084\t259120273\t323379310\tFast trading\tSK\n2013-04-12T02:43:20.000Z\tWTB.L\t0.7245186414571044\t0.23067902065561263\t652665471\t2018392582\tFast trading\tLXE\n2013-04-12T04:06:40.000Z\tGKN.L\t0.6515415838396731\t0.23864306315970418\t1532849054\t1023222371\tFast trading\tGR\n2013-04-12T05:30:00.000Z\tWTB.L\t0.09628502096222857\t0.5328356645844774\t1350084863\t1055041470\tFast trading\tGR\n2013-04-12T06:53:20.000Z\tGKN.L\t0.9055907239720848\t0.034836048682158394\t344123135\t1710271924\tFast trading\tSK\n2013-04-12T08:16:40.000Z\tAGK.L\t0.5177716223670221\t0.30407501609169385\t501376435\t764837384\tFast trading\tGR\n2013-04-12T09:40:00.000Z\tTLW.L\t0.5942371359477656\t0.6016978129555995\t1012128124\t1425980453\tFast trading\tLXE\n2013-04-12T11:03:20.000Z\tBT-A.L\t0.33916490139214217\t0.3115329265295679\t215665021\t1227901882\tFast trading\tGR\n2013-04-12T12:26:40.000Z\tBP.L\t0.8301255802811823\t0.35918901657596136\t1456345630\t657431940\tFast trading\tSK\n2013-04-12T13:50:00.000Z\tGKN.L\t0.6015122660789668\t0.931434237368395\t1492399735\t1294526166\tFast trading\tGR\n2013-04-12T15:13:20.000Z\tWTB.L\t0.7978218817864975\t0.3653953654981392\t320156718\t494303111\tFast trading\tLXE\n2013-04-12T16:36:40.000Z\tAGK.L\t0.4452808809996973\t0.5507469928526005\t1828402881\t1545424865\tFast trading\tSK\n2013-04-12T18:00:00.000Z\tWTB.L\t0.7780029038096427\t0.5679437211432476\t1919924427\t1446437038\tFast trading\tSK\n2013-04-12T19:23:20.000Z\tTLW.L\t0.0988116314765336\t0.571680968107846\t1517758391\t1930703316\tFast trading\tLXE\n2013-04-12T20:46:40.000Z\tLLOY.L\t0.35505708072152053\t0.12115332165080916\t1802811652\t1596613845\tFast trading\tGR\n2013-04-12T22:10:00.000Z\tABF.L\t0.46619911230058486\t0.25731155367539116\t489536881\t600890421\tFast trading\tGR\n2013-04-12T23:33:20.000Z\tAGK.L\t0.45262697107209293\t0.6322027994869411\t1738755188\t2053118367\tFast trading\tSK\n2013-04-13T00:56:40.000Z\tWTB.L\t0.5841294181372991\t0.9066105776170947\t1747312581\t1286423150\tFast trading\tSK\n2013-04-13T02:20:00.000Z\tRRS.L\t0.09162483559440004\t0.4495948764377925\t806297901\t528057978\tFast trading\tGR\n2013-04-13T03:43:20.000Z\tGKN.L\t0.4672064585480441\t0.09716486029818305\t1801198155\t487777042\tFast trading\tLXE\n2013-04-13T05:06:40.000Z\tADM.L\t0.015252709908849305\t0.35719942864987586\t1536084074\t1742120246\tFast trading\tSK\n2013-04-13T06:30:00.000Z\tBP.L\t0.11129849285823601\t0.9838643139591695\t796068953\t630659425\tFast trading\tGR\n2013-04-13T07:53:20.000Z\tADM.L\t0.5755580580732055\t0.28715652707506734\t329574901\t1221890853\tFast trading\tGR\n2013-04-13T09:16:40.000Z\tTLW.L\t0.6744357940661624\t0.8918402257218604\t27272954\t1256412492\tFast trading\tSK\n2013-04-13T10:40:00.000Z\tAGK.L\t0.5260563203664265\t0.914920585566174\t1111737575\t1891745851\tFast trading\tLXE\n2013-04-13T12:03:20.000Z\tAGK.L\t0.10479087625257688\t0.6919354839867665\t269653802\t613800212\tFast trading\tGR\n2013-04-13T13:26:40.000Z\tWTB.L\t0.614951687320939\t0.2497269016058733\t1518551843\t912632393\tFast trading\tSK\n2013-04-13T14:50:00.000Z\tRRS.L\t0.7352724852578524\t0.6969877519453052\t1914356060\t1852763665\tFast trading\tGR\n2013-04-13T16:13:20.000Z\tAGK.L\t0.1234871079176908\t0.5837616548597029\t1176962272\t1966539941\tFast trading\tGR\n2013-04-13T17:36:40.000Z\tRRS.L\t0.6142647200315485\t0.06720675956824373\t515398158\t259454960\tFast trading\tLXE\n2013-04-13T19:00:00.000Z\tLLOY.L\t0.7439550800254134\t0.41331699871319083\t734458091\t668277877\tFast trading\tLXE\n2013-04-13T20:23:20.000Z\tGKN.L\t0.592042164046212\t0.9629273212908004\t205838084\t209571067\tFast trading\tLXE\n2013-04-13T21:46:40.000Z\tRRS.L\t0.44190038746062466\t0.19521210881812778\t600874233\t2082762351\tFast trading\tGR\n2013-04-13T23:10:00.000Z\tBT-A.L\t0.4323928188633599\t0.9330188111715949\t1983027816\t1313554524\tFast trading\tGR\n2013-04-14T00:33:20.000Z\tABF.L\t0.19704572825277322\t0.0517615928400752\t1010577027\t2101055363\tFast trading\tLXE\n2013-04-14T01:56:40.000Z\tRRS.L\t0.4689796372870788\t0.27723282940573746\t264611403\t535315040\tFast trading\tGR\n2013-04-14T03:20:00.000Z\tTLW.L\t0.7674719870869265\t0.7875726246210093\t667277015\t1819485115\tFast trading\tGR\n2013-04-14T04:43:20.000Z\tAGK.L\t0.5759721129170616\t0.3707700676407295\t1629426243\t329306304\tFast trading\tSK\n2013-04-14T06:06:40.000Z\tBP.L\t0.8715841039589816\t0.8314518567719068\t2027503140\t1599810249\tFast trading\tSK\n2013-04-14T07:30:00.000Z\tWTB.L\t0.4724791929230956\t0.18934762268772565\t1372177705\t801781657\tFast trading\tLXE\n2013-04-14T08:53:20.000Z\tLLOY.L\t0.43239368851877147\t0.966703407853948\t316482966\t325126368\tFast trading\tGR\n2013-04-14T10:16:40.000Z\tABF.L\t0.6303146206755303\t0.5230479970448297\t1976690493\t700259204\tFast trading\tSK\n2013-04-14T11:40:00.000Z\tRRS.L\t0.7786499803365622\t0.9630993283404299\t650013006\t679435764\tFast trading\tSK\n2013-04-14T13:03:20.000Z\tAGK.L\t0.3046261166147757\t0.6172312518918114\t654430486\t1039031933\tFast trading\tSK\n2013-04-14T14:26:40.000Z\tTLW.L\t0.9473500288968267\t0.4738035956489056\t337880947\t1949886263\tFast trading\tLXE\n2013-04-14T15:50:00.000Z\tBP.L\t0.45691954124725853\t0.22879127530143317\t1965609204\t455678191\tFast trading\tGR\n2013-04-14T17:13:20.000Z\tADM.L\t0.48215973080769614\t0.8105310498862247\t1922649316\t1286210147\tFast trading\tGR\n2013-04-14T18:36:40.000Z\tTLW.L\t0.5900093815956629\t0.3360375046669055\t654347978\t1408172517\tFast trading\tLXE\n2013-04-14T20:00:00.000Z\tADM.L\t0.37227642666662075\t0.4602222535407632\t1458520828\t971841176\tFast trading\tSK\n2013-04-14T21:23:20.000Z\tGKN.L\t0.7644266379356587\t0.9904835205760758\t103793814\t1169142322\tFast trading\tLXE\n2013-04-14T22:46:40.000Z\tBP.L\t0.026265089951411746\t0.45651599223832307\t470102385\t2033513892\tFast trading\tSK\n2013-04-15T00:10:00.000Z\tTLW.L\t0.31581565331261785\t0.048823515855741406\t1941689663\t393306775\tFast trading\tLXE\n2013-04-15T01:33:20.000Z\tADM.L\t0.4253984303975874\t0.9693001837291547\t853547964\t1668746277\tFast trading\tLXE\n2013-04-15T02:56:40.000Z\tAGK.L\t0.042850821109493564\t0.7733780644672739\t1589746189\t51331549\tFast trading\tSK\n2013-04-15T04:20:00.000Z\tBP.L\t0.8510330708910628\t0.7256227259580637\t1984376557\t1936805688\tFast trading\tSK\n2013-04-15T05:43:20.000Z\tLLOY.L\t0.8852045715983282\t0.5392903504391368\t723883797\t1630361761\tFast trading\tGR\n2013-04-15T07:06:40.000Z\tABF.L\t0.8305522917004627\t0.12524340156234515\t1819911059\t2029983337\tFast trading\tSK\n2013-04-15T08:30:00.000Z\tWTB.L\t0.36109804213314445\t0.13675412505529216\t375461039\t1042217593\tFast trading\tSK\n2013-04-15T09:53:20.000Z\tGKN.L\t0.19640712109848357\t0.164108302594284\t117732481\t2103752326\tFast trading\tLXE\n2013-04-15T11:16:40.000Z\tABF.L\t0.28396522841965643\t0.40655469404610844\t1500959728\t301005020\tFast trading\tSK\n2013-04-15T12:40:00.000Z\tBT-A.L\t0.40278675048432566\t0.5290276171414775\t741731269\t1333177957\tFast trading\tLXE\n2013-04-15T14:03:20.000Z\tWTB.L\t0.5277624164003275\t0.19720409124205696\t77352698\t736421577\tFast trading\tLXE\n2013-04-15T15:26:40.000Z\tTLW.L\t0.4944495836700432\t0.4768385024120426\t1331896434\t1480894198\tFast trading\tLXE\n2013-04-15T16:50:00.000Z\tADM.L\t0.8604538337512425\t0.8819518074920342\t1963787769\t27338891\tFast trading\tGR\n2013-04-15T18:13:20.000Z\tGKN.L\t0.37224615921315185\t0.36133396791435113\t1332450178\t1858134820\tFast trading\tSK\n2013-04-15T19:36:40.000Z\tWTB.L\t0.11520461272416382\t0.9239521642513725\t489967413\t87590085\tFast trading\tGR\n2013-04-15T21:00:00.000Z\tABF.L\t0.24986535231589313\t0.9212391431210654\t109614495\t588222479\tFast trading\tLXE\n2013-04-15T22:23:20.000Z\tGKN.L\t0.2188128452458471\t0.22786978259776292\t1254423272\t490674067\tFast trading\tSK\n2013-04-15T23:46:40.000Z\tTLW.L\t0.4463347300950432\t0.6925161438197618\t1814510926\t2115486826\tFast trading\tGR\n2013-04-16T01:10:00.000Z\tABF.L\t0.8469114122260541\t0.2662042296295709\t1463194038\t1477966731\tFast trading\tLXE\n2013-04-16T02:33:20.000Z\tBP.L\t0.9088068169199539\t0.15827882958352824\t1332695233\t1500198110\tFast trading\tSK\n2013-04-16T03:56:40.000Z\tAGK.L\t0.7254711370183379\t0.21861507693793314\t45796789\t637460892\tFast trading\tSK\n2013-04-16T05:20:00.000Z\tRRS.L\t0.11016207656748878\t0.49959862931092014\t1193182994\t1094663465\tFast trading\tSK\n2013-04-16T06:43:20.000Z\tABF.L\t0.8481365931855511\t0.6125289075925316\t321588607\t1998483470\tFast trading\tLXE\n2013-04-16T08:06:40.000Z\tAGK.L\t0.2159600773188992\t0.06048282412620842\t40274574\t861269285\tFast trading\tLXE\n2013-04-16T09:30:00.000Z\tADM.L\t0.1289254683136415\t0.20330911145166142\t863778792\t2045791750\tFast trading\tGR\n2013-04-16T10:53:20.000Z\tABF.L\t0.665270086331557\t0.8903062932259495\t726534633\t1537834963\tFast trading\tGR\n2013-04-16T12:16:40.000Z\tBT-A.L\t0.25982311949948733\t0.08226996798358577\t1167648290\t1551980447\tFast trading\tLXE\n2013-04-16T13:40:00.000Z\tBP.L\t0.5599122986402687\t0.976978238622683\t35665855\t1332306990\tFast trading\tSK\n2013-04-16T15:03:20.000Z\tRRS.L\t0.7928032893115645\t0.25081634069753356\t1408294775\t2107726101\tFast trading\tSK\n2013-04-16T16:26:40.000Z\tTLW.L\t0.5066409396705072\t0.034125065735139515\t1777252481\t74739908\tFast trading\tSK\n2013-04-16T17:50:00.000Z\tTLW.L\t0.7158064464858439\t0.14898987887430504\t1378740363\t1026293951\tFast trading\tLXE\n2013-04-16T19:13:20.000Z\tBT-A.L\t0.8068004838711893\t0.9555704365868636\t801048844\t1108330142\tFast trading\tSK\n2013-04-16T20:36:40.000Z\tAGK.L\t0.04220672760628963\t0.876703460476772\t1032439632\t559676243\tFast trading\tSK\n2013-04-16T22:00:00.000Z\tBP.L\t0.13798638481152692\t0.3003941419492133\t2140126175\t1401757932\tFast trading\tSK\n2013-04-16T23:23:20.000Z\tAGK.L\t0.18329911539571342\t0.09594467507269244\t124393666\t184835335\tFast trading\tSK\n2013-04-17T00:46:40.000Z\tBP.L\t0.12224131348041978\t0.42185069743193215\t2112121645\t742449192\tFast trading\tGR\n2013-04-17T02:10:00.000Z\tBP.L\t0.12333773300880568\t0.8522298943856105\t117018443\t1055256290\tFast trading\tGR\n2013-04-17T03:33:20.000Z\tAGK.L\t0.4253183522869842\t0.1034291682962225\t1302110737\t1319036971\tFast trading\tSK\n2013-04-17T04:56:40.000Z\tLLOY.L\t0.6666567036885838\t0.8035900943847095\t1524023215\t998312463\tFast trading\tSK\n2013-04-17T06:20:00.000Z\tLLOY.L\t0.28154238736984283\t0.8153351652464201\t1564571942\t1690853399\tFast trading\tGR\n2013-04-17T07:43:20.000Z\tTLW.L\t0.2764047457507224\t0.5953695369451356\t1934650112\t866281182\tFast trading\tSK\n2013-04-17T09:06:40.000Z\tTLW.L\t0.5888007518329997\t0.9546767618443591\t1073083495\t915766639\tFast trading\tGR\n2013-04-17T10:30:00.000Z\tAGK.L\t0.27442487030061957\t0.36911888477159194\t1788303253\t426725743\tFast trading\tLXE\n2013-04-17T11:53:20.000Z\tTLW.L\t0.9681946530885687\t0.6826349256252374\t384417589\t625961973\tFast trading\tSK\n2013-04-17T13:16:40.000Z\tADM.L\t0.42181026969127666\t0.6438636564510443\t939094138\t2023613191\tFast trading\tGR\n2013-04-17T14:40:00.000Z\tGKN.L\t0.43288245927592073\t0.22190038492242692\t1517486591\t1318085706\tFast trading\tGR\n2013-04-17T16:03:20.000Z\tRRS.L\t0.1496677715774255\t0.05802946866746883\t767831894\t1907959998\tFast trading\tGR\n2013-04-17T17:26:40.000Z\tADM.L\t0.5606460724637143\t0.7276575607329406\t1604503112\t1241623544\tFast trading\tGR\n2013-04-17T18:50:00.000Z\tADM.L\t0.959620013629208\t0.7103052332148029\t1479277719\t1742297127\tFast trading\tGR\n2013-04-17T20:13:20.000Z\tWTB.L\t0.3147117541770178\t0.09539735897113255\t464140945\t228575709\tFast trading\tLXE\n2013-04-17T21:36:40.000Z\tRRS.L\t0.763577661606776\t0.08772568878580445\t1473017691\t455815573\tFast trading\tSK\n2013-04-17T23:00:00.000Z\tTLW.L\t0.9073565639007614\t0.31883968341033864\t1413755303\t1567927064\tFast trading\tGR\n2013-04-18T00:23:20.000Z\tAGK.L\t0.18231298232130988\t0.8192543383154339\t740486634\t165138405\tFast trading\tGR\n2013-04-18T01:46:40.000Z\tWTB.L\t0.35083173884882635\t0.2612470846804251\t554223249\t949591965\tFast trading\tGR\n2013-04-18T03:10:00.000Z\tGKN.L\t0.07236577380885778\t0.7431480451965935\t515434179\t650462836\tFast trading\tSK\n2013-04-18T04:33:20.000Z\tBP.L\t0.5901341681994278\t0.9534109048098541\t1340139674\t1757489362\tFast trading\tLXE\n2013-04-18T05:56:40.000Z\tTLW.L\t0.8008131356058481\t0.026384917940381003\t1553081546\t674345350\tFast trading\tLXE\n2013-04-18T07:20:00.000Z\tAGK.L\t0.362157237932033\t0.7815907291832017\t941364406\t428811377\tFast trading\tSK\n2013-04-18T08:43:20.000Z\tLLOY.L\t0.03743435712415766\t0.32443596918889506\t31873068\t432781882\tFast trading\tLXE\n2013-04-18T10:06:40.000Z\tBP.L\t0.17575246023679592\t0.1786890492951242\t1632037271\t780570766\tFast trading\tSK\n2013-04-18T11:30:00.000Z\tBP.L\t0.08380196743033497\t0.219662767248613\t360544308\t729726243\tFast trading\tSK\n2013-04-18T12:53:20.000Z\tRRS.L\t0.05723279855329633\t0.6819418364129978\t1988282878\t1028364213\tFast trading\tGR\n2013-04-18T14:16:40.000Z\tRRS.L\t0.00883024677860278\t0.42662140959018646\t1904847064\t234281272\tFast trading\tSK\n2013-04-18T15:40:00.000Z\tGKN.L\t0.9558493182764055\t0.4704064899449716\t1842599331\t1262083660\tFast trading\tSK\n2013-04-18T17:03:20.000Z\tBP.L\t0.11031265298416937\t0.502554745910034\t243354467\t1649522468\tFast trading\tGR\n2013-04-18T18:26:40.000Z\tGKN.L\t0.9537720518343229\t0.745528493925012\t982415362\t1988862871\tFast trading\tGR\n2013-04-18T19:50:00.000Z\tABF.L\t0.4719792171173166\t0.051353738993118236\t1163959318\t1647351778\tFast trading\tSK\n2013-04-18T21:13:20.000Z\tAGK.L\t0.6751067305283465\t0.5680678505309044\t1974130620\t564334675\tFast trading\tGR\n2013-04-18T22:36:40.000Z\tABF.L\t0.6356051753402773\t0.6592693023764222\t584532953\t1069565967\tFast trading\tLXE\n2013-04-19T00:00:00.000Z\tGKN.L\t0.5384782047842\t0.014666631497371796\t549176979\t457702016\tFast trading\tGR\n2013-04-19T01:23:20.000Z\tLLOY.L\t0.6577020925330458\t0.0506558681309599\t677705685\t1222024061\tFast trading\tLXE\n2013-04-19T02:46:40.000Z\tRRS.L\t0.7477121083469277\t0.7673389324071147\t458680880\t1232986592\tFast trading\tLXE\n2013-04-19T04:10:00.000Z\tTLW.L\t0.07032290099232896\t0.20202807591590044\t1384838795\t1369058291\tFast trading\tSK\n2013-04-19T05:33:20.000Z\tAGK.L\t0.16514590844414612\t0.4991644589632205\t1459258629\t206811433\tFast trading\tLXE\n2013-04-19T06:56:40.000Z\tBP.L\t0.5155117298701682\t0.402711516247675\t25299361\t2002745344\tFast trading\tGR\n2013-04-19T08:20:00.000Z\tBT-A.L\t0.4621006217781848\t0.669466858862395\t26222559\t215239755\tFast trading\tSK\n2013-04-19T09:43:20.000Z\tABF.L\t0.07293025411024634\t0.500369030896355\t1020987266\t338219921\tFast trading\tLXE\n2013-04-19T11:06:40.000Z\tRRS.L\t0.19104430111899917\t0.5917583487474295\t1060778628\t776936187\tFast trading\tGR\n2013-04-19T12:30:00.000Z\tTLW.L\t0.5501913863943443\t0.8196838684306206\t1952814587\t1340540883\tFast trading\tLXE\n2013-04-19T13:53:20.000Z\tTLW.L\t0.6739788927333529\t0.8877315188903572\t229668147\t531821716\tFast trading\tLXE\n2013-04-19T15:16:40.000Z\tBT-A.L\t0.25543176518548083\t0.4924806092277396\t339922626\t1260141772\tFast trading\tLXE\n2013-04-19T16:40:00.000Z\tABF.L\t0.85158124904719\t0.6905798576341321\t966209931\t1786052977\tFast trading\tSK\n2013-04-19T18:03:20.000Z\tAGK.L\t0.02165439137142222\t0.1875654932460037\t1415223537\t1192224417\tFast trading\tGR\n2013-04-19T19:26:40.000Z\tBT-A.L\t0.48762999363423987\t0.21092816881692655\t499918574\t136579046\tFast trading\tLXE\n2013-04-19T20:50:00.000Z\tWTB.L\t0.5023723227027094\t0.4785671915359112\t122787836\t1297259710\tFast trading\tLXE\n2013-04-19T22:13:20.000Z\tRRS.L\t0.3732490154771946\t0.528653984622627\t844264469\t1728622979\tFast trading\tLXE\n2013-04-19T23:36:40.000Z\tABF.L\t0.008085024398053031\t0.33805930461025646\t466781577\t254349067\tFast trading\tSK\n2013-04-20T01:00:00.000Z\tLLOY.L\t0.42549950566134076\t0.7238814525554275\t904965434\t858970862\tFast trading\tSK\n2013-04-20T02:23:20.000Z\tABF.L\t0.4031185607827227\t0.4962458447162521\t1268394752\t1712091173\tFast trading\tSK\n2013-04-20T03:46:40.000Z\tWTB.L\t0.8248509632696956\t0.7104287319268751\t1042510674\t1294543197\tFast trading\tLXE\n2013-04-20T05:10:00.000Z\tABF.L\t0.8323605781322707\t0.6524909925804234\t1378592267\t962629439\tFast trading\tLXE\n2013-04-20T06:33:20.000Z\tABF.L\t0.5860631208924326\t0.3849904456084924\t1022700950\t750016385\tFast trading\tLXE\n2013-04-20T07:56:40.000Z\tADM.L\t0.29742176277611587\t0.7779743335153394\t1222683502\t1843788357\tFast trading\tLXE\n2013-04-20T09:20:00.000Z\tBT-A.L\t0.20700968590622537\t0.9553359467668496\t1518519687\t94316090\tFast trading\tSK\n2013-04-20T10:43:20.000Z\tLLOY.L\t0.3517547320839087\t0.9977527069967247\t543099071\t922708893\tFast trading\tLXE\n2013-04-20T12:06:40.000Z\tRRS.L\t0.2899751699334592\t0.5608052071045311\t79234870\t2112782694\tFast trading\tSK\n2013-04-20T13:30:00.000Z\tWTB.L\t0.4342617369153986\t0.7905102843819515\t512276742\t20407816\tFast trading\tGR\n2013-04-20T14:53:20.000Z\tBP.L\t0.27995624652932327\t0.5483832427860625\t2067197976\t227530321\tFast trading\tGR\n2013-04-20T16:16:40.000Z\tBT-A.L\t0.6109222598165949\t0.4942777332069732\t1447919635\t776498400\tFast trading\tLXE\n2013-04-20T17:40:00.000Z\tRRS.L\t0.7144986189340898\t0.017634340679860472\t185042858\t2084024891\tFast trading\tSK\n2013-04-20T19:03:20.000Z\tBT-A.L\t0.7439721036097795\t0.35640177725889366\t59989887\t1513067560\tFast trading\tSK\n2013-04-20T20:26:40.000Z\tTLW.L\t0.6296008155868514\t0.4977774257783619\t1985109735\t73318806\tFast trading\tGR\n2013-04-20T21:50:00.000Z\tLLOY.L\t0.35816477898868093\t0.616046748468714\t1519738403\t1853441251\tFast trading\tSK\n2013-04-20T23:13:20.000Z\tADM.L\t0.016216230514148222\t0.8701839143837846\t365752702\t1273121898\tFast trading\tSK\n2013-04-21T00:36:40.000Z\tTLW.L\t0.7236467932169485\t0.357508895929066\t842406253\t871557091\tFast trading\tLXE\n2013-04-21T02:00:00.000Z\tABF.L\t0.4718844016066648\t0.8995789394362598\t823849570\t734827987\tFast trading\tGR\n2013-04-21T03:23:20.000Z\tBT-A.L\t0.9249779391138784\t0.12262508533437888\t1183004456\t783059581\tFast trading\tSK\n2013-04-21T04:46:40.000Z\tABF.L\t0.4420230599642636\t0.9872276874525574\t1481469554\t587781618\tFast trading\tSK\n2013-04-21T06:10:00.000Z\tADM.L\t0.9358277915447609\t0.5205568702151235\t2037657095\t812659907\tFast trading\tLXE\n2013-04-21T07:33:20.000Z\tGKN.L\t0.6954119656742774\t0.009387666396920569\t1587953397\t1278659245\tFast trading\tGR\n2013-04-21T08:56:40.000Z\tBP.L\t0.9688797862712805\t0.32323139690022873\t373363492\t633988729\tFast trading\tSK\n2013-04-21T10:20:00.000Z\tLLOY.L\t0.928400025950425\t0.3543084725888782\t817166558\t1862329916\tFast trading\tLXE\n2013-04-21T11:43:20.000Z\tADM.L\t0.6204740809287583\t0.7847202363380229\t2124210537\t587515486\tFast trading\tGR\n2013-04-21T13:06:40.000Z\tBP.L\t0.6423666886455287\t0.5210600622340643\t545059236\t228914770\tFast trading\tLXE\n2013-04-21T14:30:00.000Z\tLLOY.L\t0.5795203718199939\t0.17283746314876214\t752590070\t389895065\tFast trading\tLXE\n2013-04-21T15:53:20.000Z\tBT-A.L\t0.6889689804055317\t0.8934708945172383\t1634585214\t840702793\tFast trading\tLXE\n2013-04-21T17:16:40.000Z\tGKN.L\t0.9202119780512024\t0.7512382911059381\t1626542234\t1017932723\tFast trading\tSK\n2013-04-21T18:40:00.000Z\tAGK.L\t0.12770553265527784\t0.5524573020208224\t1894915997\t614368822\tFast trading\tSK\n2013-04-21T20:03:20.000Z\tBT-A.L\t0.24807258276664157\t0.7002993097479435\t1940234541\t51231157\tFast trading\tLXE\n2013-04-21T21:26:40.000Z\tGKN.L\t0.2903287188143948\t0.24002510523086373\t215958518\t775638553\tFast trading\tGR\n2013-04-21T22:50:00.000Z\tRRS.L\t0.2188665481266565\t0.7150618920876085\t997943482\t2106278439\tFast trading\tGR\n2013-04-22T00:13:20.000Z\tGKN.L\t0.19663607457038812\t0.8382249237512825\t1648984554\t35612265\tFast trading\tSK\n2013-04-22T01:36:40.000Z\tGKN.L\t0.19990436514908594\t0.2685196020543499\t1047564091\t2125223116\tFast trading\tGR\n2013-04-22T03:00:00.000Z\tLLOY.L\t0.7161725641915424\t0.9763422233400576\t1177117241\t1239779592\tFast trading\tLXE\n2013-04-22T04:23:20.000Z\tGKN.L\t0.093274371125597\t0.7785313579009606\t1122637533\t575922299\tFast trading\tGR\n2013-04-22T05:46:40.000Z\tBT-A.L\t0.12037454433177286\t0.629603618443436\t737806576\t2142628946\tFast trading\tLXE\n2013-04-22T07:10:00.000Z\tBP.L\t0.5905319753579278\t0.16664115785804057\t1973077802\t1106569197\tFast trading\tLXE\n2013-04-22T08:33:20.000Z\tRRS.L\t0.9196869957606026\t0.8226804916935584\t291238459\t1486020588\tFast trading\tLXE\n2013-04-22T09:56:40.000Z\tBT-A.L\t0.3783775929808282\t0.5470857740908067\t351816214\t365832191\tFast trading\tSK\n2013-04-22T11:20:00.000Z\tADM.L\t0.13018510543840767\t0.8012712041764293\t1397842991\t2114928986\tFast trading\tLXE\n2013-04-22T12:43:20.000Z\tTLW.L\t0.06485468407887174\t0.03427185454063508\t1892658103\t667160078\tFast trading\tSK\n2013-04-22T14:06:40.000Z\tBT-A.L\t0.3642315384021064\t0.2850431442001362\t1350841499\t331729521\tFast trading\tSK\n2013-04-22T15:30:00.000Z\tABF.L\t0.845599060611026\t0.9070033842206565\t1977292460\t526844717\tFast trading\tLXE\n2013-04-22T16:53:20.000Z\tABF.L\t0.3897004744308562\t0.665215955425475\t277397923\t552690407\tFast trading\tGR\n2013-04-22T18:16:40.000Z\tADM.L\t0.17967059757983295\t0.6177408039867266\t2056441449\t1708120878\tFast trading\tGR\n2013-04-22T19:40:00.000Z\tAGK.L\t0.05229999482609193\t0.26006715483597953\t343434192\t55553929\tFast trading\tSK\n2013-04-22T21:03:20.000Z\tADM.L\t0.9944989058398587\t0.385173386553605\t9393385\t141556570\tFast trading\tGR\n2013-04-22T22:26:40.000Z\tWTB.L\t0.7055236633074717\t0.991641205738034\t18284084\t1875565980\tFast trading\tSK\n2013-04-22T23:50:00.000Z\tLLOY.L\t0.18947379750846016\t0.35838554937947287\t1941590060\t1393408230\tFast trading\tLXE\n2013-04-23T01:13:20.000Z\tADM.L\t0.5427628789084831\t0.0969435617418678\t726424512\t685427395\tFast trading\tGR\n2013-04-23T02:36:40.000Z\tBT-A.L\t0.4577122578357192\t0.5908988904531399\t1710513900\t1984703491\tFast trading\tSK\n2013-04-23T04:00:00.000Z\tBT-A.L\t0.4761110907424354\t0.7369009629809495\t1964128662\t1111481034\tFast trading\tLXE\n2013-04-23T05:23:20.000Z\tAGK.L\t0.6955327023425288\t0.312870827772747\t1530972463\t1625310002\tFast trading\tSK\n2013-04-23T06:46:40.000Z\tAGK.L\t0.4563910874441425\t0.6163687629131023\t610077717\t1373574264\tFast trading\tLXE\n2013-04-23T08:10:00.000Z\tWTB.L\t0.5191682256331007\t0.23973118896605805\t1701993333\t1087251675\tFast trading\tGR\n2013-04-23T09:33:20.000Z\tGKN.L\t0.3789368311376311\t0.9784671704578825\t156792249\t1333861177\tFast trading\tGR\n2013-04-23T10:56:40.000Z\tTLW.L\t0.658249687746105\t0.9055382651404992\t1793432152\t1645914238\tFast trading\tSK\n2013-04-23T12:20:00.000Z\tLLOY.L\t0.9696608028660199\t0.586527237967611\t1580083466\t826258751\tFast trading\tLXE\n2013-04-23T13:43:20.000Z\tBT-A.L\t0.24559017308735664\t0.25933508681717243\t1186748332\t1455310536\tFast trading\tLXE\n2013-04-23T15:06:40.000Z\tBT-A.L\t0.29593824737751806\t0.5569278613884084\t924735785\t731992450\tFast trading\tLXE\n2013-04-23T16:30:00.000Z\tBP.L\t0.2728019583809025\t0.01278763720267706\t993459551\t2025068147\tFast trading\tGR\n2013-04-23T17:53:20.000Z\tBT-A.L\t0.7968396790844594\t0.15610542032074592\t1387574230\t120758096\tFast trading\tSK\n2013-04-23T19:16:40.000Z\tBT-A.L\t0.7312771894052983\t0.47738585751051377\t1785761799\t1165978272\tFast trading\tGR\n2013-04-23T20:40:00.000Z\tBP.L\t0.9772426869120343\t0.9250167208388378\t1680887683\t817388605\tFast trading\tSK\n2013-04-23T22:03:20.000Z\tAGK.L\t0.20806366372224905\t0.8794891372341633\t1740269564\t318740884\tFast trading\tLXE\n2013-04-23T23:26:40.000Z\tLLOY.L\t0.16035433279840772\t0.744336965635932\t182449915\t1129116964\tFast trading\tLXE\n2013-04-24T00:50:00.000Z\tTLW.L\t0.9561668372080154\t0.3914970174237439\t455564972\t1267023813\tFast trading\tGR\n2013-04-24T02:13:20.000Z\tRRS.L\t0.9431756509494652\t0.7036738986425659\t1857201507\t1528216063\tFast trading\tSK\n2013-04-24T03:36:40.000Z\tAGK.L\t0.7088093100337292\t0.3674269414293716\t415593497\t1018790358\tFast trading\tLXE\n2013-04-24T05:00:00.000Z\tWTB.L\t0.24943899871749153\t0.8880790514727186\t242591408\t62117410\tFast trading\tLXE\n2013-04-24T06:23:20.000Z\tBT-A.L\t0.7571791557741792\t0.5211796843055796\t2083461963\t827990771\tFast trading\tGR\n2013-04-24T07:46:40.000Z\tTLW.L\t0.12455007168082621\t0.445138006254728\t1005737026\t1533560167\tFast trading\tSK\n2013-04-24T09:10:00.000Z\tAGK.L\t0.061198252433663836\t0.03577419848237173\t1558882600\t1950611224\tFast trading\tSK\n2013-04-24T10:33:20.000Z\tAGK.L\t0.6670653859478679\t0.5459200881118444\t1464635759\t2099759694\tFast trading\tGR\n2013-04-24T11:56:40.000Z\tLLOY.L\t0.41284188221092344\t0.8418329613826846\t460797532\t1151744738\tFast trading\tGR\n2013-04-24T13:20:00.000Z\tADM.L\t0.7412367794921478\t0.10306948380567404\t564377648\t1350614279\tFast trading\tLXE\n2013-04-24T14:43:20.000Z\tADM.L\t0.9215407513411673\t0.5535989590948046\t846597497\t1816942438\tFast trading\tSK\n2013-04-24T16:06:40.000Z\tRRS.L\t0.36515396650984544\t0.35931860958931694\t722229786\t1844501308\tFast trading\tLXE\n2013-04-24T17:30:00.000Z\tBT-A.L\t0.3411969427063698\t0.8007657419568004\t1168290839\t1903666604\tFast trading\tLXE\n2013-04-24T18:53:20.000Z\tADM.L\t0.9190164656384662\t0.7097050765829422\t1118947014\t1063568520\tFast trading\tGR\n2013-04-24T20:16:40.000Z\tADM.L\t0.0083448854966236\t0.9444016936121006\t1996932267\t586822460\tFast trading\tLXE\n2013-04-24T21:40:00.000Z\tWTB.L\t0.5680663309088269\t0.3707735312040207\t399120393\t7627305\tFast trading\tSK\n2013-04-24T23:03:20.000Z\tGKN.L\t0.41098831072134234\t0.4152496886229553\t1078976933\t1208893999\tFast trading\tGR\n2013-04-25T00:26:40.000Z\tGKN.L\t0.5447125964871362\t0.7600436519097304\t2016793563\t977501011\tFast trading\tSK\n2013-04-25T01:50:00.000Z\tBT-A.L\t0.6576451187687067\t0.16268374958748721\t495489282\t950342145\tFast trading\tLXE\n2013-04-25T03:13:20.000Z\tAGK.L\t0.18437894603570104\t0.6990254531238901\t1091638284\t1687370208\tFast trading\tGR\n2013-04-25T04:36:40.000Z\tBT-A.L\t0.366130777634858\t0.9526033796581732\t1864927274\t1334605755\tFast trading\tGR\n2013-04-25T06:00:00.000Z\tTLW.L\t0.8596057934205292\t0.8030632446611555\t540749257\t724460336\tFast trading\tSK\n2013-04-25T07:23:20.000Z\tRRS.L\t0.7416117682393039\t0.5025473527708153\t412274487\t389081778\tFast trading\tLXE\n2013-04-25T08:46:40.000Z\tRRS.L\t0.20693799502171673\t0.6712894049714179\t660255379\t659446327\tFast trading\tSK\n2013-04-25T10:10:00.000Z\tBT-A.L\t0.8634604032531915\t0.6923078684498395\t1872080187\t551937071\tFast trading\tLXE\n2013-04-25T11:33:20.000Z\tTLW.L\t0.2911293878254695\t0.7399693239677205\t1129164985\t1749026215\tFast trading\tSK\n2013-04-25T12:56:40.000Z\tABF.L\t0.4504419770633721\t0.3383265629263382\t975765261\t1684212411\tFast trading\tLXE\n2013-04-25T14:20:00.000Z\tLLOY.L\t0.6011956045216453\t0.9125186812112099\t881720162\t434224461\tFast trading\tLXE\n2013-04-25T15:43:20.000Z\tBT-A.L\t0.6237659234761993\t0.2701533802922441\t1566672197\t58636676\tFast trading\tSK\n2013-04-25T17:06:40.000Z\tTLW.L\t0.022846203323476755\t0.3294743481612157\t1572302605\t814850383\tFast trading\tSK\n2013-04-25T18:30:00.000Z\tWTB.L\t0.4375317525194694\t0.6972497432729854\t292639802\t277189665\tFast trading\tSK\n2013-04-25T19:53:20.000Z\tGKN.L\t0.1818273476665202\t0.8917001175168765\t970180916\t1822594093\tFast trading\tSK\n2013-04-25T21:16:40.000Z\tLLOY.L\t0.19610148019935003\t0.10441728811233097\t693877758\t293005347\tFast trading\tSK\n2013-04-25T22:40:00.000Z\tGKN.L\t0.8027066024947154\t0.40010857071014894\t773881811\t729260225\tFast trading\tSK\n2013-04-26T00:03:20.000Z\tBT-A.L\t0.8279293896259295\t0.16413311886403903\t1649959028\t1512267347\tFast trading\tSK\n2013-04-26T01:26:40.000Z\tAGK.L\t0.9776307470144742\t0.4251803834341643\t1625204265\t754945853\tFast trading\tSK\n2013-04-26T02:50:00.000Z\tWTB.L\t0.8353806660008818\t0.4040733447729141\t2062702888\t624444718\tFast trading\tSK\n2013-04-26T04:13:20.000Z\tLLOY.L\t0.48958786515087727\t0.26956205989180415\t1594568784\t511206764\tFast trading\tSK\n2013-04-26T05:36:40.000Z\tBT-A.L\t0.5900700493546804\t0.6181055952695677\t2043539828\t1411822511\tFast trading\tSK\n2013-04-26T07:00:00.000Z\tLLOY.L\t0.5847053958978617\t0.6370237458257473\t899168885\t1027448954\tFast trading\tLXE\n2013-04-26T08:23:20.000Z\tADM.L\t0.9932517122507327\t0.2590321794039394\t366317456\t189068805\tFast trading\tSK\n2013-04-26T09:46:40.000Z\tGKN.L\t0.838114652287837\t0.8710579992561518\t227873986\t815681889\tFast trading\tSK\n2013-04-26T11:10:00.000Z\tLLOY.L\t0.7707916926083817\t0.30136493441916146\t2081624307\t466479498\tFast trading\tGR\n2013-04-26T12:33:20.000Z\tAGK.L\t0.007914005262672386\t0.8764009529203859\t1251238240\t657497987\tFast trading\tSK\n2013-04-26T13:56:40.000Z\tBT-A.L\t0.9222540367080808\t0.31241302050888986\t1111716243\t1998120721\tFast trading\tSK\n2013-04-26T15:20:00.000Z\tBP.L\t0.021760890994208082\t0.08675720182638702\t459876525\t988132288\tFast trading\tLXE\n2013-04-26T16:43:20.000Z\tGKN.L\t0.09363209428940089\t0.7199650417358132\t234355545\t128526717\tFast trading\tSK\n2013-04-26T18:06:40.000Z\tLLOY.L\t0.49062491989261725\t0.09200938052748842\t702813006\t488084446\tFast trading\tLXE\n2013-04-26T19:30:00.000Z\tADM.L\t0.8932559196394961\t0.5148466085934312\t1675984825\t1961253049\tFast trading\tLXE\n2013-04-26T20:53:20.000Z\tWTB.L\t0.39423273013851057\t0.7881939944982873\t886560585\t1356520521\tFast trading\tLXE\n2013-04-26T22:16:40.000Z\tTLW.L\t0.4204073472425597\t0.8766346253312641\t360336969\t1800751392\tFast trading\tSK\n2013-04-26T23:40:00.000Z\tTLW.L\t0.8327357836429247\t0.16352449257113777\t231845639\t2131809484\tFast trading\tGR\n2013-04-27T01:03:20.000Z\tAGK.L\t0.52617362883267\t0.4608095441854577\t121699397\t951066779\tFast trading\tGR\n2013-04-27T02:26:40.000Z\tADM.L\t0.9891329617157226\t0.0837431224611016\t1291225558\t1448350099\tFast trading\tSK\n2013-04-27T03:50:00.000Z\tGKN.L\t0.5760713568827512\t0.33562699629481463\t1551018897\t1463929354\tFast trading\tLXE\n2013-04-27T05:13:20.000Z\tABF.L\t0.6969784207390691\t0.6900824296790676\t67053801\t2027207912\tFast trading\tSK\n2013-04-27T06:36:40.000Z\tBT-A.L\t0.7339714645145\t0.8069896763657657\t2067103419\t1440586882\tFast trading\tSK\n2013-04-27T08:00:00.000Z\tBP.L\t0.25790654277476655\t0.2731181132242275\t1204373939\t579257911\tFast trading\tGR\n2013-04-27T09:23:20.000Z\tBT-A.L\t0.03685679589400548\t0.6196012261424408\t1014819273\t1284056620\tFast trading\tGR\n2013-04-27T10:46:40.000Z\tRRS.L\t0.4035050448991431\t0.7357940163992334\t539091359\t740500514\tFast trading\tGR\n2013-04-27T12:10:00.000Z\tTLW.L\t0.7799434468798462\t0.27268285218432176\t2128943361\t2047811947\tFast trading\tLXE\n2013-04-27T13:33:20.000Z\tRRS.L\t0.5460673594879607\t0.008900854380514356\t1765659239\t1527617741\tFast trading\tLXE\n2013-04-27T14:56:40.000Z\tBP.L\t0.9816971539215531\t0.43853444535937625\t1460978675\t895177238\tFast trading\tGR\n2013-04-27T16:20:00.000Z\tRRS.L\t0.7127557441258068\t0.032289851767849265\t1689560176\t1909046550\tFast trading\tLXE\n2013-04-27T17:43:20.000Z\tBT-A.L\t0.9482759384258049\t0.722220915203416\t1286881579\t1050302059\tFast trading\tSK\n2013-04-27T19:06:40.000Z\tBP.L\t0.8077063004176618\t0.16510231805096875\t2038626242\t1240355820\tFast trading\tGR\n2013-04-27T20:30:00.000Z\tWTB.L\t0.20693018773069394\t0.2506654991029972\t2075534973\t1334134680\tFast trading\tGR\n2013-04-27T21:53:20.000Z\tAGK.L\t0.09660706980446321\t0.1382968036038582\t1423867738\t1364344839\tFast trading\tSK\n2013-04-27T23:16:40.000Z\tGKN.L\t0.3278916704780759\t0.8294309010136357\t335863681\t701358178\tFast trading\tGR\n2013-04-28T00:40:00.000Z\tBT-A.L\t0.058280601727196624\t0.9127546331765387\t575498331\t782233133\tFast trading\tGR\n2013-04-28T02:03:20.000Z\tABF.L\t0.40428243655634066\t0.6554697589003367\t1969810317\t1112227425\tFast trading\tLXE\n2013-04-28T03:26:40.000Z\tRRS.L\t0.9978020355814625\t0.056245586154867855\t1061959288\t1031333906\tFast trading\tLXE\n2013-04-28T04:50:00.000Z\tADM.L\t0.2095750323483918\t0.8241255563825306\t701149767\t754844100\tFast trading\tGR\n2013-04-28T06:13:20.000Z\tABF.L\t0.06568433767621085\t0.5025343640959431\t154363736\t1978627544\tFast trading\tSK\n2013-04-28T07:36:40.000Z\tTLW.L\t0.30213522732633424\t0.1186652617035786\t1376781093\t655113830\tFast trading\tLXE\n2013-04-28T09:00:00.000Z\tBT-A.L\t0.5776612950543363\t0.8059097265683594\t460712354\t1740229726\tFast trading\tSK\n2013-04-28T10:23:20.000Z\tRRS.L\t0.5963785113643011\t0.8206250106726152\t621390966\t1903652982\tFast trading\tSK\n2013-04-28T11:46:40.000Z\tABF.L\t0.779600302269596\t0.2544170475636133\t862429149\t441747852\tFast trading\tGR\n2013-04-28T13:10:00.000Z\tBT-A.L\t0.17007165566846838\t0.529250019841342\t975011870\t1793995862\tFast trading\tLXE\n2013-04-28T14:33:20.000Z\tRRS.L\t0.4520755206258048\t0.455075778627134\t646464112\t1183430832\tFast trading\tGR\n2013-04-28T15:56:40.000Z\tRRS.L\t0.32731044023349676\t0.22830984539786814\t659485870\t2140244811\tFast trading\tGR\n2013-04-28T17:20:00.000Z\tADM.L\t0.9991330212896724\t0.2543630254606476\t1427291982\t1788924502\tFast trading\tGR\n2013-04-28T18:43:20.000Z\tRRS.L\t0.18670502698896196\t0.0885706583279452\t505468688\t2038459861\tFast trading\tGR\n2013-04-28T20:06:40.000Z\tAGK.L\t0.915779154884911\t0.1072445825833257\t659123462\t1516991412\tFast trading\tGR\n2013-04-28T21:30:00.000Z\tBP.L\t0.31430399958862776\t0.7442052266426017\t1902801116\t1526668764\tFast trading\tGR\n2013-04-28T22:53:20.000Z\tRRS.L\t0.7787230809761455\t0.25803443163774886\t857471455\t190622110\tFast trading\tLXE\n2013-04-29T00:16:40.000Z\tLLOY.L\t0.17078848195089802\t0.031422297574265734\t791371928\t1142552242\tFast trading\tSK\n2013-04-29T01:40:00.000Z\tWTB.L\t0.154905273744959\t0.3463641298845208\t1190004376\t548681062\tFast trading\tSK\n2013-04-29T03:03:20.000Z\tTLW.L\t0.3924674980643327\t0.42759642071766735\t325469131\t1148755905\tFast trading\tGR\n2013-04-29T04:26:40.000Z\tBP.L\t0.0723426168916399\t0.30154348935233677\t483391973\t1635859661\tFast trading\tLXE\n2013-04-29T05:50:00.000Z\tGKN.L\t0.17560585850669297\t0.6791795548403247\t2114761437\t561608998\tFast trading\tLXE\n2013-04-29T07:13:20.000Z\tWTB.L\t0.94782183700974\t0.6385933398879912\t507408673\t477022979\tFast trading\tSK\n2013-04-29T08:36:40.000Z\tAGK.L\t0.28361580324662805\t0.3566755365918044\t2099258677\t368954223\tFast trading\tSK\n2013-04-29T10:00:00.000Z\tRRS.L\t0.11597222374313398\t0.5192320969480931\t1317970912\t546140855\tFast trading\tGR\n2013-04-29T11:23:20.000Z\tGKN.L\t0.4466437532316928\t0.32495899970572273\t2015090903\t1376158663\tFast trading\tLXE\n2013-04-29T12:46:40.000Z\tBT-A.L\t0.3542490655977256\t0.19109723285077962\t1111156559\t746276626\tFast trading\tSK\n2013-04-29T14:10:00.000Z\tLLOY.L\t0.17308313956148713\t0.36721951744987336\t1526462256\t842116069\tFast trading\tSK\n2013-04-29T15:33:20.000Z\tABF.L\t0.04835893598200669\t0.6684826049193934\t272519515\t1459187837\tFast trading\tGR\n2013-04-29T16:56:40.000Z\tBP.L\t0.24254498312457362\t0.450812713380639\t955560446\t2063318120\tFast trading\tSK\n2013-04-29T18:20:00.000Z\tADM.L\t0.8926581614910641\t0.7678734619427338\t1006057945\t1923705917\tFast trading\tLXE\n2013-04-29T19:43:20.000Z\tAGK.L\t0.3998170370357713\t0.3732992994215891\t136700330\t578060629\tFast trading\tGR\n2013-04-29T21:06:40.000Z\tRRS.L\t0.27005559955766234\t0.8615598067123645\t657091681\t801271858\tFast trading\tGR\n2013-04-29T22:30:00.000Z\tAGK.L\t0.019343142400739755\t0.7769531679242314\t169194785\t2110727937\tFast trading\tSK\n2013-04-29T23:53:20.000Z\tADM.L\t0.7059511990460272\t0.9626098243028786\t353760630\t1852387051\tFast trading\tLXE\n2013-04-30T01:16:40.000Z\tTLW.L\t0.7597536320961927\t0.7700203386464268\t1200935293\t1616239737\tFast trading\tLXE\n2013-04-30T02:40:00.000Z\tAGK.L\t0.04074132935092767\t0.004484255021279582\t764755954\t1707042982\tFast trading\tSK\n2013-04-30T04:03:20.000Z\tWTB.L\t0.47797848524672126\t0.6430092838094059\t1405625919\t753070187\tFast trading\tLXE\n2013-04-30T05:26:40.000Z\tTLW.L\t0.21542235902826057\t0.42857329503151054\t774479136\t91697613\tFast trading\tSK\n2013-04-30T06:50:00.000Z\tRRS.L\t0.9224740894383063\t0.4182944098171566\t958319102\t842755864\tFast trading\tLXE\n2013-04-30T08:13:20.000Z\tTLW.L\t0.8148234471679948\t0.4429368812285467\t2005241955\t1521333140\tFast trading\tLXE\n2013-04-30T09:36:40.000Z\tADM.L\t0.9750950674803412\t0.22131379249382566\t1483122450\t1981068860\tFast trading\tLXE\n2013-04-30T11:00:00.000Z\tBT-A.L\t0.7630002744048395\t0.5655301296325983\t170034893\t555018287\tFast trading\tGR\n2013-04-30T12:23:20.000Z\tTLW.L\t0.46114243553817713\t0.7116424005305213\t1322718319\t1067901381\tFast trading\tSK\n2013-04-30T13:46:40.000Z\tLLOY.L\t0.8153204011060089\t0.31519462741564885\t1605402601\t166305656\tFast trading\tLXE\n2013-04-30T15:10:00.000Z\tLLOY.L\t0.7971190949625937\t0.062221941250062196\t1174242989\t1681071393\tFast trading\tLXE\n2013-04-30T16:33:20.000Z\tLLOY.L\t0.7417718380704188\t0.1636972956768088\t563945975\t1566126176\tFast trading\tGR\n2013-04-30T17:56:40.000Z\tGKN.L\t0.9957244238271116\t0.22502876454673404\t1074244114\t1402712074\tFast trading\tLXE\n2013-04-30T19:20:00.000Z\tBP.L\t0.34602616547919973\t0.11209766463974158\t838659555\t2089640349\tFast trading\tGR\n2013-04-30T20:43:20.000Z\tAGK.L\t0.7976185011129686\t0.4714611453741183\t2084037958\t817810247\tFast trading\tLXE\n2013-04-30T22:06:40.000Z\tBT-A.L\t0.7147870329232192\t0.5047251666299352\t1632653036\t1459199712\tFast trading\tGR\n2013-04-30T23:30:00.000Z\tLLOY.L\t0.9494879307183522\t0.445726792042184\t1942723379\t1447697900\tFast trading\tGR\n2013-05-01T00:53:20.000Z\tADM.L\t0.34195577112827147\t0.9440475343742334\t1548749696\t755946340\tFast trading\tGR\n2013-05-01T02:16:40.000Z\tGKN.L\t0.8979439248915824\t0.2195123104786394\t1682785535\t1705950772\tFast trading\tLXE\n2013-05-01T03:40:00.000Z\tRRS.L\t0.02214511956698062\t0.4197114107915003\t546860253\t131966276\tFast trading\tGR\n2013-05-01T05:03:20.000Z\tLLOY.L\t0.41878435349451426\t0.08621549406747886\t1129009178\t1386081146\tFast trading\tLXE\n2013-05-01T06:26:40.000Z\tADM.L\t0.6580721374764023\t0.015036771906895785\t1811518812\t70409996\tFast trading\tSK\n2013-05-01T07:50:00.000Z\tAGK.L\t0.9511507241696612\t0.08302202765868905\t652144090\t848553399\tFast trading\tLXE\n2013-05-01T09:13:20.000Z\tAGK.L\t0.3763621294848153\t0.804246112596439\t1954040330\t1791045465\tFast trading\tGR\n2013-05-01T10:36:40.000Z\tBT-A.L\t0.6561113751342125\t0.47910748281262994\t514913551\t831670347\tFast trading\tLXE\n2013-05-01T12:00:00.000Z\tGKN.L\t0.5962940647708228\t0.8037097062216977\t1034412808\t1681490823\tFast trading\tLXE\n2013-05-01T13:23:20.000Z\tAGK.L\t0.46920237466566783\t0.7182462450271192\t338737405\t2031458901\tFast trading\tSK\n2013-05-01T14:46:40.000Z\tWTB.L\t0.9460194923216076\t0.09048831254437362\t1231092052\t1026180063\tFast trading\tLXE\n2013-05-01T16:10:00.000Z\tTLW.L\t0.6664569545168485\t0.5541082723624778\t1520797094\t114683911\tFast trading\tLXE\n2013-05-01T17:33:20.000Z\tAGK.L\t0.17078558767565122\t0.45145442891378285\t1255386212\t1530900317\tFast trading\tGR\n2013-05-01T18:56:40.000Z\tTLW.L\t0.7134551426883604\t0.36652513994805036\t1614561742\t1432439927\tFast trading\tGR\n2013-05-01T20:20:00.000Z\tTLW.L\t0.4276939984406388\t0.17627351127106772\t56813425\t1343523717\tFast trading\tLXE\n2013-05-01T21:43:20.000Z\tBP.L\t0.4169245941596208\t0.8970066646662288\t1089760189\t632670746\tFast trading\tLXE\n2013-05-01T23:06:40.000Z\tRRS.L\t0.6115265337537894\t0.85752616310559\t2014391952\t782784264\tFast trading\tGR\n2013-05-02T00:30:00.000Z\tADM.L\t0.6484238901257546\t0.891789154715561\t839056671\t73991037\tFast trading\tLXE\n2013-05-02T01:53:20.000Z\tGKN.L\t0.6061689700945626\t0.3112527710614069\t765148442\t1939054544\tFast trading\tGR\n2013-05-02T03:16:40.000Z\tADM.L\t0.1596397886292107\t0.39069663050303693\t908049170\t504998471\tFast trading\tLXE\n2013-05-02T04:40:00.000Z\tRRS.L\t0.6061643091896248\t0.9812017566926329\t183363356\t965895392\tFast trading\tSK\n2013-05-02T06:03:20.000Z\tADM.L\t0.25882921284566274\t0.6500964117444217\t163768705\t810757175\tFast trading\tLXE\n2013-05-02T07:26:40.000Z\tBT-A.L\t0.9029266635624776\t0.4400626920975901\t188866311\t1663084154\tFast trading\tSK\n2013-05-02T08:50:00.000Z\tGKN.L\t0.3679378100903369\t0.9382300968477628\t1388063503\t1125355543\tFast trading\tSK\n2013-05-02T10:13:20.000Z\tTLW.L\t0.7801469788077624\t0.8509654712822936\t1231551112\t1554816591\tFast trading\tLXE\n2013-05-02T11:36:40.000Z\tGKN.L\t0.7299258007491024\t0.6912012922060378\t980854034\t1765743108\tFast trading\tLXE\n2013-05-02T13:00:00.000Z\tBT-A.L\t0.4129219991106413\t0.5025269563465262\t944280080\t148476167\tFast trading\tLXE\n2013-05-02T14:23:20.000Z\tWTB.L\t0.7858327043313086\t0.7679013186397453\t150870909\t427886371\tFast trading\tGR\n2013-05-02T15:46:40.000Z\tBP.L\t0.9151375584313991\t0.7807261040785343\t1688917476\t1220320444\tFast trading\tLXE\n2013-05-02T17:10:00.000Z\tBP.L\t0.9911120865317999\t0.7921542600659871\t149123703\t1990756409\tFast trading\tLXE\n2013-05-02T18:33:20.000Z\tBT-A.L\t0.9296374772157955\t0.19088899950218174\t980203892\t1476326981\tFast trading\tLXE\n2013-05-02T19:56:40.000Z\tAGK.L\t0.09076750471715689\t0.820362305963362\t1136677964\t262489859\tFast trading\tLXE\n2013-05-02T21:20:00.000Z\tGKN.L\t0.4057095419320843\t0.2930651074363966\t970097888\t1768370800\tFast trading\tGR\n2013-05-02T22:43:20.000Z\tBT-A.L\t0.12282110119740142\t0.822933043281861\t997442403\t430556502\tFast trading\tSK\n2013-05-03T00:06:40.000Z\tLLOY.L\t0.4584193481063288\t0.6640757886311363\t1934524011\t2000528632\tFast trading\tGR\n2013-05-03T01:30:00.000Z\tWTB.L\t0.6696457609278927\t0.7177695674107006\t1859909396\t1567568718\tFast trading\tSK\n2013-05-03T02:53:20.000Z\tADM.L\t0.45432377472957375\t0.24951632448448258\t1602041565\t1679979058\tFast trading\tSK\n2013-05-03T04:16:40.000Z\tAGK.L\t0.12669255867413365\t0.9441049113910885\t356218872\t1299555260\tFast trading\tLXE\n2013-05-03T05:40:00.000Z\tTLW.L\t0.7180950271706947\t0.7189931302044412\t683609150\t1494093736\tFast trading\tGR\n2013-05-03T07:03:20.000Z\tBT-A.L\t0.008144226019699663\t0.8149620429664706\t1492076657\t2143247261\tFast trading\tLXE\n2013-05-03T08:26:40.000Z\tADM.L\t0.5045865023784246\t0.6878766777137407\t1616308889\t163602422\tFast trading\tGR\n2013-05-03T09:50:00.000Z\tRRS.L\t0.5590262812936236\t0.13652035496254744\t1522957952\t1962377774\tFast trading\tLXE\n2013-05-03T11:13:20.000Z\tAGK.L\t0.1308718381894728\t0.9188520987338477\t1037118922\t4589843\tFast trading\tLXE\n2013-05-03T12:36:40.000Z\tBP.L\t0.19330691787589716\t0.8326703977785086\t195394189\t827458680\tFast trading\tLXE\n2013-05-03T14:00:00.000Z\tLLOY.L\t0.4127885420872661\t0.8665482054133304\t1506109341\t539672448\tFast trading\tGR\n2013-05-03T15:23:20.000Z\tGKN.L\t0.5275167947685228\t0.5630377869323533\t1843235138\t1122238976\tFast trading\tGR\n2013-05-03T16:46:40.000Z\tBP.L\t0.800516898126557\t0.17852653385834039\t39877735\t1842395295\tFast trading\tGR\n2013-05-03T18:10:00.000Z\tBP.L\t0.02942030917851568\t0.572757460747041\t683641977\t1362036057\tFast trading\tLXE\n2013-05-03T19:33:20.000Z\tADM.L\t0.8577260763596468\t0.01591134909601677\t901921998\t767627517\tFast trading\tSK\n2013-05-03T20:56:40.000Z\tAGK.L\t0.5512691746253235\t0.2622798544196908\t523767429\t834063697\tFast trading\tSK\n2013-05-03T22:20:00.000Z\tAGK.L\t0.9788182552381814\t0.3069421348721998\t2053761104\t1032198554\tFast trading\tLXE\n2013-05-03T23:43:20.000Z\tLLOY.L\t0.26716989176964423\t0.21548997929605662\t1042166874\t578687855\tFast trading\tSK\n2013-05-04T01:06:40.000Z\tBT-A.L\t0.4888022268408503\t0.29672957386948207\t336680606\t399745768\tFast trading\tSK\n2013-05-04T02:30:00.000Z\tABF.L\t0.784096211147592\t0.6744206681186953\t1093552275\t2056100282\tFast trading\tGR\n2013-05-04T03:53:20.000Z\tTLW.L\t0.520327451863136\t0.00649653429640229\t1745668548\t1367781936\tFast trading\tLXE\n2013-05-04T05:16:40.000Z\tBT-A.L\t0.446077824829904\t0.6988415338645972\t1292164916\t1478758623\tFast trading\tGR\n2013-05-04T06:40:00.000Z\tTLW.L\t0.3124102949897708\t0.4655850758843939\t1797275861\t1228252246\tFast trading\tLXE\n2013-05-04T08:03:20.000Z\tTLW.L\t0.1010967065651025\t0.4990044037517981\t2070623667\t2060273453\tFast trading\tSK\n2013-05-04T09:26:40.000Z\tRRS.L\t0.825383087211078\t0.8295107751764524\t295364324\t405766589\tFast trading\tGR\n2013-05-04T10:50:00.000Z\tABF.L\t0.8502220170513402\t0.6798268728882876\t1716466056\t1584026409\tFast trading\tGR\n2013-05-04T12:13:20.000Z\tADM.L\t0.8165979021660478\t0.7473458227283912\t1577639455\t1061778601\tFast trading\tLXE\n2013-05-04T13:36:40.000Z\tGKN.L\t0.5485152099626798\t0.3847951638258288\t543254483\t1530188749\tFast trading\tGR\n2013-05-04T15:00:00.000Z\tTLW.L\t0.771415760128552\t0.5917118717316834\t1448724735\t398777129\tFast trading\tGR\n2013-05-04T16:23:20.000Z\tTLW.L\t0.07723630752860178\t0.577867303192654\t1918206534\t261966598\tFast trading\tGR\n2013-05-04T17:46:40.000Z\tLLOY.L\t0.33401272203645294\t0.4146639342165668\t236902596\t1104542543\tFast trading\tLXE\n2013-05-04T19:10:00.000Z\tBT-A.L\t0.6568827503244907\t0.9516581518449365\t1087441335\t215261555\tFast trading\tLXE\n2013-05-04T20:33:20.000Z\tBP.L\t0.13253432478748917\t0.742746833335633\t336535369\t223976425\tFast trading\tLXE\n2013-05-04T21:56:40.000Z\tBT-A.L\t0.7205919912375708\t0.2001874412720378\t2040960322\t585186319\tFast trading\tLXE\n2013-05-04T23:20:00.000Z\tGKN.L\t0.1431291421988593\t0.5745050981046427\t1264064609\t1875890436\tFast trading\tLXE\n2013-05-05T00:43:20.000Z\tRRS.L\t0.11743906690268846\t0.6444719429134952\t1105959503\t652964395\tFast trading\tGR\n2013-05-05T02:06:40.000Z\tWTB.L\t0.987393258130514\t0.19372778674904867\t74296203\t1261843476\tFast trading\tSK\n2013-05-05T03:30:00.000Z\tADM.L\t0.6651605624415704\t0.44924321369539355\t1065647784\t981210587\tFast trading\tLXE\n2013-05-05T04:53:20.000Z\tAGK.L\t0.8077563840150129\t0.6617094454079331\t1593920062\t1701554990\tFast trading\tLXE\n2013-05-05T06:16:40.000Z\tADM.L\t0.32183591222731356\t0.9190720816969892\t1035899527\t1133552627\tFast trading\tGR\n2013-05-05T07:40:00.000Z\tTLW.L\t0.6153413402387309\t0.10180841267235818\t1514322115\t1409436313\tFast trading\tLXE\n2013-05-05T09:03:20.000Z\tAGK.L\t0.4960576983768935\t0.6121810693860691\t11308476\t1377530884\tFast trading\tGR\n2013-05-05T10:26:40.000Z\tAGK.L\t0.25482780498062496\t0.13958362455577333\t1911512995\t122875081\tFast trading\tLXE\n2013-05-05T11:50:00.000Z\tRRS.L\t0.26512170342893404\t0.260226030092623\t815877831\t636479586\tFast trading\tLXE\n2013-05-05T13:13:20.000Z\tAGK.L\t0.38085166997373454\t0.11179154015541148\t1241766823\t1944335528\tFast trading\tGR\n2013-05-05T14:36:40.000Z\tRRS.L\t0.5207685204705551\t0.7323284410284714\t920542286\t937779680\tFast trading\tGR\n2013-05-05T16:00:00.000Z\tRRS.L\t0.09047143578684991\t0.9075239328203828\t370045480\t1923062137\tFast trading\tSK\n2013-05-05T17:23:20.000Z\tTLW.L\t0.312007395214155\t0.5316391740370102\t872516781\t358245103\tFast trading\tGR\n2013-05-05T18:46:40.000Z\tRRS.L\t0.10623268061771685\t0.5547681745359796\t1884826495\t1613441647\tFast trading\tSK\n2013-05-05T20:10:00.000Z\tADM.L\t0.9045540660350425\t0.5627155077556809\t1971582911\t2117564472\tFast trading\tSK\n2013-05-05T21:33:20.000Z\tWTB.L\t0.6543618489306964\t0.9156710489125467\t1749241381\t300624252\tFast trading\tSK\n2013-05-05T22:56:40.000Z\tRRS.L\t0.3264135223399327\t0.157992209825908\t1678606123\t914044009\tFast trading\tLXE\n2013-05-06T00:20:00.000Z\tLLOY.L\t0.43262078881102095\t0.10378756402623446\t686556051\t2131477677\tFast trading\tLXE\n2013-05-06T01:43:20.000Z\tWTB.L\t0.4191390374952899\t0.601628162260468\t2104114979\t1431449453\tFast trading\tLXE\n2013-05-06T03:06:40.000Z\tTLW.L\t0.31235312790637193\t0.4865957036424433\t385983022\t706111640\tFast trading\tSK\n2013-05-06T04:30:00.000Z\tABF.L\t0.6642987021593373\t0.6390097534838051\t288643332\t844966286\tFast trading\tGR\n2013-05-06T05:53:20.000Z\tGKN.L\t0.6692538497726956\t0.38655868492682444\t1851982635\t389597203\tFast trading\tSK\n2013-05-06T07:16:40.000Z\tADM.L\t0.30468082169729516\t0.710192204681452\t176224241\t1898789862\tFast trading\tLXE\n2013-05-06T08:40:00.000Z\tTLW.L\t0.48739321264904534\t0.8440157580321933\t2087928281\t127404501\tFast trading\tSK\n2013-05-06T10:03:20.000Z\tTLW.L\t0.5297691576545087\t0.8955601955351037\t1759910298\t993978229\tFast trading\tLXE\n2013-05-06T11:26:40.000Z\tAGK.L\t0.6310262756208203\t0.05518288469822141\t1689645681\t1760027436\tFast trading\tLXE\n2013-05-06T12:50:00.000Z\tBT-A.L\t0.7450196824408323\t0.8119889048254362\t872373948\t268786165\tFast trading\tGR\n2013-05-06T14:13:20.000Z\tBT-A.L\t0.9287194647688317\t0.3485445026156174\t1276818540\t532491427\tFast trading\tGR\n2013-05-06T15:36:40.000Z\tRRS.L\t0.1944696111340929\t0.9477868235286393\t823976883\t1563711959\tFast trading\tGR\n2013-05-06T17:00:00.000Z\tABF.L\t0.9643251238886018\t0.8129177499445661\t1945548281\t499978914\tFast trading\tSK\n2013-05-06T18:23:20.000Z\tBP.L\t0.45621034230309654\t0.1747016272521107\t1179616540\t908015035\tFast trading\tGR\n2013-05-06T19:46:40.000Z\tLLOY.L\t0.7193355196302277\t0.9404701555734597\t704067095\t1668582762\tFast trading\tGR\n2013-05-06T21:10:00.000Z\tBT-A.L\t0.5802553772318062\t0.42527010055682646\t1089603881\t1629058050\tFast trading\tGR\n2013-05-06T22:33:20.000Z\tBP.L\t0.46114752131469783\t0.8979723557722048\t1579801637\t2117833235\tFast trading\tGR\n2013-05-06T23:56:40.000Z\tBT-A.L\t0.8883345886748325\t0.7737938544972554\t1750740931\t1514907397\tFast trading\tGR\n2013-05-07T01:20:00.000Z\tAGK.L\t0.5217691943089976\t0.28956673106743125\t681718809\t1972465127\tFast trading\tLXE\n2013-05-07T02:43:20.000Z\tRRS.L\t0.7051458116683191\t0.40922139034207683\t631143150\t997183581\tFast trading\tLXE\n2013-05-07T04:06:40.000Z\tADM.L\t0.861499400556018\t0.5243336208514339\t648366676\t698699955\tFast trading\tSK\n2013-05-07T05:30:00.000Z\tTLW.L\t0.5405954330001682\t0.23821846687340553\t1057951361\t1833806187\tFast trading\tLXE\n";
        try (JournalWriter w2 = this.getFactory().writer(Quote.class, "W2");){
            TestData.appendQuoteData1((JournalWriter<Quote>)w2);
            TestData.appendQuoteData2((JournalWriter<Quote>)w2);
            Query q2 = w2.query();
            TestUtils.assertEquals(expected, q2.all().iterator(0x200000000062L));
            try (ConcurrentIterator iterator = q2.all().concurrentIterator(0x200000000062L);){
                TestUtils.assertEquals(expected, iterator);
            }
        }
    }
}

