/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.std.NumericException;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.BSearchType;
import com.questdb.store.Interval;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.store.Partition;
import com.questdb.test.tools.AbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class PartitionTest
extends AbstractTest {
    @Test
    public void testIndexOf() throws JournalException, NumericException {
        try (JournalWriter journal = this.getFactory().writer(Quote.class);){
            long ts1 = DateFormatUtils.parseDateTime((CharSequence)"2012-06-05T00:00:00.000Z");
            long ts2 = DateFormatUtils.parseDateTime((CharSequence)"2012-07-03T00:00:00.000Z");
            long ts3 = DateFormatUtils.parseDateTime((CharSequence)"2012-06-04T00:00:00.000Z");
            long ts4 = DateFormatUtils.parseDateTime((CharSequence)"2012-06-06T00:00:00.000Z");
            Quote q9 = new Quote().setSym("S5").setTimestamp(ts3);
            Quote q10 = new Quote().setSym("S5").setTimestamp(ts4);
            Quote q1 = new Quote().setSym("S1").setTimestamp(ts1);
            Quote q2 = new Quote().setSym("S2").setTimestamp(ts1);
            Quote q3 = new Quote().setSym("S3").setTimestamp(ts1);
            Quote q4 = new Quote().setSym("S4").setTimestamp(ts1);
            Quote q5 = new Quote().setSym("S1").setTimestamp(ts2);
            Quote q6 = new Quote().setSym("S2").setTimestamp(ts2);
            Quote q7 = new Quote().setSym("S3").setTimestamp(ts2);
            Quote q8 = new Quote().setSym("S4").setTimestamp(ts2);
            journal.append((Object)q9);
            journal.append((Object)q1);
            journal.append((Object)q2);
            journal.append((Object)q3);
            journal.append((Object)q4);
            journal.append((Object)q10);
            journal.append((Object)q5);
            journal.append((Object)q6);
            journal.append((Object)q7);
            journal.append((Object)q8);
            Assert.assertEquals((long)2L, (long)journal.getPartitionCount());
            long tsA = DateFormatUtils.parseDateTime((CharSequence)"2012-06-15T00:00:00.000Z");
            Partition partition1 = this.getPartitionForTimestamp((Journal)journal, tsA).open();
            Assert.assertNotNull((String)"getPartition(timestamp) failed", (Object)partition1);
            Assert.assertEquals((long)-2L, (long)partition1.indexOf(tsA, BSearchType.NEWER_OR_SAME));
            Assert.assertEquals((long)-1L, (long)partition1.indexOf(DateFormatUtils.parseDateTime((CharSequence)"2012-06-03T00:00:00.000Z"), BSearchType.OLDER_OR_SAME));
            Assert.assertEquals((long)0L, (long)partition1.indexOf(DateFormatUtils.parseDateTime((CharSequence)"2012-06-03T00:00:00.000Z"), BSearchType.NEWER_OR_SAME));
            Assert.assertEquals((long)4L, (long)partition1.indexOf(ts1, BSearchType.OLDER_OR_SAME));
            Assert.assertEquals((long)1L, (long)partition1.indexOf(ts1, BSearchType.NEWER_OR_SAME));
            Partition p = journal.openOrCreateLagPartition();
            long result = p.indexOf(DateFormatUtils.parseDateTime((CharSequence)"2012-06-15T00:00:00.000Z"), BSearchType.OLDER_OR_SAME);
            Assert.assertEquals((long)-1L, (long)result);
        }
    }

    private <T> Partition<T> getPartitionForTimestamp(Journal<T> journal, long timestamp) throws JournalException {
        int sz = journal.getPartitionCount();
        for (int i = 0; i < sz; ++i) {
            Partition result = journal.getPartition(i, false);
            Interval interval = result.getInterval();
            if (interval != null && !interval.contains(timestamp)) continue;
            return result;
        }
        if (journal.getPartition(0, false).getInterval().isAfter(timestamp)) {
            return journal.getPartition(0, false);
        }
        return journal.getPartition(sz - 1, false);
    }
}

