/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.std.NumericException;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.Journal;
import com.questdb.store.JournalIterators;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.AbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class NullTest
extends AbstractTest {
    @Test
    public void tumbleDryNullTest() throws JournalException, NumericException {
        int TEST_DATA_SIZE = 1000;
        try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", 1000);){
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z");
            String[] symbols = new String[]{"AGK.L", "BP.L", "TLW.L", "ABF.L", "LLOY.L", "BT-A.L", "WTB.L", "RRS.L", "ADM.L", "GKN.L", "HSBA.L"};
            Quote q = new Quote();
            int increment = 6000;
            for (int i = 0; i < 1000; ++i) {
                q.clear();
                if (i % 7 != 0) {
                    q.setSym(symbols[i % symbols.length]);
                }
                if (i % 11 != 0) {
                    q.setAsk((double)i * 2.298007E9);
                }
                if (i % 13 != 0) {
                    q.setBid((double)i * 2.298007E-7);
                }
                if (i % 3 != 0) {
                    q.setAskSize(i);
                }
                if (i % 5 != 0) {
                    q.setBidSize(i * 7);
                }
                if (i % 2 != 0) {
                    q.setEx("LXE");
                }
                if (i % 17 != 0) {
                    q.setMode("Some interesting string with \u043a\u0438\u0440\u0440\u0438\u043b\u0438\u0446\u0430 and special char" + (char)(i % 65535));
                }
                q.setTimestamp(timestamp);
                timestamp += (long)increment;
                w.append((Object)q);
            }
            w.commit();
            try (Journal r = this.getFactory().reader(Quote.class, "quote");){
                int i = 0;
                for (Quote qr : JournalIterators.bufferedIterator((Journal)r)) {
                    if (i % 7 != 0) {
                        Assert.assertEquals((Object)symbols[i % symbols.length], (Object)qr.getSym());
                    }
                    if (i % 11 != 0) {
                        Assert.assertEquals((double)((double)i * 2.298007E9), (double)qr.getAsk(), (double)1.0E-9);
                    }
                    if (i % 13 != 0) {
                        Assert.assertEquals((double)((double)i * 2.298007E-7), (double)qr.getBid(), (double)1.0E-9);
                    }
                    if (i % 3 != 0) {
                        Assert.assertEquals((long)i, (long)qr.getAskSize());
                    }
                    if (i % 5 != 0) {
                        Assert.assertEquals((long)(i * 7), (long)qr.getBidSize());
                    }
                    if (i % 2 != 0) {
                        Assert.assertEquals((Object)"LXE", (Object)qr.getEx());
                    }
                    if (i % 17 != 0) {
                        Assert.assertEquals((Object)("Some interesting string with \u043a\u0438\u0440\u0440\u0438\u043b\u0438\u0446\u0430 and special char" + (char)(i % 65535)), (Object)qr.getMode());
                    }
                    ++i;
                }
            }
        }
    }
}

