/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.ex.JournalInvalidSymbolValueException;
import com.questdb.std.ex.JournalException;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MMappedSymbolTableTest
extends AbstractTest {
    private static final int DATA_SIZE = 500;
    private MMappedSymbolTable tab = null;

    @Override
    @After
    public void tearDown() {
        if (this.tab != null) {
            this.tab.close();
        }
    }

    @Test
    public void testCachePreLoad() throws Exception {
        String[] data = this.createData();
        this.createTestTable(data);
        try (MMappedSymbolTable tab = this.getReader().preLoad();){
            for (int i = 0; i < data.length; ++i) {
                Assert.assertEquals((long)i, (long)tab.getQuick((CharSequence)data[i]));
            }
        }
    }

    @Test
    public void testKeyValueMatch() throws Exception {
        String[] data = this.createData();
        this.createTestTable(data);
        try (MMappedSymbolTable tab = this.getReader();){
            for (int i = 0; i < tab.size(); ++i) {
                Assert.assertEquals((Object)data[i], (Object)tab.value(i));
            }
        }
    }

    @Test(expected=JournalInvalidSymbolValueException.class)
    public void testLoudCheckKey() throws Exception {
        this.createTestTable(this.createData());
        try (MMappedSymbolTable tab = this.getReader();){
            Assert.assertEquals((long)420L, (long)tab.get((CharSequence)"TEST420"));
            tab.get((CharSequence)"650");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullValues() throws Exception {
        String[] data = new String[]{null, null};
        this.createTestTable(data);
        try (MMappedSymbolTable tab = this.getReader();){
            Assert.assertEquals((long)0L, (long)tab.size());
        }
        tab = this.getReader().preLoad();
        try {
            Assert.assertEquals((long)0L, (long)tab.size());
        }
        finally {
            tab.close();
        }
    }

    @Test
    public void testReload() throws Exception {
        String[] data = this.createData();
        this.createTestTable(data);
        try (MMappedSymbolTable tab = this.getReader();){
            int i;
            int i2;
            for (i2 = 0; i2 < tab.size(); ++i2) {
                Assert.assertEquals((Object)data[i2], (Object)tab.value(i2));
            }
            for (i2 = 0; i2 < data.length; ++i2) {
                Assert.assertEquals((long)i2, (long)tab.getQuick((CharSequence)data[i2]));
            }
            int LEN2 = 50;
            String[] data2 = new String[LEN2];
            for (i = 0; i < data2.length; ++i) {
                data2[i] = "ABC" + i;
            }
            this.createTestTable(data2);
            tab.applyTx(this.tab.size(), this.tab.getIndexTxAddress());
            Assert.assertEquals((long)(data.length + data2.length), (long)tab.size());
            for (i = data.length; i < tab.size(); ++i) {
                Assert.assertEquals((Object)data2[i - data.length], (Object)tab.value(i));
            }
            for (i = data2.length - 1; i >= 0; --i) {
                Assert.assertEquals((long)(i + data.length), (long)tab.getQuick((CharSequence)data2[i]));
            }
        }
    }

    @Test
    public void testRepeatedValues() throws Exception {
        String[] data = new String[]{"VAL1", null, "VAL2", "", "VAL2", "", null, "VAL1", "VAL3"};
        int[] expectedKeys = new int[]{0, -1, 1, 2, 1, 2, -1, 0, 3};
        this.createTestTable(data);
        try (MMappedSymbolTable tab = this.getReader();){
            for (int i = 0; i < data.length; ++i) {
                Assert.assertEquals((long)expectedKeys[i], (long)tab.getQuick((CharSequence)data[i]));
            }
        }
    }

    @Test
    public void testTruncate() throws Exception {
        String[] data = this.createData();
        this.createTestTable(data);
        try (MMappedSymbolTable tab = this.getWriter();){
            Assert.assertEquals((long)500L, (long)tab.size());
            Assert.assertTrue((boolean)tab.valueExists((CharSequence)"TEST25"));
            tab.truncate();
            Assert.assertEquals((long)0L, (long)tab.size());
            Assert.assertFalse((boolean)tab.valueExists((CharSequence)"TEST25"));
        }
    }

    @Test
    public void testValueIterator() throws Exception {
        String[] data = this.createData();
        this.createTestTable(data);
        try (MMappedSymbolTable tab = this.getReader();){
            for (MMappedSymbolTable.Entry e : tab.values()) {
                TestUtils.assertEquals((CharSequence)data[e.key], e.value);
            }
        }
    }

    @Test
    public void testValueKeyMatch() throws Exception {
        String[] data = this.createData();
        this.createTestTable(data);
        try (MMappedSymbolTable tab = this.getReader();){
            for (int i = 0; i < data.length; ++i) {
                Assert.assertEquals((long)i, (long)tab.getQuick((CharSequence)data[i]));
            }
        }
    }

    private String[] createData() {
        String[] data = new String[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = "TEST" + i;
        }
        return data;
    }

    private void createTestTable(String[] data) throws JournalException {
        if (this.tab == null) {
            this.tab = new MMappedSymbolTable(500, 256, 1, this.getFactory().getConfiguration().getJournalBase(), "test", 2, 0, 0L, false, false);
        }
        for (String s : data) {
            this.tab.put((CharSequence)s);
        }
        this.tab.commit();
    }

    private MMappedSymbolTable getReader() throws JournalException {
        return new MMappedSymbolTable(500, 256, 1, this.getFactory().getConfiguration().getJournalBase(), "test", 0, this.tab.size(), this.tab.getIndexTxAddress(), false, false);
    }

    private MMappedSymbolTable getWriter() throws JournalException {
        return new MMappedSymbolTable(500, 256, 1, this.getFactory().getConfiguration().getJournalBase(), "test", 2, this.tab.size(), this.tab.getIndexTxAddress(), false, false);
    }
}

