/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.model.configuration.ModelConfiguration;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.Dates;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.test.tools.AbstractTest;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class LockTest
extends AbstractTest {
    @Test
    public void testLockAcrossClassLoaders() throws JournalException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        URLClassLoader classLoader = new URLClassLoader(((URLClassLoader)this.getClass().getClassLoader()).getURLs(), null);
        JournalWriter rw = this.getFactory().writer(Quote.class);
        rw.close();
        this.getFactory().delete(Quote.class.getName());
        rw = this.getFactory().writer(Quote.class);
        ArrayList<Quote> data = new ArrayList<Quote>();
        data.add(new Quote().setSym("S1").setTimestamp(Dates.toMillis((int)2013, (int)3, (int)10, (int)15, (int)0)));
        data.add(new Quote().setSym("S2").setTimestamp(Dates.toMillis((int)2013, (int)3, (int)10, (int)16, (int)0)));
        rw.mergeAppend(data);
        rw.commit();
        new TestAccessor(this.factoryContainer.getConfiguration().getJournalBase());
        classLoader.loadClass("com.questdb.store.LockTest$TestAccessor").getConstructor(File.class).newInstance(this.factoryContainer.getConfiguration().getJournalBase());
        rw.close();
        this.getFactory().delete(Quote.class.getName());
    }

    public static class TestAccessor {
        public TestAccessor(File journalBase) throws JournalException {
            try (Factory factory = new Factory(ModelConfiguration.MAIN.build(journalBase));
                 Journal reader = factory.reader(Quote.class);){
                Assert.assertEquals((long)2L, (long)reader.size());
            }
        }
    }
}

