/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.std.NumericException;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.Dates;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.store.Partition;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestData;
import java.io.File;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LagTest
extends AbstractTest {
    private JournalWriter<Quote> rw;

    @Before
    public void setUp() throws Exception {
        this.rw = this.getFactory().writer(Quote.class);
    }

    @Override
    @After
    public void tearDown() {
        this.rw.close();
    }

    @Test
    public void testLagAppendScenarios() throws JournalException {
        File loc;
        ArrayList<Quote> data1 = new ArrayList<Quote>();
        data1.add(new Quote().setSym("S1").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)10, (int)10, (int)0)));
        data1.add(new Quote().setSym("S2").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)10, (int)14, (int)0)));
        this.rw.mergeAppend(data1);
        this.rw.commit();
        try (Journal reader = this.getFactory().reader(Quote.class);){
            reader.query().all().asResultSet().read();
            loc = reader.getLocation();
            ArrayList<Quote> data2 = new ArrayList<Quote>();
            data2.add(new Quote().setSym("S3").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)10, (int)15, (int)0)));
            data2.add(new Quote().setSym("S4").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)10, (int)16, (int)0)));
            this.rw.mergeAppend(data2);
            ArrayList<Quote> data3 = new ArrayList<Quote>();
            data3.add(new Quote().setSym("S8").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)15, (int)0)));
            data3.add(new Quote().setSym("S9").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)16, (int)0)));
            this.rw.mergeAppend(data3);
            ArrayList<Quote> data4 = new ArrayList<Quote>();
            data4.add(new Quote().setSym("S6").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)10, (int)0)));
            data4.add(new Quote().setSym("S7").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)11, (int)0)));
            this.rw.mergeAppend(data4);
            ArrayList<Quote> data5 = new ArrayList<Quote>();
            data5.add(new Quote().setSym("S5").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)9, (int)0)));
            data5.add(new Quote().setSym("S10").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)17, (int)0)));
            this.rw.mergeAppend(data5);
            ArrayList<Quote> data6 = new ArrayList<Quote>();
            data6.add(new Quote().setSym("near-S5").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)9, (int)0)));
            data6.add(new Quote().setSym("near-S10").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)17, (int)0)));
            this.rw.mergeAppend(data6);
            ArrayList<Quote> data7 = new ArrayList<Quote>();
            data7.add(new Quote().setSym("after-S4").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)9, (int)9, (int)0)));
            data7.add(new Quote().setSym("after-S9").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)16, (int)30)));
            this.rw.mergeAppend(data7);
            ArrayList<Quote> data8 = new ArrayList<Quote>();
            data8.add(new Quote().setSym("after-S8").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)15, (int)30)));
            data8.add(new Quote().setSym("after-S10").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)18, (int)30)));
            this.rw.mergeAppend(data8);
            ArrayList<Quote> data9 = new ArrayList<Quote>();
            data9.add(new Quote().setSym("after-S6").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)10, (int)30)));
            data9.add(new Quote().setSym("before-S10").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)16, (int)45)));
            this.rw.mergeAppend(data9);
            ArrayList<Quote> data10 = new ArrayList<Quote>();
            data10.add(new Quote().setSym("discard-S1").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)1, (int)10, (int)30)));
            data10.add(new Quote().setSym("discard-S2").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)1, (int)16, (int)45)));
            this.rw.mergeAppend(data10);
            ArrayList<Quote> data11 = new ArrayList<Quote>();
            data11.add(new Quote().setSym("discard-S3").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)1, (int)10, (int)30)));
            data11.add(new Quote().setSym("before-S6").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)9, (int)45)));
            this.rw.mergeAppend(data11);
            String[] expected = new String[]{"S1", "S2", "S3", "S4", "after-S4", "S5", "near-S5", "before-S6", "S6", "after-S6", "S7", "S8", "after-S8", "S9", "after-S9", "before-S10", "S10", "near-S10", "after-S10"};
            int i = 0;
            for (Quote p : this.rw) {
                Assert.assertEquals((String)"Order incorrect", (Object)expected[i++], (Object)p.getSym());
            }
            this.rw.commit();
            Assert.assertEquals((String)"Journal size mismatch", (long)19L, (long)this.rw.size());
            Assert.assertEquals((String)"Partition count mismatch", (long)3L, (long)this.rw.getPartitionCount());
            Assert.assertEquals((String)"Lag size mismatch", (long)14L, (long)this.rw.openOrCreateLagPartition().size());
            this.rw.close();
            reader.refresh();
            reader.query().all().asResultSet().read();
        }
        this.getFactory().lock(Quote.class.getName());
        String[] tempDirs = loc.list((dir, name) -> name.startsWith("temp") && !name.endsWith(".lock"));
        Assert.assertNotNull((Object)tempDirs);
        Assert.assertEquals((long)1L, (long)tempDirs.length);
    }

    @Test
    public void testLagDelete() throws Exception {
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin");){
            String lagName;
            TestData.appendQuoteData2((JournalWriter<Quote>)origin);
            this.rw.mergeAppend(origin.query().all().asResultSet().subset(0, 300));
            this.rw.commit();
            try (Journal r = this.getFactory().reader(Quote.class);){
                Assert.assertEquals((long)300L, (long)r.size());
                lagName = r.getIrregularPartition().getName();
            }
            this.rw.mergeAppend(origin.query().all().asResultSet().subset(300, 400));
            this.rw.mergeAppend(origin.query().all().asResultSet().subset(400, 500));
            this.rw.mergeAppend(origin.query().all().asResultSet().subset(500, 600));
            r = this.getFactory().reader(Quote.class);
            var5_4 = null;
            try {
                Assert.assertEquals((long)300L, (long)r.size());
                Assert.assertEquals((Object)lagName, (Object)r.getIrregularPartition().getName());
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (r != null) {
                    if (var5_4 != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable) {
                            var5_4.addSuppressed(throwable);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
    }

    @Test
    public void testLagWorkflow() throws JournalException, NumericException {
        Quote v1 = new Quote().setSym("1").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-10T00:00:00.000Z"));
        Quote v2 = new Quote().setSym("2").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-10T10:00:00.000Z"));
        Quote v3 = new Quote().setSym("2").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-10T16:00:00.000Z"));
        Quote v4 = new Quote().setSym("3").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-10T19:00:00.000Z"));
        Quote v5 = new Quote().setSym("4").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-10T22:00:00.000Z"));
        this.rw.append((Object)v1);
        Partition p = this.rw.openOrCreateLagPartition();
        p.append((Object)v2);
        p.append((Object)v3);
        p.append((Object)v4);
        p.append((Object)v5);
        Quote v6 = new Quote().setSym("5").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-11T08:00:00.000Z"));
        ArrayList<Quote> data = new ArrayList<Quote>();
        data.add(v6);
        this.rw.mergeAppend(data);
        this.rw.commit();
        Assert.assertEquals((long)6L, (long)this.rw.size());
        Assert.assertEquals((long)5L, (long)this.rw.openOrCreateLagPartition().size());
        this.rw.close();
        this.rw = this.getFactory().writer(Quote.class);
        Assert.assertEquals((long)6L, (long)this.rw.size());
        Assert.assertEquals((long)5L, (long)this.rw.openOrCreateLagPartition().size());
        this.rw.purgeTempPartitions();
    }

    @Test
    public void testOpenWithLag() throws JournalException, NumericException {
        Partition partition = this.rw.openOrCreateLagPartition();
        Quote v1 = new Quote().setSym("1").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-11T00:00:00.000Z"));
        Quote v2 = new Quote().setSym("2").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-11T10:00:00.000Z"));
        Quote v3 = new Quote().setSym("2").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-06-11T06:00:00.000Z"));
        this.rw.append((Object)v1);
        partition.append((Object)v2);
        partition.append((Object)v3);
        Assert.assertEquals((long)2L, (long)partition.size());
        Assert.assertEquals((long)2L, (long)this.rw.getPartitionCount());
        Assert.assertEquals((Object)partition, (Object)this.rw.getPartition(1, true));
    }
}

