/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.LongList;
import com.questdb.std.ex.JournalException;
import com.questdb.store.IndexCursor;
import com.questdb.store.JournalRuntimeException;
import com.questdb.store.KVIndex;
import com.questdb.test.tools.AbstractTest;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KvIndexTest
extends AbstractTest {
    private static final int totalKeys = 10;
    private static final int totalValues = 100;
    private File indexFile;

    @Before
    public void setUp() {
        this.indexFile = new File(this.getFactory().getConfiguration().getJournalBase(), "index-test");
    }

    @Test
    public void testAppendNullAfterTruncate() throws JournalException {
        int totalKeys = 2;
        int totalValues = 1;
        try (KVIndex index = new KVIndex(this.indexFile, (long)totalKeys, (long)totalValues, 1, 2, 0L, false);){
            for (int i = -1; i < totalKeys; ++i) {
                index.add(i, (long)i);
            }
            Assert.assertEquals((long)totalKeys, (long)index.size());
            index.truncate(0L);
            Assert.assertEquals((long)0L, (long)index.size());
            index.add(-1, 10L);
            Assert.assertEquals((long)11L, (long)index.size());
        }
    }

    @Test
    public void testGetValueQuick() throws Exception {
        long[][] expected = new long[][]{{0L, 3L, 5L, 6L, 8L, 10L, 12L, 14L, 16L, 22L}, {1L, 2L, 3L, 4L, 6L, 8L, 9L, 11L, 16L, 21L, 33L}};
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 60L, 1, 2, 0L, false);){
            this.putValues(expected, index);
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((long)expected[i].length, (long)index.getValueCount(i));
                for (int k = 0; k < expected[i].length; ++k) {
                    Assert.assertEquals((long)expected[i][k], (long)index.getValueQuick(i, k));
                }
            }
        }
    }

    @Test
    public void testGetValuesMultiBlock() throws Exception {
        long[][] expected = new long[][]{{0L, 3L, 5L, 6L, 8L, 10L, 12L, 14L, 16L, 22L}, {1L, 2L, 3L, 4L, 6L, 8L, 9L, 11L, 16L, 21L, 33L}};
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 60L, 1, 2, 0L, false);){
            this.putValues(expected, index);
            this.assertValues(expected, index);
        }
    }

    @Test
    public void testGetValuesPartialBlock() throws Exception {
        long[][] expected = new long[][]{{0L, 3L, 5L, 6L, 8L, 10L, 12L, 14L, 16L, 22L}, {1L, 2L, 3L, 4L, 6L, 8L, 9L, 11L, 16L, 21L, 33L}};
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 200L, 1, 2, 0L, false);){
            this.putValues(expected, index);
            this.assertValues(expected, index);
        }
    }

    @Test
    public void testIndexReadWrite() throws JournalException {
        KVIndex index = new KVIndex(this.indexFile, 10L, 100L, 1, 2, 0L, false);
        index.add(0, 0L);
        index.add(1, 1L);
        index.add(1, 2L);
        index.add(0, 3L);
        index.add(0, 4L);
        index.add(1, 5L);
        index.add(1, 6L);
        index.add(0, 7L);
        Assert.assertEquals((long)1L, (long)index.getValueQuick(1, 0));
        Assert.assertEquals((long)2L, (long)index.getValueQuick(1, 1));
        Assert.assertEquals((long)5L, (long)index.getValueQuick(1, 2));
        Assert.assertEquals((long)6L, (long)index.getValueQuick(1, 3));
        Assert.assertEquals((long)0L, (long)index.getValueQuick(0, 0));
        Assert.assertEquals((long)3L, (long)index.getValueQuick(0, 1));
        Assert.assertEquals((long)4L, (long)index.getValueQuick(0, 2));
        Assert.assertEquals((long)7L, (long)index.getValueQuick(0, 3));
        Assert.assertEquals((long)8L, (long)index.size());
        index.close();
    }

    @Test
    public void testIndexTx() throws Exception {
        long[][] expected = new long[][]{{0L, 3L, 5L, 6L, 8L, 10L, 12L, 14L, 16L, 22L}, {1L, 2L, 3L, 4L, 6L, 8L, 9L, 11L, 16L, 21L, 33L}};
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 60L, 1, 2, 0L, false);
             KVIndex reader = new KVIndex(this.indexFile, 10L, 60L, 1, 0, 0L, false);){
            this.putValues(expected, index);
            Assert.assertEquals((long)34L, (long)index.size());
            Assert.assertTrue((boolean)index.contains(0));
            Assert.assertTrue((boolean)index.contains(1));
            Assert.assertEquals((long)10L, (long)index.getValues(0).size());
            Assert.assertEquals((long)10L, (long)index.getValueCount(0));
            Assert.assertEquals((long)11L, (long)index.getValueCount(1));
            Assert.assertEquals((long)0L, (long)reader.size());
            Assert.assertEquals((long)0L, (long)reader.getValues(0).size());
            Assert.assertFalse((boolean)reader.contains(0));
            Assert.assertFalse((boolean)reader.contains(1));
            Assert.assertEquals((long)0L, (long)reader.getValueCount(0));
            Assert.assertEquals((long)0L, (long)reader.getValueCount(1));
            index.commit();
            reader.setTxAddress(index.getTxAddress());
            index.add(0, 35L);
            index.add(1, 46L);
            Assert.assertEquals((long)34L, (long)reader.size());
            Assert.assertTrue((boolean)reader.contains(0));
            Assert.assertTrue((boolean)reader.contains(1));
            Assert.assertEquals((long)10L, (long)reader.getValues(0).size());
            Assert.assertEquals((long)10L, (long)reader.getValueCount(0));
            Assert.assertEquals((long)11L, (long)reader.getValueCount(1));
            try (KVIndex reader2 = new KVIndex(this.indexFile, 10L, 60L, 1, 0, reader.getTxAddress(), false);){
                Assert.assertEquals((long)34L, (long)reader2.size());
                Assert.assertTrue((boolean)reader2.contains(0));
                Assert.assertTrue((boolean)reader2.contains(1));
                Assert.assertEquals((long)10L, (long)reader2.getValues(0).size());
                Assert.assertEquals((long)10L, (long)reader2.getValueCount(0));
                Assert.assertEquals((long)11L, (long)reader2.getValueCount(1));
            }
            index.commit();
            reader2 = new KVIndex(this.indexFile, 10L, 60L, 1, 0, index.getTxAddress(), false);
            var7_11 = null;
            try {
                Assert.assertEquals((long)47L, (long)reader2.size());
                Assert.assertTrue((boolean)reader2.contains(0));
                Assert.assertTrue((boolean)reader2.contains(1));
                Assert.assertEquals((long)11L, (long)reader2.getValues(0).size());
                Assert.assertEquals((long)11L, (long)reader2.getValueCount(0));
                Assert.assertEquals((long)12L, (long)reader2.getValueCount(1));
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (reader2 != null) {
                    if (var7_11 != null) {
                        try {
                            reader2.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        reader2.close();
                    }
                }
            }
        }
    }

    @Test
    public void testKeyOutOfBounds() throws JournalException {
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 100L, 1, 2, 0L, false);){
            index.add(0, 0L);
            index.add(1, 1L);
            index.add(1, 2L);
            Assert.assertEquals((long)0L, (long)index.getValues(2).size());
        }
    }

    @Test
    public void testSmallValueArray() throws JournalException {
        int totalKeys = 2;
        int totalValues = 1;
        try (KVIndex index = new KVIndex(this.indexFile, (long)totalKeys, (long)totalValues, 1, 2, 0L, false);){
            for (int i = 0; i < totalKeys; ++i) {
                index.add(i, (long)i);
            }
            Assert.assertEquals((long)totalKeys, (long)index.size());
            index.truncate(0L);
            Assert.assertEquals((long)0L, (long)index.size());
        }
    }

    @Test
    public void testTruncateAtTail() throws JournalException {
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 100L, 1, 2, 0L, false);){
            index.add(0, 0L);
            index.add(1, 1L);
            index.add(1, 2L);
            index.add(0, 3L);
            index.add(0, 4L);
            index.add(1, 5L);
            index.add(1, 6L);
            index.add(0, 7L);
            index.truncate(6L);
            Assert.assertEquals((long)3L, (long)index.getValues(0).size());
            Assert.assertEquals((long)3L, (long)index.getValues(1).size());
            Assert.assertEquals((long)1L, (long)index.getValueQuick(1, 0));
            Assert.assertEquals((long)2L, (long)index.getValueQuick(1, 1));
            Assert.assertEquals((long)5L, (long)index.getValueQuick(1, 2));
            Assert.assertEquals((long)0L, (long)index.getValueQuick(0, 0));
            Assert.assertEquals((long)3L, (long)index.getValueQuick(0, 1));
            Assert.assertEquals((long)4L, (long)index.getValueQuick(0, 2));
            Assert.assertEquals((long)6L, (long)index.size());
        }
    }

    @Test
    public void testTruncateBeforeStart() throws JournalException {
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 100L, 1, 2, 0L, false);){
            index.add(0, 0L);
            index.add(1, 1L);
            index.add(1, 2L);
            index.add(0, 3L);
            index.add(0, 4L);
            index.add(1, 5L);
            index.add(1, 6L);
            index.add(0, 7L);
            index.truncate(0L);
            Assert.assertFalse((boolean)index.contains(0));
            Assert.assertFalse((boolean)index.contains(1));
            Assert.assertEquals((long)0L, (long)index.size());
        }
    }

    @Test
    public void testTruncateBeyondTail() throws JournalException {
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 100L, 1, 2, 0L, false);){
            index.add(0, 0L);
            index.add(1, 1L);
            index.add(1, 2L);
            index.add(0, 3L);
            index.add(0, 4L);
            index.add(1, 5L);
            index.add(1, 6L);
            index.add(0, 7L);
            index.truncate(10L);
            Assert.assertEquals((long)4L, (long)index.getValues(0).size());
            Assert.assertEquals((long)4L, (long)index.getValues(1).size());
            Assert.assertEquals((long)1L, (long)index.getValueQuick(1, 0));
            Assert.assertEquals((long)2L, (long)index.getValueQuick(1, 1));
            Assert.assertEquals((long)5L, (long)index.getValueQuick(1, 2));
            Assert.assertEquals((long)6L, (long)index.getValueQuick(1, 3));
            Assert.assertEquals((long)0L, (long)index.getValueQuick(0, 0));
            Assert.assertEquals((long)3L, (long)index.getValueQuick(0, 1));
            Assert.assertEquals((long)4L, (long)index.getValueQuick(0, 2));
            Assert.assertEquals((long)7L, (long)index.getValueQuick(0, 3));
            Assert.assertEquals((long)8L, (long)index.size());
        }
    }

    @Test
    public void testTruncateMiddle() throws JournalException {
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 100L, 1, 2, 0L, false);){
            index.add(0, 0L);
            index.add(1, 1L);
            index.add(1, 2L);
            index.add(0, 3L);
            index.add(0, 4L);
            index.add(1, 5L);
            index.add(1, 6L);
            index.add(0, 7L);
            index.truncate(5L);
            Assert.assertEquals((long)3L, (long)index.getValues(0).size());
            Assert.assertEquals((long)2L, (long)index.getValues(1).size());
            Assert.assertEquals((long)1L, (long)index.getValueQuick(1, 0));
            Assert.assertEquals((long)2L, (long)index.getValueQuick(1, 1));
            Assert.assertEquals((long)0L, (long)index.getValueQuick(0, 0));
            Assert.assertEquals((long)3L, (long)index.getValueQuick(0, 1));
            Assert.assertEquals((long)4L, (long)index.getValueQuick(0, 2));
        }
    }

    @Test(expected=JournalRuntimeException.class)
    public void testValueOutOfBounds() throws JournalException {
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 100L, 1, 2, 0L, false);){
            index.add(0, 0L);
            index.add(1, 1L);
            index.add(1, 2L);
            index.getValueQuick(0, 1);
        }
    }

    private void assertValues(long[][] values, KVIndex index) {
        for (int i = 0; i < values.length; ++i) {
            LongList array = index.getValues(i);
            Assert.assertEquals((long)values[i].length, (long)array.size());
            for (int k = 0; k < values[i].length; ++k) {
                Assert.assertEquals((long)values[i][k], (long)array.get(k));
            }
            IndexCursor cursor = index.cursor(i);
            int k = (int)cursor.size();
            while (cursor.hasNext()) {
                Assert.assertEquals((long)values[i][--k], (long)cursor.next());
            }
            KVIndex.FwdIndexCursor c = index.fwdCursor(i);
            int n = 0;
            while (c.hasNext()) {
                long l = c.next();
                Assert.assertEquals((long)values[i][n++], (long)l);
            }
        }
    }

    private void putValues(long[][] values, KVIndex index) {
        for (int i = 0; i < values.length; ++i) {
            for (int k = 0; k < values[i].length; ++k) {
                index.add(i, values[i][k]);
            }
        }
    }
}

