/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.model.TestEntity;
import com.questdb.std.NumericException;
import com.questdb.std.Rnd;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.Files;
import com.questdb.store.Journal;
import com.questdb.store.JournalKey;
import com.questdb.store.JournalListener;
import com.questdb.store.JournalWriter;
import com.questdb.store.Partition;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.configuration.JournalConfigurationBuilder;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.store.query.OrderedResultSet;
import com.questdb.store.query.ResultSet;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestData;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class JournalTest
extends AbstractTest {
    @Test(expected=JournalException.class)
    public void testAddPartitionOutOfOrder() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            w.getAppendPartition(DateFormatUtils.parseDateTime((CharSequence)"2012-02-10T10:00:00.000Z"));
            w.getAppendPartition(DateFormatUtils.parseDateTime((CharSequence)"2012-01-10T10:00:00.000Z"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendBreak() throws Exception {
        Rnd random = new Rnd(System.nanoTime(), System.currentTimeMillis());
        try (JournalWriter w = this.getFactory().writer(TestEntity.class);){
            try {
                w.append((Object)new TestEntity().setSym("ABC").setDStr("test1"));
                w.append((Object)new TestEntity().setSym("ABC").setDStr(random.nextString(100)));
                w.append((Object)new TestEntity().setSym("ABC").setDStr(random.nextString(70000)).setTimestamp(-1L));
            }
            catch (Exception exception) {
            }
            finally {
                w.commit();
            }
            w.append((Object)new TestEntity().setSym("ABC").setDStr(random.nextString(300)));
            Assert.assertEquals((long)3L, (long)w.query().all().withKeys(new String[]{"ABC"}).asResultSet().size());
            Assert.assertEquals((long)1L, (long)w.query().head().withKeys(new String[]{"ABC"}).asResultSet().size());
        }
    }

    @Test
    public void testDecrementRowID() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000);
            OrderedResultSet rs = w.query().all().asResultSet();
            for (int i = 1; i < rs.size(); ++i) {
                Assert.assertEquals((long)rs.getRowID(i - 1), (long)w.decrementRowID(rs.getRowID(i)));
            }
        }
    }

    @Test
    public void testIncrementRowID() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000);
            OrderedResultSet rs = w.query().all().asResultSet();
            for (int i = 1; i < rs.size(); ++i) {
                Assert.assertEquals((long)rs.getRowID(i), (long)w.incrementRowID(rs.getRowID(i - 1)));
            }
        }
    }

    @Test
    public void testInvalidColumnName() {
        File base = this.getFactory().getConfiguration().getJournalBase();
        File dir = new File(base, "x");
        Assert.assertFalse((boolean)dir.exists());
        try {
            this.getFactory().writer((MetadataBuilder)new JournalStructure("x").$sym("x").index().$sym("y").index().$sym("z\u0000is\u0000bad").index().$());
            Assert.fail();
        }
        catch (JournalException journalException) {
            // empty catch block
        }
        this.getFactory().expire();
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)Files.delete((File)dir));
    }

    @Test
    public void testMaxRowID() throws JournalException, NumericException {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 100);
            long maxRowID = w.getMaxRowID();
            int partitionID = Rows.toPartitionIndex((long)maxRowID);
            long localRowID = Rows.toLocalRowID((long)maxRowID);
            Assert.assertEquals((long)w.getLastPartition().getPartitionIndex(), (long)partitionID);
            Assert.assertEquals((long)(w.getLastPartition().size() - 1L), (long)localRowID);
            Assert.assertEquals((long)0x200000000020L, (long)maxRowID);
        }
    }

    @Test
    public void testMaxRowIDBlankJournal() throws Exception {
        try (JournalWriter journal = this.getFactory().writer(Quote.class);){
            Assert.assertEquals((long)-1L, (long)journal.getMaxRowID());
        }
    }

    @Test
    public void testMaxRowIDForJournalWithEmptyPartition() throws Exception {
        try (JournalWriter journal = this.getFactory().writer(Quote.class);){
            journal.getAppendPartition(System.currentTimeMillis());
            Assert.assertEquals((long)-1L, (long)journal.getMaxRowID());
        }
    }

    @Test
    public void testMaxRowIDOnEmptyReader() throws Exception {
        this.getFactory().writer(Quote.class).close();
        try (Journal r = this.getFactory().reader(Quote.class).select(new String[]{"sym"});){
            Assert.assertEquals((long)-1L, (long)r.getMaxRowID());
            Assert.assertNull((Object)r.getLastPartition());
        }
    }

    @Test
    public void testMaxRowIDOnReader() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            w.commit();
        }
        var2_2 = null;
        try (Journal r = this.getFactory().reader(Quote.class).select(new String[]{"sym"});){
            Assert.assertEquals((long)999L, (long)r.getMaxRowID());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflinePartition() throws Exception {
        File location;
        int SIZE = 50000;
        String name = "origin";
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin", SIZE);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            origin.commit();
            location = new File(origin.getLocation(), "2014-03");
        }
        this.getFactory().lock("origin");
        try {
            Files.deleteOrException((File)location);
        }
        finally {
            this.getFactory().unlock("origin");
        }
        origin = this.getFactory().writer(Quote.class, "origin");
        var5_4 = null;
        try {
            Assert.assertEquals((long)25914L, (long)origin.size());
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, 3000, DateFormatUtils.parseDateTime((CharSequence)"2014-03-30T00:11:00.000Z"), 10000L);
            Assert.assertEquals((long)28914L, (long)origin.size());
            origin.rollback();
            Assert.assertEquals((long)25914L, (long)origin.size());
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (origin != null) {
                if (var5_4 != null) {
                    try {
                        origin.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    origin.close();
                }
            }
        }
    }

    @Test
    public void testOpenJournalWithWrongPartitionType() throws Exception {
        try (JournalWriter w2 = this.getFactory().writer(new JournalKey(Quote.class, "quote", 3));){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w2, 1000);
        }
        try {
            this.getFactory().writer(new JournalKey(Quote.class, "quote", 1));
            Assert.fail((String)"Exception expected");
        }
        catch (JournalException w2) {
            // empty catch block
        }
        try {
            var2_4 = null;
            try (Factory f2 = new Factory(new JournalConfigurationBuilder(){
                {
                    this.$(Quote.class).$sym("mode");
                }
            }.build(this.factoryContainer.getConfiguration().getJournalBase()));){
                f2.writer(new JournalKey(Quote.class, "quote"));
                Assert.fail((String)"Exception expected");
            }
            catch (Throwable throwable) {
                var2_4 = throwable;
                throw throwable;
            }
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testReadableColumns() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestData.appendQuoteData1((JournalWriter<Quote>)w);
        }
        String expected = "null\tALDW\t0.25400183821760114\t0.0\t0\t0\tnull\tnull\nnull\tHSBA.L\t0.2534455148850241\t0.0\t0\t0\tnull\tnull\nnull\tALDW\t0.8527617099649412\t0.0\t0\t0\tnull\tnull\nnull\tAMD\t0.7900175963007109\t0.0\t0\t0\tnull\tnull\nnull\tAMD\t0.3667176571649916\t0.0\t0\t0\tnull\tnull\nnull\tHSBA.L\t0.08280315349114653\t0.0\t0\t0\tnull\tnull\nnull\tAMD\t0.32594344090522576\t0.0\t0\t0\tnull\tnull\nnull\tAMD\t0.05533504314019688\t0.0\t0\t0\tnull\tnull\nnull\tAMD\t0.061826046796662926\t0.0\t0\t0\tnull\tnull\nnull\tHSBA.L\t0.30903524429086027\t0.0\t0\t0\tnull\tnull";
        try (Journal r = this.getFactory().reader(Quote.class).select(new String[]{"sym", "bid"});){
            TestUtils.assertEquals(expected, r.query().all().asResultSet().subset(90, 100));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReindex() throws JournalException, NumericException {
        File path;
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestData.appendQuoteData1((JournalWriter<Quote>)w);
            path = w.getLocation();
        }
        this.getFactory().lock(Quote.class.getName());
        try {
            Files.deleteOrException((File)new File(path, "2013-02/sym.r"));
            Files.deleteOrException((File)new File(path, "2013-02/sym.k"));
        }
        finally {
            this.getFactory().unlock(Quote.class.getName());
        }
        var3_2 = null;
        try (Journal journal = this.getFactory().reader(Quote.class);){
            try {
                journal.query().head().withKeys(new String[0]).asResultSet().read();
                Assert.fail((String)"Expected exception here");
            }
            catch (JournalException journalException) {
                // empty catch block
            }
            try (JournalWriter w = this.getFactory().writer(Quote.class);){
                w.rebuildIndexes();
            }
            Assert.assertEquals((long)3L, (long)((Quote[])journal.query().head().withKeys(new String[0]).asResultSet().read()).length);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testRollbackToMiddle() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);
             JournalWriter w2 = this.getFactory().writer(Quote.class, "ctrl");){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000, w.getMaxTimestamp());
            w.commit();
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000, w.getMaxTimestamp());
            w.commit();
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000, w.getMaxTimestamp());
            w.commit();
            long pin = w.getTxPin();
            w2.append((Journal)w);
            w2.commit();
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000, w.getMaxTimestamp());
            w.commit();
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000, w.getMaxTimestamp());
            w.commit();
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000, w.getMaxTimestamp());
            w.commit();
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000, w.getMaxTimestamp());
            w.commit();
            w.rollback(3L, pin);
            TestUtils.assertDataEquals(w2, w);
            Assert.assertEquals((long)3L, (long)w.getTxn());
        }
    }

    @Test
    public void testSingleWriterModel() throws Exception {
        try (JournalWriter writer = this.getFactory().writer(Quote.class);){
            Assert.assertNotNull((Object)writer);
            CountDownLatch finished = new CountDownLatch(1);
            AtomicInteger errors = new AtomicInteger();
            new Thread(() -> {
                try {
                    this.getFactory().writer(Quote.class);
                    errors.incrementAndGet();
                }
                catch (JournalException journalException) {
                    // empty catch block
                }
                finished.countDown();
            }).start();
            Assert.assertTrue((boolean)finished.await(1L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)errors.get());
            try (Journal r = this.getFactory().reader(Quote.class);){
                Assert.assertNotNull((Object)r);
            }
            var6_8 = null;
            try (JournalWriter w = this.getFactory().writer(Quote.class, "test-Quote");){
                Assert.assertNotNull((Object)w);
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testSizeAfterCompaction() throws JournalException, NumericException {
        long sizeAfterCompaction;
        File f2;
        try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", 1000000);){
            TestData.appendQuoteData2((JournalWriter<Quote>)w);
        }
        w = this.getFactory().writer(Quote.class, "quote");
        var4_2 = null;
        try {
            f2 = new File(w.getLocation(), "2013-03/sym.d");
            long size = f2.length();
            w.compact();
            sizeAfterCompaction = f2.length();
            Assert.assertTrue((sizeAfterCompaction < size ? 1 : 0) != 0);
        }
        catch (Throwable f2) {
            var4_2 = f2;
            throw f2;
        }
        finally {
            if (w != null) {
                if (var4_2 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable f2) {
                        var4_2.addSuppressed(f2);
                    }
                } else {
                    w.close();
                }
            }
        }
        var4_2 = null;
        try (Journal r = this.getFactory().reader(Quote.class, "quote");){
            Assert.assertEquals((long)1000L, (long)r.query().all().size());
            f2 = new File(r.getLocation(), "2013-03/sym.d");
            Assert.assertEquals((long)sizeAfterCompaction, (long)f2.length());
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testTxLagTumbleDrier() throws Exception {
        int SIZE = 1000000;
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin", SIZE / 12);
             JournalWriter w = this.getFactory().writer(Quote.class, "q", SIZE / 12);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            origin.commit();
            OrderedResultSet originRs = origin.query().all().asResultSet();
            int blockSize = 5130;
            Rnd rnd = new Rnd(System.currentTimeMillis(), System.nanoTime());
            try {
                int i = 0;
                while (i < originRs.size()) {
                    int d = Math.min(i + blockSize, originRs.size());
                    w.mergeAppend(originRs.subset(i, d));
                    if (rnd.nextBoolean()) {
                        w.commit();
                        i += blockSize;
                        continue;
                    }
                    w.rollback();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Assert.assertFalse((boolean)w.isTxActive());
            TestUtils.assertDataEquals(origin, w);
        }
    }

    @Test
    public void testTxListener() throws Exception {
        int SIZE = 10000;
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin");
             JournalWriter w = this.getFactory().writer(Quote.class, "q");){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), SIZE);
            origin.commit();
            TestJournalListener lsnr = new TestJournalListener();
            w.setJournalListener((JournalListener)lsnr);
            w.append(origin.query().all().asResultSet().subset(0, 1000));
            w.commit();
            Assert.assertTrue((boolean)lsnr.isNotifyAsyncNoWait());
        }
    }

    @Test
    public void testTxRefresh() throws Exception {
        int SIZE = 50000;
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin", SIZE);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            origin.commit();
            try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", SIZE);){
                w.append((Journal)origin);
                w.refresh();
                TestUtils.assertEquals(origin, w);
            }
        }
    }

    @Test
    public void testTxRollbackLag() throws JournalException, NumericException {
        int SIZE = 150000;
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin", SIZE);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            origin.commit();
            try (JournalWriter w = this.getFactory().writer(Quote.class);){
                w.append(origin.query().all().asResultSet().subset(0, 100000));
                w.commit();
                w.mergeAppend(origin.query().all().asResultSet().subset(100000, 120000));
                w.commit();
                try (Journal r = this.getFactory().reader(Quote.class);){
                    TestUtils.assertEquals(w, r);
                    w.mergeAppend(origin.query().all().asResultSet().subset(120000, 150000));
                    w.rollback();
                    TestUtils.assertEquals(w, r);
                    w.mergeAppend(origin.query().all().asResultSet().subset(120000, 150000));
                    w.commit();
                    r.refresh();
                    TestUtils.assertEquals(w, r);
                    TestUtils.assertDataEquals(origin, w);
                }
            }
        }
    }

    @Test
    public void testTxRollbackMultiplePartitions() throws Exception {
        int SIZE = 50000;
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin", SIZE);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            origin.commit();
            try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", SIZE);){
                w.append((Journal)origin);
                w.commit();
                TestUtils.generateQuoteData((JournalWriter<Quote>)w, 50000, DateFormatUtils.parseDateTime((CharSequence)"2014-03-30T00:11:00.000Z"), 100000L);
                Assert.assertEquals((long)100000L, (long)w.size());
                Assert.assertEquals((long)50000L, (long)origin.size());
                w.rollback();
                TestUtils.assertEquals(origin, w);
            }
        }
    }

    @Test
    public void testTxRollbackSamePartition() throws Exception {
        int SIZE = 50000;
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin", SIZE);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            origin.commit();
            try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", SIZE);){
                w.append((Journal)origin);
                w.commit();
                TestUtils.generateQuoteData((JournalWriter<Quote>)w, 20, DateFormatUtils.parseDateTime((CharSequence)"2014-03-30T00:11:00.000Z"), 100L);
                Assert.assertEquals((long)50020L, (long)w.size());
                Assert.assertEquals((long)50000L, (long)origin.size());
                w.rollback();
                TestUtils.assertEquals(origin, w);
            }
        }
    }

    @Test
    public void testTxRollbackToEmpty() throws Exception {
        int SIZE = 100000;
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin", SIZE);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            origin.commit();
            try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", SIZE);){
                w.append((Journal)origin);
                w.rollback();
                Assert.assertEquals((long)0L, (long)w.size());
                Assert.assertEquals((long)1L, (long)w.getPartitionCount());
                Assert.assertEquals((long)0L, (long)w.getSymbolTable("sym").size());
                Assert.assertEquals((long)-2L, (long)w.getSymbolTable("sym").getQuick((CharSequence)"LLOY.L"));
                Assert.assertNull((Object)w.getLastPartition());
                Partition p = w.getPartition(w.getPartitionCount() - 1, false);
                Assert.assertNotNull((Object)p);
                Assert.assertEquals((long)0L, (long)p.getIndexForColumn("sym").size());
            }
        }
    }

    @Test
    public void testTxTumbleDrier() throws Exception {
        int SIZE = 1000000;
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin", SIZE / 12);
             JournalWriter w = this.getFactory().writer(Quote.class, "q", SIZE / 12);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, SIZE, DateFormatUtils.parseDateTime((CharSequence)"2014-01-30T00:11:00.000Z"), 100000L);
            origin.commit();
            OrderedResultSet originRs = origin.query().all().asResultSet();
            int blockSize = 5130;
            Rnd rnd = new Rnd(System.currentTimeMillis(), System.nanoTime());
            try {
                int i = 0;
                while (i < originRs.size()) {
                    int d = Math.min(i + blockSize, originRs.size());
                    ResultSet rs = originRs.subset(i, d);
                    w.append(rs);
                    if (rnd.nextBoolean()) {
                        w.commit();
                        i += blockSize;
                        continue;
                    }
                    w.rollback();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Assert.assertFalse((boolean)w.isTxActive());
            TestUtils.assertDataEquals(origin, w);
        }
    }

    private static class TestJournalListener
    implements JournalListener {
        private boolean notifyAsyncNoWait = false;

        private TestJournalListener() {
        }

        public boolean isNotifyAsyncNoWait() {
            return this.notifyAsyncNoWait;
        }

        public void onCommit() {
            this.notifyAsyncNoWait = true;
        }

        public void onEvent(int event) {
        }

        public void reset() {
            this.notifyAsyncNoWait = false;
        }
    }
}

