/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.Dates;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.store.query.OrderedResultSet;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JournalRefreshTest
extends AbstractTest {
    private JournalWriter<Quote> rw;

    @Before
    public void before() throws JournalException {
        this.rw = this.getFactory().writer(Quote.class);
    }

    @Override
    @After
    public void tearDown() {
        this.rw.close();
    }

    @Test
    public void testIllegalArgExceptionInStorage() throws JournalException {
        this.rw.append((Object)new Quote().setMode("A").setSym("B").setEx("E1").setAsk(10.0).setAskSize(1000).setBid(9.0).setBidSize(900).setTimestamp(System.currentTimeMillis()));
        this.rw.compact();
        this.rw.commit();
        this.rw.close();
        try (Journal reader = this.getFactory().reader(Quote.class);){
            reader.query().all().asResultSet().read();
            try (JournalWriter writer = this.getFactory().writer(Quote.class);){
                writer.append((Object)new Quote().setMode("A").setSym("B").setEx("E1").setAsk(10.0).setAskSize(1000).setBid(9.0).setBidSize(900).setTimestamp(System.currentTimeMillis()));
                Quote expected = new Quote().setMode("A").setSym("B22").setEx("E1").setAsk(10.0).setAskSize(1000).setBid(9.0).setBidSize(900).setTimestamp(System.currentTimeMillis());
                writer.append((Object)expected);
                writer.commit();
                reader.refresh();
                OrderedResultSet rs = reader.query().all().asResultSet();
                Quote q = (Quote)rs.read(rs.size() - 1);
                Assert.assertEquals((Object)expected, (Object)q);
            }
        }
    }

    @Test
    public void testLagDetach() throws Exception {
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin");
             Journal reader = this.getFactory().reader(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2014-02-10T02:00:00.000Z"));
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2014-02-10T10:00:00.000Z"));
            this.rw.append(origin.query().all().asResultSet().subset(0, 500));
            this.rw.commit();
            reader.refresh();
            Assert.assertEquals((long)this.rw.size(), (long)reader.size());
            this.rw.append(origin.query().all().asResultSet().subset(500, 600));
            this.rw.commit();
            reader.refresh();
            Assert.assertEquals((long)this.rw.size(), (long)reader.size());
            this.rw.mergeAppend(origin.query().all().asResultSet().subset(500, 600));
            this.rw.commit();
            reader.refresh();
            Assert.assertEquals((long)this.rw.size(), (long)reader.size());
            this.rw.removeIrregularPartition();
            this.rw.commit();
            reader.refresh();
            Assert.assertEquals((long)this.rw.size(), (long)reader.size());
        }
    }

    @Test
    public void testPartitionRescan() throws Exception {
        try (Journal reader = this.getFactory().reader(Quote.class);){
            Assert.assertEquals((long)0L, (long)reader.size());
            TestUtils.generateQuoteData(this.rw, 1001);
            reader.refresh();
            Assert.assertEquals((long)1001L, (long)reader.size());
            TestUtils.generateQuoteData(this.rw, 302, DateFormatUtils.parseDateTime((CharSequence)"2014-02-10T10:00:00.000Z"));
            reader.refresh();
            Assert.assertEquals((long)1001L, (long)reader.size());
            this.rw.commit();
            reader.refresh();
            Assert.assertEquals((long)1303L, (long)reader.size());
        }
    }

    @Test
    public void testReadConsistency() throws JournalException {
        Quote q1 = new Quote().setSym("ABC").setEx("LN");
        Quote q2 = new Quote().setSym("EFG").setEx("SK");
        this.rw.append((Object)q1);
        this.rw.close();
        this.rw = this.getFactory().writer(Quote.class);
        try (Journal r = this.getFactory().reader(Quote.class);){
            for (Quote v : r) {
                Assert.assertEquals((Object)q1, (Object)v);
            }
            this.rw.append((Object)q2);
            for (Quote v : r) {
                Assert.assertEquals((Object)q1, (Object)v);
            }
        }
    }

    @Test
    public void testRefreshScenarios() throws JournalException {
        this.rw.append((Object)new Quote().setSym("IMO-1").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)10, (int)10, (int)0)));
        this.rw.append((Object)new Quote().setSym("IMO-2").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)10, (int)14, (int)0)));
        this.rw.commit();
        try (Journal r = this.getFactory().reader(Quote.class);){
            Assert.assertEquals((long)2L, (long)r.size());
            this.rw.append((Object)new Quote().setSym("IMO-1").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)10, (int)15, (int)0)));
            this.rw.append((Object)new Quote().setSym("IMO-2").setTimestamp(Dates.toMillis((int)2013, (int)1, (int)10, (int)16, (int)0)));
            this.rw.commit();
            Assert.assertEquals((long)2L, (long)r.size());
            r.refresh();
            Assert.assertEquals((long)4L, (long)r.size());
            this.rw.append((Object)new Quote().setSym("IMO-3").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)15, (int)0)));
            this.rw.append((Object)new Quote().setSym("IMO-4").setTimestamp(Dates.toMillis((int)2013, (int)2, (int)10, (int)16, (int)0)));
            Assert.assertEquals((long)4L, (long)r.size());
            r.refresh();
            Assert.assertEquals((long)4L, (long)r.size());
            this.rw.commit();
            r.refresh();
            Assert.assertEquals((long)6L, (long)r.size());
            ArrayList<Quote> data = new ArrayList<Quote>();
            data.add(new Quote().setSym("IMO-5").setTimestamp(Dates.toMillis((int)2013, (int)3, (int)10, (int)15, (int)0)));
            data.add(new Quote().setSym("IMO-6").setTimestamp(Dates.toMillis((int)2013, (int)3, (int)10, (int)16, (int)0)));
            this.rw.mergeAppend(data);
            this.rw.commit();
            Assert.assertEquals((long)6L, (long)r.size());
            r.refresh();
            Assert.assertEquals((long)8L, (long)r.size());
        }
    }

    @Test
    public void testTruncateRefresh() throws Exception {
        TestUtils.generateQuoteData(this.rw, 1000, DateFormatUtils.parseDateTime((CharSequence)"2013-09-04T10:00:00.000Z"));
        this.rw.commit();
        try (Journal r = this.getFactory().reader(Quote.class);){
            Assert.assertEquals((long)10L, (long)r.getSymbolTable("sym").size());
            r.getSymbolTable("sym").preLoad();
            this.rw.truncate();
            Assert.assertTrue((boolean)r.refresh());
            Assert.assertEquals((long)0L, (long)r.size());
            Assert.assertEquals((long)0L, (long)r.getSymbolTable("sym").size());
        }
    }
}

