/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.store.Interval;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JournalRecoveryTest
extends AbstractTest {
    @Test
    public void testLagRecovery() throws Exception {
        try (JournalWriter origin = this.getFactory().writer(Quote.class, "origin");){
            long ts;
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, 100000, new Interval((CharSequence)"2013-01-01T00:00:00.000Z", (CharSequence)"2013-05-30T12:55:00.000Z"));
            try (Journal r = this.getFactory().reader(Quote.class, "origin");){
                Assert.assertEquals((long)100000L, (long)r.size());
            }
            try (JournalWriter w = this.getFactory().writer(Quote.class);){
                w.disableCommitOnClose();
                w.append(origin.query().all().asResultSet().subset(0, 15000));
                w.mergeAppend(origin.query().all().asResultSet().subset(15000, 17000));
                w.commit();
                ts = w.getMaxTimestamp();
                w.mergeAppend(origin.query().all().asResultSet().subset(16000, 27000));
                w.mergeAppend(origin.query().all().asResultSet().subset(23000, 37000));
                Assert.assertTrue((ts < w.getMaxTimestamp() ? 1 : 0) != 0);
                Assert.assertEquals((long)37672L, (long)w.size());
            }
            this.getFactory().lock(Quote.class.getName());
            this.getFactory().unlock(Quote.class.getName());
            w = this.getFactory().reader(Quote.class);
            var6_12 = null;
            try {
                Assert.assertEquals((long)ts, (long)w.getMaxTimestamp());
                Assert.assertEquals((long)17000L, (long)w.size());
            }
            catch (Throwable throwable) {
                var6_12 = throwable;
                throw throwable;
            }
            finally {
                if (w != null) {
                    if (var6_12 != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable) {
                            var6_12.addSuppressed(throwable);
                        }
                    } else {
                        w.close();
                    }
                }
            }
            w = this.getFactory().writer(Quote.class);
            var6_12 = null;
            try {
                Assert.assertEquals((long)ts, (long)w.getMaxTimestamp());
                Assert.assertEquals((long)17000L, (long)w.size());
            }
            catch (Throwable throwable) {
                var6_12 = throwable;
                throw throwable;
            }
            finally {
                if (w != null) {
                    if (var6_12 != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable) {
                            var6_12.addSuppressed(throwable);
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
    }

    @Test
    public void testRecovery() throws Exception {
        long ts;
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            w.disableCommitOnClose();
            Assert.assertFalse((boolean)w.isCommitOnClose());
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 10000, new Interval((CharSequence)"2013-01-01T00:00:00.000Z", (CharSequence)"2013-02-28T12:55:00.000Z"));
            ts = w.getMaxTimestamp();
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 10000, new Interval((CharSequence)"2013-03-01T00:00:00.000Z", (CharSequence)"2013-05-30T12:55:00.000Z"), false);
            Assert.assertTrue((w.getMaxTimestamp() > ts ? 1 : 0) != 0);
        }
        this.getFactory().lock(Quote.class.getName());
        this.getFactory().unlock(Quote.class.getName());
        w = this.getFactory().reader(Quote.class);
        var4_2 = null;
        try {
            Assert.assertEquals((long)ts, (long)w.getMaxTimestamp());
            Assert.assertEquals((long)10000L, (long)w.size());
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var4_2 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
        w = this.getFactory().writer(Quote.class);
        var4_2 = null;
        try {
            w.disableCommitOnClose();
            Assert.assertEquals((long)ts, (long)w.getMaxTimestamp());
            Assert.assertEquals((long)10000L, (long)w.size());
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var4_2 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
    }
}

