/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.store.JournalKey;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.Test;

public class JournalKeyTest {
    @Test
    public void testKeyEquals() {
        JournalKey key1 = new JournalKey(Quote.class);
        JournalKey key2 = new JournalKey(Quote.class, "Quote22");
        Assert.assertNotEquals((Object)key1, (Object)key2);
    }

    @Test
    public void testKeySerialization() {
        JournalKey key = new JournalKey(Quote.class, "Quote22");
        ByteBuffer buffer = ByteBuffer.allocate(key.getBufferSize()).order(ByteOrder.LITTLE_ENDIAN);
        key.write(buffer);
        Assert.assertEquals((long)key.getBufferSize(), (long)buffer.position());
        buffer.flip();
        JournalKey key2 = JournalKey.fromBuffer((ByteBuffer)buffer);
        Assert.assertEquals((Object)key, (Object)key2);
    }

    @Test
    public void testKeySerializationNullLocation() {
        JournalKey key = new JournalKey(Quote.class);
        ByteBuffer buffer = ByteBuffer.allocate(key.getBufferSize()).order(ByteOrder.LITTLE_ENDIAN);
        key.write(buffer);
        Assert.assertEquals((long)key.getBufferSize(), (long)buffer.position());
        buffer.flip();
        JournalKey key2 = JournalKey.fromBuffer((ByteBuffer)buffer);
        Assert.assertEquals((Object)key, (Object)key2);
    }
}

