/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.std.NumericException;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.Interval;
import com.questdb.store.Journal;
import com.questdb.store.JournalIterators;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.WriterFactory;
import com.questdb.store.query.iter.ConcurrentIterator;
import com.questdb.store.query.iter.JournalConcurrentIterator;
import com.questdb.store.query.iter.JournalPeekingIterator;
import com.questdb.store.query.iter.MergingIterator;
import com.questdb.store.query.iter.MergingPeekingIterator;
import com.questdb.store.query.iter.PeekingIterator;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class IteratorTest
extends AbstractTest {
    private final Comparator<Quote> comparator = (o1, o2) -> {
        long x = o1.getTimestamp();
        long y = o2.getTimestamp();
        return Long.compare(x, y);
    };

    @Test
    public void testBufferedIncrementIterator() throws Exception {
        this.getFactory().writer(Quote.class).close();
        try (Journal r = this.getFactory().reader(Quote.class);
             JournalWriter w = this.getFactory().writer(Quote.class);
             JournalWriter origin = this.getFactory().writer(Quote.class, "origin");){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, 10000);
            int count = 0;
            for (Quote q : JournalIterators.incrementBufferedIterator((Journal)r)) {
                ++count;
            }
            Assert.assertEquals((long)0L, (long)count);
            w.append(origin.query().all().asResultSet().subset(0, 5000));
            w.commit();
            for (Quote q : JournalIterators.incrementBufferedIterator((Journal)r)) {
                ++count;
            }
            Assert.assertEquals((long)5000L, (long)count);
            w.append(origin.query().all().asResultSet().subset(5000, 10000));
            w.commit();
            count = 0;
            for (Quote q : JournalIterators.incrementBufferedIterator((Journal)r)) {
                ++count;
            }
            Assert.assertEquals((long)5000L, (long)count);
        }
    }

    @Test
    public void testEmptyPartitionFollowedByNonEmpty() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            w.getAppendPartition(DateFormatUtils.parseDateTime((CharSequence)"2012-01-10T10:00:00.000Z"));
            w.append((Object)new Quote().setSym("TST").setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2012-02-10T10:00:00.000Z")));
            Assert.assertTrue((boolean)w.iterator().hasNext());
        }
    }

    @Test
    public void testIncrementIterator() throws Exception {
        this.getFactory().writer(Quote.class).close();
        try (Journal r = this.getFactory().reader(Quote.class);
             JournalWriter w = this.getFactory().writer(Quote.class);
             JournalWriter origin = this.getFactory().writer(Quote.class, "origin");){
            TestUtils.generateQuoteData((JournalWriter<Quote>)origin, 10000);
            int count = 0;
            for (Quote q : JournalIterators.incrementIterator((Journal)r)) {
                ++count;
            }
            Assert.assertEquals((long)0L, (long)count);
            w.append(origin.query().all().asResultSet().subset(0, 5000));
            w.commit();
            for (Quote q : JournalIterators.incrementIterator((Journal)r)) {
                ++count;
            }
            Assert.assertEquals((long)5000L, (long)count);
            w.append(origin.query().all().asResultSet().subset(5000, 10000));
            w.commit();
            count = 0;
            for (Quote q : JournalIterators.incrementIterator((Journal)r)) {
                ++count;
            }
            Assert.assertEquals((long)5000L, (long)count);
        }
    }

    @Test
    public void testJournalIterator() throws JournalException, NumericException {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000);
            try (Journal r = this.getFactory().reader(Quote.class);){
                ArrayList<Quote> posList = new ArrayList<Quote>((int)r.size());
                for (Quote q : r) {
                    posList.add(q);
                }
                int i = 0;
                for (Quote q : JournalIterators.bufferedIterator((Journal)r)) {
                    Assert.assertEquals((Object)q, posList.get(i++));
                }
                i = 0;
                for (Quote q : r.query().all().bufferedIterator()) {
                    Assert.assertEquals((Object)q, posList.get(i++));
                }
                i = 0;
                for (Quote q : r.getPartition(0, true).bufferedIterator()) {
                    Assert.assertEquals((Object)q, posList.get(i++));
                }
            }
        }
    }

    @Test
    public void testJournalParallelIterator() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 100000);
            try (Journal r = this.getFactory().reader(Quote.class);
                 Journal r2 = this.getFactory().reader(Quote.class);
                 JournalConcurrentIterator it = JournalIterators.concurrentIterator((Journal)r);){
                TestUtils.assertEquals(JournalIterators.bufferedIterator((Journal)r2), it);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMerge() throws Exception {
        this.populateQuotes();
        ObjList<Journal<Quote>> journals = new ObjList<Journal<Quote>>(){
            {
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-0"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-1"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-2"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-3"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-4"));
            }
        };
        try {
            ArrayList<JournalPeekingIterator> list = new ArrayList<JournalPeekingIterator>();
            for (int i = 0; i < journals.size(); ++i) {
                list.add(JournalIterators.bufferedIterator((Journal)((Journal)journals.get(i))));
            }
            long ts = 0L;
            for (Quote q : MergingIterator.merge(list, this.comparator)) {
                Assert.assertTrue((ts <= q.getTimestamp() ? 1 : 0) != 0);
                ts = q.getTimestamp();
            }
        }
        finally {
            int n = journals.size();
            for (int i = 0; i < n; ++i) {
                ((Journal)journals.getQuick(i)).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeAppend() throws Exception {
        this.populateQuotes();
        ObjList<Journal<Quote>> journals = new ObjList<Journal<Quote>>(){
            {
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-0"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-1"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-2"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-3"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-4"));
            }
        };
        try (JournalWriter writer = this.getFactory().writer(Quote.class, "quote-merge");){
            writer.mergeAppend((PeekingIterator)JournalIterators.bufferedIterator((Journal)((Journal)journals.get(3))));
            writer.commit();
            ArrayList<JournalPeekingIterator> list = new ArrayList<JournalPeekingIterator>();
            for (int i = 0; i < journals.size(); ++i) {
                list.add(JournalIterators.bufferedIterator((Journal)((Journal)journals.get(i))));
            }
            writer.mergeAppend(MergingPeekingIterator.mergePeek(list, this.comparator));
            writer.commit();
            Assert.assertEquals((long)60000L, (long)writer.size());
            TestUtils.assertOrder(JournalIterators.bufferedIterator((Journal)writer));
        }
        finally {
            int n = journals.size();
            for (int i = 0; i < n; ++i) {
                ((Journal)journals.getQuick(i)).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergePeeking() throws Exception {
        this.populateQuotes();
        ObjList<Journal<Quote>> journals = new ObjList<Journal<Quote>>(){
            {
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-0"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-1"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-2"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-3"));
                this.add(IteratorTest.this.getFactory().reader(Quote.class, "quote-4"));
            }
        };
        try {
            ArrayList<JournalPeekingIterator> list = new ArrayList<JournalPeekingIterator>();
            for (int i = 0; i < journals.size(); ++i) {
                list.add(JournalIterators.bufferedIterator((Journal)((Journal)journals.get(i))));
            }
            long ts = 0L;
            for (Quote q : MergingPeekingIterator.mergePeek(list, this.comparator)) {
                Assert.assertTrue((ts <= q.getTimestamp() ? 1 : 0) != 0);
                ts = q.getTimestamp();
            }
        }
        finally {
            int n = journals.size();
            for (int i = 0; i < n; ++i) {
                ((Journal)journals.getQuick(i)).close();
            }
        }
    }

    @Test
    public void testMergingIterator() {
        ArrayList<Integer> listA = new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(3);
                this.add(4);
                this.add(4);
                this.add(5);
                this.add(7);
                this.add(9);
                this.add(11);
                this.add(13);
                this.add(14);
                this.add(15);
                this.add(17);
            }
        };
        ArrayList<Integer> listB = new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(2);
                this.add(2);
                this.add(4);
                this.add(6);
                this.add(6);
                this.add(8);
                this.add(10);
            }
        };
        MergingIterator iterator = new MergingIterator().$new(listA.iterator(), listB.iterator(), Integer::compareTo);
        int[] expected = new int[]{1, 1, 2, 2, 3, 4, 4, 4, 5, 6, 6, 7, 8, 9, 10, 11, 13, 14, 15, 17};
        int i = 0;
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            int a = (Integer)iterator2.next();
            Assert.assertEquals((long)expected[i++], (long)a);
        }
    }

    @Test
    public void testResultSetParallelIterator() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 100000, new Interval((CharSequence)"2014-01-01T00:00:00.000Z", (CharSequence)"2014-02-10T00:00:00.000Z"));
            try (Journal r1 = this.getFactory().reader(Quote.class);
                 Journal r2 = this.getFactory().reader(Quote.class);
                 JournalConcurrentIterator expected = JournalIterators.concurrentIterator((Journal)r1);
                 ConcurrentIterator actual = r2.query().all().concurrentIterator();){
                TestUtils.assertEquals(expected, actual);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateQuotes() throws InterruptedException {
        int count = 5;
        CyclicBarrier cyclicBarrier = new CyclicBarrier(count);
        CountDownLatch countDownLatch = new CountDownLatch(count);
        ExecutorService service = Executors.newCachedThreadPool();
        try {
            for (int i = 0; i < count; ++i) {
                service.submit(new Generator((WriterFactory)this.getFactory(), cyclicBarrier, i, countDownLatch));
            }
            countDownLatch.await();
        }
        finally {
            service.shutdown();
        }
    }

    private static class Generator
    implements Runnable {
        private final WriterFactory factory;
        private final CyclicBarrier barrier;
        private final CountDownLatch latch;
        private final int index;

        private Generator(WriterFactory factory, CyclicBarrier barrier, int index, CountDownLatch latch) {
            this.factory = factory;
            this.barrier = barrier;
            this.index = index;
            this.latch = latch;
        }

        @Override
        public void run() {
            try (JournalWriter w = this.factory.writer(Quote.class, "quote-" + this.index);){
                this.barrier.await();
                Quote p = new Quote();
                long t = System.currentTimeMillis();
                for (int i = 0; i < 10000; ++i) {
                    p.setTimestamp(t + (long)i);
                    p.setSym(String.valueOf(i % 20));
                    p.setAsk((double)i * 1.04598 + (double)i);
                    w.append((Object)p);
                }
                w.commit();
                this.latch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

