/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.Rnd;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.configuration.JournalConfigurationBuilder;
import com.questdb.test.tools.FactoryContainer;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class HugeTableTest {
    private static final Log LOG = LogFactory.getLog(HugeTableTest.class);
    @ClassRule
    public static FactoryContainer factoryContainer = new FactoryContainer(new JournalConfigurationBuilder(){
        {
            this.$(Name.class).recordCountHint(15000000).txCountHint(1).$sym("name").valueCountHint(15000000).index().noCache();
        }
    });

    @After
    public void tearDown() {
        Assert.assertEquals((long)0L, (long)HugeTableTest.getFactory().getBusyReaderCount());
        Assert.assertEquals((long)0L, (long)HugeTableTest.getFactory().getBusyWriterCount());
    }

    @Test
    public void testLargeSymbolTable() throws Exception {
        try (JournalWriter w = HugeTableTest.getFactory().writer(Name.class, "name");){
            Name name = new Name();
            Rnd rnd = new Rnd();
            long t = 0L;
            for (int i = -500000; i < 2000000; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                name.name = rnd.nextString(10);
                w.append((Object)name);
            }
            w.commit();
            LOG.info().$((CharSequence)"Appended 2M symbols in ").$(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t)).$((CharSequence)"ms").$();
        }
    }

    private static Factory getFactory() {
        return factoryContainer.getFactory();
    }

    public static class Name {
        String name;
    }
}

