/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.ByteBuffers;
import com.questdb.std.Rnd;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Files;
import com.questdb.store.FixedColumn;
import com.questdb.store.MemoryFile;
import com.questdb.store.VariableColumn;
import java.io.File;
import java.nio.ByteBuffer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ColumnTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File dataFile;
    private File indexFile;

    @Before
    public void setUp() {
        this.dataFile = new File(this.temporaryFolder.getRoot(), "col.d");
        this.indexFile = new File(this.temporaryFolder.getRoot(), "col.i");
    }

    @After
    public void tearDown() throws Exception {
        Files.deleteOrException((File)this.dataFile);
        Files.deleteOrException((File)this.indexFile);
    }

    @Test
    public void testFixedWidthColumns() throws JournalException {
        MemoryFile mf = new MemoryFile(this.dataFile, 22, 2, false);
        try (FixedColumn pcc = new FixedColumn(mf, 4);){
            for (int i = 0; i < 10000; ++i) {
                pcc.putInt(i);
                pcc.commit();
            }
        }
        MemoryFile mf2 = new MemoryFile(this.dataFile, 22, 0, false);
        try (FixedColumn pcc2 = new FixedColumn(mf2, 4);){
            Assert.assertEquals((long)66L, (long)pcc2.getInt(66L));
            Assert.assertEquals((long)4597L, (long)pcc2.getInt(4597L));
            Assert.assertEquals((long)120L, (long)pcc2.getInt(120L));
            Assert.assertEquals((long)4599L, (long)pcc2.getInt(4599L));
        }
        MemoryFile mf3 = new MemoryFile(this.dataFile, 22, 0, false);
        try (FixedColumn pcc3 = new FixedColumn(mf3, 4);){
            Assert.assertEquals((long)4598L, (long)pcc3.getInt(4598L));
        }
    }

    @Test
    public void testFixedWidthFloat() throws Exception {
        try (FixedColumn col = new FixedColumn(new MemoryFile(this.dataFile, 22, 2, false), 4);){
            int max = 150;
            for (int i = 0; i < max; ++i) {
                col.putFloat((float)(max - i) + 0.33f);
                col.commit();
            }
            for (long l = 0L; l < col.size(); ++l) {
                Assert.assertEquals((float)((float)((long)max - l) + 0.33f), (float)col.getFloat(l), (float)0.0f);
            }
        }
    }

    @Test
    public void testTruncate() throws JournalException {
        MemoryFile df1 = new MemoryFile(this.dataFile, 22, 2, false);
        MemoryFile idxFile1 = new MemoryFile(this.indexFile, 22, 2, false);
        try (VariableColumn varchar1 = new VariableColumn(df1, idxFile1);){
            varchar1.putStr((CharSequence)"string1");
            varchar1.commit();
            varchar1.putStr((CharSequence)"string2");
            varchar1.commit();
            varchar1.putNull();
            varchar1.commit();
            varchar1.putStr((CharSequence)"string3");
            varchar1.commit();
            varchar1.putNull();
            varchar1.commit();
            varchar1.putStr((CharSequence)"string4");
            varchar1.commit();
            Assert.assertEquals((long)6L, (long)varchar1.size());
            varchar1.truncate(4L);
            varchar1.commit();
            Assert.assertEquals((long)4L, (long)varchar1.size());
            Assert.assertEquals((Object)"string1", (Object)varchar1.getStr(0L));
            Assert.assertEquals((Object)"string2", (Object)varchar1.getStr(1L));
            Assert.assertEquals((Object)"string3", (Object)varchar1.getStr(3L));
        }
        MemoryFile df2 = new MemoryFile(this.dataFile, 22, 0, false);
        MemoryFile idxFile12 = new MemoryFile(this.indexFile, 22, 0, false);
        try (VariableColumn varchar2 = new VariableColumn(df2, idxFile12);){
            Assert.assertEquals((Object)"string1", (Object)varchar2.getStr(0L));
            Assert.assertEquals((Object)"string2", (Object)varchar2.getStr(1L));
            Assert.assertEquals((Object)"string3", (Object)varchar2.getStr(3L));
        }
    }

    @Test
    public void testTwoByteEdges() throws JournalException {
        Rnd r = new Rnd();
        String s1 = r.nextString(65000);
        String s2 = r.nextString(65000);
        MemoryFile df1 = new MemoryFile(this.dataFile, 22, 2, false);
        MemoryFile idxFile1 = new MemoryFile(this.indexFile, 22, 2, false);
        try (VariableColumn varchar1 = new VariableColumn(df1, idxFile1);){
            varchar1.putStr((CharSequence)s1);
            varchar1.commit();
            varchar1.putStr((CharSequence)s2);
            varchar1.commit();
        }
        MemoryFile df2 = new MemoryFile(this.dataFile, 22, 0, false);
        MemoryFile idxFile2 = new MemoryFile(this.indexFile, 22, 0, false);
        try (VariableColumn varchar2 = new VariableColumn(df2, idxFile2);){
            Assert.assertEquals((Object)s1, (Object)varchar2.getStr(0L));
            Assert.assertEquals((Object)s2, (Object)varchar2.getStr(1L));
        }
    }

    @Test
    public void testVarByteBuffer() throws Exception {
        MemoryFile df1 = new MemoryFile(this.dataFile, 12, 2, false);
        MemoryFile idxFile1 = new MemoryFile(this.indexFile, 12, 2, false);
        Rnd random = new Rnd(System.currentTimeMillis(), System.currentTimeMillis());
        int len = 5024;
        try (VariableColumn col = new VariableColumn(df1, idxFile1);){
            ByteBuffer buf = ByteBuffer.allocate(5024);
            String s = random.nextString(buf.remaining() / 2);
            ByteBuffers.putStr((ByteBuffer)buf, (CharSequence)s);
            buf.flip();
            col.putBin(buf);
            col.commit();
            ByteBuffer bb = ByteBuffer.allocate(col.getBinLen(0L));
            col.getBin(0L, bb);
            bb.flip();
            char[] chars = new char[bb.remaining() / 2];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = bb.getChar();
            }
            String actual = new String(chars);
            Assert.assertEquals((Object)s, (Object)actual);
        }
    }

    @Test
    public void testVarcharColumn() throws JournalException {
        int recordCount = 10000;
        MemoryFile df1 = new MemoryFile(this.dataFile, 22, 2, false);
        MemoryFile idxFile1 = new MemoryFile(this.indexFile, 22, 2, false);
        try (VariableColumn varchar1 = new VariableColumn(df1, idxFile1);){
            for (int i = 0; i < 10000; ++i) {
                varchar1.putStr((CharSequence)("s" + i));
                varchar1.commit();
            }
        }
        MemoryFile df2 = new MemoryFile(this.dataFile, 22, 2, false);
        MemoryFile idxFile2 = new MemoryFile(this.indexFile, 22, 2, false);
        try (VariableColumn varchar2 = new VariableColumn(df2, idxFile2);){
            Assert.assertEquals((long)10000L, (long)varchar2.size());
            int i = 0;
            while ((long)i < varchar2.size()) {
                String s = varchar2.getStr((long)i);
                Assert.assertEquals((Object)("s" + i), (Object)s);
                ++i;
            }
        }
    }

    @Test
    public void testVarcharNulls() throws JournalException {
        MemoryFile df1 = new MemoryFile(this.dataFile, 22, 2, false);
        MemoryFile idxFile1 = new MemoryFile(this.indexFile, 22, 2, false);
        try (VariableColumn varchar1 = new VariableColumn(df1, idxFile1);){
            varchar1.putStr((CharSequence)"string1");
            varchar1.commit();
            varchar1.putStr((CharSequence)"string2");
            varchar1.commit();
            varchar1.putNull();
            varchar1.commit();
            varchar1.putStr((CharSequence)"string3");
            varchar1.commit();
            varchar1.putNull();
            varchar1.commit();
            varchar1.putStr((CharSequence)"string4");
            varchar1.commit();
        }
        MemoryFile df2 = new MemoryFile(this.dataFile, 22, 0, false);
        MemoryFile idxFile2 = new MemoryFile(this.indexFile, 22, 0, false);
        try (VariableColumn varchar2 = new VariableColumn(df2, idxFile2);){
            Assert.assertEquals((Object)"string1", (Object)varchar2.getStr(0L));
            Assert.assertEquals((Object)"string2", (Object)varchar2.getStr(1L));
            Assert.assertEquals((Object)"string3", (Object)varchar2.getStr(3L));
            Assert.assertEquals((Object)"string4", (Object)varchar2.getStr(5L));
        }
    }
}

