/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.model.Quote;
import com.questdb.store.Journal;
import com.questdb.store.JournalIterators;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class BulkTest
extends AbstractTest {
    @Test
    public void testBulkWrite() throws Exception {
        int batchSize = 1000000;
        try (JournalWriter writer = this.getFactory().writer(Quote.class);
             Journal reader = this.getFactory().reader(Quote.class);){
            reader.setSequentialAccess(true);
            TestUtils.generateQuoteData((JournalWriter<Quote>)writer, 1000000, System.currentTimeMillis(), 31104L);
            writer.commit();
            Assert.assertTrue((boolean)reader.refresh());
            long count = 0L;
            for (Quote q : JournalIterators.bufferedIterator((Journal)reader)) {
                assert (q != null);
                ++count;
            }
            Assert.assertEquals((long)1000000L, (long)count);
        }
    }

    @Test
    public void testDurable() throws Exception {
        int batchSize = 100000;
        int iterations = 10;
        try (JournalWriter writer = this.getFactory().writer(Quote.class);
             Journal reader = this.getFactory().reader(Quote.class);){
            reader.setSequentialAccess(true);
            long start = System.currentTimeMillis();
            long p = 864000000L;
            for (int i = 0; i < 10; ++i) {
                TestUtils.generateQuoteData((JournalWriter<Quote>)writer, 100000, start, p / 100000L);
                writer.commitDurable();
                start += p;
            }
            Assert.assertTrue((boolean)reader.refresh());
            long count = 0L;
            for (Quote q : JournalIterators.bufferedIterator((Journal)reader)) {
                assert (q != null);
                ++count;
            }
            Assert.assertEquals((long)1000000L, (long)count);
        }
    }
}

