/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.model.Band;
import com.questdb.std.Rnd;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.AbstractTest;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class BinaryTest
extends AbstractTest {
    private static final Log LOGGER = LogFactory.getLog(BinaryTest.class);

    @Test
    public void testBinaryAppend() throws Exception {
        try (JournalWriter writer = this.getFactory().writer(Band.class);){
            Rnd r = new Rnd(System.currentTimeMillis(), System.currentTimeMillis());
            ArrayList<byte[]> bytes = new ArrayList<byte[]>();
            for (int i = 0; i < 3; ++i) {
                bytes.add(r.nextBytes((3 - i) * 1024));
            }
            writer.append((Object)new Band().setName("Supertramp").setType("jazz").setImage((byte[])bytes.get(0)));
            writer.append((Object)new Band().setName("TinieTempah").setType("rap").setImage((byte[])bytes.get(1)));
            writer.append((Object)new Band().setName("Rihanna").setType("pop").setImage((byte[])bytes.get(2)));
            writer.commit();
            int count = 0;
            for (Band b : writer) {
                Assert.assertArrayEquals((byte[])((byte[])bytes.get(count)), (byte[])b.getImage().array());
                ++count;
            }
        }
    }

    @Test
    public void testBinaryPerformance() throws Exception {
        try (JournalWriter writer = this.getFactory().writer(Band.class);){
            int count = 20000;
            Rnd r = new Rnd(System.currentTimeMillis(), System.currentTimeMillis());
            byte[] bytes = r.nextBytes(10240);
            String[] types = new String[]{"jazz", "rap", "pop", "rock", "soul"};
            String[] bands = new String[1200];
            for (int i = 0; i < bands.length; ++i) {
                bands[i] = r.nextString(10);
            }
            long t = System.nanoTime();
            Band band = new Band();
            for (int i = 0; i < 20000; ++i) {
                band.setName(bands[Math.abs(r.nextInt() % bands.length)]);
                band.setType(types[Math.abs(r.nextInt() % types.length)]);
                band.setImage(bytes);
                writer.append((Object)band);
            }
            writer.commit();
            LOGGER.info().$((CharSequence)"Appended ").$(20000).$((CharSequence)" 10k blobs in ").$(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t)).$((CharSequence)"ms.").$();
        }
    }
}

