/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.store.BSearchType;
import com.questdb.store.FixedColumn;
import com.questdb.store.MemoryFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BinarySearchTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    private FixedColumn column;

    @Before
    public void setUp() throws Exception {
        this.column = new FixedColumn(new MemoryFile(this.temp.newFile(), 16, 2, false), 8);
    }

    @After
    public void tearDown() {
        this.column.close();
    }

    @Test
    public void testSearchGreaterOrEquals() {
        this.assertEquals(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 9L, 12L, 17L, 23L}, BSearchType.NEWER_OR_SAME, 7L, 6L);
        this.assertEquals(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 6L, 6L, 7L, 12L, 17L, 23L}, BSearchType.NEWER_OR_SAME, 6L, 5L);
        this.assertEquals(new long[]{2L, 2L, 3L, 4L, 5L, 6L, 6L, 6L, 7L, 12L, 17L, 23L}, BSearchType.NEWER_OR_SAME, 1L, 0L);
        this.assertEquals(new long[]{2L, 2L, 3L, 4L, 5L, 6L, 6L, 6L, 7L, 12L, 17L, 23L}, BSearchType.NEWER_OR_SAME, 2L, 0L);
        this.assertEquals(new long[]{2L, 2L, 3L, 4L, 5L, 6L, 6L, 6L, 7L, 12L, 17L, 23L}, BSearchType.NEWER_OR_SAME, 25L, -2L);
        this.assertEquals(new long[]{2L, 2L}, BSearchType.NEWER_OR_SAME, 25L, -2L);
    }

    @Test
    public void testSearchLessOrEquals() {
        this.assertEquals(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 9L, 12L, 17L, 23L}, BSearchType.OLDER_OR_SAME, 11L, 6L);
        this.assertEquals(new long[]{1L, 2L, 3L, 4L, 9L, 9L, 9L, 12L, 17L, 23L}, BSearchType.OLDER_OR_SAME, 9L, 6L);
        this.assertEquals(new long[]{1L, 2L, 3L, 4L, 9L, 9L, 9L, 12L, 17L, 23L}, BSearchType.OLDER_OR_SAME, 25L, 9L);
        this.assertEquals(new long[]{3L, 3L, 3L, 4L, 9L, 9L, 9L, 12L, 17L, 23L}, BSearchType.OLDER_OR_SAME, 1L, -1L);
        this.assertEquals(new long[]{3L, 3L}, BSearchType.OLDER_OR_SAME, 1L, -1L);
    }

    private void assertEquals(long[] src, BSearchType type, long val, long expected) {
        this.column.truncate(0L);
        this.column.commit();
        for (long l : src) {
            this.column.putLong(l);
            this.column.commit();
        }
        Assert.assertEquals((long)expected, (long)this.column.bsearchEdge(val, type));
    }
}

