/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.time;

import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.IntHashSet;
import com.questdb.std.NumericException;
import com.questdb.std.ex.BytecodeException;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormat;
import com.questdb.std.time.DateFormatCompiler;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.DateLocale;
import com.questdb.std.time.DateLocaleFactory;
import com.questdb.std.time.Dates;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DateFormatCompilerTest {
    private static final DateFormatCompiler compiler = new DateFormatCompiler();
    private static final DateLocale defaultLocale = DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"en-GB");
    private static final StringSink sink = new StringSink();

    @BeforeClass
    public static void setUp() {
        DateFormatUtils.updateReferenceYear((long)Dates.toMillis((int)1997, (int)1, (int)1, (int)0, (int)0));
    }

    @Test(expected=NumericException.class)
    public void testBadAmPm() throws Exception {
        this.assertThat("KaMMy", "", "11 0910 am");
    }

    @Test(expected=NumericException.class)
    public void testBadAmPm2() throws Exception {
        this.assertThat("KaMMy", "", "11az0910");
    }

    @Test(expected=NumericException.class)
    public void testBadDelimiter() throws Exception {
        this.assertThat("y.MM", "0001-03-01T00:00:00.000Z", "1-03");
    }

    @Test(expected=NumericException.class)
    public void testBadMonth() throws Exception {
        this.assertThat("yMM", "0001-03-01T00:00:00.000Z", "133");
    }

    @Test
    public void testBasicParserCompiler() throws Exception {
        DateFormat fmt = compiler.compile((CharSequence)"E, dd MMM yyyy a KK:m:s.S Z");
        String utcPattern = "yyyy-MM-ddTHH:mm:ss.SSSz";
        DateFormat utc = compiler.compile((CharSequence)utcPattern);
        long millis = fmt.parse((CharSequence)"Mon, 08 Apr 2017 PM 11:11:10.123 UTC", defaultLocale);
        sink.clear();
        utc.format(millis, defaultLocale, (CharSequence)"Z", (CharSink)sink);
        TestUtils.assertEquals((CharSequence)"2017-04-08T23:11:10.123Z", (CharSequence)sink);
    }

    @Test
    public void testDayGreedy() throws Exception {
        this.assertThat("d, MM-yy", "2011-10-03T00:00:00.000Z", "3, 10-11");
        this.assertThat("d, MM-yy", "2011-10-03T00:00:00.000Z", "03, 10-11");
        this.assertThat("d, MM-yy", "2011-10-25T00:00:00.000Z", "25, 10-11");
    }

    @Test
    public void testDayMonthYear() throws Exception {
        this.assertThat("dd-MM-yyyy", "2010-03-10T00:00:00.000Z", "10-03-2010");
    }

    @Test
    public void testDayMonthYearNoDelim() throws Exception {
        this.assertThat("yyyyddMM", "2010-03-10T00:00:00.000Z", "20101003");
    }

    @Test
    public void testDayOneDigit() throws Exception {
        this.assertThat("dyyyy", "2014-01-03T00:00:00.000Z", "32014");
    }

    @Test
    public void testEra() throws Exception {
        this.assertThat("E, dd-MM-yyyy G", "2014-04-03T00:00:00.000Z", "Tuesday, 03-04-2014 AD");
        this.assertThat("E, dd-MM-yyyy G", "-2013-04-03T00:00:00.000Z", "Tuesday, 03-04-2014 BC");
    }

    @Test
    public void testFormatAMPM() throws Exception {
        this.assertFormat("PM, 31", "a, dd", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 31", "a, dd", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 31", "a, dd", "2017-03-31T00:00:00.000Z");
        this.assertFormat("AM, 31", "a, dd", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatBSTtoMSK() throws Exception {
        DateFormat fmt = DateFormatCompilerTest.get("dd-MM-yyyy HH:mm:ss Z");
        String targetTimezoneName = "MSK";
        long millis = fmt.parse((CharSequence)"06-04-2017 01:09:30 BST", defaultLocale);
        millis += defaultLocale.getRules((CharSequence)targetTimezoneName).getOffset(millis);
        sink.clear();
        fmt.format(millis, defaultLocale, (CharSequence)targetTimezoneName, (CharSink)sink);
        TestUtils.assertEquals((CharSequence)"06-04-2017 03:09:30 MSK", (CharSequence)sink);
    }

    @Test
    public void testFormatDay() throws Exception {
        this.assertFormat("03", "dd", "2014-04-03T00:00:00.000Z");
    }

    @Test
    public void testFormatEra() throws Exception {
        this.assertFormat("AD", "G", "2017-04-09T00:00:00.000Z");
        this.assertFormat("BC", "G", "-1024-04-09T00:00:00.000Z");
    }

    @Test
    public void testFormatHour23() throws Exception {
        this.assertFormat("PM, 14", "a, HH", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 12", "a, HH", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 03", "a, HH", "2017-03-31T03:00:00.000Z");
        this.assertFormat("AM, 11", "a, HH", "2017-03-31T11:59:59.999Z");
        this.assertFormat("14", "HH", "2017-03-31T14:00:00.000Z");
        this.assertFormat("12", "HH", "2017-03-31T12:00:00.000Z");
        this.assertFormat("03", "HH", "2017-03-31T03:00:00.000Z");
        this.assertFormat("11", "HH", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatHour23OneDigit() throws Exception {
        this.assertFormat("PM, 14", "a, H", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 12", "a, H", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 3", "a, H", "2017-03-31T03:00:00.000Z");
        this.assertFormat("AM, 11", "a, H", "2017-03-31T11:59:59.999Z");
        this.assertFormat("14", "H", "2017-03-31T14:00:00.000Z");
        this.assertFormat("12", "H", "2017-03-31T12:00:00.000Z");
        this.assertFormat("3", "H", "2017-03-31T03:00:00.000Z");
        this.assertFormat("11", "H", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatHour24() throws Exception {
        this.assertFormat("PM, 15", "a, kk", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 13", "a, kk", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 04", "a, kk", "2017-03-31T03:00:00.000Z");
        this.assertFormat("AM, 12", "a, kk", "2017-03-31T11:59:59.999Z");
        this.assertFormat("15", "kk", "2017-03-31T14:00:00.000Z");
        this.assertFormat("13", "kk", "2017-03-31T12:00:00.000Z");
        this.assertFormat("04", "kk", "2017-03-31T03:00:00.000Z");
        this.assertFormat("12", "kk", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatHour24OneDigit() throws Exception {
        this.assertFormat("PM, 15", "a, k", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 13", "a, k", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 4", "a, k", "2017-03-31T03:00:00.000Z");
        this.assertFormat("AM, 12", "a, k", "2017-03-31T11:59:59.999Z");
        this.assertFormat("15", "k", "2017-03-31T14:00:00.000Z");
        this.assertFormat("13", "k", "2017-03-31T12:00:00.000Z");
        this.assertFormat("4", "k", "2017-03-31T03:00:00.000Z");
        this.assertFormat("12", "k", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatHourTwelve() throws Exception {
        this.assertFormat("PM, 03", "a, hh", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 01", "a, hh", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 04", "a, hh", "2017-03-31T03:00:00.000Z");
        this.assertFormat("AM, 12", "a, hh", "2017-03-31T11:59:59.999Z");
        this.assertFormat("03", "hh", "2017-03-31T14:00:00.000Z");
        this.assertFormat("01", "hh", "2017-03-31T12:00:00.000Z");
        this.assertFormat("04", "hh", "2017-03-31T03:00:00.000Z");
        this.assertFormat("12", "hh", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatHourTwelveOneDigit() throws Exception {
        this.assertFormat("PM, 3", "a, h", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 1", "a, h", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 4", "a, h", "2017-03-31T03:00:00.000Z");
        this.assertFormat("AM, 12", "a, h", "2017-03-31T11:59:59.999Z");
        this.assertFormat("3", "h", "2017-03-31T14:00:00.000Z");
        this.assertFormat("1", "h", "2017-03-31T12:00:00.000Z");
        this.assertFormat("4", "h", "2017-03-31T03:00:00.000Z");
        this.assertFormat("12", "h", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatHourZeroEleven() throws Exception {
        this.assertFormat("PM, 02", "a, KK", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 00", "a, KK", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 03", "a, KK", "2017-03-31T03:00:00.000Z");
        this.assertFormat("AM, 11", "a, KK", "2017-03-31T11:59:59.999Z");
        this.assertFormat("02", "KK", "2017-03-31T14:00:00.000Z");
        this.assertFormat("00", "KK", "2017-03-31T12:00:00.000Z");
        this.assertFormat("03", "KK", "2017-03-31T03:00:00.000Z");
        this.assertFormat("11", "KK", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatHourZeroElevenOneDigit() throws Exception {
        this.assertFormat("PM, 2", "a, K", "2017-03-31T14:00:00.000Z");
        this.assertFormat("PM, 0", "a, K", "2017-03-31T12:00:00.000Z");
        this.assertFormat("AM, 3", "a, K", "2017-03-31T03:00:00.000Z");
        this.assertFormat("AM, 11", "a, K", "2017-03-31T11:59:59.999Z");
        this.assertFormat("2", "K", "2017-03-31T14:00:00.000Z");
        this.assertFormat("0", "K", "2017-03-31T12:00:00.000Z");
        this.assertFormat("3", "K", "2017-03-31T03:00:00.000Z");
        this.assertFormat("11", "K", "2017-03-31T11:59:59.999Z");
    }

    @Test
    public void testFormatMillis() throws Exception {
        this.assertFormat("033", "SSS", "2017-03-31T14:00:05.033Z");
        this.assertFormat("579", "SSS", "2017-03-31T12:00:59.579Z");
    }

    @Test
    public void testFormatMillisOneDigit() throws Exception {
        this.assertFormat("15", "S", "2017-03-31T14:05:03.015Z");
        this.assertFormat("459", "S", "2017-03-31T12:59:45.459Z");
    }

    @Test
    public void testFormatMinute() throws Exception {
        this.assertFormat("05", "mm", "2017-03-31T14:05:00.000Z");
        this.assertFormat("59", "mm", "2017-03-31T12:59:00.000Z");
    }

    @Test
    public void testFormatMinuteOneDigit() throws Exception {
        this.assertFormat("5", "m", "2017-03-31T14:05:00.000Z");
        this.assertFormat("59", "m", "2017-03-31T12:59:00.000Z");
    }

    @Test
    public void testFormatMonthName() throws Exception {
        this.assertFormat("09, April", "dd, MMMM", "2017-04-09T00:00:00.000Z");
        this.assertFormat("09, December", "dd, MMMM", "2017-12-09T00:00:00.000Z");
        this.assertFormat("09, January", "dd, MMMM", "2017-01-09T00:00:00.000Z");
        this.assertFormat("April", "MMMM", "2017-04-09T00:00:00.000Z");
        this.assertFormat("December", "MMMM", "2017-12-09T00:00:00.000Z");
        this.assertFormat("January", "MMMM", "2017-01-09T00:00:00.000Z");
    }

    @Test
    public void testFormatMonthOneDigit() throws Exception {
        this.assertFormat("09, 4", "dd, M", "2017-04-09T00:00:00.000Z");
        this.assertFormat("09, 12", "dd, M", "2017-12-09T00:00:00.000Z");
        this.assertFormat("09, 1", "dd, M", "2017-01-09T00:00:00.000Z");
        this.assertFormat("4", "M", "2017-04-09T00:00:00.000Z");
        this.assertFormat("12", "M", "2017-12-09T00:00:00.000Z");
        this.assertFormat("1", "M", "2017-01-09T00:00:00.000Z");
    }

    @Test
    public void testFormatMonthTwoDigits() throws Exception {
        this.assertFormat("09, 04", "dd, MM", "2017-04-09T00:00:00.000Z");
        this.assertFormat("09, 12", "dd, MM", "2017-12-09T00:00:00.000Z");
        this.assertFormat("09, 01", "dd, MM", "2017-01-09T00:00:00.000Z");
        this.assertFormat("04", "MM", "2017-04-09T00:00:00.000Z");
        this.assertFormat("12", "MM", "2017-12-09T00:00:00.000Z");
        this.assertFormat("01", "MM", "2017-01-09T00:00:00.000Z");
    }

    @Test
    public void testFormatSecond() throws Exception {
        this.assertFormat("05", "ss", "2017-03-31T14:00:05.000Z");
        this.assertFormat("59", "ss", "2017-03-31T12:00:59.000Z");
    }

    @Test
    public void testFormatSecondOneDigit() throws Exception {
        this.assertFormat("3", "s", "2017-03-31T14:05:03.000Z");
        this.assertFormat("45", "s", "2017-03-31T12:59:45.000Z");
    }

    @Test
    public void testFormatShortDay() throws Exception {
        this.assertFormat("3", "d", "2014-04-03T00:00:00.000Z");
    }

    @Test
    public void testFormatShortMonthName() throws Exception {
        this.assertFormat("09, Apr", "dd, MMM", "2017-04-09T00:00:00.000Z");
        this.assertFormat("09, Dec", "dd, MMM", "2017-12-09T00:00:00.000Z");
        this.assertFormat("09, Jan", "dd, MMM", "2017-01-09T00:00:00.000Z");
        this.assertFormat("Apr", "MMM", "2017-04-09T00:00:00.000Z");
        this.assertFormat("Dec", "MMM", "2017-12-09T00:00:00.000Z");
        this.assertFormat("Jan", "MMM", "2017-01-09T00:00:00.000Z");
    }

    @Test
    public void testFormatShortWeekday() throws Exception {
        this.assertFormat("09, Sun", "dd, E", "2017-04-09T00:00:00.000Z");
        this.assertFormat("10, Mon", "dd, E", "2017-04-10T00:00:00.000Z");
        this.assertFormat("11, Tue", "dd, E", "2017-04-11T00:00:00.000Z");
        this.assertFormat("12, Wed", "dd, E", "2017-04-12T00:00:00.000Z");
        this.assertFormat("13, Thu", "dd, E", "2017-04-13T00:00:00.000Z");
        this.assertFormat("14, Fri", "dd, E", "2017-04-14T00:00:00.000Z");
        this.assertFormat("15, Sat", "dd, E", "2017-04-15T00:00:00.000Z");
    }

    @Test
    public void testFormatTimezone() throws Exception {
        this.assertFormat("GMT", "z", "2014-04-03T00:00:00.000Z");
    }

    @Test
    public void testFormatWeekday() throws Exception {
        this.assertFormat("09, Sunday", "dd, EE", "2017-04-09T00:00:00.000Z");
        this.assertFormat("10, Monday", "dd, EE", "2017-04-10T00:00:00.000Z");
        this.assertFormat("11, Tuesday", "dd, EE", "2017-04-11T00:00:00.000Z");
        this.assertFormat("12, Wednesday", "dd, EE", "2017-04-12T00:00:00.000Z");
        this.assertFormat("13, Thursday", "dd, EE", "2017-04-13T00:00:00.000Z");
        this.assertFormat("14, Friday", "dd, EE", "2017-04-14T00:00:00.000Z");
        this.assertFormat("15, Saturday", "dd, EE", "2017-04-15T00:00:00.000Z");
    }

    @Test
    public void testFormatWeekdayDigit() throws Exception {
        this.assertFormat("09, 1", "dd, u", "2017-04-09T00:00:00.000Z");
        this.assertFormat("10, 2", "dd, u", "2017-04-10T00:00:00.000Z");
        this.assertFormat("11, 3", "dd, u", "2017-04-11T00:00:00.000Z");
        this.assertFormat("12, 4", "dd, u", "2017-04-12T00:00:00.000Z");
        this.assertFormat("13, 5", "dd, u", "2017-04-13T00:00:00.000Z");
        this.assertFormat("14, 6", "dd, u", "2017-04-14T00:00:00.000Z");
        this.assertFormat("15, 7", "dd, u", "2017-04-15T00:00:00.000Z");
    }

    @Test
    public void testFormatYearFourDigits() throws Exception {
        this.assertFormat("09, 2017", "dd, yyyy", "2017-04-09T00:00:00.000Z");
        this.assertFormat("2017", "yyyy", "2017-04-09T00:00:00.000Z");
        this.assertFormat("09, 0007", "dd, yyyy", "0007-04-09T00:00:00.000Z");
        this.assertFormat("0007", "yyyy", "0007-04-09T00:00:00.000Z");
    }

    @Test
    public void testFormatYearOneDigit() throws Exception {
        this.assertFormat("09, 2017", "dd, y", "2017-04-09T00:00:00.000Z");
        this.assertFormat("2017", "y", "2017-04-09T00:00:00.000Z");
        this.assertFormat("09, 7", "dd, y", "0007-04-09T00:00:00.000Z");
        this.assertFormat("7", "y", "0007-04-09T00:00:00.000Z");
    }

    @Test
    public void testFormatYearTwoDigits() throws Exception {
        this.assertFormat("09, 17", "dd, yy", "2017-04-09T00:00:00.000Z");
        this.assertFormat("17", "yy", "2017-04-09T00:00:00.000Z");
        this.assertFormat("09, 07", "dd, yy", "0007-04-09T00:00:00.000Z");
        this.assertFormat("07", "yy", "0007-04-09T00:00:00.000Z");
    }

    @Test
    public void testGreedyYear() throws Exception {
        this.assertThat("y-MM", "1564-03-01T00:00:00.000Z", "1564-03");
        this.assertThat("y-MM", "1936-03-01T00:00:00.000Z", "36-03");
        this.assertThat("y-MM", "2015-03-01T00:00:00.000Z", "15-03");
        this.assertThat("y-MM", "0137-03-01T00:00:00.000Z", "137-03");
    }

    @Test
    public void testGreedyYear2() throws Exception {
        long referenceYear = DateFormatUtils.getReferenceYear();
        try {
            DateFormatUtils.updateReferenceYear((long)Dates.toMillis((int)2015, (int)1, (int)20, (int)0, (int)0));
            this.assertThat("y-MM", "1564-03-01T00:00:00.000Z", "1564-03");
            this.assertThat("y-MM", "2006-03-01T00:00:00.000Z", "06-03");
            this.assertThat("y-MM", "1955-03-01T00:00:00.000Z", "55-03");
            this.assertThat("y-MM", "0137-03-01T00:00:00.000Z", "137-03");
        }
        finally {
            DateFormatUtils.updateReferenceYear((long)referenceYear);
        }
    }

    @Test(expected=NumericException.class)
    public void testHour12BadAM() throws Exception {
        this.assertThat("K MMy a", "2010-09-01T04:00:00.000Z", "13 0910 am");
    }

    @Test(expected=NumericException.class)
    public void testHour12BadPM() throws Exception {
        this.assertThat("K MMy a", "2010-09-01T04:00:00.000Z", "13 0910 pm");
    }

    @Test
    public void testHour12Greedy() throws Exception {
        this.assertThat("K MMy a", "2010-09-01T23:00:00.000Z", "11 0910 pm");
        this.assertThat("KaMMy", "2010-09-01T23:00:00.000Z", "11pm0910");
    }

    @Test
    public void testHour12GreedyOneBased() throws Exception {
        this.assertThat("h MMy a", "2010-09-01T22:00:00.000Z", "11 0910 pm");
        this.assertThat("haMMy", "2010-09-01T22:00:00.000Z", "11pm0910");
    }

    @Test
    public void testHour12OneDigit() throws Exception {
        this.assertThat("KMMy a", "2010-09-01T04:00:00.000Z", "40910 am");
        this.assertThat("KMMy a", "2010-09-01T16:00:00.000Z", "40910 pm");
    }

    @Test
    public void testHour12OneDigitDefaultAM() throws Exception {
        this.assertThat("KMMy", "2010-09-01T04:00:00.000Z", "40910");
    }

    @Test
    public void testHour12OneDigitOneBased() throws Exception {
        this.assertThat("hMMy a", "2010-09-01T03:00:00.000Z", "40910 am");
        this.assertThat("hMMy a", "2010-09-01T15:00:00.000Z", "40910 pm");
    }

    @Test
    public void testHour12TwoDigits() throws Exception {
        this.assertThat("KKMMy a", "2010-09-01T04:00:00.000Z", "040910 am");
        this.assertThat("KKMMy a", "2010-09-01T23:00:00.000Z", "110910 pm");
    }

    @Test
    public void testHour12TwoDigitsOneBased() throws Exception {
        this.assertThat("hhMMy a", "2010-09-01T03:00:00.000Z", "040910 am");
        this.assertThat("hhMMy a", "2010-09-01T22:00:00.000Z", "110910 pm");
    }

    @Test
    public void testHour24Greedy() throws Exception {
        this.assertThat("H, dd-MM", "1970-11-04T03:00:00.000Z", "3, 04-11");
        this.assertThat("H, dd-MM", "1970-11-04T19:00:00.000Z", "19, 04-11");
        this.assertThat("k, dd-MM", "1970-11-04T02:00:00.000Z", "3, 04-11");
        this.assertThat("k, dd-MM", "1970-11-04T18:00:00.000Z", "19, 04-11");
    }

    @Test
    public void testHour24OneDigit() throws Exception {
        this.assertThat("HMMy", "2010-09-01T04:00:00.000Z", "40910");
        this.assertThat("kMMy", "2010-09-01T03:00:00.000Z", "40910");
    }

    @Test
    public void testHour24TwoDigits() throws Exception {
        this.assertThat("HHMMy", "2010-09-01T04:00:00.000Z", "040910");
        this.assertThat("HHMMy", "2010-09-01T23:00:00.000Z", "230910");
        this.assertThat("kkMMy", "2010-09-01T03:00:00.000Z", "040910");
        this.assertThat("kkMMy", "2010-09-01T22:00:00.000Z", "230910");
    }

    @Test
    public void testHttpFormat() throws Exception {
        this.assertThat("E, dd MMM yyyy HH:mm:ss", "2017-04-05T14:55:10.000Z", "Mon, 05 Apr 2017 14:55:10");
    }

    @Test
    public void testLeapYear() throws Exception {
        this.assertThat("dd-MM-yyyy", "2016-02-29T00:00:00.000Z", "29-02-2016");
    }

    @Test(expected=NumericException.class)
    public void testLeapYearFailure() throws Exception {
        this.assertThat("dd-MM-yyyy", "", "29-02-2015");
    }

    @Test(expected=BytecodeException.class)
    public void testLongPattern() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            b.append("KK").append(' ').append('Z').append(',');
        }
        compiler.compile((CharSequence)b);
    }

    @Test
    public void testMillisGreedy() throws Exception {
        this.assertThat("ddMMy HH:mm:ss.S", "1978-03-19T21:20:45.678Z", "190378 21:20:45.678");
    }

    @Test(expected=NumericException.class)
    public void testMillisGreedyShort() throws Exception {
        this.assertThat("ddMMy HH:mm:ss.SSS", "1978-03-19T21:20:45.678Z", "190378 21:20:45.");
    }

    @Test
    public void testMillisOneDigit() throws Exception {
        this.assertThat("mmsSHH MMy", "2010-09-01T13:55:03.002Z", "553213 0910");
        this.assertThat("SHH dd-MM-yyyy", "2014-10-03T14:00:00.003Z", "314 03-10-2014");
    }

    @Test
    public void testMillisThreeDigits() throws Exception {
        this.assertThat("ddMMy HH:mm:ss.SSS", "1978-03-19T21:20:45.678Z", "190378 21:20:45.678");
    }

    @Test
    public void testMinuteGreedy() throws Exception {
        this.assertThat("dd-MM-yy HH:m", "2010-09-03T14:54:00.000Z", "03-09-10 14:54");
    }

    @Test
    public void testMinuteOneDigit() throws Exception {
        this.assertThat("mHH MMy", "2010-09-01T13:05:00.000Z", "513 0910");
    }

    @Test
    public void testMinuteTwoDigits() throws Exception {
        this.assertThat("mm:HH MMy", "2010-09-01T13:45:00.000Z", "45:13 0910");
    }

    @Test
    public void testMonthGreedy() throws Exception {
        this.assertThat("M-y", "2012-11-01T00:00:00.000Z", "11-12");
        this.assertThat("M-y", "2012-02-01T00:00:00.000Z", "2-12");
    }

    @Test
    public void testMonthName() throws Exception {
        this.assertThat("dd-MMM-y", "2012-11-15T00:00:00.000Z", "15-NOV-12");
        this.assertThat("dd MMMM yyy", "2013-09-18T00:00:00.000Z", "18 September 2013");
    }

    @Test
    public void testMonthOneDigit() throws Exception {
        this.assertThat("My", "2010-04-01T00:00:00.000Z", "410");
    }

    @Test
    public void testNegativeYear() throws Exception {
        this.assertThat("yyyy MMM dd", "-2010-09-01T00:00:00.000Z", "-2010 Sep 01");
        DateFormat fmt1 = compiler.compile((CharSequence)"G yyyy MMM", true);
        DateFormat fmt2 = compiler.compile((CharSequence)"yyyy MMM dd", true);
        long millis = fmt2.parse((CharSequence)"-2010 Sep 01", defaultLocale);
        sink.clear();
        fmt1.format(millis, defaultLocale, (CharSequence)"Z", (CharSink)sink);
        TestUtils.assertEquals((CharSequence)"BC -2010 Sep", (CharSequence)sink);
    }

    @Test
    public void testOperationUniqueness() {
        Assert.assertTrue((DateFormatCompiler.opList.size() > 0 ? 1 : 0) != 0);
        IntHashSet codeSet = new IntHashSet();
        CharSequenceHashSet nameSet = new CharSequenceHashSet();
        int n = DateFormatCompiler.opList.size();
        for (int i = 0; i < n; ++i) {
            String name = (String)DateFormatCompiler.opList.getQuick(i);
            int code = DateFormatCompiler.opMap.get((CharSequence)name);
            Assert.assertTrue((boolean)codeSet.add(code));
            Assert.assertTrue((boolean)nameSet.add((CharSequence)name));
        }
    }

    @Test
    public void testParseUtc() throws Exception {
        this.assertThat("yyyy-MM-ddTHH:mm:ss.SSSz", "2011-10-03T00:00:00.000Z", "2011-10-03T00:00:00.000Z");
    }

    @Test
    public void testQuote() throws Exception {
        this.assertThat("yyyy'y'ddMM", "2010-03-10T00:00:00.000Z", "2010y1003");
    }

    @Test
    public void testSecondGreedy() throws Exception {
        this.assertThat("ddMMy HH:mm:s", "1978-03-19T21:20:45.000Z", "190378 21:20:45");
    }

    @Test
    public void testSecondOneDigit() throws Exception {
        this.assertThat("mmsHH MMy", "2010-09-01T13:55:03.000Z", "55313 0910");
    }

    @Test
    public void testSecondTwoDigits() throws Exception {
        this.assertThat("ddMMy HH:mm:ss", "1978-03-19T21:20:45.000Z", "190378 21:20:45");
    }

    @Test
    public void testSingleDigitYear() throws Exception {
        this.assertThat("yMM", "0001-03-01T00:00:00.000Z", "103");
    }

    @Test
    public void testTimeZone1() throws Exception {
        this.assertThat("dd-MM-yy HH:m z", "2010-09-03T18:54:00.000Z", "03-09-10 14:54 EST");
    }

    @Test
    public void testTimeZone2() throws Exception {
        this.assertThat("dd-MM-yy HH:m z", "2010-09-03T18:50:00.000Z", "03-09-10 21:50 MSK");
    }

    @Test
    public void testTimeZone3() throws Exception {
        this.assertThat("dd-MM-yy HH:m z", "2010-09-03T20:50:00.000Z", "03-09-10 21:50 BST");
    }

    @Test
    public void testTimeZone4() throws Exception {
        this.assertThat("dd-MM-yy HH:m z", "2010-09-03T21:01:00.000Z", "03-09-10 23:01 Hora de verano de Sud\u00e1frica", "es-PA");
    }

    @Test
    public void testTimeZone5() throws Exception {
        this.assertThat("dd-MM-yy HH:m [z]", "2010-09-03T21:01:00.000Z", "03-09-10 23:01 [Hora de verano de Sud\u00e1frica]", "es-PA");
    }

    @Test
    public void testTimeZone6() throws Exception {
        this.assertThat("dd-MM-yy HH:m z", "2010-09-03T17:35:00.000Z", "03-09-10 21:50 +04:15");
    }

    @Test
    public void testTimeZone7() throws Exception {
        this.assertThat("dd-MM-yy HH:m z", "2010-09-04T05:50:00.000Z", "03-09-10 21:50 UTC-08:00");
    }

    @Test
    public void testTimeZone8() throws Exception {
        this.assertThat("dd-MM-yy HH:m z", "2010-09-04T07:50:00.000Z", "03-09-10 21:50 -10");
    }

    @Test(expected=NumericException.class)
    public void testTooLongInput() throws Exception {
        this.assertThat("E, dd-MM-yyyy G", "2014-04-03T00:00:00.000Z", "Tuesday, 03-04-2014 ADD");
    }

    @Test
    public void testTwoDigitYear() throws Exception {
        this.assertThat("MMyy", "2010-11-01T00:00:00.000Z", "1110");
        this.assertThat("MM, yy", "2010-11-01T00:00:00.000Z", "11, 10");
    }

    @Test
    public void testWeekdayDigit() throws Exception {
        this.assertThat("u, dd-MM-yyyy", "2014-04-03T00:00:00.000Z", "5, 03-04-2014");
    }

    @Test(expected=NumericException.class)
    public void testWeekdayIncomplete() throws Exception {
        this.assertThat("E, dd-MM-yyyy", "2014-04-03T00:00:00.000Z", "Tu, 03-04-2014");
    }

    @Test(expected=NumericException.class)
    public void testWeekdayIncomplete2() throws Exception {
        this.assertThat("dd-MM-yyyy, E", "2014-04-03T00:00:00.000Z", "03-04-2014, Fr");
    }

    @Test
    public void testWeekdayLong() throws Exception {
        this.assertThat("E, dd-MM-yyyy", "2014-04-03T00:00:00.000Z", "Tuesday, 03-04-2014");
        this.assertThat("EE, dd-MM-yyyy", "2014-04-03T00:00:00.000Z", "Tuesday, 03-04-2014");
    }

    @Test
    public void testWeekdayShort() throws Exception {
        this.assertThat("E, dd-MM-yyyy", "2014-04-03T00:00:00.000Z", "Fri, 03-04-2014");
        this.assertThat("EE, dd-MM-yyyy", "2014-04-03T00:00:00.000Z", "Fri, 03-04-2014");
    }

    private static DateFormat get(CharSequence pattern) {
        return compiler.compile(pattern, true);
    }

    private void assertFormat(String expected, String pattern, String date) throws NumericException {
        sink.clear();
        DateFormatCompilerTest.get(pattern).format(DateFormatUtils.parseDateTime((CharSequence)date), defaultLocale, (CharSequence)"GMT", (CharSink)sink);
        TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
        sink.clear();
        compiler.compile((CharSequence)pattern, false).format(DateFormatUtils.parseDateTime((CharSequence)date), defaultLocale, (CharSequence)"GMT", (CharSink)sink);
        TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
    }

    private void assertThat(String pattern, String expected, String input, CharSequence localeId) throws NumericException {
        this.assertThat(pattern, expected, input, DateLocaleFactory.INSTANCE.getDateLocale(localeId));
    }

    private void assertThat(String pattern, String expected, String input) throws NumericException {
        this.assertThat(pattern, expected, input, defaultLocale);
    }

    private void assertThat(String pattern, String expected, String input, DateLocale locale) throws NumericException {
        DateFormat format = DateFormatCompilerTest.get(pattern);
        TestUtils.assertEquals((CharSequence)expected, Dates.toString((long)format.parse((CharSequence)input, locale)));
        DateFormat compiled = compiler.compile((CharSequence)pattern);
        TestUtils.assertEquals((CharSequence)expected, Dates.toString((long)compiled.parse((CharSequence)input, locale)));
    }
}

