/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Os;
import com.questdb.std.str.PrefixedPath;
import org.junit.Assert;
import org.junit.Test;

public class PrefixedPathTest {
    @Test
    public void testBorderlineChild() {
        try (PrefixedPath path = new PrefixedPath((CharSequence)"/home/xterm/public", 12);){
            this.assertThat(path, "/home/xterm/public/xyz/123456789/abcd", "xyz/123456789/abcd");
        }
    }

    @Test
    public void testLargeChild() {
        try (PrefixedPath path = new PrefixedPath((CharSequence)"/home/xterm/public", 24);){
            this.assertThat(path, "/home/xterm/public/xyz/123456789/abcdef", "xyz/123456789/abcdef");
        }
    }

    @Test
    public void testReuse() {
        try (PrefixedPath path = new PrefixedPath((CharSequence)"/home/xterm/public", 12);){
            this.assertThat(path, "/home/xterm/public/xyz", "xyz");
            this.assertThat(path, "/home/xterm/public/xyz", "xyz");
            this.assertThat(path, "/home/xterm/public/xyz", "xyz");
        }
    }

    @Test
    public void testSimpleNoSlash() {
        try (PrefixedPath path = new PrefixedPath((CharSequence)"/home/xterm/public");){
            Assert.assertEquals((Object)PrefixedPathTest.transform("/home/xterm/public/"), (Object)path.$().toString());
        }
    }

    @Test
    public void testSimpleSlash() {
        try (PrefixedPath path = new PrefixedPath((CharSequence)"/home/xterm/public/");){
            Assert.assertEquals((Object)PrefixedPathTest.transform("/home/xterm/public/"), (Object)path.$().toString());
        }
    }

    @Test
    public void testSmallChild() {
        try (PrefixedPath path = new PrefixedPath((CharSequence)"/home/xterm/public");){
            this.assertThat(path, "/home/xterm/public/xyz", "xyz");
        }
    }

    private static String transform(String s) {
        return Os.type == 3 ? s.replaceAll("/", "\\\\") : s;
    }

    private void assertThat(PrefixedPath path, String expected, CharSequence concat) {
        Assert.assertEquals((Object)PrefixedPathTest.transform(expected), (Object)path.rewind().concat(concat).$().toString());
    }
}

