/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Files;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PathTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    private final Path path = new Path();
    private final char separator = System.getProperty("file.separator").charAt(0);

    @Test
    public void testConcatNoSlash() {
        TestUtils.assertEquals((CharSequence)("xyz" + this.separator + "123"), (CharSequence)this.path.of((CharSequence)"xyz").concat((CharSequence)"123").$());
    }

    @Test
    public void testConcatWithSlash() {
        TestUtils.assertEquals((CharSequence)("xyz" + this.separator + "123"), (CharSequence)this.path.of((CharSequence)"xyz/").concat((CharSequence)"123").$());
    }

    @Test
    public void testLpszConcat() {
        try (Path p1 = new Path();){
            p1.of((CharSequence)"abc").concat((CharSequence)"123").$();
            try (Path p = new Path();){
                p.of((CharSequence)"/xyz/").concat(p1.address()).$();
                Assert.assertEquals((Object)(this.separator + "xyz" + this.separator + "abc" + this.separator + "123"), (Object)p.toString());
            }
        }
    }

    @Test
    public void testOverflow() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 256; ++i) {
            b.append('9');
        }
        try (Path p = new Path();){
            TestUtils.assertEquals((CharSequence)("9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999" + System.getProperty("file.separator") + "xyz"), (CharSequence)p.of((CharSequence)b).concat((CharSequence)"xyz").$());
        }
    }

    @Test
    public void testSimple() {
        TestUtils.assertEquals((CharSequence)"xyz", (CharSequence)this.path.of((CharSequence)"xyz").$());
    }

    @Test
    public void testZeroEnd() throws Exception {
        File dir = this.temp.newFolder(new String[]{"a", "b", "c"});
        File f = new File(dir, "f.txt");
        Assert.assertTrue((boolean)f.createNewFile());
        Assert.assertTrue((boolean)Files.exists((LPSZ)this.path.of((CharSequence)this.temp.getRoot().getAbsolutePath()).concat((CharSequence)"a").concat((CharSequence)"b").concat((CharSequence)"c").concat((CharSequence)"f.txt").$()));
    }
}

