/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.microtime;

import com.questdb.std.microtime.Dates;
import com.questdb.std.microtime.TimeZoneRulesImpl;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TimeZoneRulesImplTest {
    @Test
    public void testCompatibility() {
        Set<String> allZones = ZoneId.getAvailableZoneIds();
        ArrayList<String> zoneList = new ArrayList<String>(allZones);
        Collections.sort(zoneList);
        ArrayList<ZoneId> zones = new ArrayList<ZoneId>(zoneList.size());
        ArrayList<TimeZoneRulesImpl> zoneRules = new ArrayList<TimeZoneRulesImpl>(zoneList.size());
        for (String z : zoneList) {
            ZoneId zone = ZoneId.of(z);
            zones.add(zone);
            zoneRules.add(new TimeZoneRulesImpl(z, zone.getRules()));
        }
        long deadline = Dates.toMicros((int)2115, (int)12, (int)31, (int)0, (int)0);
        for (long micros = Dates.toMicros((int)1900, (int)1, (int)1, (int)0, (int)0); micros < deadline; micros += 86400000000L) {
            int y = Dates.getYear((long)micros);
            boolean leap = Dates.isLeapYear((int)y);
            int m = Dates.getMonthOfYear((long)micros, (int)y, (boolean)leap);
            int d = Dates.getDayOfMonth((long)micros, (int)y, (int)m, (boolean)leap);
            LocalDateTime dt = LocalDateTime.of(y, m, d, 0, 0);
            int n = zones.size();
            for (int i = 0; i < n; ++i) {
                ZoneId zone = (ZoneId)zones.get(i);
                TimeZoneRulesImpl rules = (TimeZoneRulesImpl)zoneRules.get(i);
                ZonedDateTime zdt = dt.atZone(zone);
                long expected = zdt.getOffset().getTotalSeconds();
                long changed = Dates.toMicros((int)zdt.getYear(), (int)zdt.getMonthValue(), (int)zdt.getDayOfMonth(), (int)zdt.getHour(), (int)zdt.getMinute()) + (long)zdt.getSecond() * 1000000L;
                expected += (changed - micros) / 1000000L;
                long offset = rules.getOffset(micros, y, leap);
                try {
                    Assert.assertEquals((long)expected, (long)(offset / 1000000L));
                    continue;
                }
                catch (Throwable e) {
                    System.out.println(zone.getId() + "; " + zdt + "; " + Dates.toString((long)(micros + offset)));
                    System.out.println("e: " + expected + "; a: " + offset);
                    System.out.println(dt);
                    System.out.println(Dates.toString((long)micros));
                    throw e;
                }
            }
        }
    }

    @Test
    public void testPerformance() {
        Set<String> allZones = ZoneId.getAvailableZoneIds();
        ArrayList<String> zoneList = new ArrayList<String>(allZones);
        Collections.sort(zoneList);
        ArrayList<ZoneId> zones = new ArrayList<ZoneId>(zoneList.size());
        ArrayList<TimeZoneRulesImpl> zoneRules = new ArrayList<TimeZoneRulesImpl>(zoneList.size());
        for (String z : zoneList) {
            ZoneId zone = ZoneId.of(z);
            zones.add(zone);
            zoneRules.add(new TimeZoneRulesImpl(z, zone.getRules()));
        }
        long deadline = Dates.toMicros((int)2615, (int)12, (int)31, (int)0, (int)0);
        for (long millis = Dates.toMicros((int)1900, (int)1, (int)1, (int)0, (int)0); millis < deadline; millis += 86400000000L) {
            int n = zones.size();
            for (int i = 0; i < n; ++i) {
                ((TimeZoneRulesImpl)zoneRules.get(i)).getOffset(millis);
            }
        }
    }

    @Test
    public void testSingle() {
        ZoneId zone = ZoneId.of("GMT");
        TimeZoneRulesImpl rules = new TimeZoneRulesImpl("GMT", zone.getRules());
        int y = 2017;
        int m = 3;
        int d = 29;
        LocalDateTime dt = LocalDateTime.of(y, m, d, 0, 0);
        long millis = Dates.toMicros((int)y, (int)m, (int)d, (int)0, (int)0);
        ZonedDateTime zdt = dt.atZone(zone);
        long expected = zdt.getOffset().getTotalSeconds();
        long changed = Dates.toMicros((int)zdt.getYear(), (int)zdt.getMonthValue(), (int)zdt.getDayOfMonth(), (int)zdt.getHour(), (int)zdt.getMinute()) + (long)(zdt.getSecond() * 1000);
        expected += (changed - millis) / 1000L;
        long offset = rules.getOffset(millis, y, Dates.isLeapYear((int)y));
        try {
            Assert.assertEquals((long)expected, (long)(offset / 1000L));
        }
        catch (Throwable e) {
            System.out.println(zone.getId() + "; " + zdt + "; " + Dates.toString((long)(millis + offset)));
            throw e;
        }
    }
}

