/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.microtime;

import com.questdb.std.Numbers;
import com.questdb.std.microtime.Dates;
import org.junit.Assert;
import org.junit.Test;

public class OffsetParserTest {
    @Test
    public void testBadDelim() {
        OffsetParserTest.assertError("UTC+01x30");
    }

    @Test
    public void testBadGMT() {
        OffsetParserTest.assertError("GMX+03:30");
    }

    @Test
    public void testBadHour() {
        OffsetParserTest.assertError("UTC+0x:30");
    }

    @Test
    public void testBadMinute() {
        OffsetParserTest.assertError("UTC+01:3x");
    }

    @Test
    public void testBadSign() {
        OffsetParserTest.assertError("GMT*08:00");
    }

    @Test
    public void testBadStart() {
        OffsetParserTest.assertError("*08");
    }

    @Test
    public void testBadUtc() {
        OffsetParserTest.assertError("UTX+09:00");
    }

    @Test
    public void testGMTCamelCasePositive() {
        OffsetParserTest.assertThat(135, "gMt+02:15");
    }

    @Test
    public void testGMTNegative() {
        OffsetParserTest.assertThat(-135, "gMt-02:15");
    }

    @Test
    public void testGMTPositive() {
        OffsetParserTest.assertThat(210, "GMT+03:30");
    }

    @Test
    public void testHourMinNoDelim() {
        OffsetParserTest.assertThat(495, "0815");
    }

    @Test
    public void testHourMinNoDelimNegative() {
        OffsetParserTest.assertThat(-210, "-0330");
    }

    @Test
    public void testHourMinNoDelimPositive() {
        OffsetParserTest.assertThat(495, "+0815");
    }

    @Test
    public void testHoursOnly() {
        OffsetParserTest.assertThat(480, "08");
    }

    @Test
    public void testLargeHour() {
        OffsetParserTest.assertError("UTC+24:00");
    }

    @Test
    public void testLargeMinute() {
        OffsetParserTest.assertError("UTC+12:60");
    }

    @Test
    public void testMissingHour() {
        OffsetParserTest.assertError("UTC+");
    }

    @Test
    public void testMissingMinute() {
        OffsetParserTest.assertError("UTC+01:");
    }

    @Test
    public void testNegativeHoursOnly() {
        OffsetParserTest.assertThat(-240, "-04");
    }

    @Test
    public void testPositiveHoursOnly() {
        OffsetParserTest.assertThat(480, "+08");
    }

    @Test
    public void testShortHour() {
        OffsetParserTest.assertError("UTC+1");
    }

    @Test
    public void testShortMinute() {
        OffsetParserTest.assertError("UTC+01:3");
    }

    @Test
    public void testUTCCamelCasePositive() {
        OffsetParserTest.assertThat(540, "uTc+09:00");
    }

    @Test
    public void testUTCNegative() {
        OffsetParserTest.assertThat(-255, "UTC-04:15");
    }

    @Test
    public void testUTCPositive() {
        OffsetParserTest.assertThat(540, "UTC+09:00");
    }

    private static void assertError(String offset) {
        Assert.assertEquals((long)Long.MIN_VALUE, (long)Dates.parseOffset((CharSequence)offset, (int)0, (int)offset.length()));
    }

    private static void assertThat(int expected, String offset) {
        long r = Dates.parseOffset((CharSequence)offset, (int)0, (int)offset.length());
        Assert.assertEquals((long)expected, (long)Numbers.decodeLowInt((long)r));
    }
}

