/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.microtime;

import com.questdb.std.NumericException;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.microtime.Dates;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatesTest {
    private final StringSink sink = new StringSink();

    @Before
    public void setUp() {
        this.sink.clear();
    }

    @Test
    public void testAddDaysPrevEpoch() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"1888-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.addDays((long)millis, (int)24));
        TestUtils.assertEquals((CharSequence)"1888-06-05T23:45:51.045Z", (CharSequence)this.sink);
    }

    @Test
    public void testAddMonths() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2008-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.addMonths((long)millis, (int)-10));
        TestUtils.assertEquals((CharSequence)"2007-07-12T23:45:51.045Z", (CharSequence)this.sink);
    }

    @Test
    public void testAddMonthsPrevEpoch() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"1888-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.addMonths((long)millis, (int)-10));
        TestUtils.assertEquals((CharSequence)"1887-07-12T23:45:51.045Z", (CharSequence)this.sink);
    }

    @Test
    public void testAddYears() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"1988-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.addYear((long)millis, (int)10));
        TestUtils.assertEquals((CharSequence)"1998-05-12T23:45:51.045Z", (CharSequence)this.sink);
    }

    @Test
    public void testAddYears3() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2014-01-01T00:00:00.000Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.addYear((long)millis, (int)1));
        TestUtils.assertEquals((CharSequence)"2015-01-01T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testAddYearsNonLeapToLeap() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2015-01-01T00:00:00.000Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.addYear((long)millis, (int)1));
        TestUtils.assertEquals((CharSequence)"2016-01-01T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testAddYearsPrevEpoch() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"1888-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.addYear((long)millis, (int)10));
        TestUtils.assertEquals((CharSequence)"1898-05-12T23:45:51.045Z", (CharSequence)this.sink);
    }

    @Test
    public void testCeilDD() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2008-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.ceilDD((long)millis));
        TestUtils.assertEquals((CharSequence)"2008-05-12T23:59:59.999Z", (CharSequence)this.sink);
    }

    @Test
    public void testCeilDDPrevEpoch() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"1888-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.ceilDD((long)millis));
        TestUtils.assertEquals((CharSequence)"1888-05-12T23:59:59.999Z", (CharSequence)this.sink);
    }

    @Test
    public void testCeilMM() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2008-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.ceilMM((long)millis));
        TestUtils.assertEquals((CharSequence)"2008-05-31T23:59:59.999Z", (CharSequence)this.sink);
    }

    @Test
    public void testCeilYYYY() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2008-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.ceilYYYY((long)millis));
        TestUtils.assertEquals((CharSequence)"2008-12-31T23:59:59.999Z", (CharSequence)this.sink);
    }

    @Test
    public void testDayOfWeek() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"1893-03-19T17:16:30.192Z");
        Assert.assertEquals((long)7L, (long)Dates.getDayOfWeek((long)millis));
        Assert.assertEquals((long)1L, (long)Dates.getDayOfWeekSundayFirst((long)millis));
        millis = DateFormatUtils.parseDateTime((CharSequence)"2017-04-09T17:16:30.192Z");
        Assert.assertEquals((long)7L, (long)Dates.getDayOfWeek((long)millis));
        Assert.assertEquals((long)1L, (long)Dates.getDayOfWeekSundayFirst((long)millis));
    }

    @Test
    public void testDaysBetween() throws Exception {
        Assert.assertEquals((long)41168L, (long)Dates.getDaysBetween((long)DateFormatUtils.parseDateTime((CharSequence)"1904-11-05T23:45:41.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2017-07-24T23:45:31.045Z")));
        Assert.assertEquals((long)41169L, (long)Dates.getDaysBetween((long)DateFormatUtils.parseDateTime((CharSequence)"1904-11-05T23:45:41.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2017-07-24T23:45:51.045Z")));
    }

    @Test
    public void testFloorDD() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2008-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.floorDD((long)millis));
        TestUtils.assertEquals((CharSequence)"2008-05-12T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testFloorHH() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2008-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.floorHH((long)millis));
        TestUtils.assertEquals((CharSequence)"2008-05-12T23:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testFloorMM() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2008-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.floorMM((long)millis));
        TestUtils.assertEquals((CharSequence)"2008-05-01T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testFloorYYYY() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2008-05-12T23:45:51.045Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.floorYYYY((long)millis));
        TestUtils.assertEquals((CharSequence)"2008-01-01T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testFormatCalDate1() throws Exception {
        DateFormatUtils.formatDashYYYYMMDD((CharSink)this.sink, (long)DateFormatUtils.parseDateTime((CharSequence)"2008-05-10T12:31:02.008Z"));
        TestUtils.assertEquals((CharSequence)"2008-05-10", (CharSequence)this.sink);
    }

    @Test
    public void testFormatCalDate2() throws Exception {
        DateFormatUtils.formatYYYYMM((CharSink)this.sink, (long)DateFormatUtils.parseDateTime((CharSequence)"2008-05-10T12:31:02.008Z"));
        TestUtils.assertEquals((CharSequence)"2008-05", (CharSequence)this.sink);
    }

    @Test
    public void testFormatCalDate3() throws Exception {
        DateFormatUtils.formatYYYYMMDD((CharSink)this.sink, (long)DateFormatUtils.parseDateTime((CharSequence)"2008-05-10T12:31:02.008Z"));
        TestUtils.assertEquals((CharSequence)"20080510", (CharSequence)this.sink);
    }

    @Test
    public void testFormatDateTime() throws Exception {
        this.assertTrue("2014-11-30T12:34:55.332Z");
        this.assertTrue("2008-03-15T11:22:30.500Z");
        this.assertTrue("1917-10-01T11:22:30.500Z");
        this.assertTrue("0900-01-01T01:02:00.005Z");
    }

    @Test
    public void testFormatHTTP() throws Exception {
        DateFormatUtils.formatHTTP((CharSink)this.sink, (long)DateFormatUtils.parseDateTime((CharSequence)"2015-12-05T12:34:55.332Z"));
        TestUtils.assertEquals((CharSequence)"Sat, 5 Dec 2015 12:34:55 GMT", (CharSequence)this.sink);
    }

    @Test
    public void testFormatHTTP2() throws Exception {
        DateFormatUtils.formatHTTP((CharSink)this.sink, (long)DateFormatUtils.parseDateTime((CharSequence)"2015-12-05T12:04:55.332Z"));
        TestUtils.assertEquals((CharSequence)"Sat, 5 Dec 2015 12:04:55 GMT", (CharSequence)this.sink);
    }

    @Test
    public void testMonthsBetween() throws Exception {
        Assert.assertEquals((long)2L, (long)Dates.getMonthsBetween((long)DateFormatUtils.parseDateTime((CharSequence)"2014-05-12T23:45:51.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2014-07-15T23:45:51.045Z")));
        Assert.assertEquals((long)2L, (long)Dates.getMonthsBetween((long)DateFormatUtils.parseDateTime((CharSequence)"2014-07-15T23:45:51.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2014-05-12T23:45:51.045Z")));
        Assert.assertEquals((long)26L, (long)Dates.getMonthsBetween((long)DateFormatUtils.parseDateTime((CharSequence)"2014-05-12T23:45:51.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2016-07-15T23:45:51.045Z")));
        Assert.assertEquals((long)1L, (long)Dates.getMonthsBetween((long)DateFormatUtils.parseDateTime((CharSequence)"2014-05-12T23:45:51.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2014-07-03T23:45:51.045Z")));
        Assert.assertEquals((long)1309L, (long)Dates.getMonthsBetween((long)DateFormatUtils.parseDateTime((CharSequence)"1905-05-12T23:45:51.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2014-07-03T23:45:51.045Z")));
    }

    @Test
    public void testNExtOrSameDow3() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2017-04-06T00:00:00.000Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.nextOrSameDayOfWeek((long)millis, (int)4));
        TestUtils.assertEquals((CharSequence)"2017-04-06T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testNextOrSameDow1() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2017-04-06T00:00:00.000Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.nextOrSameDayOfWeek((long)millis, (int)3));
        TestUtils.assertEquals((CharSequence)"2017-04-12T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testNextOrSameDow2() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2017-04-06T00:00:00.000Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.nextOrSameDayOfWeek((long)millis, (int)6));
        TestUtils.assertEquals((CharSequence)"2017-04-08T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testOverflowDate() {
        Assert.assertEquals((Object)"6477-07-27T03:15:50.400Z", (Object)Dates.toString((long)142245170150400000L));
    }

    @Test
    public void testParseBadISODate() {
        this.expectExceptionDateTime("201");
        this.expectExceptionDateTime("2014");
        this.expectExceptionDateTime("2014-");
        this.expectExceptionDateTime("2014-0");
        this.expectExceptionDateTime("2014-03");
        this.expectExceptionDateTime("2014-03-");
        this.expectExceptionDateTime("2014-03-1");
        this.expectExceptionDateTime("2014-03-10");
        this.expectExceptionDateTime("2014-03-10T0");
        this.expectExceptionDateTime("2014-03-10T01");
        this.expectExceptionDateTime("2014-03-10T01-");
        this.expectExceptionDateTime("2014-03-10T01:1");
        this.expectExceptionDateTime("2014-03-10T01:19");
        this.expectExceptionDateTime("2014-03-10T01:19:");
        this.expectExceptionDateTime("2014-03-10T01:19:28.");
        this.expectExceptionDateTime("2014-03-10T01:19:28.2");
        this.expectExceptionDateTime("2014-03-10T01:19:28.255K");
    }

    @Test
    public void testParseDateTime() throws Exception {
        String date = "2008-02-29T10:54:01.010Z";
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)DateFormatUtils.parseDateTime((CharSequence)date));
        TestUtils.assertEquals((CharSequence)date, (CharSequence)this.sink);
    }

    @Test
    public void testParseDateTimePrevEpoch() throws Exception {
        String date = "1812-02-29T10:54:01.010Z";
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)DateFormatUtils.parseDateTime((CharSequence)date));
        TestUtils.assertEquals((CharSequence)date, (CharSequence)this.sink);
    }

    @Test(expected=NumericException.class)
    public void testParseWrongDay() throws Exception {
        DateFormatUtils.parseDateTime((CharSequence)"2013-09-31T00:00:00.000Z");
    }

    @Test(expected=NumericException.class)
    public void testParseWrongHour() throws Exception {
        DateFormatUtils.parseDateTime((CharSequence)"2013-09-30T24:00:00.000Z");
    }

    @Test(expected=NumericException.class)
    public void testParseWrongMillis() throws Exception {
        DateFormatUtils.parseDateTime((CharSequence)"2013-09-30T22:04:34.1024Z");
    }

    @Test(expected=NumericException.class)
    public void testParseWrongMinute() throws Exception {
        DateFormatUtils.parseDateTime((CharSequence)"2013-09-30T22:61:00.000Z");
    }

    @Test(expected=NumericException.class)
    public void testParseWrongMonth() throws Exception {
        DateFormatUtils.parseDateTime((CharSequence)"2013-00-12T00:00:00.000Z");
    }

    @Test(expected=NumericException.class)
    public void testParseWrongSecond() throws Exception {
        DateFormatUtils.parseDateTime((CharSequence)"2013-09-30T22:04:60.000Z");
    }

    @Test
    public void testPreviousOrSameDow1() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2017-04-06T00:00:00.000Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.previousOrSameDayOfWeek((long)millis, (int)3));
        TestUtils.assertEquals((CharSequence)"2017-04-05T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testPreviousOrSameDow2() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2017-04-06T00:00:00.000Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.previousOrSameDayOfWeek((long)millis, (int)6));
        TestUtils.assertEquals((CharSequence)"2017-04-01T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testPreviousOrSameDow3() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2017-04-06T00:00:00.000Z");
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)Dates.previousOrSameDayOfWeek((long)millis, (int)4));
        TestUtils.assertEquals((CharSequence)"2017-04-06T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testYearsBetween() throws Exception {
        Assert.assertEquals((long)112L, (long)Dates.getYearsBetween((long)DateFormatUtils.parseDateTime((CharSequence)"1904-11-05T23:45:41.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2017-07-24T23:45:31.045Z")));
        Assert.assertEquals((long)113L, (long)Dates.getYearsBetween((long)DateFormatUtils.parseDateTime((CharSequence)"1904-11-05T23:45:41.045Z"), (long)DateFormatUtils.parseDateTime((CharSequence)"2017-12-24T23:45:51.045Z")));
    }

    private void assertTrue(String date) throws NumericException {
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)DateFormatUtils.parseDateTime((CharSequence)date));
        TestUtils.assertEquals((CharSequence)date, (CharSequence)this.sink);
        this.sink.clear();
    }

    private void expectExceptionDateTime(String s) {
        try {
            DateFormatUtils.parseDateTime((CharSequence)s);
            Assert.fail((String)"Expected exception");
        }
        catch (NumericException numericException) {
            // empty catch block
        }
    }
}

