/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.microtime;

import com.questdb.std.Numbers;
import com.questdb.std.NumericException;
import com.questdb.std.microtime.DateLocaleFactory;
import org.junit.Assert;
import org.junit.Test;

public class DateLocaleTest {
    @Test(expected=NumericException.class)
    public void testBadMonth() throws Exception {
        String date = "23 Dek 2010";
        DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"en-GB").matchMonth((CharSequence)date, 3, date.length());
    }

    @Test(expected=NumericException.class)
    public void testBadMonth2() throws Exception {
        String date = "23 Zek 2010";
        DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"en-GB").matchMonth((CharSequence)date, 3, date.length());
    }

    @Test
    public void testLongMonth() throws Exception {
        String date = "23 December 2010";
        long result = DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"en-GB").matchMonth((CharSequence)date, 3, date.length());
        Assert.assertEquals((long)8L, (long)Numbers.decodeHighInt((long)result));
        Assert.assertEquals((long)11L, (long)Numbers.decodeLowInt((long)result));
    }

    @Test
    public void testLowCaseLongMonth() throws Exception {
        String date = "23 december 2010";
        long result = DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"en-GB").matchMonth((CharSequence)date, 3, date.length());
        Assert.assertEquals((long)8L, (long)Numbers.decodeHighInt((long)result));
        Assert.assertEquals((long)11L, (long)Numbers.decodeLowInt((long)result));
    }

    @Test
    public void testRTLMonth() throws Exception {
        String s = "23\u0645\u0627\u0631\u0633";
        long result = DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"ar-DZ").matchMonth((CharSequence)s, 2, s.length());
        Assert.assertEquals((long)4L, (long)Numbers.decodeHighInt((long)result));
        Assert.assertEquals((long)2L, (long)Numbers.decodeLowInt((long)result));
    }

    @Test
    public void testShortMonth() throws Exception {
        String date = "23 Sep 2010";
        long result = DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"en-GB").matchMonth((CharSequence)date, 3, date.length());
        Assert.assertEquals((long)3L, (long)Numbers.decodeHighInt((long)result));
        Assert.assertEquals((long)8L, (long)Numbers.decodeLowInt((long)result));
    }

    @Test(expected=NumericException.class)
    public void testWrongLength() throws Exception {
        String date = "23 Zek 2010";
        DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"en-GB").matchMonth((CharSequence)date, 30, date.length());
    }
}

