/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.ObjHashSet;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ObjHashSetTest {
    @Test
    public void testBasicOperations() {
        int i;
        Rnd rnd = new Rnd();
        ObjHashSet set = new ObjHashSet();
        int N = 1000;
        for (i = 0; i < 1000; ++i) {
            set.add((Object)rnd.nextChars(25).toString());
        }
        Assert.assertEquals((long)1000L, (long)set.size());
        rnd.reset();
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((set.keyIndex((Object)rnd.nextChars(25)) < 0 ? 1 : 0) != 0);
        }
        rnd.reset();
        for (i = 0; i < 1000; ++i) {
            TestUtils.assertEquals(rnd.nextChars(25), (CharSequence)set.get(i));
        }
        rnd.reset();
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)set.contains((Object)rnd.nextChars(25)));
        }
    }

    @Test
    public void testNull() {
        ObjHashSet set = new ObjHashSet();
        set.add((Object)"X");
        set.add(null);
        set.add((Object)"Y");
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertEquals((Object)"X", (Object)set.get(0));
        Assert.assertNull((Object)set.get(1));
        Assert.assertEquals((Object)"Y", (Object)set.get(2));
        int n = set.size();
        Assert.assertEquals((long)3L, (long)n);
        int nullCount = 0;
        for (int i = 0; i < n; ++i) {
            if (set.get(i) != null) continue;
            ++nullCount;
        }
        Assert.assertEquals((long)1L, (long)nullCount);
    }

    @Test
    public void testRemove() {
        CharSequence cs;
        int i;
        CharSequence cs2;
        int i2;
        Rnd rnd = new Rnd();
        ObjHashSet set = new ObjHashSet();
        int N = 1000;
        for (i2 = 0; i2 < 1000; ++i2) {
            cs2 = rnd.nextChars(15);
            Assert.assertTrue((boolean)set.add((Object)cs2.toString()));
        }
        Assert.assertEquals((long)1000L, (long)set.size());
        rnd.reset();
        for (i2 = 0; i2 < 1000; ++i2) {
            cs2 = rnd.nextChars(15);
            Assert.assertTrue((boolean)set.contains((Object)cs2.toString()));
        }
        Rnd rnd2 = new Rnd();
        rnd.reset();
        int removed = 0;
        for (i = 0; i < 1000; ++i) {
            cs = rnd.nextChars(15);
            if (rnd2.nextPositiveInt() % 16 != 0) continue;
            Assert.assertTrue((boolean)set.remove((Object)cs.toString()));
            Assert.assertEquals((long)(1000 - ++removed), (long)set.size());
        }
        Assert.assertTrue((removed > 0 ? 1 : 0) != 0);
        rnd2.reset();
        rnd.reset();
        for (i = 0; i < 1000; ++i) {
            cs = rnd.nextChars(15);
            if (rnd2.nextPositiveInt() % 16 == 0) {
                Assert.assertFalse((boolean)set.contains((Object)cs.toString()));
                continue;
            }
            Assert.assertTrue((boolean)set.contains((Object)cs.toString()));
        }
        Assert.assertFalse((boolean)set.add((Object)"ZTXZCXTOLXDJDKV"));
        Assert.assertFalse((boolean)set.remove((Object)"hello"));
    }
}

