/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Net;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class NetTest {
    @Test
    public void testNoLinger() throws InterruptedException {
        this.bindAcceptConnectClose();
        this.bindAcceptConnectClose();
    }

    @Test
    public void testSocketShutdown() throws BrokenBarrierException, InterruptedException {
        CyclicBarrier barrier = new CyclicBarrier(2);
        CountDownLatch haltLatch = new CountDownLatch(1);
        AtomicLong fileDescriptor = new AtomicLong();
        new Thread(() -> {
            long fd = Net.socketTcp((boolean)true);
            try {
                Net.configureNoLinger((long)fd);
                Assert.assertTrue((boolean)Net.bindTcp((long)fd, (int)0, (int)19004));
                Net.listen((long)fd, (int)64);
                barrier.await();
                fileDescriptor.set(fd);
                Net.accept((long)fd);
            }
            catch (InterruptedException | BrokenBarrierException e) {
                e.printStackTrace();
            }
            finally {
                Net.close((long)fd);
                haltLatch.countDown();
            }
        }).start();
        barrier.await();
        Thread.sleep(500L);
        Net.abortAccept((long)fileDescriptor.get());
        Assert.assertTrue((boolean)haltLatch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void testTcpNoDelay() {
        long fd = Net.socketTcp((boolean)true);
        try {
            Assert.assertEquals((long)0L, (long)Net.setTcpNoDelay((long)fd, (boolean)false));
            Assert.assertEquals((long)0L, (long)Net.getTcpNoDelay((long)fd));
            Assert.assertEquals((long)0L, (long)Net.setTcpNoDelay((long)fd, (boolean)true));
            Assert.assertTrue((Net.getTcpNoDelay((long)fd) > 0 ? 1 : 0) != 0);
        }
        finally {
            Net.close((long)fd);
        }
    }

    private void bindAcceptConnectClose() throws InterruptedException {
        int port = 9992;
        long fd = Net.socketTcp((boolean)true);
        Assert.assertTrue((fd > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Net.bindTcp((long)fd, (int)0, (int)port));
        Net.listen((long)fd, (int)1024);
        StringSink sink = new StringSink();
        CountDownLatch haltLatch = new CountDownLatch(1);
        new Thread(() -> {
            long clientfd = Net.accept((long)fd);
            Net.appendIP4((CharSink)sink, (long)Net.getPeerIP((long)clientfd));
            Net.configureNoLinger((long)clientfd);
            Net.close((long)clientfd);
            haltLatch.countDown();
        }).start();
        long clientFd = Net.socketTcp((boolean)true);
        long sockAddr = Net.sockaddr((CharSequence)"127.0.0.1", (int)port);
        Assert.assertEquals((long)0L, (long)Net.connect((long)clientFd, (long)sockAddr));
        haltLatch.await(10L, TimeUnit.SECONDS);
        Net.close((long)clientFd);
        Net.close((long)fd);
        TestUtils.assertEquals((CharSequence)"127.0.0.1", (CharSequence)sink);
    }

    @Test
    @Ignore
    public void testMulticast() {
        long socket = Net.socketUdp();
        System.out.println(socket);
        System.out.println(Net.setMulticastInterface((long)socket, (int)Net.parseIPv4((CharSequence)"192.168.1.156")));
        System.out.println(Net.setMulticastLoop((long)socket, (boolean)true));
    }

    @Test
    @Ignore
    public void testReusePort() {
        this.bindSocket(Net.socketUdp());
        this.bindSocket(Net.socketUdp());
    }

    private void bindSocket(long fd) {
        Assert.assertTrue((fd > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)Net.setReuseAddress((long)fd));
        Assert.assertEquals((long)0L, (long)Net.setReusePort((long)fd));
        Assert.assertTrue((boolean)Net.bindUdp((long)fd, (CharSequence)"0.0.0.0", (int)18215));
        Assert.assertTrue((boolean)Net.join((long)fd, (CharSequence)"0.0.0.0", (CharSequence)"224.0.0.125"));
    }
}

