/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.LongMatrix;
import org.junit.Assert;
import org.junit.Test;

public class LongMatrixTest {
    @Test
    public void testApproxBinarySearch() {
        int k = 0;
        LongMatrix m = new LongMatrix(2);
        for (int i = 0; i < 1000; ++i) {
            int r = m.addRow();
            m.set(r, 0, (long)k);
            m.set(r, 1, (long)k);
            m.set(r, (Object)("s" + k));
            k += 2;
        }
        int r = m.binarySearch(631L);
        Assert.assertTrue((r < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)632L, (long)m.get(-r - 1, 0));
        r = m.binarySearch(2500L);
        Assert.assertEquals((long)1000L, (long)(-r - 1));
    }

    @Test
    public void testBinarySearch() {
        LongMatrix m = new LongMatrix(2);
        for (int i = 0; i < 1000; ++i) {
            int r = m.addRow();
            m.set(r, 0, (long)i);
            m.set(r, 1, (long)i);
            m.set(r, (Object)("s" + i));
        }
        int r = m.binarySearch(631L);
        Assert.assertEquals((long)631L, (long)m.get(r, 0));
    }

    @Test
    public void testDeleteRow() {
        LongMatrix m = new LongMatrix(2);
        for (int i = 0; i < 1000; ++i) {
            int r = m.addRow();
            m.set(r, 0, (long)i);
            m.set(r, 1, (long)i);
            m.set(r, (Object)("s" + i));
        }
        Assert.assertEquals((long)1000L, (long)m.size());
        m.deleteRow(450);
        Assert.assertEquals((long)999L, (long)m.size());
        Assert.assertEquals((long)451L, (long)m.get(450, 0));
        Assert.assertEquals((long)451L, (long)m.get(450, 1));
        Assert.assertEquals((Object)"s451", (Object)m.get(450));
        Assert.assertEquals((long)449L, (long)m.get(449, 0));
        Assert.assertEquals((long)449L, (long)m.get(449, 1));
        Assert.assertEquals((Object)"s449", (Object)m.get(449));
        m.deleteRow(998);
        Assert.assertEquals((long)998L, (long)m.size());
        Assert.assertEquals((long)998L, (long)m.get(997, 0));
        Assert.assertEquals((long)998L, (long)m.get(997, 1));
        Assert.assertEquals((Object)"s998", (Object)m.get(997));
        m.deleteRow(0);
        Assert.assertEquals((long)997L, (long)m.size());
        Assert.assertEquals((long)998L, (long)m.get(996, 0));
        Assert.assertEquals((long)998L, (long)m.get(996, 1));
        Assert.assertEquals((Object)"s998", (Object)m.get(996));
    }

    @Test
    public void testResize() {
        int i;
        LongMatrix m = new LongMatrix(2);
        for (i = 0; i < 1000; ++i) {
            int r = m.addRow();
            m.set(r, 0, (long)i);
            m.set(r, 1, (long)i);
            m.set(r, (Object)("s" + i));
        }
        Assert.assertEquals((long)1000L, (long)m.size());
        int n = m.size();
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((long)i, (long)m.get(i, 0));
            Assert.assertEquals((long)i, (long)m.get(i, 1));
            Assert.assertEquals((Object)("s" + i), (Object)m.get(i));
        }
    }

    @Test
    public void testZapTop() {
        LongMatrix m = new LongMatrix(2);
        for (int i = 0; i < 1000; ++i) {
            int r = m.addRow();
            m.set(r, 0, (long)i);
            m.set(r, 1, (long)i);
            m.set(r, (Object)("s" + i));
        }
        Assert.assertEquals((long)1000L, (long)m.size());
        m.zapTop(35);
        Assert.assertEquals((long)965L, (long)m.size());
        Assert.assertEquals((long)35L, (long)m.get(0, 0));
        Assert.assertEquals((long)35L, (long)m.get(0, 1));
        Assert.assertEquals((Object)"s35", (Object)m.get(0));
        Assert.assertEquals((long)999L, (long)m.get(964, 0));
        Assert.assertEquals((long)999L, (long)m.get(964, 1));
        Assert.assertEquals((Object)"s999", (Object)m.get(964));
        m.zapTop(1000);
        Assert.assertEquals((long)0L, (long)m.size());
    }
}

