/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.LocalValue;
import com.questdb.std.LocalValueMap;
import com.questdb.std.Locality;
import java.io.Closeable;
import org.junit.Assert;
import org.junit.Test;

public class LocalValueTest {
    @Test
    public void testCloseable() {
        int i;
        LocalValue[] values = new LocalValue[1024];
        ClosableImpl[] closeables = new ClosableImpl[values.length];
        LocalityImpl locality = new LocalityImpl();
        for (i = 0; i < values.length; ++i) {
            values[i] = new LocalValue();
            closeables[i] = new ClosableImpl();
            values[i].set((Locality)locality, (Object)closeables[i]);
        }
        locality.clear();
        for (i = 0; i < values.length; ++i) {
            Assert.assertNull((Object)values[i].get((Locality)locality));
            Assert.assertTrue((boolean)closeables[i].closed);
        }
    }

    @Test
    public void testLocalValue() {
        int i;
        LocalValue[] values = new LocalValue[524288];
        LocalityImpl locality1 = new LocalityImpl();
        LocalityImpl locality2 = new LocalityImpl();
        for (i = 0; i < values.length; ++i) {
            values[i] = new LocalValue();
            values[i].set((Locality)locality1, (Object)i);
            values[i].set((Locality)locality2, (Object)(i + 10000000));
        }
        for (i = 0; i < values.length; ++i) {
            Assert.assertEquals((long)((Integer)values[i].get((Locality)locality1)).intValue(), (long)i);
            Assert.assertEquals((long)((Integer)values[i].get((Locality)locality2)).intValue(), (long)(i + 10000000));
        }
    }

    private static class LocalityImpl
    implements Locality {
        private final LocalValueMap map = new LocalValueMap();

        private LocalityImpl() {
        }

        public void clear() {
            this.map.close();
        }

        public LocalValueMap getMap() {
            return this.map;
        }
    }

    private static class ClosableImpl
    implements Closeable {
        private boolean closed = false;

        private ClosableImpl() {
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

