/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Lexer;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class LexerTest {
    @Test
    public void testBlockComments() {
        Lexer lex = new Lexer();
        lex.defineSymbol("+");
        lex.defineSymbol("++");
        lex.defineSymbol("*");
        lex.defineSymbol("/*");
        lex.defineSymbol("*/");
        lex.setContent((CharSequence)"a + /* ok, this /* is a */ comment */ 'b' * abc");
        StringSink sink = new StringSink();
        while (lex.hasNext()) {
            sink.put(lex.optionTok());
        }
        TestUtils.assertEquals((CharSequence)"a+'b'*abc", (CharSequence)sink);
    }

    @Test
    public void testEdgeSymbol() {
        Lexer ts = new Lexer();
        ts.defineSymbol(" ");
        ts.defineSymbol("+");
        ts.defineSymbol("(");
        ts.defineSymbol(")");
        ts.defineSymbol(",");
        String content = "create journal xyz(a int, b int)";
        ts.setContent((CharSequence)"create journal xyz(a int, b int)");
        StringSink sink = new StringSink();
        for (CharSequence cs : ts) {
            sink.put(cs);
        }
        TestUtils.assertEquals((CharSequence)content, (CharSequence)sink);
    }

    @Test
    public void testLineComment() {
        Lexer lex = new Lexer();
        lex.defineSymbol("+");
        lex.defineSymbol("++");
        lex.defineSymbol("*");
        lex.defineSymbol("/*");
        lex.defineSymbol("*/");
        lex.defineSymbol("--");
        lex.setContent((CharSequence)"a + -- ok, this is a comment \n 'b' * abc");
        StringSink sink = new StringSink();
        while (lex.hasNext()) {
            sink.put(lex.optionTok());
        }
        TestUtils.assertEquals((CharSequence)"a+'b'*abc", (CharSequence)sink);
    }

    @Test
    public void testNullContent() {
        Lexer ts = new Lexer();
        ts.defineSymbol(" ");
        ts.setContent(null);
        Assert.assertFalse((boolean)ts.iterator().hasNext());
    }

    @Test
    public void testQuotedToken() {
        Lexer ts = new Lexer();
        ts.defineSymbol("+");
        ts.defineSymbol("++");
        ts.defineSymbol("*");
        ts.setContent((CharSequence)"a+\"b\"*abc");
        StringSink sink = new StringSink();
        for (CharSequence cs : ts) {
            sink.put(cs);
        }
        TestUtils.assertEquals((CharSequence)"a+\"b\"*abc", (CharSequence)sink);
    }

    @Test
    public void testSingleQuotedToken() {
        Lexer ts = new Lexer();
        ts.defineSymbol("+");
        ts.defineSymbol("++");
        ts.defineSymbol("*");
        ts.setContent((CharSequence)"a+'b'*abc");
        StringSink sink = new StringSink();
        for (CharSequence cs : ts) {
            sink.put(cs);
        }
        TestUtils.assertEquals((CharSequence)"a+'b'*abc", (CharSequence)sink);
    }

    @Test
    public void testSymbolLookup() {
        Lexer ts = new Lexer();
        ts.defineSymbol("+");
        ts.defineSymbol("++");
        ts.defineSymbol("*");
        String content = "+*a+b++blah-";
        ts.setContent((CharSequence)"+*a+b++blah-");
        StringSink sink = new StringSink();
        for (CharSequence cs : ts) {
            sink.put(cs);
        }
        TestUtils.assertEquals((CharSequence)content, (CharSequence)sink);
    }

    @Test
    public void testUnparse() {
        Lexer ts = new Lexer();
        ts.defineSymbol("+");
        ts.defineSymbol("++");
        ts.defineSymbol("*");
        ts.setContent((CharSequence)"+*a+b++blah-");
        Iterator it = ts.iterator();
        while (it.hasNext()) {
            CharSequence e = (CharSequence)it.next();
            ts.unparse();
            CharSequence a = (CharSequence)it.next();
            TestUtils.assertEquals(e, a);
        }
    }
}

