/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.griffin.SqlUtil;
import com.questdb.std.GenericLexer;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class GenericLexerTest {
    @Test
    public void testBlockComments() {
        CharSequence token;
        GenericLexer lex = new GenericLexer(64);
        lex.defineSymbol("+");
        lex.defineSymbol("++");
        lex.defineSymbol("*");
        lex.defineSymbol("/*");
        lex.defineSymbol("*/");
        lex.of((CharSequence)"a + /* ok, this /* is a */ comment */ 'b' * abc");
        StringSink sink = new StringSink();
        while ((token = SqlUtil.fetchNext((GenericLexer)lex)) != null) {
            sink.put(token);
        }
        TestUtils.assertEquals((CharSequence)"a+'b'*abc", (CharSequence)sink);
    }

    @Test
    public void testEdgeSymbol() {
        GenericLexer ts = new GenericLexer(64);
        ts.defineSymbol(" ");
        ts.defineSymbol("+");
        ts.defineSymbol("(");
        ts.defineSymbol(")");
        ts.defineSymbol(",");
        String content = "create journal xyz(a int, b int)";
        ts.of((CharSequence)"create journal xyz(a int, b int)");
        StringSink sink = new StringSink();
        for (CharSequence cs : ts) {
            sink.put(cs);
        }
        TestUtils.assertEquals((CharSequence)content, (CharSequence)sink);
    }

    @Test
    public void testLineComment() {
        CharSequence token;
        GenericLexer lex = new GenericLexer(64);
        lex.defineSymbol("+");
        lex.defineSymbol("++");
        lex.defineSymbol("*");
        lex.defineSymbol("/*");
        lex.defineSymbol("*/");
        lex.defineSymbol("--");
        lex.of((CharSequence)"a + -- ok, this is a comment \n 'b' * abc");
        StringSink sink = new StringSink();
        while ((token = SqlUtil.fetchNext((GenericLexer)lex)) != null) {
            sink.put(token);
        }
        TestUtils.assertEquals((CharSequence)"a+'b'*abc", (CharSequence)sink);
    }

    @Test
    public void testNullContent() {
        GenericLexer ts = new GenericLexer(64);
        ts.defineSymbol(" ");
        ts.of(null);
        Assert.assertFalse((boolean)ts.iterator().hasNext());
    }

    @Test
    public void testQuotedToken() {
        GenericLexer ts = new GenericLexer(64);
        ts.defineSymbol("+");
        ts.defineSymbol("++");
        ts.defineSymbol("*");
        ts.of((CharSequence)"a+\"b\"*abc");
        StringSink sink = new StringSink();
        for (CharSequence cs : ts) {
            sink.put(cs);
        }
        TestUtils.assertEquals((CharSequence)"a+\"b\"*abc", (CharSequence)sink);
    }

    @Test
    public void testSingleQuotedToken() {
        GenericLexer ts = new GenericLexer(64);
        ts.defineSymbol("+");
        ts.defineSymbol("++");
        ts.defineSymbol("*");
        ts.of((CharSequence)"a+'b'*abc");
        StringSink sink = new StringSink();
        for (CharSequence cs : ts) {
            sink.put(cs);
        }
        TestUtils.assertEquals((CharSequence)"a+'b'*abc", (CharSequence)sink);
    }

    @Test
    public void testSymbolLookup() {
        GenericLexer ts = new GenericLexer(64);
        ts.defineSymbol("+");
        ts.defineSymbol("++");
        ts.defineSymbol("*");
        String content = "+*a+b++blah-";
        ts.of((CharSequence)"+*a+b++blah-");
        StringSink sink = new StringSink();
        for (CharSequence cs : ts) {
            sink.put(cs);
        }
        TestUtils.assertEquals((CharSequence)content, (CharSequence)sink);
    }

    @Test
    public void testUnparse() {
        GenericLexer ts = new GenericLexer(64);
        ts.defineSymbol("+");
        ts.defineSymbol("++");
        ts.defineSymbol("*");
        ts.of((CharSequence)"+*a+b++blah-");
        Iterator it = ts.iterator();
        while (it.hasNext()) {
            CharSequence e = (CharSequence)it.next();
            ts.unparse();
            CharSequence a = (CharSequence)it.next();
            TestUtils.assertEquals(e, a);
        }
    }
}

