/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Rnd;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class CharSequenceHashSetTest {
    @Test
    public void testNullHandling() {
        Rnd rnd = new Rnd();
        CharSequenceHashSet set = new CharSequenceHashSet();
        int n = 1000;
        for (int i = 0; i < n; ++i) {
            set.add((CharSequence)CharSequenceHashSetTest.next(rnd).toString());
        }
        Assert.assertFalse((boolean)set.contains(null));
        Assert.assertTrue((boolean)set.add(null));
        Assert.assertEquals((long)(n + 1), (long)set.size());
        Assert.assertFalse((boolean)set.add(null));
        Assert.assertEquals((long)(n + 1), (long)set.size());
        Assert.assertTrue((boolean)set.contains(null));
        Assert.assertTrue((set.remove(null) > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)n, (long)set.size());
        Assert.assertEquals((long)set.remove(null), (long)-1L);
        Assert.assertEquals((long)n, (long)set.size());
    }

    @Test
    public void testStress() {
        int i;
        Rnd rnd = new Rnd();
        CharSequenceHashSet set = new CharSequenceHashSet();
        int n = 10000;
        for (int i2 = 0; i2 < n; ++i2) {
            set.add((CharSequence)CharSequenceHashSetTest.next(rnd).toString());
        }
        Assert.assertEquals((long)n, (long)set.size());
        HashSet<String> check = new HashSet<String>();
        int m = set.size();
        for (int i3 = 0; i3 < m; ++i3) {
            check.add(set.get(i3).toString());
        }
        Assert.assertEquals((long)n, (long)check.size());
        Rnd rnd2 = new Rnd();
        for (int i4 = 0; i4 < n; ++i4) {
            Assert.assertTrue((String)("at " + i4), (boolean)set.contains(CharSequenceHashSetTest.next(rnd2)));
        }
        Assert.assertEquals((long)n, (long)set.size());
        Rnd rnd3 = new Rnd();
        for (i = 0; i < n; ++i) {
            Assert.assertFalse((String)("at " + i), (boolean)set.add(CharSequenceHashSetTest.next(rnd3)));
        }
        Assert.assertEquals((long)n, (long)set.size());
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((String)("at " + i), (long)set.remove(CharSequenceHashSetTest.next(rnd)), (long)-1L);
        }
        Rnd rnd4 = new Rnd();
        for (int i5 = 0; i5 < n; ++i5) {
            Assert.assertTrue((String)("at " + i5), (set.remove(CharSequenceHashSetTest.next(rnd4)) > -1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)0L, (long)set.size());
    }

    private static CharSequence next(Rnd rnd) {
        return rnd.nextChars((rnd.nextInt() & 0xF) + 10);
    }
}

