/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.AssociativeCache;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Rnd;
import org.junit.Assert;
import org.junit.Test;

public class AssociativeCacheTest {
    @Test
    public void testBasic() {
        AssociativeCache cache = new AssociativeCache(8, 64);
        cache.put((CharSequence)"X", (Object)"1");
        cache.put((CharSequence)"Y", (Object)"2");
        cache.put((CharSequence)"Z", (Object)"3");
        Assert.assertEquals((Object)"1", (Object)cache.peek((CharSequence)"X"));
        Assert.assertEquals((Object)"2", (Object)cache.peek((CharSequence)"Y"));
        Assert.assertEquals((Object)"3", (Object)cache.peek((CharSequence)"Z"));
    }

    @Test
    public void testFull() {
        CharSequence k;
        int i;
        AssociativeCache cache = new AssociativeCache(8, 64);
        CharSequenceHashSet all = new CharSequenceHashSet();
        CharSequenceHashSet reject = new CharSequenceHashSet();
        Rnd rnd = new Rnd();
        for (i = 0; i < 1024; ++i) {
            k = rnd.nextString(10);
            all.add(k);
            CharSequence o = cache.put(k, (Object)rnd.nextString(10));
            if (o == null) continue;
            reject.add(o);
        }
        for (i = 0; i < all.size(); ++i) {
            k = all.get(i);
            if (cache.peek(k) != null) continue;
            Assert.assertTrue((boolean)reject.contains(k));
        }
        Assert.assertEquals((long)512L, (long)reject.size());
    }
}

