/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.sys;

import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.ql.sys.;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import org.junit.BeforeClass;
import org.junit.Test;

public class $TabsRecordSourceTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUp() throws Exception {
        try (JournalWriter w = compiler.createWriter(FACTORY_CONTAINER.getFactory(), (CharSequence)"create table xyz(x int, y string, timestamp date) timestamp(timestamp) partition by MONTH");){
            JournalEntryWriter ew = w.entryWriter(DateFormatUtils.parseDateTime((CharSequence)"2016-01-02T00:00:00.000Z"));
            ew.putInt(0, 0);
            ew.append();
            ew = w.entryWriter(DateFormatUtils.parseDateTime((CharSequence)"2016-02-02T00:00:00.000Z"));
            ew.putInt(0, 1);
            ew.append();
            w.commit();
        }
        .TabsRecordSource.init();
    }

    @Test
    public void testAsSubQuery() throws Exception {
        this.assertThat("1\n", "select count() from ($tabs order by last_modified desc)");
    }

    @Test
    public void testCompiled() throws Exception {
        this.assertThat("xyz\tMONTH\t2\t3\t9703504\n", "select name, partition_by, partition_count, column_count, size from $tabs");
    }

    @Test
    public void testInJoin() throws Exception {
        this.assertThat("xyz\txyz\n", "select a.name, b.name from $tabs a cross join $tabs b");
    }
}

