/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.sort;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.parser.sql.QueryError;
import com.questdb.std.Rnd;
import com.questdb.std.time.Dates;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RBTreeSortedRecordSourceTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUp() throws Exception {
        try (JournalWriter w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("xyz").$int("i").$str("str").$());){
            int n = 100;
            Rnd rnd = new Rnd();
            for (int i = 0; i < n; ++i) {
                JournalEntryWriter ew = w.entryWriter();
                ew.putInt(0, rnd.nextInt());
                ew.putStr(1, rnd.nextChars(2));
                ew.append();
            }
            w.commit();
        }
        w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("dupes").$int("x").$());
        var1_1 = null;
        try {
            for (int i = 0; i < 10; ++i) {
                JournalEntryWriter ew = w.entryWriter();
                ew.putInt(0, i % 2 == 0 ? 10 : 20);
                ew.append();
            }
            JournalEntryWriter ew = w.entryWriter();
            ew.putInt(0, 30);
            ew.append();
            w.commit();
        }
        catch (Throwable ew) {
            var1_1 = ew;
            throw ew;
        }
        finally {
            if (w != null) {
                if (var1_1 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable ew) {
                        var1_1.addSuppressed(ew);
                    }
                } else {
                    w.close();
                }
            }
        }
        w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("timeseries").$double("d").$ts().$());
        var1_1 = null;
        try {
            Rnd rnd = new Rnd();
            long ts = Dates.toMillis((int)2016, (int)3, (int)12, (int)0, (int)0);
            for (int i = 0; i < 1000; ++i) {
                JournalEntryWriter ew = w.entryWriter();
                ew.putDouble(0, rnd.nextDouble());
                ew.putDate(1, ts + (long)rnd.nextPositiveInt() % 86400000L);
                ew.append();
            }
            w.commit();
        }
        catch (Throwable throwable) {
            var1_1 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var1_1 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var1_1.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
    }

    @Test
    public void testBaseRowIdNestedOrder() throws Exception {
        this.assertThat("-10.000000000000\t34\t2016-03-12T07:40:06.028Z\n-9.000000000000\t18\t2016-03-12T20:30:19.422Z\n-8.000000000000\t11\t2016-03-12T13:03:05.265Z\n-7.000000000000\t13\t2016-03-12T09:45:28.391Z\n-6.000000000000\t27\t2016-03-12T01:09:44.659Z\n-5.000000000000\t23\t2016-03-12T17:40:21.589Z\n-4.000000000000\t14\t2016-03-12T12:19:13.427Z\n-3.000000000000\t20\t2016-03-12T19:26:07.812Z\n-2.000000000000\t10\t2016-03-12T09:23:09.879Z\n-1.000000000000\t14\t2016-03-12T12:25:09.894Z\n0.000000000000\t540\t2016-03-12T14:47:52.891Z\n0.000000000000\t20\t2016-03-12T04:10:20.861Z\n1.000000000000\t47\t2016-03-12T19:13:21.813Z\n2.000000000000\t30\t2016-03-12T15:58:53.134Z\n3.000000000000\t33\t2016-03-12T05:05:26.412Z\n4.000000000000\t26\t2016-03-12T16:52:51.947Z\n5.000000000000\t28\t2016-03-12T13:51:07.787Z\n6.000000000000\t23\t2016-03-12T18:26:11.749Z\n7.000000000000\t15\t2016-03-12T15:04:24.613Z\n8.000000000000\t28\t2016-03-12T06:12:55.118Z\n9.000000000000\t16\t2016-03-12T22:14:00.570Z\n10.000000000000\t10\t2016-03-12T06:04:33.309Z\n", "(select roundHalfUp(d/100,0) r, count() count, last(timestamp) ts from timeseries order by ts) order by r");
    }

    @Test
    public void testEqualRows() throws Exception {
        this.assertThat("10\n10\n10\n10\n10\n20\n20\n20\n20\n20\n30\n", "dupes order by x");
    }

    @Test
    public void testFirstColumnOrderDescending() throws Exception {
        this.assertThat("-10505757\tCC\n-27395319\tOJ\n-120660220\tQE\n-147343840\tLD\n-230430837\tZZ\n-235358133\tMY\n-246923735\tGL\n-283321892\tJO\n-292438036\tPG\n-370796356\tNZ\n-409854405\tZS\n-422941535\tPD\n-483853667\tHR\n-530317703\tTJ\n-623471113\tQM\n-636975106\tZE\n-661194722\tZO\n-720881601\tQC\n-727724771\tCP\n-731466113\tLY\n-847531048\tRX\n-876466531\tOL\n-907794648\tSS\n-916132123\tYC\n-942999384\tVV\n-1121895896\tVD\n-1125169127\tEY\n-1148479920\tTJ\n-1153445279\tYU\n-1165635863\tMV\n-1172180184\tYL\n-1204245663\tPJ\n-1234141625\tND\n-1252906348\tQE\n-1269042121\tEK\n-1270731285\tEO\n-1271909747\tYS\n-1272693194\tED\n-1311366306\tML\n-1418341054\tJG\n-1424048819\tVS\n-1436881714\tEH\n-1465751763\tUS\n-1515787781\tGO\n-1533414895\tTM\n-1538602195\tDZ\n-1613687261\tBE\n-1768335227\tSW\n-1810676855\tLO\n-1844391305\tWF\n-1870444467\tRY\n-1871994006\tZS\n-1960168360\tUO\n-2002373666\tQQ\n-2043803188\tVI\n-2088317486\tSS\n-2108151088\tXP\n-2119387831\tBH\n-2132716300\tEO\n", "xyz where i < 100 order by i desc");
    }

    @Test
    public void testNestedOrderBy() throws Exception {
        String expected = "-1613687261\tBE\n-2119387831\tBH\n-10505757\tCC\n-727724771\tCP\n-1538602195\tDZ\n-1272693194\tED\n-1436881714\tEH\n-1269042121\tEK\n-2132716300\tEO\n-1270731285\tEO\n-1125169127\tEY\n-246923735\tGL\n-1515787781\tGO\n-483853667\tHR\n-1418341054\tJG\n-283321892\tJO\n-147343840\tLD\n-1810676855\tLO\n-731466113\tLY\n-1311366306\tML\n-1165635863\tMV\n-235358133\tMY\n-1234141625\tND\n-370796356\tNZ\n-27395319\tOJ\n-876466531\tOL\n-422941535\tPD\n-292438036\tPG\n-1204245663\tPJ\n-720881601\tQC\n-1252906348\tQE\n-120660220\tQE\n-623471113\tQM\n-2002373666\tQQ\n-847531048\tRX\n-1870444467\tRY\n-2088317486\tSS\n-907794648\tSS\n-1768335227\tSW\n-1148479920\tTJ\n-530317703\tTJ\n-1533414895\tTM\n-1960168360\tUO\n-1465751763\tUS\n-1121895896\tVD\n-2043803188\tVI\n-1424048819\tVS\n-942999384\tVV\n-1844391305\tWF\n-2108151088\tXP\n-916132123\tYC\n-1172180184\tYL\n-1271909747\tYS\n-1153445279\tYU\n-636975106\tZE\n-661194722\tZO\n-1871994006\tZS\n-409854405\tZS\n-230430837\tZZ\n";
        this.assertThat("-1613687261\tBE\n-2119387831\tBH\n-10505757\tCC\n-727724771\tCP\n-1538602195\tDZ\n-1272693194\tED\n-1436881714\tEH\n-1269042121\tEK\n-2132716300\tEO\n-1270731285\tEO\n-1125169127\tEY\n-246923735\tGL\n-1515787781\tGO\n-483853667\tHR\n-1418341054\tJG\n-283321892\tJO\n-147343840\tLD\n-1810676855\tLO\n-731466113\tLY\n-1311366306\tML\n-1165635863\tMV\n-235358133\tMY\n-1234141625\tND\n-370796356\tNZ\n-27395319\tOJ\n-876466531\tOL\n-422941535\tPD\n-292438036\tPG\n-1204245663\tPJ\n-720881601\tQC\n-1252906348\tQE\n-120660220\tQE\n-623471113\tQM\n-2002373666\tQQ\n-847531048\tRX\n-1870444467\tRY\n-2088317486\tSS\n-907794648\tSS\n-1768335227\tSW\n-1148479920\tTJ\n-530317703\tTJ\n-1533414895\tTM\n-1960168360\tUO\n-1465751763\tUS\n-1121895896\tVD\n-2043803188\tVI\n-1424048819\tVS\n-942999384\tVV\n-1844391305\tWF\n-2108151088\tXP\n-916132123\tYC\n-1172180184\tYL\n-1271909747\tYS\n-1153445279\tYU\n-636975106\tZE\n-661194722\tZO\n-1871994006\tZS\n-409854405\tZS\n-230430837\tZZ\n", "(xyz where i < 100 order by i) order by str, i");
    }

    @Test
    public void testNestedOrderByDescending() throws Exception {
        String expected = "-1613687261\tBE\n-2119387831\tBH\n-10505757\tCC\n-727724771\tCP\n-1538602195\tDZ\n-1272693194\tED\n-1436881714\tEH\n-1269042121\tEK\n-1270731285\tEO\n-2132716300\tEO\n-1125169127\tEY\n-246923735\tGL\n-1515787781\tGO\n-483853667\tHR\n-1418341054\tJG\n-283321892\tJO\n-147343840\tLD\n-1810676855\tLO\n-731466113\tLY\n-1311366306\tML\n-1165635863\tMV\n-235358133\tMY\n-1234141625\tND\n-370796356\tNZ\n-27395319\tOJ\n-876466531\tOL\n-422941535\tPD\n-292438036\tPG\n-1204245663\tPJ\n-720881601\tQC\n-120660220\tQE\n-1252906348\tQE\n-623471113\tQM\n-2002373666\tQQ\n-847531048\tRX\n-1870444467\tRY\n-907794648\tSS\n-2088317486\tSS\n-1768335227\tSW\n-530317703\tTJ\n-1148479920\tTJ\n-1533414895\tTM\n-1960168360\tUO\n-1465751763\tUS\n-1121895896\tVD\n-2043803188\tVI\n-1424048819\tVS\n-942999384\tVV\n-1844391305\tWF\n-2108151088\tXP\n-916132123\tYC\n-1172180184\tYL\n-1271909747\tYS\n-1153445279\tYU\n-636975106\tZE\n-661194722\tZO\n-409854405\tZS\n-1871994006\tZS\n-230430837\tZZ\n";
        this.assertThat("-1613687261\tBE\n-2119387831\tBH\n-10505757\tCC\n-727724771\tCP\n-1538602195\tDZ\n-1272693194\tED\n-1436881714\tEH\n-1269042121\tEK\n-1270731285\tEO\n-2132716300\tEO\n-1125169127\tEY\n-246923735\tGL\n-1515787781\tGO\n-483853667\tHR\n-1418341054\tJG\n-283321892\tJO\n-147343840\tLD\n-1810676855\tLO\n-731466113\tLY\n-1311366306\tML\n-1165635863\tMV\n-235358133\tMY\n-1234141625\tND\n-370796356\tNZ\n-27395319\tOJ\n-876466531\tOL\n-422941535\tPD\n-292438036\tPG\n-1204245663\tPJ\n-720881601\tQC\n-120660220\tQE\n-1252906348\tQE\n-623471113\tQM\n-2002373666\tQQ\n-847531048\tRX\n-1870444467\tRY\n-907794648\tSS\n-2088317486\tSS\n-1768335227\tSW\n-530317703\tTJ\n-1148479920\tTJ\n-1533414895\tTM\n-1960168360\tUO\n-1465751763\tUS\n-1121895896\tVD\n-2043803188\tVI\n-1424048819\tVS\n-942999384\tVV\n-1844391305\tWF\n-2108151088\tXP\n-916132123\tYC\n-1172180184\tYL\n-1271909747\tYS\n-1153445279\tYU\n-636975106\tZE\n-661194722\tZO\n-409854405\tZS\n-1871994006\tZS\n-230430837\tZZ\n", "(xyz where i < 100 order by i) order by str, i desc");
        this.assertString("(xyz where i < 100 order by i) order by str, i desc", 1);
    }

    @Test
    public void testNestedOrderByExplicitAsc() throws Exception {
        String expected = "-1613687261\tBE\n-2119387831\tBH\n-10505757\tCC\n-727724771\tCP\n-1538602195\tDZ\n-1272693194\tED\n-1436881714\tEH\n-1269042121\tEK\n-2132716300\tEO\n-1270731285\tEO\n-1125169127\tEY\n-246923735\tGL\n-1515787781\tGO\n-483853667\tHR\n-1418341054\tJG\n-283321892\tJO\n-147343840\tLD\n-1810676855\tLO\n-731466113\tLY\n-1311366306\tML\n-1165635863\tMV\n-235358133\tMY\n-1234141625\tND\n-370796356\tNZ\n-27395319\tOJ\n-876466531\tOL\n-422941535\tPD\n-292438036\tPG\n-1204245663\tPJ\n-720881601\tQC\n-1252906348\tQE\n-120660220\tQE\n-623471113\tQM\n-2002373666\tQQ\n-847531048\tRX\n-1870444467\tRY\n-2088317486\tSS\n-907794648\tSS\n-1768335227\tSW\n-1148479920\tTJ\n-530317703\tTJ\n-1533414895\tTM\n-1960168360\tUO\n-1465751763\tUS\n-1121895896\tVD\n-2043803188\tVI\n-1424048819\tVS\n-942999384\tVV\n-1844391305\tWF\n-2108151088\tXP\n-916132123\tYC\n-1172180184\tYL\n-1271909747\tYS\n-1153445279\tYU\n-636975106\tZE\n-661194722\tZO\n-1871994006\tZS\n-409854405\tZS\n-230430837\tZZ\n";
        this.assertThat("-1613687261\tBE\n-2119387831\tBH\n-10505757\tCC\n-727724771\tCP\n-1538602195\tDZ\n-1272693194\tED\n-1436881714\tEH\n-1269042121\tEK\n-2132716300\tEO\n-1270731285\tEO\n-1125169127\tEY\n-246923735\tGL\n-1515787781\tGO\n-483853667\tHR\n-1418341054\tJG\n-283321892\tJO\n-147343840\tLD\n-1810676855\tLO\n-731466113\tLY\n-1311366306\tML\n-1165635863\tMV\n-235358133\tMY\n-1234141625\tND\n-370796356\tNZ\n-27395319\tOJ\n-876466531\tOL\n-422941535\tPD\n-292438036\tPG\n-1204245663\tPJ\n-720881601\tQC\n-1252906348\tQE\n-120660220\tQE\n-623471113\tQM\n-2002373666\tQQ\n-847531048\tRX\n-1870444467\tRY\n-2088317486\tSS\n-907794648\tSS\n-1768335227\tSW\n-1148479920\tTJ\n-530317703\tTJ\n-1533414895\tTM\n-1960168360\tUO\n-1465751763\tUS\n-1121895896\tVD\n-2043803188\tVI\n-1424048819\tVS\n-942999384\tVV\n-1844391305\tWF\n-2108151088\tXP\n-916132123\tYC\n-1172180184\tYL\n-1271909747\tYS\n-1153445279\tYU\n-636975106\tZE\n-661194722\tZO\n-1871994006\tZS\n-409854405\tZS\n-230430837\tZZ\n", "(xyz where i < 100 order by i) order by str asc, i asc");
    }

    @Test
    public void testOrderByExpression() throws Exception {
        try {
            this.assertThat("", "(xyz where i < 100 order by i) order by str, i+i");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)46L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testOrderByString() throws Exception {
        try {
            this.assertThat("", "(xyz where i < 100 order by i) order by str, 'i+i'");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)45L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testRowIdPassThru() throws Exception {
        this.assertThat("2016-03-12T00:00:00.000Z\t997.471052482297\n2016-03-12T03:00:00.000Z\t-3263.256266783491\n2016-03-12T06:00:00.000Z\t2356.131512016518\n2016-03-12T09:00:00.000Z\t929.843516548567\n2016-03-12T12:00:00.000Z\t589.176100472390\n2016-03-12T15:00:00.000Z\t2177.881065221333\n2016-03-12T18:00:00.000Z\t1411.259807112342\n2016-03-12T21:00:00.000Z\t645.325834388574\n", "select timestamp, sum(d) from (timeseries order by timestamp) sample by 3h");
    }

    @Test
    public void testSampleWithNestedOrder() throws Exception {
        this.assertThat("2016-03-12T01:00:00.000Z\t27\n2016-03-12T04:00:00.000Z\t20\n2016-03-12T05:00:00.000Z\t33\n2016-03-12T06:00:00.000Z\t38\n2016-03-12T07:00:00.000Z\t34\n2016-03-12T09:00:00.000Z\t23\n2016-03-12T12:00:00.000Z\t28\n2016-03-12T13:00:00.000Z\t39\n2016-03-12T14:00:00.000Z\t540\n2016-03-12T15:00:00.000Z\t45\n2016-03-12T16:00:00.000Z\t26\n2016-03-12T17:00:00.000Z\t23\n2016-03-12T18:00:00.000Z\t23\n2016-03-12T19:00:00.000Z\t67\n2016-03-12T20:00:00.000Z\t18\n2016-03-12T22:00:00.000Z\t16\n", "select ts, sum(count) from (select roundHalfUp(d/100,0) r, count() count, last(timestamp) ts from timeseries order by ts) timestamp(ts) sample by 1h");
    }

    @Test
    public void testStrSort() throws Exception {
        String expected = "1125579207\tBB\n-1613687261\tBE\n-2119387831\tBH\n-10505757\tCC\n-727724771\tCP\n-1538602195\tDZ\n-1272693194\tED\n1775935667\tED\n-1436881714\tEH\n-1269042121\tEK\n-2132716300\tEO\n-1270731285\tEO\n-1125169127\tEY\n1637847416\tFB\n1295866259\tFL\n422714199\tGH\n-246923735\tGL\n-1515787781\tGO\n426455968\tGP\n215354468\tGQ\n1060917944\tGS\n1728220848\tHB\n1826239903\tHN\n-483853667\tHR\n1876812930\tHV\n1196016669\tIC\n1920398380\tIF\n359345889\tIH\n82099057\tIH\n133913299\tIM\n502711083\tIP\n1677463366\tIP\n-1418341054\tJG\n-283321892\tJO\n1335037859\tJS\n-147343840\tLD\n410717394\tLO\n-1810676855\tLO\n614536941\tLT\n1362833895\tLT\n-731466113\tLY\n2076507991\tMF\n-1311366306\tML\n-1165635863\tMV\n-235358133\tMY\n719189074\tMZ\n-1234141625\tND\n-370796356\tNZ\n-27395319\tOJ\n-876466531\tOL\n1234796102\tOT\n1110979454\tOW\n-422941535\tPD\n-292438036\tPG\n387510473\tPH\n-1204245663\tPJ\n838743782\tQB\n-720881601\tQC\n-1252906348\tQE\n-120660220\tQE\n-623471113\tQM\n-2002373666\tQQ\n1743740444\tQS\n239305284\tRG\n-847531048\tRX\n1545253512\tRX\n-1870444467\tRY\n-2088317486\tSS\n-907794648\tSS\n-1768335227\tSW\n936627841\tSZ\n-1148479920\tTJ\n-530317703\tTJ\n-1533414895\tTM\n1751526583\tUM\n-1960168360\tUO\n-1465751763\tUS\n1254404167\tUW\n1904508147\tUX\n-1121895896\tVD\n-2043803188\tVI\n1503763988\tVL\n-1424048819\tVS\n1864113037\tVT\n-942999384\tVV\n852921272\tWC\n-1844391305\tWF\n1326447242\tWH\n844704299\tXI\n-2108151088\tXP\n-916132123\tYC\n-1172180184\tYL\n-1271909747\tYS\n-1153445279\tYU\n-636975106\tZE\n-661194722\tZO\n-409854405\tZS\n-1871994006\tZS\n1920890138\tZZ\n-230430837\tZZ\n";
        this.assertThat("1125579207\tBB\n-1613687261\tBE\n-2119387831\tBH\n-10505757\tCC\n-727724771\tCP\n-1538602195\tDZ\n-1272693194\tED\n1775935667\tED\n-1436881714\tEH\n-1269042121\tEK\n-2132716300\tEO\n-1270731285\tEO\n-1125169127\tEY\n1637847416\tFB\n1295866259\tFL\n422714199\tGH\n-246923735\tGL\n-1515787781\tGO\n426455968\tGP\n215354468\tGQ\n1060917944\tGS\n1728220848\tHB\n1826239903\tHN\n-483853667\tHR\n1876812930\tHV\n1196016669\tIC\n1920398380\tIF\n359345889\tIH\n82099057\tIH\n133913299\tIM\n502711083\tIP\n1677463366\tIP\n-1418341054\tJG\n-283321892\tJO\n1335037859\tJS\n-147343840\tLD\n410717394\tLO\n-1810676855\tLO\n614536941\tLT\n1362833895\tLT\n-731466113\tLY\n2076507991\tMF\n-1311366306\tML\n-1165635863\tMV\n-235358133\tMY\n719189074\tMZ\n-1234141625\tND\n-370796356\tNZ\n-27395319\tOJ\n-876466531\tOL\n1234796102\tOT\n1110979454\tOW\n-422941535\tPD\n-292438036\tPG\n387510473\tPH\n-1204245663\tPJ\n838743782\tQB\n-720881601\tQC\n-1252906348\tQE\n-120660220\tQE\n-623471113\tQM\n-2002373666\tQQ\n1743740444\tQS\n239305284\tRG\n-847531048\tRX\n1545253512\tRX\n-1870444467\tRY\n-2088317486\tSS\n-907794648\tSS\n-1768335227\tSW\n936627841\tSZ\n-1148479920\tTJ\n-530317703\tTJ\n-1533414895\tTM\n1751526583\tUM\n-1960168360\tUO\n-1465751763\tUS\n1254404167\tUW\n1904508147\tUX\n-1121895896\tVD\n-2043803188\tVI\n1503763988\tVL\n-1424048819\tVS\n1864113037\tVT\n-942999384\tVV\n852921272\tWC\n-1844391305\tWF\n1326447242\tWH\n844704299\tXI\n-2108151088\tXP\n-916132123\tYC\n-1172180184\tYL\n-1271909747\tYS\n-1153445279\tYU\n-636975106\tZE\n-661194722\tZO\n-409854405\tZS\n-1871994006\tZS\n1920890138\tZZ\n-230430837\tZZ\n", "xyz order by str");
    }
}

