/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.sort;

import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.ql.RecordSource;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.sort.ComparatorCompiler;
import com.questdb.ql.sort.RBTreeSortedRecordSource;
import com.questdb.ql.sort.RecordComparator;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.IntList;
import com.questdb.std.ObjList;
import com.questdb.store.AbstractRecordMetadata;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.RecordColumnMetadata;
import com.questdb.store.RecordMetadata;
import com.questdb.store.StorageFacade;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ComparatorCompilerTest
extends AbstractOptimiserTest {
    private final ComparatorCompiler cc = new ComparatorCompiler(new BytecodeAssembler());

    @Test
    public void testAllGetters() throws Exception {
        try (JournalWriter w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("xyz").$bool("bool").$byte("byte").$double("double").$float("float").$int("int").$long("long").$date("date").$short("short").$str("str").$sym("sym").$());){
            JournalEntryWriter ew = w.entryWriter();
            ew.putBool(0, true);
            ew.put(1, (byte)13);
            ew.putDouble(2, 20.12);
            ew.putFloat(3, 10.15f);
            ew.putInt(4, 4);
            ew.putLong(5, 9988908080988890L);
            ew.putDate(6, 88979879L);
            ew.putShort(7, (short)902);
            ew.putStr(8, (CharSequence)"complexity made simple");
            ew.putSym(9, (CharSequence)"questdb");
            ew.append();
            ew = w.entryWriter();
            ew.put(1, (byte)13);
            ew.putDouble(2, 20.12);
            ew.putFloat(3, 10.15f);
            ew.putInt(4, 4);
            ew.putLong(5, 9988908080988890L);
            ew.putDate(6, 88979879L);
            ew.putShort(7, (short)902);
            ew.putStr(8, (CharSequence)"complexity made simple");
            ew.putSym(9, (CharSequence)"appsicle");
            ew.append();
            w.commit();
            IntList indices = new IntList();
            int n = w.getMetadata().getColumnCount();
            for (int i = 0; i < n; ++i) {
                indices.add(i + 1);
            }
            RecordSource rs = this.compileSource("xyz");
            RecordComparator rc = this.cc.compile(rs.getMetadata(), indices);
            RBTreeSortedRecordSource map = new RBTreeSortedRecordSource(rs, rc, 0x100000, 0x400000);
            sink.clear();
            printer.print((RecordSource)map, (ReaderFactory)FACTORY_CONTAINER.getFactory());
        }
        TestUtils.assertEquals((CharSequence)"false\t13\t20.120000000000\t10.1500\t4\t9988908080988890\t1970-01-02T00:42:59.879Z\t902\tcomplexity made simple\tappsicle\ntrue\t13\t20.120000000000\t10.1500\t4\t9988908080988890\t1970-01-02T00:42:59.879Z\t902\tcomplexity made simple\tquestdb\n", (CharSequence)sink);
    }

    @Test
    public void testCompileAll() {
        TestRecordMetadata m = new TestRecordMetadata().addDistinct();
        IntList indices = new IntList(m.getColumnCount());
        int n = m.getColumnCount();
        for (int i = 0; i < n; ++i) {
            indices.add(i + 1);
        }
        RecordComparator rc = this.cc.compile((RecordMetadata)m, indices);
        Assert.assertNotNull((Object)rc);
    }

    @Test
    public void testCompileLarge() {
        TestRecordMetadata m = new TestRecordMetadata();
        for (int i = 0; i < 155; ++i) {
            m.addDistinct();
        }
        IntList indices = new IntList(m.getColumnCount());
        int n = m.getColumnCount();
        for (int i = 0; i < n; ++i) {
            indices.add(i + 1);
        }
        RecordComparator rc = this.cc.compile((RecordMetadata)m, indices);
        Assert.assertNotNull((Object)rc);
    }

    @Test
    public void testCompileMultipleOfSame() {
        TestRecordMetadata m = new TestRecordMetadata();
        for (int i = 0; i < 155; ++i) {
            m.asType(7);
        }
        IntList indices = new IntList(m.getColumnCount());
        int n = m.getColumnCount();
        for (int i = 0; i < n; ++i) {
            indices.add(i + 1);
        }
        RecordComparator rc = this.cc.compile((RecordMetadata)m, indices);
        Assert.assertNotNull((Object)rc);
    }

    @Test
    public void testTwoClassesSameClassloader() {
        TestRecordMetadata m = new TestRecordMetadata();
        for (int i = 0; i < 155; ++i) {
            m.asType(7);
        }
        IntList indices = new IntList(m.getColumnCount());
        int n = m.getColumnCount();
        for (int i = 0; i < n; ++i) {
            indices.add(i + 1);
        }
        RecordComparator rc1 = this.cc.compile((RecordMetadata)m, indices);
        RecordComparator rc2 = this.cc.compile((RecordMetadata)m, indices);
        Assert.assertNotNull((Object)rc1);
        Assert.assertNotNull((Object)rc2);
    }

    private static class TestRecordMetadata
    extends AbstractRecordMetadata {
        private final ObjList<TestColumnMetadata> columns = new ObjList();

        private TestRecordMetadata() {
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public int getColumnIndexQuiet(CharSequence name) {
            return 0;
        }

        public RecordColumnMetadata getColumnQuick(int index) {
            return (RecordColumnMetadata)this.columns.getQuick(index);
        }

        public int getTimestampIndex() {
            return -1;
        }

        TestRecordMetadata addDistinct() {
            this.asType(0);
            this.asType(1);
            this.asType(6);
            this.asType(5);
            this.asType(3);
            this.asType(4);
            this.asType(10);
            this.asType(2);
            this.asType(7);
            this.asType(8);
            return this;
        }

        void asType(int columnType) {
            this.columns.add((Object)new TestColumnMetadata(columnType));
        }
    }

    private static class TestColumnMetadata
    extends AbstractVirtualColumn {
        TestColumnMetadata(int columnType) {
            super(columnType, 0);
        }

        public boolean isConstant() {
            return false;
        }

        public void prepare(StorageFacade facade) {
        }
    }
}

