/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.regex;

import com.questdb.ql.ops.regex.MatchResult;
import com.questdb.ql.ops.regex.Matcher;
import com.questdb.ql.ops.regex.POSIX_ASCII;
import com.questdb.ql.ops.regex.POSIX_Unicode;
import com.questdb.ql.ops.regex.Pattern;
import com.questdb.ql.ops.regex.PatternSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class RegExTest {
    private static final Random generator = new Random();
    private static boolean failure = false;
    private static int failCount = 0;
    private static String firstFailure = null;

    public static void main(String[] args) throws Exception {
        RegExTest.processFile("TestCases.txt");
        RegExTest.processFile("BMPTestCases.txt");
        RegExTest.processFile("SupplementaryTestCases.txt");
        RegExTest.bm();
        RegExTest.slice();
        RegExTest.escapes();
        RegExTest.blankInput();
        RegExTest.globalSubstitute();
        RegExTest.stringbufferSubstitute();
        RegExTest.substitutionBasher();
        RegExTest.ceTest();
        RegExTest.anchorTest();
        RegExTest.matchesTest();
        RegExTest.lookingAtTest();
        RegExTest.patternMatchesTest();
        RegExTest.lookbehindTest();
        RegExTest.nullArgumentTest();
        RegExTest.backRefTest();
        RegExTest.groupCaptureTest();
        RegExTest.caretTest();
        RegExTest.charClassTest();
        RegExTest.emptyPatternTest();
        RegExTest.findIntTest();
        RegExTest.group0Test();
        RegExTest.longPatternTest();
        RegExTest.octalTest();
        RegExTest.ampersandTest();
        RegExTest.negationTest();
        RegExTest.appendTest();
        RegExTest.caseFoldingTest();
        RegExTest.commentsTest();
        RegExTest.unixLinesTest();
        RegExTest.replaceFirstTest();
        RegExTest.gTest();
        RegExTest.zTest();
        RegExTest.serializeTest();
        RegExTest.reluctantRepetitionTest();
        RegExTest.multilineDollarTest();
        RegExTest.dollarAtEndTest();
        RegExTest.caretBetweenTerminatorsTest();
        RegExTest.javaCharClassTest();
        RegExTest.nonCaptureRepetitionTest();
        RegExTest.notCapturedGroupCurlyMatchTest();
        RegExTest.escapedSegmentTest();
        RegExTest.literalPatternTest();
        RegExTest.literalReplacementTest();
        RegExTest.regionTest();
        RegExTest.toStringTest();
        RegExTest.negatedCharClassTest();
        RegExTest.findFromTest();
        RegExTest.boundsTest();
        RegExTest.unicodeWordBoundsTest();
        RegExTest.caretAtEndTest();
        RegExTest.wordSearchTest();
        RegExTest.hitEndTest();
        RegExTest.toMatchResultTest();
        RegExTest.surrogatesInClassTest();
        RegExTest.removeQEQuotingTest();
        RegExTest.namedGroupCaptureTest();
        RegExTest.nonBmpClassComplementTest();
        RegExTest.unicodePropertiesTest();
        RegExTest.unicodeHexNotationTest();
        RegExTest.unicodeClassesTest();
        RegExTest.horizontalAndVerticalWSTest();
        RegExTest.linebreakTest();
        RegExTest.branchTest();
        RegExTest.groupCurlyNotFoundSuppTest();
        RegExTest.groupCurlyBackoffTest();
        if (failure) {
            throw new RuntimeException("RegExTest failed, 1st failure: " + firstFailure);
        }
        System.err.println("OKAY: All tests passed.");
    }

    private static String getRandomAlphaString(int length) {
        StringBuilder buf = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char randChar = (char)(97 + generator.nextInt(26));
            buf.append(randChar);
        }
        return buf.toString();
    }

    private static void check(Matcher m, String expected) {
        m.find();
        if (!m.group().equals(expected)) {
            ++failCount;
        }
    }

    private static void check(Matcher m, String result, boolean expected) {
        m.find();
        if (m.group().equals(result) != expected) {
            ++failCount;
        }
    }

    private static void check(Pattern p, String s, boolean expected) {
        if (p.matcher((CharSequence)s).find() != expected) {
            ++failCount;
        }
    }

    private static void check(String p, String s, boolean expected) {
        Matcher matcher = Pattern.compile((String)p).matcher((CharSequence)s);
        if (matcher.find() != expected) {
            ++failCount;
        }
    }

    private static void check(String p, char c, boolean expected) {
        char[] ca;
        String propertyPattern = expected ? "\\p" + p : "\\P" + p;
        Pattern pattern = Pattern.compile((String)propertyPattern);
        Matcher matcher = pattern.matcher((CharSequence)new String(ca = new char[]{c}));
        if (!matcher.find()) {
            ++failCount;
        }
    }

    private static void check(String p, int codePoint, boolean expected) {
        char[] ca;
        String propertyPattern = expected ? "\\p" + p : "\\P" + p;
        Pattern pattern = Pattern.compile((String)propertyPattern);
        Matcher matcher = pattern.matcher((CharSequence)new String(ca = Character.toChars(codePoint)));
        if (!matcher.find()) {
            ++failCount;
        }
    }

    private static void check(String p, int flag, String input, String s, boolean expected) {
        Pattern pattern = Pattern.compile((String)p, (int)flag);
        Matcher matcher = pattern.matcher((CharSequence)input);
        if (expected) {
            RegExTest.check(matcher, s, true);
        } else {
            RegExTest.check(pattern, input, false);
        }
    }

    private static void report(String testName) {
        int spacesToAdd = 30 - testName.length();
        StringBuilder paddedNameBuffer = new StringBuilder(testName);
        for (int i = 0; i < spacesToAdd; ++i) {
            paddedNameBuffer.append(" ");
        }
        String paddedName = paddedNameBuffer.toString();
        System.err.println(paddedName + ": " + (failCount == 0 ? "Passed" : "Failed(" + failCount + ")"));
        if (failCount > 0) {
            failure = true;
            if (firstFailure == null) {
                firstFailure = testName;
            }
        }
        failCount = 0;
    }

    private static String toSupplementaries(String s) {
        int length = s.length();
        StringBuilder sb = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                sb.append(c);
                if (i >= length) continue;
                c = s.charAt(i++);
                sb.append(c);
                if (c != 'u') continue;
                sb.append(s.charAt(i++));
                sb.append(s.charAt(i++));
                sb.append(s.charAt(i++));
                sb.append(s.charAt(i++));
                continue;
            }
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                sb.append('\ud800').append((char)(56320 + c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean check(Runnable test) {
        try {
            test.run();
            ++failCount;
            return false;
        }
        catch (NullPointerException npe) {
            return true;
        }
    }

    private static void nullArgumentTest() {
        RegExTest.check(() -> Pattern.compile(null));
        RegExTest.check(() -> Pattern.matches(null, null));
        RegExTest.check(() -> Pattern.matches((String)"xyz", null));
        RegExTest.check(() -> Pattern.quote(null));
        RegExTest.check(() -> Pattern.compile((String)"xyz").split(null));
        RegExTest.check(() -> Pattern.compile((String)"xyz").matcher(null));
        Matcher m = Pattern.compile((String)"xyz").matcher((CharSequence)"xyz");
        m.matches();
        RegExTest.check(() -> m.appendTail(null));
        RegExTest.check(() -> m.replaceAll(null));
        RegExTest.check(() -> m.replaceFirst(null));
        RegExTest.check(() -> m.appendReplacement(null, null));
        RegExTest.check(() -> m.reset(null));
        RegExTest.check(() -> Matcher.quoteReplacement(null));
        RegExTest.report("Null Argument");
    }

    private static void surrogatesInClassTest() {
        Pattern pattern = Pattern.compile((String)"[\\ud834\\udd21-\\ud834\\udd24]");
        Matcher matcher = pattern.matcher((CharSequence)"\ud834\udd22");
        if (!matcher.find()) {
            ++failCount;
        }
        RegExTest.report("Surrogate pair in Unicode escape");
    }

    private static void removeQEQuotingTest() {
        Pattern pattern = Pattern.compile((String)"\\011\\Q1sometext\\E\\011\\Q2sometext\\E");
        Matcher matcher = pattern.matcher((CharSequence)"\t1sometext\t2sometext");
        if (!matcher.find()) {
            ++failCount;
        }
        RegExTest.report("Remove Q/E Quoting");
    }

    private static void toMatchResultTest() {
        MatchResult mr2;
        int resultStart1;
        Pattern pattern = Pattern.compile((String)"squid");
        Matcher matcher = pattern.matcher((CharSequence)"agiantsquidofdestinyasmallsquidoffate");
        matcher.find();
        int matcherStart1 = matcher.start();
        MatchResult mr = matcher.toMatchResult();
        if (mr == matcher) {
            ++failCount;
        }
        if (matcherStart1 != (resultStart1 = mr.start())) {
            ++failCount;
        }
        matcher.find();
        int matcherStart2 = matcher.start();
        int resultStart2 = mr.start();
        if (matcherStart2 == resultStart2) {
            ++failCount;
        }
        if (resultStart1 != resultStart2) {
            ++failCount;
        }
        if (mr == (mr2 = matcher.toMatchResult())) {
            ++failCount;
        }
        if (mr2.start() != matcherStart2) {
            ++failCount;
        }
        RegExTest.report("toMatchResult is a copy");
    }

    private static void hitEndTest() {
        Pattern p = Pattern.compile((String)"^squidattack");
        Matcher m = p.matcher((CharSequence)"squack");
        m.find();
        if (m.hitEnd()) {
            ++failCount;
        }
        m.reset((CharSequence)"squid");
        m.find();
        if (!m.hitEnd()) {
            ++failCount;
        }
        for (int i = 0; i < 3; ++i) {
            int flags = 0;
            if (i == 1) {
                flags = 2;
            }
            if (i == 2) {
                flags = 64;
            }
            p = Pattern.compile((String)"^abc", (int)flags);
            m = p.matcher((CharSequence)"ad");
            m.find();
            if (m.hitEnd()) {
                ++failCount;
            }
            m.reset((CharSequence)"ab");
            m.find();
            if (m.hitEnd()) continue;
            ++failCount;
        }
        p = Pattern.compile((String)"catattack");
        m = p.matcher((CharSequence)"attack");
        m.find();
        if (!m.hitEnd()) {
            ++failCount;
        }
        p = Pattern.compile((String)"catattack");
        m = p.matcher((CharSequence)"attackattackattackcatatta");
        m.find();
        if (!m.hitEnd()) {
            ++failCount;
        }
        RegExTest.report("hitEnd from a Slice");
    }

    private static void wordSearchTest() {
        String testString = "word1 word2 word3";
        Pattern p = Pattern.compile((String)"\\b");
        Matcher m = p.matcher((CharSequence)testString);
        int position = 0;
        int start = 0;
        while (m.find(position) && (start = m.start()) != testString.length()) {
            position = m.find(start + 1) ? m.start() : testString.length();
            if (testString.substring(start, position).equals(" ") || testString.substring(start, position - 1).startsWith("word")) continue;
            ++failCount;
        }
        RegExTest.report("Customer word search");
    }

    private static void caretAtEndTest() {
        Pattern pattern = Pattern.compile((String)"^x?", (int)8);
        Matcher matcher = pattern.matcher((CharSequence)"\r");
        matcher.find();
        matcher.find();
        RegExTest.report("Caret at end");
    }

    private static void unicodeWordBoundsTest() {
        String spaces = "  ";
        String wordChar = "a";
        String nsm = "\u030a";
        assert (Character.getType('\u030a') == 6);
        Pattern pattern = Pattern.compile((String)"\\b");
        Matcher matcher = pattern.matcher((CharSequence)"");
        String input = spaces + wordChar + wordChar + spaces;
        RegExTest.twoFindIndexes(input, matcher, 2, 4);
        input = spaces + wordChar + wordChar + nsm + spaces;
        RegExTest.twoFindIndexes(input, matcher, 2, 5);
        input = spaces + wordChar + nsm + spaces;
        RegExTest.twoFindIndexes(input, matcher, 2, 4);
        input = spaces + wordChar + nsm + nsm + spaces;
        RegExTest.twoFindIndexes(input, matcher, 2, 5);
        input = spaces + nsm + wordChar + wordChar + spaces;
        RegExTest.twoFindIndexes(input, matcher, 3, 5);
        input = spaces + wordChar + nsm + wordChar + spaces;
        RegExTest.twoFindIndexes(input, matcher, 2, 5);
        input = spaces + nsm + nsm + spaces;
        matcher.reset((CharSequence)input);
        if (matcher.find()) {
            ++failCount;
        }
        input = spaces + nsm + wordChar + wordChar + nsm + spaces;
        RegExTest.twoFindIndexes(input, matcher, 3, 6);
        RegExTest.report("Unicode word boundary");
    }

    private static void twoFindIndexes(String input, Matcher matcher, int a, int b) {
        matcher.reset((CharSequence)input);
        matcher.find();
        if (matcher.start() != a) {
            ++failCount;
        }
        matcher.find();
        if (matcher.start() != b) {
            ++failCount;
        }
    }

    static void check(String regex, String input, String[] expected) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile((String)regex);
        Matcher m = p.matcher((CharSequence)input);
        while (m.find()) {
            result.add(m.group());
        }
        if (!Arrays.asList(expected).equals(result)) {
            ++failCount;
        }
    }

    private static void lookbehindTest() {
        RegExTest.check("(?<=%.{0,5})foo\\d", "%foo1\n%bar foo2\n%bar  foo3\n%blahblah foo4\nfoo5", new String[]{"foo1", "foo2", "foo3"});
        RegExTest.check("(?<=.*\\b)foo", "abcd foo", new String[]{"foo"});
        RegExTest.check("(?<=.*)\\bfoo", "abcd foo", new String[]{"foo"});
        RegExTest.check("(?<!abc )\\bfoo", "abc foo", new String[0]);
        RegExTest.check("(?<!abc \\b)foo", "abc foo", new String[0]);
        RegExTest.check("(?<!%.{0,5})foo\\d", "%foo1\n%bar foo2\n%bar  foo3\n%blahblah foo4\nfoo5", new String[]{"foo4", "foo5"});
        RegExTest.check("(?<=%b{1,4})foo", "%bbbbfoo", new String[]{"foo"});
        RegExTest.check("(?<=%b{1,4}?)foo", "%bbbbfoo", new String[]{"foo"});
        RegExTest.check("(?<=%b{1,4})fo\ud800\udc00o", "%bbbbfo\ud800\udc00o", new String[]{"fo\ud800\udc00o"});
        RegExTest.check("(?<=%b{1,4}?)fo\ud800\udc00o", "%bbbbfo\ud800\udc00o", new String[]{"fo\ud800\udc00o"});
        RegExTest.check("(?<!%b{1,4})fo\ud800\udc00o", "%afo\ud800\udc00o", new String[]{"fo\ud800\udc00o"});
        RegExTest.check("(?<!%b{1,4}?)fo\ud800\udc00o", "%afo\ud800\udc00o", new String[]{"fo\ud800\udc00o"});
        RegExTest.report("Lookbehind");
    }

    private static void boundsTest() {
        String fullMessage = "catdogcat";
        Pattern pattern = Pattern.compile((String)"(?<=cat)dog(?=cat)");
        Matcher matcher = pattern.matcher((CharSequence)"catdogca");
        matcher.useTransparentBounds(true);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"atdogcat");
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)fullMessage);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)fullMessage);
        matcher.region(0, 9);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)fullMessage);
        matcher.region(0, 6);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)fullMessage);
        matcher.region(3, 6);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.useTransparentBounds(false);
        if (matcher.find()) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"(?<!cat)dog(?!cat)");
        matcher = pattern.matcher((CharSequence)"dogcat");
        matcher.useTransparentBounds(true);
        matcher.region(0, 3);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"catdog");
        matcher.region(3, 6);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.useTransparentBounds(false);
        matcher.reset((CharSequence)"dogcat");
        matcher.region(0, 3);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"catdog");
        matcher.region(3, 6);
        if (!matcher.find()) {
            ++failCount;
        }
        RegExTest.report("Region bounds transparency");
    }

    private static void findFromTest() {
        String message = "This is 40 $0 message.";
        Pattern pat = Pattern.compile((String)"\\$0");
        Matcher match = pat.matcher((CharSequence)message);
        if (!match.find()) {
            ++failCount;
        }
        if (match.find()) {
            ++failCount;
        }
        if (match.find()) {
            ++failCount;
        }
        RegExTest.report("Check for alternating find");
    }

    private static void negatedCharClassTest() {
        String s;
        String[] result;
        Pattern pattern = Pattern.compile((String)"[^>]");
        Matcher matcher = pattern.matcher((CharSequence)"\u203a");
        if (!matcher.matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"[^fr]")).matcher((CharSequence)"a")).find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"\u203a");
        if (!matcher.find()) {
            ++failCount;
        }
        if (!(result = (s = "for").split("[^fr]"))[0].equals("f")) {
            ++failCount;
        }
        if (!result[1].equals("r")) {
            ++failCount;
        }
        if (!(result = (s = "f\u203ar").split("[^fr]"))[0].equals("f")) {
            ++failCount;
        }
        if (!result[1].equals("r")) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"[^f\u203ar]")).matcher((CharSequence)"a")).find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"f");
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"\u203a");
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"r");
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"\u203b");
        if (!matcher.find()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"[^\u203ar\u203b]")).matcher((CharSequence)"a")).find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"\u203a");
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"r");
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"\u203b");
        if (matcher.find()) {
            ++failCount;
        }
        matcher.reset((CharSequence)"\u203c");
        if (!matcher.find()) {
            ++failCount;
        }
        RegExTest.report("Negated Character Class");
    }

    private static void toStringTest() {
        Pattern pattern = Pattern.compile((String)"b+");
        if (pattern.toString() != "b+") {
            ++failCount;
        }
        Matcher matcher = pattern.matcher((CharSequence)"aaabbbccc");
        String matcherString = matcher.toString();
        matcher.find();
        matcherString = matcher.toString();
        matcher.region(0, 3);
        matcherString = matcher.toString();
        matcher.reset();
        matcherString = matcher.toString();
        RegExTest.report("toString");
    }

    private static void literalPatternTest() {
        int flags = 16;
        Pattern pattern = Pattern.compile((String)"abc\\t$^", (int)flags);
        RegExTest.check(pattern, "abc\\t$^", true);
        pattern = Pattern.compile((String)Pattern.quote((String)"abc\\t$^"));
        RegExTest.check(pattern, "abc\\t$^", true);
        pattern = Pattern.compile((String)"\\Qa^$bcabc\\E", (int)flags);
        RegExTest.check(pattern, "\\Qa^$bcabc\\E", true);
        RegExTest.check(pattern, "a^$bcabc", false);
        pattern = Pattern.compile((String)"\\\\Q\\\\E");
        RegExTest.check(pattern, "\\Q\\E", true);
        pattern = Pattern.compile((String)"\\Qabc\\Eefg\\\\Q\\\\Ehij");
        RegExTest.check(pattern, "abcefg\\Q\\Ehij", true);
        pattern = Pattern.compile((String)"\\\\\\Q\\\\E");
        RegExTest.check(pattern, "\\\\\\\\", true);
        pattern = Pattern.compile((String)Pattern.quote((String)"\\Qa^$bcabc\\E"));
        RegExTest.check(pattern, "\\Qa^$bcabc\\E", true);
        RegExTest.check(pattern, "a^$bcabc", false);
        pattern = Pattern.compile((String)Pattern.quote((String)"\\Qabc\\Edef"));
        RegExTest.check(pattern, "\\Qabc\\Edef", true);
        RegExTest.check(pattern, "abcdef", false);
        pattern = Pattern.compile((String)Pattern.quote((String)"abc\\Edef"));
        RegExTest.check(pattern, "abc\\Edef", true);
        RegExTest.check(pattern, "abcdef", false);
        pattern = Pattern.compile((String)Pattern.quote((String)"\\E"));
        RegExTest.check(pattern, "\\E", true);
        pattern = Pattern.compile((String)"((((abc.+?:)", (int)flags);
        RegExTest.check(pattern, "((((abc.+?:)", true);
        pattern = Pattern.compile((String)"^cat$", (int)(flags |= 8));
        RegExTest.check(pattern, "abc^cat$def", true);
        RegExTest.check(pattern, "cat", false);
        pattern = Pattern.compile((String)"abcdef", (int)(flags |= 2));
        RegExTest.check(pattern, "ABCDEF", true);
        RegExTest.check(pattern, "AbCdEf", true);
        pattern = Pattern.compile((String)"a...b", (int)(flags |= 0x20));
        RegExTest.check(pattern, "A...b", true);
        RegExTest.check(pattern, "Axxxb", false);
        Pattern p = Pattern.compile((String)"testa\u030a", (int)(flags |= 0x80));
        RegExTest.check(pattern, "testa\u030a", false);
        RegExTest.check(pattern, "test\u00e5", false);
        flags = 16;
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("abc\\t$^"), (int)flags);
        RegExTest.check(pattern, RegExTest.toSupplementaries("abc\\t$^"), true);
        pattern = Pattern.compile((String)Pattern.quote((String)RegExTest.toSupplementaries("abc\\t$^")));
        RegExTest.check(pattern, RegExTest.toSupplementaries("abc\\t$^"), true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("\\Qa^$bcabc\\E"), (int)flags);
        RegExTest.check(pattern, RegExTest.toSupplementaries("\\Qa^$bcabc\\E"), true);
        RegExTest.check(pattern, RegExTest.toSupplementaries("a^$bcabc"), false);
        pattern = Pattern.compile((String)Pattern.quote((String)RegExTest.toSupplementaries("\\Qa^$bcabc\\E")));
        RegExTest.check(pattern, RegExTest.toSupplementaries("\\Qa^$bcabc\\E"), true);
        RegExTest.check(pattern, RegExTest.toSupplementaries("a^$bcabc"), false);
        pattern = Pattern.compile((String)Pattern.quote((String)RegExTest.toSupplementaries("\\Qabc\\Edef")));
        RegExTest.check(pattern, RegExTest.toSupplementaries("\\Qabc\\Edef"), true);
        RegExTest.check(pattern, RegExTest.toSupplementaries("abcdef"), false);
        pattern = Pattern.compile((String)Pattern.quote((String)RegExTest.toSupplementaries("abc\\Edef")));
        RegExTest.check(pattern, RegExTest.toSupplementaries("abc\\Edef"), true);
        RegExTest.check(pattern, RegExTest.toSupplementaries("abcdef"), false);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("((((abc.+?:)"), (int)flags);
        RegExTest.check(pattern, RegExTest.toSupplementaries("((((abc.+?:)"), true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("^cat$"), (int)(flags |= 8));
        RegExTest.check(pattern, RegExTest.toSupplementaries("abc^cat$def"), true);
        RegExTest.check(pattern, RegExTest.toSupplementaries("cat"), false);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("a...b"), (int)(flags |= 0x20));
        RegExTest.check(pattern, RegExTest.toSupplementaries("a...b"), true);
        RegExTest.check(pattern, RegExTest.toSupplementaries("axxxb"), false);
        String t = RegExTest.toSupplementaries("test");
        p = Pattern.compile((String)(t + "a\u030a"), (int)(flags |= 0x80));
        RegExTest.check(pattern, t + "a\u030a", false);
        RegExTest.check(pattern, t + "\u00e5", false);
        RegExTest.report("Literal pattern");
    }

    private static void literalReplacementTest() {
        String replaceTest;
        int flags = 16;
        Pattern pattern = Pattern.compile((String)"abc", (int)flags);
        Matcher matcher = pattern.matcher((CharSequence)"zzzabczzz");
        String result = matcher.replaceAll(replaceTest = "$0");
        if (!result.equals("zzzabczzz")) {
            ++failCount;
        }
        matcher.reset();
        String literalReplacement = Matcher.quoteReplacement((String)replaceTest);
        result = matcher.replaceAll(literalReplacement);
        if (!result.equals("zzz$0zzz")) {
            ++failCount;
        }
        matcher.reset();
        replaceTest = "\\t$\\$";
        literalReplacement = Matcher.quoteReplacement((String)replaceTest);
        result = matcher.replaceAll(literalReplacement);
        if (!result.equals("zzz\\t$\\$zzz")) {
            ++failCount;
        }
        if (!(result = (matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("abc"), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("zzzabczzz"))).replaceAll(replaceTest = "$0")).equals(RegExTest.toSupplementaries("zzzabczzz"))) {
            ++failCount;
        }
        matcher.reset();
        literalReplacement = Matcher.quoteReplacement((String)replaceTest);
        result = matcher.replaceAll(literalReplacement);
        if (!result.equals(RegExTest.toSupplementaries("zzz$0zzz"))) {
            ++failCount;
        }
        matcher.reset();
        replaceTest = "\\t$\\$";
        literalReplacement = Matcher.quoteReplacement((String)replaceTest);
        result = matcher.replaceAll(literalReplacement);
        if (!result.equals(RegExTest.toSupplementaries("zzz\\t$\\$zzz"))) {
            ++failCount;
        }
        try {
            "\uac00".replaceAll("\uac00", "$");
            ++failCount;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            ++failCount;
        }
        try {
            "\uac00".replaceAll("\uac00", "\\");
            ++failCount;
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            ++failCount;
        }
        RegExTest.report("Literal replacement");
    }

    private static void regionTest() {
        Pattern pattern = Pattern.compile((String)"abc");
        Matcher matcher = pattern.matcher((CharSequence)"abcdefabc");
        matcher.region(0, 9);
        if (!matcher.find()) {
            ++failCount;
        }
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.region(0, 3);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.region(3, 6);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.region(0, 2);
        if (matcher.find()) {
            ++failCount;
        }
        RegExTest.expectRegionFail(matcher, 1, -1);
        RegExTest.expectRegionFail(matcher, -1, -1);
        RegExTest.expectRegionFail(matcher, -1, 1);
        RegExTest.expectRegionFail(matcher, 5, 3);
        RegExTest.expectRegionFail(matcher, 5, 12);
        RegExTest.expectRegionFail(matcher, 12, 12);
        pattern = Pattern.compile((String)"^abc$");
        matcher = pattern.matcher((CharSequence)"zzzabczzz");
        matcher.region(0, 9);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.region(3, 6);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.region(3, 6);
        matcher.useAnchoringBounds(false);
        if (matcher.find()) {
            ++failCount;
        }
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("abc"));
        matcher = pattern.matcher((CharSequence)RegExTest.toSupplementaries("abcdefabc"));
        matcher.region(0, 18);
        if (!matcher.find()) {
            ++failCount;
        }
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.region(0, 6);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.region(1, 6);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.region(6, 12);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.region(0, 4);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.region(0, 5);
        if (matcher.find()) {
            ++failCount;
        }
        RegExTest.expectRegionFail(matcher, 2, -1);
        RegExTest.expectRegionFail(matcher, -1, -1);
        RegExTest.expectRegionFail(matcher, -1, 2);
        RegExTest.expectRegionFail(matcher, 10, 6);
        RegExTest.expectRegionFail(matcher, 10, 24);
        RegExTest.expectRegionFail(matcher, 24, 24);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("^abc$"));
        matcher = pattern.matcher((CharSequence)RegExTest.toSupplementaries("zzzabczzz"));
        matcher.region(0, 18);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.region(6, 12);
        if (!matcher.find()) {
            ++failCount;
        }
        matcher.region(7, 12);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.region(6, 11);
        if (matcher.find()) {
            ++failCount;
        }
        matcher.region(6, 12);
        matcher.useAnchoringBounds(false);
        if (matcher.find()) {
            ++failCount;
        }
        RegExTest.report("Regions");
    }

    private static void expectRegionFail(Matcher matcher, int index1, int index2) {
        try {
            matcher.region(index1, index2);
            ++failCount;
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
    }

    private static void escapedSegmentTest() {
        Pattern pattern = Pattern.compile((String)"\\Qdir1\\dir2\\E");
        RegExTest.check(pattern, "dir1\\dir2", true);
        pattern = Pattern.compile((String)"\\Qdir1\\dir2\\\\E");
        RegExTest.check(pattern, "dir1\\dir2\\", true);
        pattern = Pattern.compile((String)"(\\Qdir1\\dir2\\\\E)");
        RegExTest.check(pattern, "dir1\\dir2\\", true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("\\Qdir1\\dir2\\E"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("dir1\\dir2"), true);
        pattern = Pattern.compile((String)(RegExTest.toSupplementaries("\\Qdir1\\dir2") + "\\\\E"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("dir1\\dir2\\"), true);
        pattern = Pattern.compile((String)(RegExTest.toSupplementaries("(\\Qdir1\\dir2") + "\\\\E)"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("dir1\\dir2\\"), true);
        RegExTest.report("Escaped segment");
    }

    private static void nonCaptureRepetitionTest() {
        String input = "abcdefgh;";
        String[] patterns = new String[]{"(?:\\w{4})+;", "(?:\\w{8})*;", "(?:\\w{2}){2,4};", "(?:\\w{4}){2,};", ".*?(?:\\w{5})+;", ".*?(?:\\w{9})*;", "(?:\\w{4})+?;", "(?:\\w{4})++;", "(?:\\w{2,}?)+;", "(\\w{4})+;"};
        for (int i = 0; i < patterns.length; ++i) {
            RegExTest.check(patterns[i], 0, input, input, true);
            Pattern p = Pattern.compile((String)patterns[i]);
            Matcher m = p.matcher((CharSequence)input);
            if (m.matches()) {
                if (m.group(0).equals(input)) continue;
                ++failCount;
                continue;
            }
            ++failCount;
        }
        RegExTest.report("Non capturing repetition");
    }

    private static void notCapturedGroupCurlyMatchTest() {
        Pattern pattern = Pattern.compile((String)"(abc)+|(abcd)+");
        Matcher matcher = pattern.matcher((CharSequence)"abcd");
        if (!matcher.matches() || matcher.group(1) != null || !matcher.group(2).equals("abcd")) {
            ++failCount;
        }
        RegExTest.report("Not captured GroupCurly");
    }

    private static void javaCharClassTest() {
        int i;
        for (i = 0; i < 1000; ++i) {
            char c = (char)generator.nextInt();
            RegExTest.check("{javaLowerCase}", c, Character.isLowerCase(c));
            RegExTest.check("{javaUpperCase}", c, Character.isUpperCase(c));
            RegExTest.check("{javaUpperCase}+", c, Character.isUpperCase(c));
            RegExTest.check("{javaTitleCase}", c, Character.isTitleCase(c));
            RegExTest.check("{javaDigit}", c, Character.isDigit(c));
            RegExTest.check("{javaDefined}", c, Character.isDefined(c));
            RegExTest.check("{javaLetter}", c, Character.isLetter(c));
            RegExTest.check("{javaLetterOrDigit}", c, Character.isLetterOrDigit(c));
            RegExTest.check("{javaJavaIdentifierStart}", c, Character.isJavaIdentifierStart(c));
            RegExTest.check("{javaJavaIdentifierPart}", c, Character.isJavaIdentifierPart(c));
            RegExTest.check("{javaUnicodeIdentifierStart}", c, Character.isUnicodeIdentifierStart(c));
            RegExTest.check("{javaUnicodeIdentifierPart}", c, Character.isUnicodeIdentifierPart(c));
            RegExTest.check("{javaIdentifierIgnorable}", c, Character.isIdentifierIgnorable(c));
            RegExTest.check("{javaSpaceChar}", c, Character.isSpaceChar(c));
            RegExTest.check("{javaWhitespace}", c, Character.isWhitespace(c));
            RegExTest.check("{javaISOControl}", c, Character.isISOControl(c));
            RegExTest.check("{javaMirrored}", c, Character.isMirrored(c));
        }
        for (i = 0; i < 1000; ++i) {
            int n = generator.nextInt(1048575) + 65536;
            RegExTest.check("{javaLowerCase}", n, Character.isLowerCase(n));
            RegExTest.check("{javaUpperCase}", n, Character.isUpperCase(n));
            RegExTest.check("{javaUpperCase}+", n, Character.isUpperCase(n));
            RegExTest.check("{javaTitleCase}", n, Character.isTitleCase(n));
            RegExTest.check("{javaDigit}", n, Character.isDigit(n));
            RegExTest.check("{javaDefined}", n, Character.isDefined(n));
            RegExTest.check("{javaLetter}", n, Character.isLetter(n));
            RegExTest.check("{javaLetterOrDigit}", n, Character.isLetterOrDigit(n));
            RegExTest.check("{javaJavaIdentifierStart}", n, Character.isJavaIdentifierStart(n));
            RegExTest.check("{javaJavaIdentifierPart}", n, Character.isJavaIdentifierPart(n));
            RegExTest.check("{javaUnicodeIdentifierStart}", n, Character.isUnicodeIdentifierStart(n));
            RegExTest.check("{javaUnicodeIdentifierPart}", n, Character.isUnicodeIdentifierPart(n));
            RegExTest.check("{javaIdentifierIgnorable}", n, Character.isIdentifierIgnorable(n));
            RegExTest.check("{javaSpaceChar}", n, Character.isSpaceChar(n));
            RegExTest.check("{javaWhitespace}", n, Character.isWhitespace(n));
            RegExTest.check("{javaISOControl}", n, Character.isISOControl(n));
            RegExTest.check("{javaMirrored}", n, Character.isMirrored(n));
        }
        RegExTest.report("Java character classes");
    }

    private static void caretBetweenTerminatorsTest() {
        int flags1 = 32;
        int flags2 = 33;
        int flags3 = 41;
        int flags4 = 40;
        RegExTest.check("^....", flags1, "test\ntest", "test", true);
        RegExTest.check(".....^", flags1, "test\ntest", "test", false);
        RegExTest.check(".....^", flags1, "test\n", "test", false);
        RegExTest.check("....^", flags1, "test\r\n", "test", false);
        RegExTest.check("^....", flags2, "test\ntest", "test", true);
        RegExTest.check("....^", flags2, "test\ntest", "test", false);
        RegExTest.check(".....^", flags2, "test\n", "test", false);
        RegExTest.check("....^", flags2, "test\r\n", "test", false);
        RegExTest.check("^....", flags3, "test\ntest", "test", true);
        RegExTest.check(".....^", flags3, "test\ntest", "test\n", true);
        RegExTest.check(".....^", flags3, "test\u0085test", "test\u0085", false);
        RegExTest.check(".....^", flags3, "test\n", "test", false);
        RegExTest.check(".....^", flags3, "test\r\n", "test", false);
        RegExTest.check("......^", flags3, "test\r\ntest", "test\r\n", true);
        RegExTest.check("^....", flags4, "test\ntest", "test", true);
        RegExTest.check(".....^", flags3, "test\ntest", "test\n", true);
        RegExTest.check(".....^", flags4, "test\u0085test", "test\u0085", true);
        RegExTest.check(".....^", flags4, "test\n", "test\n", false);
        RegExTest.check(".....^", flags4, "test\r\n", "test\r", false);
        String t = RegExTest.toSupplementaries("test");
        RegExTest.check("^....", flags1, t + "\n" + t, t, true);
        RegExTest.check(".....^", flags1, t + "\n" + t, t, false);
        RegExTest.check(".....^", flags1, t + "\n", t, false);
        RegExTest.check("....^", flags1, t + "\r\n", t, false);
        RegExTest.check("^....", flags2, t + "\n" + t, t, true);
        RegExTest.check("....^", flags2, t + "\n" + t, t, false);
        RegExTest.check(".....^", flags2, t + "\n", t, false);
        RegExTest.check("....^", flags2, t + "\r\n", t, false);
        RegExTest.check("^....", flags3, t + "\n" + t, t, true);
        RegExTest.check(".....^", flags3, t + "\n" + t, t + "\n", true);
        RegExTest.check(".....^", flags3, t + "\u0085" + t, t + "\u0085", false);
        RegExTest.check(".....^", flags3, t + "\n", t, false);
        RegExTest.check(".....^", flags3, t + "\r\n", t, false);
        RegExTest.check("......^", flags3, t + "\r\n" + t, t + "\r\n", true);
        RegExTest.check("^....", flags4, t + "\n" + t, t, true);
        RegExTest.check(".....^", flags3, t + "\n" + t, t + "\n", true);
        RegExTest.check(".....^", flags4, t + "\u0085" + t, t + "\u0085", true);
        RegExTest.check(".....^", flags4, t + "\n", t + "\n", false);
        RegExTest.check(".....^", flags4, t + "\r\n", t + "\r", false);
        RegExTest.report("Caret between terminators");
    }

    private static void dollarAtEndTest() {
        int flags1 = 32;
        int flags2 = 33;
        int flags3 = 40;
        RegExTest.check("....$", flags1, "test\n", "test", true);
        RegExTest.check("....$", flags1, "test\r\n", "test", true);
        RegExTest.check(".....$", flags1, "test\n", "test\n", true);
        RegExTest.check(".....$", flags1, "test\u0085", "test\u0085", true);
        RegExTest.check("....$", flags1, "test\u0085", "test", true);
        RegExTest.check("....$", flags2, "test\n", "test", true);
        RegExTest.check(".....$", flags2, "test\n", "test\n", true);
        RegExTest.check(".....$", flags2, "test\u0085", "test\u0085", true);
        RegExTest.check("....$", flags2, "test\u0085", "est\u0085", true);
        RegExTest.check("....$.blah", flags3, "test\nblah", "test\nblah", true);
        RegExTest.check(".....$.blah", flags3, "test\n\nblah", "test\n\nblah", true);
        RegExTest.check("....$blah", flags3, "test\nblah", "!!!!", false);
        RegExTest.check(".....$blah", flags3, "test\nblah", "!!!!", false);
        String t = RegExTest.toSupplementaries("test");
        String b = RegExTest.toSupplementaries("blah");
        RegExTest.check("....$", flags1, t + "\n", t, true);
        RegExTest.check("....$", flags1, t + "\r\n", t, true);
        RegExTest.check(".....$", flags1, t + "\n", t + "\n", true);
        RegExTest.check(".....$", flags1, t + "\u0085", t + "\u0085", true);
        RegExTest.check("....$", flags1, t + "\u0085", t, true);
        RegExTest.check("....$", flags2, t + "\n", t, true);
        RegExTest.check(".....$", flags2, t + "\n", t + "\n", true);
        RegExTest.check(".....$", flags2, t + "\u0085", t + "\u0085", true);
        RegExTest.check("....$", flags2, t + "\u0085", RegExTest.toSupplementaries("est\u0085"), true);
        RegExTest.check("....$." + b, flags3, t + "\n" + b, t + "\n" + b, true);
        RegExTest.check(".....$." + b, flags3, t + "\n\n" + b, t + "\n\n" + b, true);
        RegExTest.check("....$" + b, flags3, t + "\n" + b, "!!!!", false);
        RegExTest.check(".....$" + b, flags3, t + "\n" + b, "!!!!", false);
        RegExTest.report("Dollar at End");
    }

    private static void multilineDollarTest() {
        Pattern findCR = Pattern.compile((String)"$", (int)8);
        Matcher matcher = findCR.matcher((CharSequence)"first bit\nsecond bit");
        matcher.find();
        if (matcher.start(0) != 9) {
            ++failCount;
        }
        matcher.find();
        if (matcher.start(0) != 20) {
            ++failCount;
        }
        matcher = findCR.matcher((CharSequence)RegExTest.toSupplementaries("first  bit\n second  bit"));
        matcher.find();
        if (matcher.start(0) != 18) {
            ++failCount;
        }
        matcher.find();
        if (matcher.start(0) != 40) {
            ++failCount;
        }
        RegExTest.report("Multiline Dollar");
    }

    private static void reluctantRepetitionTest() {
        Pattern p = Pattern.compile((String)"1(\\s\\S+?){1,3}?[\\s,]2");
        RegExTest.check(p, "1 word word word 2", true);
        RegExTest.check(p, "1 wor wo w 2", true);
        RegExTest.check(p, "1 word word 2", true);
        RegExTest.check(p, "1 word 2", true);
        RegExTest.check(p, "1 wo w w 2", true);
        RegExTest.check(p, "1 wo w 2", true);
        RegExTest.check(p, "1 wor w 2", true);
        p = Pattern.compile((String)"([a-z])+?c");
        Matcher m = p.matcher((CharSequence)"ababcdefdec");
        RegExTest.check(m, "ababc");
        p = Pattern.compile((String)RegExTest.toSupplementaries("([a-z])+?c"));
        m = p.matcher((CharSequence)RegExTest.toSupplementaries("ababcdefdec"));
        RegExTest.check(m, RegExTest.toSupplementaries("ababc"));
        RegExTest.report("Reluctant Repetition");
    }

    private static void serializeTest() throws Exception {
        String patternStr = "(b)";
        String matchStr = "b";
        Pattern pattern = Pattern.compile((String)patternStr);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(pattern);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        Pattern serializedPattern = (Pattern)ois.readObject();
        ois.close();
        Matcher matcher = serializedPattern.matcher((CharSequence)matchStr);
        if (!matcher.matches()) {
            ++failCount;
        }
        if (matcher.groupCount() != 1) {
            ++failCount;
        }
        RegExTest.report("Serialization");
    }

    private static void gTest() {
        Pattern pattern = Pattern.compile((String)"\\G\\w");
        Matcher matcher = pattern.matcher((CharSequence)"abc#x#x");
        matcher.find();
        matcher.find();
        matcher.find();
        if (matcher.find()) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"\\GA*");
        matcher = pattern.matcher((CharSequence)"1A2AA3");
        matcher.find();
        if (matcher.find()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"\\GA*")).matcher((CharSequence)"1A2AA3")).find(1)) {
            ++failCount;
        }
        matcher.find();
        if (matcher.find()) {
            ++failCount;
        }
        RegExTest.report("\\G");
    }

    private static void zTest() {
        Pattern pattern = Pattern.compile((String)"foo\\Z");
        RegExTest.check(pattern, "foo\u0085", true);
        RegExTest.check(pattern, "foo\u2028", true);
        RegExTest.check(pattern, "foo\u2029", true);
        RegExTest.check(pattern, "foo\n", true);
        RegExTest.check(pattern, "foo\r", true);
        RegExTest.check(pattern, "foo\r\n", true);
        RegExTest.check(pattern, "fooo", false);
        RegExTest.check(pattern, "foo\n\r", false);
        pattern = Pattern.compile((String)"foo\\Z", (int)1);
        RegExTest.check(pattern, "foo", true);
        RegExTest.check(pattern, "foo\n", true);
        RegExTest.check(pattern, "foo\r", false);
        RegExTest.check(pattern, "foo\u0085", false);
        RegExTest.check(pattern, "foo\u2028", false);
        RegExTest.check(pattern, "foo\u2029", false);
        RegExTest.report("\\Z");
    }

    private static void replaceFirstTest() {
        Pattern pattern = Pattern.compile((String)"(ab)(c*)");
        Matcher matcher = pattern.matcher((CharSequence)"abccczzzabcczzzabccc");
        if (!matcher.replaceFirst("test").equals("testzzzabcczzzabccc")) {
            ++failCount;
        }
        matcher.reset((CharSequence)"zzzabccczzzabcczzzabccczzz");
        if (!matcher.replaceFirst("test").equals("zzztestzzzabcczzzabccczzz")) {
            ++failCount;
        }
        matcher.reset((CharSequence)"zzzabccczzzabcczzzabccczzz");
        String result = matcher.replaceFirst("$1");
        if (!result.equals("zzzabzzzabcczzzabccczzz")) {
            ++failCount;
        }
        matcher.reset((CharSequence)"zzzabccczzzabcczzzabccczzz");
        result = matcher.replaceFirst("$2");
        if (!result.equals("zzzccczzzabcczzzabccczzz")) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"a*")).matcher((CharSequence)"aaaaaaaaaa")).replaceFirst("test").equals("test")) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"a+")).matcher((CharSequence)"zzzaaaaaaaaaa")).replaceFirst("test").equals("zzztest")) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(c*)"))).matcher((CharSequence)RegExTest.toSupplementaries("abccczzzabcczzzabccc"))).replaceFirst(RegExTest.toSupplementaries("test")).equals(RegExTest.toSupplementaries("testzzzabcczzzabccc"))) {
            ++failCount;
        }
        matcher.reset((CharSequence)RegExTest.toSupplementaries("zzzabccczzzabcczzzabccczzz"));
        if (!matcher.replaceFirst(RegExTest.toSupplementaries("test")).equals(RegExTest.toSupplementaries("zzztestzzzabcczzzabccczzz"))) {
            ++failCount;
        }
        matcher.reset((CharSequence)RegExTest.toSupplementaries("zzzabccczzzabcczzzabccczzz"));
        result = matcher.replaceFirst("$1");
        if (!result.equals(RegExTest.toSupplementaries("zzzabzzzabcczzzabccczzz"))) {
            ++failCount;
        }
        matcher.reset((CharSequence)RegExTest.toSupplementaries("zzzabccczzzabcczzzabccczzz"));
        result = matcher.replaceFirst("$2");
        if (!result.equals(RegExTest.toSupplementaries("zzzccczzzabcczzzabccczzz"))) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("a*"))).matcher((CharSequence)RegExTest.toSupplementaries("aaaaaaaaaa"))).replaceFirst(RegExTest.toSupplementaries("test")).equals(RegExTest.toSupplementaries("test"))) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("a+"))).matcher((CharSequence)RegExTest.toSupplementaries("zzzaaaaaaaaaa"))).replaceFirst(RegExTest.toSupplementaries("test")).equals(RegExTest.toSupplementaries("zzztest"))) {
            ++failCount;
        }
        RegExTest.report("Replace First");
    }

    private static void unixLinesTest() {
        Pattern pattern = Pattern.compile((String)".*");
        Matcher matcher = pattern.matcher((CharSequence)"aa\u2028blah");
        matcher.find();
        if (!matcher.group(0).equals("aa")) {
            ++failCount;
        }
        pattern = Pattern.compile((String)".*", (int)1);
        matcher = pattern.matcher((CharSequence)"aa\u2028blah");
        matcher.find();
        if (!matcher.group(0).equals("aa\u2028blah")) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"[az]$", (int)9);
        matcher = pattern.matcher((CharSequence)"aa\u2028zz");
        RegExTest.check(matcher, "a\u2028", false);
        pattern = Pattern.compile((String)".*");
        matcher = pattern.matcher((CharSequence)RegExTest.toSupplementaries("aa\u2028blah"));
        matcher.find();
        if (!matcher.group(0).equals(RegExTest.toSupplementaries("aa"))) {
            ++failCount;
        }
        pattern = Pattern.compile((String)".*", (int)1);
        matcher = pattern.matcher((CharSequence)RegExTest.toSupplementaries("aa\u2028blah"));
        matcher.find();
        if (!matcher.group(0).equals(RegExTest.toSupplementaries("aa\u2028blah"))) {
            ++failCount;
        }
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("[az]$"), (int)9);
        matcher = pattern.matcher((CharSequence)RegExTest.toSupplementaries("aa\u2028zz"));
        RegExTest.check(matcher, RegExTest.toSupplementaries("a\u2028"), false);
        RegExTest.report("Unix Lines");
    }

    private static void commentsTest() {
        int flags = 4;
        Pattern pattern = Pattern.compile((String)"aa \\# aa", (int)flags);
        Matcher matcher = pattern.matcher((CharSequence)"aa#aa");
        if (!matcher.matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"aa  # blah", (int)flags)).matcher((CharSequence)"aa")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"aa blah", (int)flags)).matcher((CharSequence)"aablah")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"aa  # blah blech  ", (int)flags)).matcher((CharSequence)"aa")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"aa  # blah\n  ", (int)flags)).matcher((CharSequence)"aa")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"aa  # blah\nbc # blech", (int)flags)).matcher((CharSequence)"aabc")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"aa  # blah\nbc# blech", (int)flags)).matcher((CharSequence)"aabc")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"aa  # blah\nbc\\# blech", (int)flags)).matcher((CharSequence)"aabc#blech")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("aa \\# aa"), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("aa#aa"))).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("aa  # blah"), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("aa"))).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("aa blah"), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("aablah"))).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("aa  # blah blech  "), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("aa"))).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("aa  # blah\n  "), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("aa"))).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("aa  # blah\nbc # blech"), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("aabc"))).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("aa  # blah\nbc# blech"), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("aabc"))).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("aa  # blah\nbc\\# blech"), (int)flags)).matcher((CharSequence)RegExTest.toSupplementaries("aabc#blech"))).matches()) {
            ++failCount;
        }
        RegExTest.report("Comments");
    }

    private static void caseFoldingTest() {
        int i;
        int flags = 66;
        Pattern pattern = Pattern.compile((String)"aa", (int)flags);
        Matcher matcher = pattern.matcher((CharSequence)"ab");
        if (matcher.matches()) {
            ++failCount;
        }
        if ((matcher = (pattern = Pattern.compile((String)"aA", (int)flags)).matcher((CharSequence)"ab")).matches()) {
            ++failCount;
        }
        if ((matcher = (pattern = Pattern.compile((String)"aa", (int)flags)).matcher((CharSequence)"aB")).matches()) {
            ++failCount;
        }
        if ((matcher = pattern.matcher((CharSequence)"Ab")).matches()) {
            ++failCount;
        }
        String[] patterns = new String[]{"a", "\u00e0", "\u0430", "ab", "\u00e0\u00e1", "\u0430\u0431", "[a]", "[\u00e0]", "[\u0430]", "[a-b]", "[\u00e0-\u00e5]", "[\u0430-\u0431]", "(a)\\1", "(\u00e0)\\1", "(\u0430)\\1"};
        String[] texts = new String[]{"A", "\u00c0", "\u0410", "AB", "\u00c0\u00c1", "\u0410\u0411", "A", "\u00c0", "\u0410", "B", "\u00c2", "\u0411", "aA", "\u00e0\u00c0", "\u0430\u0410"};
        boolean[] expected = new boolean[]{true, false, false, true, false, false, true, false, false, true, false, false, true, false, false};
        flags = 2;
        for (i = 0; i < patterns.length; ++i) {
            pattern = Pattern.compile((String)patterns[i], (int)flags);
            matcher = pattern.matcher((CharSequence)texts[i]);
            if (matcher.matches() == expected[i]) continue;
            System.out.println("<1> Failed at " + i);
            ++failCount;
        }
        flags = 66;
        for (i = 0; i < patterns.length; ++i) {
            pattern = Pattern.compile((String)patterns[i], (int)flags);
            matcher = pattern.matcher((CharSequence)texts[i]);
            if (matcher.matches()) continue;
            System.out.println("<2> Failed at " + i);
            ++failCount;
        }
        flags = 64;
        for (i = 0; i < patterns.length; ++i) {
            pattern = Pattern.compile((String)patterns[i], (int)flags);
            matcher = pattern.matcher((CharSequence)texts[i]);
            if (!matcher.matches()) continue;
            System.out.println("<3> Failed at " + i);
            ++failCount;
        }
        flags = 66;
        pattern = Pattern.compile((String)"[h-j]+", (int)flags);
        if (!pattern.matcher((CharSequence)"\u0131\u0130").matches()) {
            ++failCount;
        }
        RegExTest.report("Case Folding");
    }

    private static void appendTest() {
        StringBuffer sb;
        Pattern pattern = Pattern.compile((String)"(ab)(cd)");
        Matcher matcher = pattern.matcher((CharSequence)"abcd");
        String result = matcher.replaceAll("$2$1");
        if (!result.equals("cdab")) {
            ++failCount;
        }
        String s1 = "Swap all: first = 123, second = 456";
        String s2 = "Swap one: first = 123, second = 456";
        String r = "$3$2$1";
        pattern = Pattern.compile((String)"([a-z]+)( *= *)([0-9]+)");
        matcher = pattern.matcher((CharSequence)s1);
        result = matcher.replaceAll(r);
        if (!result.equals("Swap all: 123 = first, 456 = second")) {
            ++failCount;
        }
        if ((matcher = pattern.matcher((CharSequence)s2)).find()) {
            sb = new StringBuffer();
            matcher.appendReplacement(sb, r);
            matcher.appendTail(sb);
            result = sb.toString();
            if (!result.equals("Swap one: 123 = first, second = 456")) {
                ++failCount;
            }
        }
        if (!(result = (matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(cd)"))).matcher((CharSequence)RegExTest.toSupplementaries("abcd"))).replaceAll("$2$1")).equals(RegExTest.toSupplementaries("cdab"))) {
            ++failCount;
        }
        s1 = RegExTest.toSupplementaries("Swap all: first = 123, second = 456");
        s2 = RegExTest.toSupplementaries("Swap one: first = 123, second = 456");
        r = RegExTest.toSupplementaries("$3$2$1");
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("([a-z]+)( *= *)([0-9]+)"));
        matcher = pattern.matcher((CharSequence)s1);
        result = matcher.replaceAll(r);
        if (!result.equals(RegExTest.toSupplementaries("Swap all: 123 = first, 456 = second"))) {
            ++failCount;
        }
        if ((matcher = pattern.matcher((CharSequence)s2)).find()) {
            sb = new StringBuffer();
            matcher.appendReplacement(sb, r);
            matcher.appendTail(sb);
            result = sb.toString();
            if (!result.equals(RegExTest.toSupplementaries("Swap one: 123 = first, second = 456"))) {
                ++failCount;
            }
        }
        RegExTest.report("Append");
    }

    private static void negationTest() {
        Pattern pattern = Pattern.compile((String)"[\\[@^]+");
        Matcher matcher = pattern.matcher((CharSequence)"@@@@[[[[^^^^");
        if (!matcher.find()) {
            ++failCount;
        }
        if (!matcher.group(0).equals("@@@@[[[[^^^^")) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"[@\\[^]+")).matcher((CharSequence)"@@@@[[[[^^^^")).find()) {
            ++failCount;
        }
        if (!matcher.group(0).equals("@@@@[[[[^^^^")) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"[@\\[^@]+")).matcher((CharSequence)"@@@@[[[[^^^^")).find()) {
            ++failCount;
        }
        if (!matcher.group(0).equals("@@@@[[[[^^^^")) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"\\)")).matcher((CharSequence)"xxx)xxx")).find()) {
            ++failCount;
        }
        RegExTest.report("Negation");
    }

    private static void ampersandTest() {
        Pattern pattern = Pattern.compile((String)"[&@]+");
        RegExTest.check(pattern, "@@@@&&&&", true);
        pattern = Pattern.compile((String)"[@&]+");
        RegExTest.check(pattern, "@@@@&&&&", true);
        pattern = Pattern.compile((String)"[@\\&]+");
        RegExTest.check(pattern, "@@@@&&&&", true);
        RegExTest.report("Ampersand");
    }

    private static void octalTest() {
        Pattern pattern = Pattern.compile((String)"\\u0007");
        Matcher matcher = pattern.matcher((CharSequence)"\u0007");
        if (!matcher.matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"\\07")).matcher((CharSequence)"\u0007")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"\\007")).matcher((CharSequence)"\u0007")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"\\0007")).matcher((CharSequence)"\u0007")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"\\040")).matcher((CharSequence)" ")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"\\0403")).matcher((CharSequence)" 3")).matches()) {
            ++failCount;
        }
        if (!(matcher = (pattern = Pattern.compile((String)"\\0103")).matcher((CharSequence)"C")).matches()) {
            ++failCount;
        }
        RegExTest.report("Octal");
    }

    private static void longPatternTest() {
        int i;
        StringBuilder patternToBe;
        Pattern pattern;
        try {
            pattern = Pattern.compile((String)"a 32-character-long pattern xxxx");
            pattern = Pattern.compile((String)"a 33-character-long pattern xxxxx");
            pattern = Pattern.compile((String)"a thirty four character long regex");
            patternToBe = new StringBuilder(101);
            for (i = 0; i < 100; ++i) {
                patternToBe.append((char)(97 + i % 26));
            }
            pattern = Pattern.compile((String)patternToBe.toString());
        }
        catch (PatternSyntaxException e) {
            ++failCount;
        }
        try {
            pattern = Pattern.compile((String)RegExTest.toSupplementaries("a 32-character-long pattern xxxx"));
            pattern = Pattern.compile((String)RegExTest.toSupplementaries("a 33-character-long pattern xxxxx"));
            pattern = Pattern.compile((String)RegExTest.toSupplementaries("a thirty four character long regex"));
            patternToBe = new StringBuilder(202);
            for (i = 0; i < 100; ++i) {
                patternToBe.append(Character.toChars(65633 + i % 26));
            }
            pattern = Pattern.compile((String)patternToBe.toString());
        }
        catch (PatternSyntaxException e) {
            ++failCount;
        }
        RegExTest.report("LongPattern");
    }

    private static void group0Test() {
        Pattern pattern = Pattern.compile((String)"(tes)ting");
        Matcher matcher = pattern.matcher((CharSequence)"testing");
        RegExTest.check(matcher, "testing");
        matcher.reset((CharSequence)"testing");
        if (matcher.lookingAt()) {
            if (!matcher.group(0).equals("testing")) {
                ++failCount;
            }
        } else {
            ++failCount;
        }
        matcher.reset((CharSequence)"testing");
        if (matcher.matches()) {
            if (!matcher.group(0).equals("testing")) {
                ++failCount;
            }
        } else {
            ++failCount;
        }
        if ((matcher = (pattern = Pattern.compile((String)"(tes)ting")).matcher((CharSequence)"testing")).lookingAt()) {
            if (!matcher.group(0).equals("testing")) {
                ++failCount;
            }
        } else {
            ++failCount;
        }
        if ((matcher = (pattern = Pattern.compile((String)"^(tes)ting")).matcher((CharSequence)"testing")).matches()) {
            if (!matcher.group(0).equals("testing")) {
                ++failCount;
            }
        } else {
            ++failCount;
        }
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("(tes)ting"));
        matcher = pattern.matcher((CharSequence)RegExTest.toSupplementaries("testing"));
        RegExTest.check(matcher, RegExTest.toSupplementaries("testing"));
        matcher.reset((CharSequence)RegExTest.toSupplementaries("testing"));
        if (matcher.lookingAt()) {
            if (!matcher.group(0).equals(RegExTest.toSupplementaries("testing"))) {
                ++failCount;
            }
        } else {
            ++failCount;
        }
        matcher.reset((CharSequence)RegExTest.toSupplementaries("testing"));
        if (matcher.matches()) {
            if (!matcher.group(0).equals(RegExTest.toSupplementaries("testing"))) {
                ++failCount;
            }
        } else {
            ++failCount;
        }
        if ((matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("(tes)ting"))).matcher((CharSequence)RegExTest.toSupplementaries("testing"))).lookingAt()) {
            if (!matcher.group(0).equals(RegExTest.toSupplementaries("testing"))) {
                ++failCount;
            }
        } else {
            ++failCount;
        }
        if ((matcher = (pattern = Pattern.compile((String)RegExTest.toSupplementaries("^(tes)ting"))).matcher((CharSequence)RegExTest.toSupplementaries("testing"))).matches()) {
            if (!matcher.group(0).equals(RegExTest.toSupplementaries("testing"))) {
                ++failCount;
            }
        } else {
            ++failCount;
        }
        RegExTest.report("Group0");
    }

    private static void findIntTest() {
        Pattern p = Pattern.compile((String)"blah");
        Matcher m = p.matcher((CharSequence)"zzzzblahzzzzzblah");
        boolean result = m.find(2);
        if (!result) {
            ++failCount;
        }
        if (!(result = (m = (p = Pattern.compile((String)"$")).matcher((CharSequence)"1234567890")).find(10))) {
            ++failCount;
        }
        try {
            result = m.find(11);
            ++failCount;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        p = Pattern.compile((String)RegExTest.toSupplementaries("blah"));
        m = p.matcher((CharSequence)RegExTest.toSupplementaries("zzzzblahzzzzzblah"));
        result = m.find(2);
        if (!result) {
            ++failCount;
        }
        RegExTest.report("FindInt");
    }

    private static void emptyPatternTest() {
        Pattern p = Pattern.compile((String)"");
        Matcher m = p.matcher((CharSequence)"foo");
        boolean result = m.find();
        if (!result) {
            ++failCount;
        }
        if (m.start() != 0) {
            ++failCount;
        }
        m.reset();
        result = m.matches();
        if (result) {
            ++failCount;
        }
        try {
            m.start(0);
            ++failCount;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        m.reset((CharSequence)"");
        result = m.matches();
        if (!result) {
            ++failCount;
        }
        if (!(result = Pattern.matches((String)"", (CharSequence)""))) {
            ++failCount;
        }
        if (result = Pattern.matches((String)"", (CharSequence)"foo")) {
            ++failCount;
        }
        RegExTest.report("EmptyPattern");
    }

    private static void charClassTest() {
        Pattern pattern = Pattern.compile((String)"blah[ab]]blech");
        RegExTest.check(pattern, "blahb]blech", true);
        pattern = Pattern.compile((String)"[abc[def]]");
        RegExTest.check(pattern, "b", true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("blah[ab]]blech"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("blahb]blech"), true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("[abc[def]]"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("b"), true);
        try {
            pattern = Pattern.compile((String)"[ab\u00ffcd]", (int)66);
            RegExTest.check(pattern, "ab\u00ffcd", true);
            RegExTest.check(pattern, "Ab\u0178Cd", true);
            pattern = Pattern.compile((String)"[ab\u00b5cd]", (int)66);
            RegExTest.check(pattern, "ab\u00b5cd", true);
            RegExTest.check(pattern, "Ab\u039cCd", true);
        }
        catch (Exception e) {
            ++failCount;
        }
        int flags = 66;
        pattern = Pattern.compile((String)"[sik\u00c5]+", (int)flags);
        if (!pattern.matcher((CharSequence)"\u017f\u0130\u0131\u212a\u212b").matches()) {
            ++failCount;
        }
        RegExTest.report("CharClass");
    }

    private static void caretTest() {
        String result;
        Pattern pattern = Pattern.compile((String)"\\w*");
        Matcher matcher = pattern.matcher((CharSequence)"a#bc#def##g");
        RegExTest.check(matcher, "a");
        RegExTest.check(matcher, "");
        RegExTest.check(matcher, "bc");
        RegExTest.check(matcher, "");
        RegExTest.check(matcher, "def");
        RegExTest.check(matcher, "");
        RegExTest.check(matcher, "");
        RegExTest.check(matcher, "g");
        RegExTest.check(matcher, "");
        if (matcher.find()) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"^\\w*");
        matcher = pattern.matcher((CharSequence)"a#bc#def##g");
        RegExTest.check(matcher, "a");
        if (matcher.find()) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"\\w");
        matcher = pattern.matcher((CharSequence)"abc##x");
        RegExTest.check(matcher, "a");
        RegExTest.check(matcher, "b");
        RegExTest.check(matcher, "c");
        RegExTest.check(matcher, "x");
        if (matcher.find()) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"^\\w");
        matcher = pattern.matcher((CharSequence)"abc##x");
        RegExTest.check(matcher, "a");
        if (matcher.find()) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"\\A\\p{Alpha}{3}");
        matcher = pattern.matcher((CharSequence)"abcdef-ghi\njklmno");
        RegExTest.check(matcher, "abc");
        if (matcher.find()) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"^\\p{Alpha}{3}", (int)8);
        matcher = pattern.matcher((CharSequence)"abcdef-ghi\njklmno");
        RegExTest.check(matcher, "abc");
        RegExTest.check(matcher, "jkl");
        if (matcher.find()) {
            ++failCount;
        }
        if (!(result = (matcher = (pattern = Pattern.compile((String)"^", (int)8)).matcher((CharSequence)"this is some text")).replaceAll("X")).equals("Xthis is some text")) {
            ++failCount;
        }
        if (!(result = (matcher = (pattern = Pattern.compile((String)"^")).matcher((CharSequence)"this is some text")).replaceAll("X")).equals("Xthis is some text")) {
            ++failCount;
        }
        if (!(result = (matcher = (pattern = Pattern.compile((String)"^", (int)9)).matcher((CharSequence)"this is some text\n")).replaceAll("X")).equals("Xthis is some text\n")) {
            ++failCount;
        }
        RegExTest.report("Caret");
    }

    private static void groupCaptureTest() {
        String blah2;
        Pattern pattern = Pattern.compile((String)"x+(?>y+)z+");
        Matcher matcher = pattern.matcher((CharSequence)"xxxyyyzzz");
        matcher.find();
        try {
            blah2 = matcher.group(1);
            ++failCount;
        }
        catch (IndexOutOfBoundsException blah2) {
            // empty catch block
        }
        pattern = Pattern.compile((String)"x+(?:y+)z+");
        matcher = pattern.matcher((CharSequence)"xxxyyyzzz");
        matcher.find();
        try {
            blah2 = matcher.group(1);
            ++failCount;
        }
        catch (IndexOutOfBoundsException blah3) {
            // empty catch block
        }
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("x+(?>y+)z+"));
        matcher = pattern.matcher((CharSequence)RegExTest.toSupplementaries("xxxyyyzzz"));
        matcher.find();
        try {
            blah2 = matcher.group(1);
            ++failCount;
        }
        catch (IndexOutOfBoundsException blah4) {
            // empty catch block
        }
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("x+(?:y+)z+"));
        matcher = pattern.matcher((CharSequence)RegExTest.toSupplementaries("xxxyyyzzz"));
        matcher.find();
        try {
            blah2 = matcher.group(1);
            ++failCount;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        RegExTest.report("GroupCapture");
    }

    private static void backRefTest() {
        Pattern pattern = Pattern.compile((String)"(a*)bc\\1");
        RegExTest.check(pattern, "zzzaabcazzz", true);
        pattern = Pattern.compile((String)"(a*)bc\\1");
        RegExTest.check(pattern, "zzzaabcaazzz", true);
        pattern = Pattern.compile((String)"(abc)(def)\\1");
        RegExTest.check(pattern, "abcdefabc", true);
        pattern = Pattern.compile((String)"(abc)(def)\\3");
        RegExTest.check(pattern, "abcdefabc", false);
        try {
            for (int i = 1; i < 10; ++i) {
                pattern = Pattern.compile((String)("abcdef\\" + i));
                RegExTest.check(pattern, "abcdef", false);
            }
        }
        catch (PatternSyntaxException e) {
            ++failCount;
        }
        pattern = Pattern.compile((String)"(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)\\11");
        RegExTest.check(pattern, "abcdefghija", false);
        RegExTest.check(pattern, "abcdefghija1", true);
        pattern = Pattern.compile((String)"(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11");
        RegExTest.check(pattern, "abcdefghijkk", true);
        pattern = Pattern.compile((String)"(a)bcdefghij\\11");
        RegExTest.check(pattern, "abcdefghija1", true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("(a*)bc\\1"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("zzzaabcazzz"), true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("(a*)bc\\1"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("zzzaabcaazzz"), true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("(abc)(def)\\1"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("abcdefabc"), true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("(abc)(def)\\3"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("abcdefabc"), false);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)\\11"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("abcdefghija"), false);
        RegExTest.check(pattern, RegExTest.toSupplementaries("abcdefghija1"), true);
        pattern = Pattern.compile((String)RegExTest.toSupplementaries("(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11"));
        RegExTest.check(pattern, RegExTest.toSupplementaries("abcdefghijkk"), true);
        RegExTest.report("BackRef");
    }

    private static void anchorTest() {
        Pattern p = Pattern.compile((String)"^.*$", (int)8);
        Matcher m = p.matcher((CharSequence)"blah1\r\nblah2");
        m.find();
        m.find();
        if (!m.group().equals("blah2")) {
            ++failCount;
        }
        m.reset((CharSequence)"blah1\n\rblah2");
        m.find();
        m.find();
        m.find();
        if (!m.group().equals("blah2")) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)".+$")).matcher((CharSequence)"blah1\r\n")).find()) {
            ++failCount;
        }
        if (!m.group().equals("blah1")) {
            ++failCount;
        }
        if (m.find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)".+$", (int)8)).matcher((CharSequence)"blah1\r\n")).find()) {
            ++failCount;
        }
        if (m.find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)".+$", (int)8)).matcher((CharSequence)"blah1\u0085")).find()) {
            ++failCount;
        }
        p = Pattern.compile((String)"^.*$", (int)8);
        m = p.matcher((CharSequence)RegExTest.toSupplementaries("blah1\r\nblah2"));
        m.find();
        m.find();
        if (!m.group().equals(RegExTest.toSupplementaries("blah2"))) {
            ++failCount;
        }
        m.reset((CharSequence)RegExTest.toSupplementaries("blah1\n\rblah2"));
        m.find();
        m.find();
        m.find();
        if (!m.group().equals(RegExTest.toSupplementaries("blah2"))) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)".+$")).matcher((CharSequence)RegExTest.toSupplementaries("blah1\r\n"))).find()) {
            ++failCount;
        }
        if (!m.group().equals(RegExTest.toSupplementaries("blah1"))) {
            ++failCount;
        }
        if (m.find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)".+$", (int)8)).matcher((CharSequence)RegExTest.toSupplementaries("blah1\r\n"))).find()) {
            ++failCount;
        }
        if (m.find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)".+$", (int)8)).matcher((CharSequence)RegExTest.toSupplementaries("blah1\u0085"))).find()) {
            ++failCount;
        }
        RegExTest.report("Anchors");
    }

    private static void lookingAtTest() {
        Pattern p = Pattern.compile((String)"(ab)(c*)");
        Matcher m = p.matcher((CharSequence)"abccczzzabcczzzabccc");
        if (!m.lookingAt()) {
            ++failCount;
        }
        if (!m.group().equals(m.group(0))) {
            ++failCount;
        }
        if ((m = p.matcher((CharSequence)"zzzabccczzzabcczzzabccczzz")).lookingAt()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(c*)"))).matcher((CharSequence)RegExTest.toSupplementaries("abccczzzabcczzzabccc"))).lookingAt()) {
            ++failCount;
        }
        if (!m.group().equals(m.group(0))) {
            ++failCount;
        }
        if ((m = p.matcher((CharSequence)RegExTest.toSupplementaries("zzzabccczzzabcczzzabccczzz"))).lookingAt()) {
            ++failCount;
        }
        RegExTest.report("Looking At");
    }

    private static void matchesTest() {
        Pattern p = Pattern.compile((String)"ulb(c*)");
        Matcher m = p.matcher((CharSequence)"ulbcccccc");
        if (!m.matches()) {
            ++failCount;
        }
        m.reset((CharSequence)"zzzulbcccccc");
        if (m.matches()) {
            ++failCount;
        }
        m.reset((CharSequence)"ulbccccccdef");
        if (m.matches()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)"a|ad")).matcher((CharSequence)"ad")).matches()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)RegExTest.toSupplementaries("ulb(c*)"))).matcher((CharSequence)RegExTest.toSupplementaries("ulbcccccc"))).matches()) {
            ++failCount;
        }
        m.reset((CharSequence)RegExTest.toSupplementaries("zzzulbcccccc"));
        if (m.matches()) {
            ++failCount;
        }
        m.reset((CharSequence)RegExTest.toSupplementaries("ulbccccccdef"));
        if (m.matches()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)RegExTest.toSupplementaries("a|ad"))).matcher((CharSequence)RegExTest.toSupplementaries("ad"))).matches()) {
            ++failCount;
        }
        RegExTest.report("Matches");
    }

    private static void patternMatchesTest() {
        if (!Pattern.matches((String)RegExTest.toSupplementaries("ulb(c*)"), (CharSequence)RegExTest.toSupplementaries("ulbcccccc"))) {
            ++failCount;
        }
        if (Pattern.matches((String)RegExTest.toSupplementaries("ulb(c*)"), (CharSequence)RegExTest.toSupplementaries("zzzulbcccccc"))) {
            ++failCount;
        }
        if (Pattern.matches((String)RegExTest.toSupplementaries("ulb(c*)"), (CharSequence)RegExTest.toSupplementaries("ulbccccccdef"))) {
            ++failCount;
        }
        if (!Pattern.matches((String)RegExTest.toSupplementaries("ulb(c*)"), (CharSequence)RegExTest.toSupplementaries("ulbcccccc"))) {
            ++failCount;
        }
        if (Pattern.matches((String)RegExTest.toSupplementaries("ulb(c*)"), (CharSequence)RegExTest.toSupplementaries("zzzulbcccccc"))) {
            ++failCount;
        }
        if (Pattern.matches((String)RegExTest.toSupplementaries("ulb(c*)"), (CharSequence)RegExTest.toSupplementaries("ulbccccccdef"))) {
            ++failCount;
        }
        RegExTest.report("Pattern Matches");
    }

    private static void ceTest() {
        Pattern p = Pattern.compile((String)"testa\u030a", (int)128);
        Matcher m = p.matcher((CharSequence)"test\u00e5");
        if (!m.matches()) {
            ++failCount;
        }
        m.reset((CharSequence)"testa\u030a");
        if (!m.matches()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)"test\u00e5", (int)128)).matcher((CharSequence)"test\u00e5")).matches()) {
            ++failCount;
        }
        m.reset((CharSequence)"testa\u030a");
        if (!m.find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)"test[abca\u030a]", (int)128)).matcher((CharSequence)"test\u00e5")).find()) {
            ++failCount;
        }
        m.reset((CharSequence)"testa\u030a");
        if (!m.find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)"test[abc\u00e5def\u00e0]", (int)128)).matcher((CharSequence)"test\u00e5")).find()) {
            ++failCount;
        }
        m.reset((CharSequence)"testa\u0300");
        if (!m.find()) {
            ++failCount;
        }
        m.reset((CharSequence)"testa\u030a");
        if (!m.find()) {
            ++failCount;
        }
        p = Pattern.compile((String)"testa\u0308\u0300", (int)128);
        RegExTest.check(p, "testa\u0308\u0300", true);
        RegExTest.check(p, "testa\u0300\u0308", false);
        p = Pattern.compile((String)"testa\u0308\u0323", (int)128);
        RegExTest.check(p, "testa\u0308\u0323", true);
        RegExTest.check(p, "testa\u0323\u0308", true);
        p = Pattern.compile((String)"testa\u0308\u0323\u0300", (int)128);
        RegExTest.check(p, "testa\u0308\u0323\u0300", true);
        RegExTest.check(p, "testa\u0323\u0308\u0300", true);
        RegExTest.check(p, "testa\u0308\u0300\u0323", true);
        RegExTest.check(p, "test\u00e4\u0323\u0300", true);
        RegExTest.check(p, "test\u00e4\u0300\u0323", true);
        RegExTest.report("Canonical Equivalence");
    }

    private static void globalSubstitute() {
        Pattern p = Pattern.compile((String)"(ab)(c*)");
        Matcher m = p.matcher((CharSequence)"abccczzzabcczzzabccc");
        if (!m.replaceAll("test").equals("testzzztestzzztest")) {
            ++failCount;
        }
        m.reset((CharSequence)"zzzabccczzzabcczzzabccczzz");
        if (!m.replaceAll("test").equals("zzztestzzztestzzztestzzz")) {
            ++failCount;
        }
        m.reset((CharSequence)"zzzabccczzzabcczzzabccczzz");
        String result = m.replaceAll("$1");
        if (!result.equals("zzzabzzzabzzzabzzz")) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(c*)"))).matcher((CharSequence)RegExTest.toSupplementaries("abccczzzabcczzzabccc"))).replaceAll(RegExTest.toSupplementaries("test")).equals(RegExTest.toSupplementaries("testzzztestzzztest"))) {
            ++failCount;
        }
        m.reset((CharSequence)RegExTest.toSupplementaries("zzzabccczzzabcczzzabccczzz"));
        if (!m.replaceAll(RegExTest.toSupplementaries("test")).equals(RegExTest.toSupplementaries("zzztestzzztestzzztestzzz"))) {
            ++failCount;
        }
        m.reset((CharSequence)RegExTest.toSupplementaries("zzzabccczzzabcczzzabccczzz"));
        result = m.replaceAll("$1");
        if (!result.equals(RegExTest.toSupplementaries("zzzabzzzabzzzabzzz"))) {
            ++failCount;
        }
        RegExTest.report("Global Substitution");
    }

    private static void stringbufferSubstitute() {
        block48: {
            String blah = "zzzblahzzz";
            Pattern p = Pattern.compile((String)"blah");
            Matcher m = p.matcher((CharSequence)blah);
            StringBuffer result = new StringBuffer();
            try {
                m.appendReplacement(result, "blech");
                ++failCount;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            m.find();
            m.appendReplacement(result, "blech");
            if (!result.toString().equals("zzzblech")) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals("zzzblechzzz")) {
                ++failCount;
            }
            blah = "zzzabcdzzz";
            p = Pattern.compile((String)"(ab)(cd)*");
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            try {
                m.appendReplacement(result, "$1");
                ++failCount;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            m.find();
            m.appendReplacement(result, "$1");
            if (!result.toString().equals("zzzab")) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals("zzzabzzz")) {
                ++failCount;
            }
            blah = "zzzabcdcdefzzz";
            p = Pattern.compile((String)"(ab)(cd)*(ef)");
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            try {
                m.appendReplacement(result, "$1w$2w$3");
                ++failCount;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            m.find();
            m.appendReplacement(result, "$1w$2w$3");
            if (!result.toString().equals("zzzabwcdwef")) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals("zzzabwcdwefzzz")) {
                ++failCount;
            }
            blah = "zzzabcdzzzabcddzzzabcdzzz";
            p = Pattern.compile((String)"(ab)(cd*)");
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            try {
                m.appendReplacement(result, "$1");
                ++failCount;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            m.find();
            m.appendReplacement(result, "$1");
            if (!result.toString().equals("zzzab")) {
                ++failCount;
            }
            m.find();
            m.find();
            m.appendReplacement(result, "$2");
            if (!result.toString().equals("zzzabzzzabcddzzzcd")) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals("zzzabzzzabcddzzzcdzzz")) {
                ++failCount;
            }
            blah = "zzzabcdcdefzzz";
            p = Pattern.compile((String)"(ab)(cd)*(ef)");
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            m.find();
            m.appendReplacement(result, "$1w\\$2w$3");
            if (!result.toString().equals("zzzabw$2wef")) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals("zzzabw$2wefzzz")) {
                ++failCount;
            }
            blah = "zzzabcdcdefzzz";
            p = Pattern.compile((String)"(ab)(cd)*(ef)");
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            m.find();
            try {
                m.appendReplacement(result, "$1w$5w$3");
                ++failCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            blah = "zzz123456789101112zzz";
            p = Pattern.compile((String)"(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)");
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            m.find();
            m.appendReplacement(result, "$1w$11w$3");
            if (!result.toString().equals("zzz1w11w3")) {
                ++failCount;
            }
            blah = "zzzabcdcdefzzz";
            p = Pattern.compile((String)"(ab)(cd)*(ef)");
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            m.find();
            m.appendReplacement(result, "$1w$15w$3");
            if (!result.toString().equals("zzzabwab5wef")) {
                ++failCount;
            }
            blah = RegExTest.toSupplementaries("zzzblahzzz");
            p = Pattern.compile((String)RegExTest.toSupplementaries("blah"));
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            try {
                m.appendReplacement(result, RegExTest.toSupplementaries("blech"));
                ++failCount;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            m.find();
            m.appendReplacement(result, RegExTest.toSupplementaries("blech"));
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzblech"))) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzblechzzz"))) {
                ++failCount;
            }
            blah = RegExTest.toSupplementaries("zzzabcdzzz");
            p = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(cd)*"));
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            try {
                m.appendReplacement(result, "$1");
                ++failCount;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            m.find();
            m.appendReplacement(result, "$1");
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzab"))) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzabzzz"))) {
                ++failCount;
            }
            blah = RegExTest.toSupplementaries("zzzabcdcdefzzz");
            p = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(cd)*(ef)"));
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            try {
                m.appendReplacement(result, RegExTest.toSupplementaries("$1w$2w$3"));
                ++failCount;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            m.find();
            m.appendReplacement(result, RegExTest.toSupplementaries("$1w$2w$3"));
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzabwcdwef"))) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzabwcdwefzzz"))) {
                ++failCount;
            }
            blah = RegExTest.toSupplementaries("zzzabcdzzzabcddzzzabcdzzz");
            p = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(cd*)"));
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            try {
                m.appendReplacement(result, "$1");
                ++failCount;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            m.find();
            m.appendReplacement(result, "$1");
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzab"))) {
                ++failCount;
            }
            m.find();
            m.find();
            m.appendReplacement(result, "$2");
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzabzzzabcddzzzcd"))) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzabzzzabcddzzzcdzzz"))) {
                ++failCount;
            }
            blah = RegExTest.toSupplementaries("zzzabcdcdefzzz");
            p = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(cd)*(ef)"));
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            m.find();
            m.appendReplacement(result, RegExTest.toSupplementaries("$1w\\$2w$3"));
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzabw$2wef"))) {
                ++failCount;
            }
            m.appendTail(result);
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzabw$2wefzzz"))) {
                ++failCount;
            }
            blah = RegExTest.toSupplementaries("zzzabcdcdefzzz");
            p = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(cd)*(ef)"));
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            m.find();
            try {
                m.appendReplacement(result, RegExTest.toSupplementaries("$1w$5w$3"));
                ++failCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            blah = RegExTest.toSupplementaries("zzz123456789101112zzz");
            p = Pattern.compile((String)"(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)");
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            m.find();
            m.appendReplacement(result, RegExTest.toSupplementaries("$1w$11w$3"));
            if (!result.toString().equals(RegExTest.toSupplementaries("zzz1w11w3"))) {
                ++failCount;
            }
            blah = RegExTest.toSupplementaries("zzzabcdcdefzzz");
            p = Pattern.compile((String)RegExTest.toSupplementaries("(ab)(cd)*(ef)"));
            m = p.matcher((CharSequence)blah);
            result = new StringBuffer();
            m.find();
            m.appendReplacement(result, RegExTest.toSupplementaries("$1w$15w$3"));
            if (!result.toString().equals(RegExTest.toSupplementaries("zzzabwab5wef"))) {
                ++failCount;
            }
            p = Pattern.compile((String)"(abc)");
            m = p.matcher((CharSequence)"abcd");
            result = new StringBuffer();
            m.find();
            try {
                m.appendReplacement(result, "xyz$g");
                ++failCount;
            }
            catch (IllegalArgumentException iae) {
                if (result.length() == 0) break block48;
                ++failCount;
            }
        }
        RegExTest.report("SB Substitution");
    }

    private static void substitutionBasher() {
        for (int runs = 0; runs < 1000; ++runs) {
            int leadingChars = generator.nextInt(10);
            StringBuilder baseBuffer = new StringBuilder(100);
            String leadingString = RegExTest.getRandomAlphaString(leadingChars);
            baseBuffer.append(leadingString);
            StringBuilder bufferToSub = new StringBuilder(25);
            StringBuilder bufferToPat = new StringBuilder(50);
            String[] groups = new String[5];
            for (int i = 0; i < 5; ++i) {
                int aGroupSize = generator.nextInt(5) + 1;
                groups[i] = RegExTest.getRandomAlphaString(aGroupSize);
                bufferToSub.append(groups[i]);
                bufferToPat.append('(');
                bufferToPat.append(groups[i]);
                bufferToPat.append(')');
            }
            String stringToSub = bufferToSub.toString();
            String pattern = bufferToPat.toString();
            baseBuffer.append(stringToSub);
            int trailingChars = generator.nextInt(10);
            String trailingString = RegExTest.getRandomAlphaString(trailingChars);
            baseBuffer.append(trailingString);
            String baseString = baseBuffer.toString();
            Pattern p = Pattern.compile((String)pattern);
            Matcher m = p.matcher((CharSequence)baseString);
            m.find();
            if (m.start() < leadingChars || m.find()) continue;
            StringBuilder bufferToRep = new StringBuilder();
            int groupIndex1 = generator.nextInt(5);
            bufferToRep.append("$").append(groupIndex1 + 1);
            String randomMidString = RegExTest.getRandomAlphaString(5);
            bufferToRep.append(randomMidString);
            int groupIndex2 = generator.nextInt(5);
            bufferToRep.append("$").append(groupIndex2 + 1);
            String replacement = bufferToRep.toString();
            String result = m.replaceAll(replacement);
            String expectedResult = leadingString + groups[groupIndex1] + randomMidString + groups[groupIndex2] + trailingString;
            if (result.equals(expectedResult)) continue;
            ++failCount;
        }
        RegExTest.report("Substitution Basher");
    }

    private static void escapes() {
        Pattern p = Pattern.compile((String)"\\043");
        Matcher m = p.matcher((CharSequence)"#");
        if (!m.find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)"\\x23")).matcher((CharSequence)"#")).find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)"\\u0023")).matcher((CharSequence)"#")).find()) {
            ++failCount;
        }
        RegExTest.report("Escape sequences");
    }

    private static void blankInput() {
        Pattern p = Pattern.compile((String)"abc", (int)2);
        Matcher m = p.matcher((CharSequence)"");
        if (m.find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)"a*", (int)2)).matcher((CharSequence)"")).find()) {
            ++failCount;
        }
        if ((m = (p = Pattern.compile((String)"abc")).matcher((CharSequence)"")).find()) {
            ++failCount;
        }
        if (!(m = (p = Pattern.compile((String)"a*")).matcher((CharSequence)"")).find()) {
            ++failCount;
        }
        RegExTest.report("Blank input");
    }

    private static void bm() {
        RegExTest.doBnM(97);
        RegExTest.report("Boyer Moore (ASCII)");
        RegExTest.doBnM(65526);
        RegExTest.report("Boyer Moore (Supplementary)");
    }

    /*
     * Unable to fully structure code
     */
    private static void doBnM(int baseCharacter) {
        achar = false;
        for (i = 0; i < 100; ++i) {
            patternLength = RegExTest.generator.nextInt(7) + 4;
            patternBuffer = new StringBuilder(patternLength);
            while (true) {
                for (x = 0; x < patternLength; ++x) {
                    ch = baseCharacter + RegExTest.generator.nextInt(26);
                    if (Character.isSupplementaryCodePoint(ch)) {
                        patternBuffer.append(Character.toChars(ch));
                        continue;
                    }
                    patternBuffer.append((char)ch);
                }
                pattern = patternBuffer.toString();
                for (x = 1; x < patternLength; ++x) {
                    if (pattern.startsWith(pattern.substring(x))) ** continue;
                }
                break;
            }
            p = Pattern.compile((String)pattern);
            toSearch = null;
            s = null;
            m = p.matcher((CharSequence)"");
            do {
                s = new StringBuffer(100);
                for (x = 0; x < 100; ++x) {
                    ch = baseCharacter + RegExTest.generator.nextInt(26);
                    if (Character.isSupplementaryCodePoint(ch)) {
                        s.append(Character.toChars(ch));
                        continue;
                    }
                    s.append((char)ch);
                }
                toSearch = s.toString();
                m.reset((CharSequence)toSearch);
            } while (m.find());
            insertIndex = RegExTest.generator.nextInt(99);
            if (Character.isLowSurrogate(s.charAt(insertIndex))) {
                ++insertIndex;
            }
            s = s.insert(insertIndex, pattern);
            toSearch = s.toString();
            m.reset((CharSequence)toSearch);
            if (!m.find()) {
                ++RegExTest.failCount;
            }
            if (!m.group().equals(pattern)) {
                ++RegExTest.failCount;
            }
            if (m.start() == insertIndex) continue;
            ++RegExTest.failCount;
        }
    }

    private static void slice() {
        RegExTest.doSlice(65535);
        RegExTest.report("Slice");
        RegExTest.doSlice(0x10FFFF);
        RegExTest.report("Slice (Supplementary)");
    }

    private static void doSlice(int maxCharacter) {
        Random generator = new Random();
        boolean achar = false;
        for (int i = 0; i < 100; ++i) {
            int patternLength = generator.nextInt(7) + 4;
            StringBuilder patternBuffer = new StringBuilder(patternLength);
            for (int x = 0; x < patternLength; ++x) {
                int randomChar = 0;
                while (!Character.isLetterOrDigit(randomChar)) {
                    randomChar = generator.nextInt(maxCharacter);
                }
                if (Character.isSupplementaryCodePoint(randomChar)) {
                    patternBuffer.append(Character.toChars(randomChar));
                    continue;
                }
                patternBuffer.append((char)randomChar);
            }
            String pattern = patternBuffer.toString();
            Pattern p = Pattern.compile((String)pattern, (int)64);
            String toSearch = null;
            StringBuffer s = null;
            Matcher m = p.matcher((CharSequence)"");
            do {
                s = new StringBuffer(100);
                for (int x = 0; x < 100; ++x) {
                    int randomChar = 0;
                    while (!Character.isLetterOrDigit(randomChar)) {
                        randomChar = generator.nextInt(maxCharacter);
                    }
                    if (Character.isSupplementaryCodePoint(randomChar)) {
                        s.append(Character.toChars(randomChar));
                        continue;
                    }
                    s.append((char)randomChar);
                }
                toSearch = s.toString();
                m.reset((CharSequence)toSearch);
            } while (m.find());
            int insertIndex = generator.nextInt(99);
            if (Character.isLowSurrogate(s.charAt(insertIndex))) {
                ++insertIndex;
            }
            s = s.insert(insertIndex, pattern);
            toSearch = s.toString();
            m.reset((CharSequence)toSearch);
            if (!m.find()) {
                ++failCount;
            }
            if (!m.group().equals(pattern)) {
                ++failCount;
            }
            if (m.start() == insertIndex) continue;
            ++failCount;
        }
    }

    private static void explainFailure(String pattern, String data, String expected, String actual) {
        System.err.println("----------------------------------------");
        System.err.println("Pattern = " + pattern);
        System.err.println("Data = " + data);
        System.err.println("Expected = " + expected);
        System.err.println("Actual   = " + actual);
    }

    private static void explainFailure(String pattern, String data, Throwable t) {
        System.err.println("----------------------------------------");
        System.err.println("Pattern = " + pattern);
        System.err.println("Data = " + data);
        t.printStackTrace(System.err);
    }

    private static void processFile(String fileName) throws Exception {
        String aLine;
        File testCases = new File(System.getProperty("test.src", "."), fileName);
        FileInputStream in = new FileInputStream(testCases);
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        while ((aLine = r.readLine()) != null) {
            String patternString = RegExTest.grabLine(r);
            Pattern p = null;
            try {
                p = RegExTest.compileTestPattern(patternString);
            }
            catch (PatternSyntaxException e) {
                String dataString = RegExTest.grabLine(r);
                String expectedResult = RegExTest.grabLine(r);
                if (expectedResult.startsWith("error")) continue;
                RegExTest.explainFailure(patternString, dataString, e);
                ++failCount;
                continue;
            }
            String dataString = RegExTest.grabLine(r);
            Matcher m = p.matcher((CharSequence)dataString);
            StringBuilder result = new StringBuilder();
            failCount += RegExTest.preMatchInvariants(m);
            boolean found = m.find();
            failCount = found ? (failCount += RegExTest.postTrueMatchInvariants(m)) : (failCount += RegExTest.postFalseMatchInvariants(m));
            if (found) {
                result.append("true ");
                result.append(m.group(0)).append(" ");
            } else {
                result.append("false ");
            }
            result.append(m.groupCount());
            if (found) {
                for (int i = 1; i < m.groupCount() + 1; ++i) {
                    if (m.group(i) == null) continue;
                    result.append(" ").append(m.group(i));
                }
            }
            String expectedResult = RegExTest.grabLine(r);
            if (result.toString().equals(expectedResult)) continue;
            RegExTest.explainFailure(patternString, dataString, expectedResult, result.toString());
            ++failCount;
        }
        RegExTest.report(fileName);
    }

    private static int preMatchInvariants(Matcher m) {
        int failCount = 0;
        try {
            m.start();
            ++failCount;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            m.end();
            ++failCount;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            m.group();
            ++failCount;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return failCount;
    }

    private static int postFalseMatchInvariants(Matcher m) {
        int failCount = 0;
        try {
            m.group();
            ++failCount;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            m.start();
            ++failCount;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            m.end();
            ++failCount;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return failCount;
    }

    private static int postTrueMatchInvariants(Matcher m) {
        int failCount = 0;
        if (m.start() != m.start(0)) {
            ++failCount;
        }
        if (m.start() != m.start(0)) {
            ++failCount;
        }
        if (!m.group().equals(m.group(0))) {
            ++failCount;
        }
        try {
            m.group(50);
            ++failCount;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return failCount;
    }

    private static Pattern compileTestPattern(String patternString) {
        if (!patternString.startsWith("'")) {
            return Pattern.compile((String)patternString);
        }
        int break1 = patternString.lastIndexOf("'");
        String flagString = patternString.substring(break1 + 1);
        patternString = patternString.substring(1, break1);
        if (flagString.equals("i")) {
            return Pattern.compile((String)patternString, (int)2);
        }
        if (flagString.equals("m")) {
            return Pattern.compile((String)patternString, (int)8);
        }
        return Pattern.compile((String)patternString);
    }

    private static String grabLine(BufferedReader r) throws Exception {
        StringBuilder temp;
        int index = 0;
        String line = r.readLine();
        while (line.startsWith("//") || line.length() < 1) {
            line = r.readLine();
        }
        while ((index = line.indexOf("\\n")) != -1) {
            temp = new StringBuilder(line);
            temp.replace(index, index + 2, "\n");
            line = temp.toString();
        }
        while ((index = line.indexOf("\\u")) != -1) {
            temp = new StringBuilder(line);
            String value = temp.substring(index + 2, index + 6);
            char aChar = (char)Integer.parseInt(value, 16);
            String unicodeChar = "" + aChar;
            temp.replace(index, index + 6, unicodeChar);
            line = temp.toString();
        }
        return line;
    }

    private static void check(Pattern p, String s, String g, String expected) {
        Matcher m = p.matcher((CharSequence)s);
        m.find();
        if (!m.group(g).equals(expected) || s.charAt(m.start(g)) != expected.charAt(0) || s.charAt(m.end(g) - 1) != expected.charAt(expected.length() - 1)) {
            ++failCount;
        }
    }

    private static void checkReplaceFirst(String p, String s, String r, String expected) {
        if (!expected.equals(Pattern.compile((String)p).matcher((CharSequence)s).replaceFirst(r))) {
            ++failCount;
        }
    }

    private static void checkReplaceAll(String p, String s, String r, String expected) {
        if (!expected.equals(Pattern.compile((String)p).matcher((CharSequence)s).replaceAll(r))) {
            ++failCount;
        }
    }

    private static void checkExpectedFail(String p) {
        try {
            Pattern.compile((String)p);
        }
        catch (PatternSyntaxException pse) {
            return;
        }
        ++failCount;
    }

    private static void checkExpectedIAE(Matcher m, String g) {
        m.find();
        try {
            m.group(g);
        }
        catch (IllegalArgumentException x) {
            try {
                m.start(g);
            }
            catch (IllegalArgumentException xx) {
                try {
                    m.start(g);
                }
                catch (IllegalArgumentException xxx) {
                    return;
                }
            }
        }
        ++failCount;
    }

    private static void checkExpectedNPE(Matcher m) {
        m.find();
        try {
            m.group(null);
        }
        catch (NullPointerException x) {
            try {
                m.start(null);
            }
            catch (NullPointerException xx) {
                try {
                    m.end(null);
                }
                catch (NullPointerException xxx) {
                    return;
                }
            }
        }
        ++failCount;
    }

    private static void namedGroupCaptureTest() {
        RegExTest.check(Pattern.compile((String)"x+(?<gname>y+)z+"), "xxxyyyzzz", "gname", "yyy");
        RegExTest.check(Pattern.compile((String)"x+(?<gname8>y+)z+"), "xxxyyyzzz", "gname8", "yyy");
        Pattern pattern = Pattern.compile((String)"(a*)bc\\1");
        RegExTest.check(pattern, "zzzaabcazzz", true);
        RegExTest.check(Pattern.compile((String)"(?<gname>a*)bc\\k<gname>"), "zzzaabcaazzz", true);
        RegExTest.check(Pattern.compile((String)"(?<gname>abc)(def)\\k<gname>"), "abcdefabc", true);
        RegExTest.check(Pattern.compile((String)"(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(?<gname>k)\\k<gname>"), "abcdefghijkk", true);
        RegExTest.check(Pattern.compile((String)("(?<gname>" + RegExTest.toSupplementaries("a*)bc") + "\\k<gname>")), RegExTest.toSupplementaries("zzzaabcazzz"), true);
        RegExTest.check(Pattern.compile((String)("(?<gname>" + RegExTest.toSupplementaries("a*)bc") + "\\k<gname>")), RegExTest.toSupplementaries("zzzaabcaazzz"), true);
        RegExTest.check(Pattern.compile((String)("(?<gname>" + RegExTest.toSupplementaries("abc)(def)") + "\\k<gname>")), RegExTest.toSupplementaries("abcdefabc"), true);
        RegExTest.check(Pattern.compile((String)(RegExTest.toSupplementaries("(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)") + "(?<gname>" + RegExTest.toSupplementaries("k)") + "\\k<gname>")), RegExTest.toSupplementaries("abcdefghijkk"), true);
        RegExTest.check(Pattern.compile((String)"x+(?<gname>y+)z+\\k<gname>"), "xxxyyyzzzyyy", "gname", "yyy");
        RegExTest.checkReplaceFirst("(?<gn>ab)(c*)", "abccczzzabcczzzabccc", "${gn}", "abzzzabcczzzabccc");
        RegExTest.checkReplaceAll("(?<gn>ab)(c*)", "abccczzzabcczzzabccc", "${gn}", "abzzzabzzzab");
        RegExTest.checkReplaceFirst("(?<gn>ab)(c*)", "zzzabccczzzabcczzzabccczzz", "${gn}", "zzzabzzzabcczzzabccczzz");
        RegExTest.checkReplaceAll("(?<gn>ab)(c*)", "zzzabccczzzabcczzzabccczzz", "${gn}", "zzzabzzzabzzzabzzz");
        RegExTest.checkReplaceFirst("(?<gn1>ab)(?<gn2>c*)", "zzzabccczzzabcczzzabccczzz", "${gn2}", "zzzccczzzabcczzzabccczzz");
        RegExTest.checkReplaceAll("(?<gn1>ab)(?<gn2>c*)", "zzzabccczzzabcczzzabccczzz", "${gn2}", "zzzccczzzcczzzccczzz");
        RegExTest.checkReplaceFirst("(?<gn1>" + RegExTest.toSupplementaries("ab") + ")(?<gn2>" + RegExTest.toSupplementaries("c") + "*)", RegExTest.toSupplementaries("abccczzzabcczzzabccc"), "${gn1}", RegExTest.toSupplementaries("abzzzabcczzzabccc"));
        RegExTest.checkReplaceAll("(?<gn1>" + RegExTest.toSupplementaries("ab") + ")(?<gn2>" + RegExTest.toSupplementaries("c") + "*)", RegExTest.toSupplementaries("abccczzzabcczzzabccc"), "${gn1}", RegExTest.toSupplementaries("abzzzabzzzab"));
        RegExTest.checkReplaceFirst("(?<gn1>" + RegExTest.toSupplementaries("ab") + ")(?<gn2>" + RegExTest.toSupplementaries("c") + "*)", RegExTest.toSupplementaries("abccczzzabcczzzabccc"), "${gn2}", RegExTest.toSupplementaries("ccczzzabcczzzabccc"));
        RegExTest.checkReplaceAll("(?<gn1>" + RegExTest.toSupplementaries("ab") + ")(?<gn2>" + RegExTest.toSupplementaries("c") + "*)", RegExTest.toSupplementaries("abccczzzabcczzzabccc"), "${gn2}", RegExTest.toSupplementaries("ccczzzcczzzccc"));
        RegExTest.checkReplaceFirst("(?<dog>Dog)AndCat", "zzzDogAndCatzzzDogAndCatzzz", "${dog}", "zzzDogzzzDogAndCatzzz");
        RegExTest.checkReplaceAll("(?<dog>Dog)AndCat", "zzzDogAndCatzzzDogAndCatzzz", "${dog}", "zzzDogzzzDogzzz");
        if (!"abcdefghij".replaceFirst("cd(?<gn>ef)gh", "${gn}").equals("abefij") || !"abbbcbdbefgh".replaceAll("(?<gn>[a-e])b", "${gn}").equals("abcdefgh")) {
            ++failCount;
        }
        RegExTest.checkExpectedFail("(?<groupnamehasnoascii.in>abc)(def)");
        RegExTest.checkExpectedFail("(?<groupnamehasnoascii_in>abc)(def)");
        RegExTest.checkExpectedFail("(?<6groupnamestartswithdigit>abc)(def)");
        RegExTest.checkExpectedFail("(?<gname>abc)(def)\\k<gnameX>");
        RegExTest.checkExpectedFail("(?<gname>abc)(?<gname>def)\\k<gnameX>");
        RegExTest.checkExpectedIAE(Pattern.compile((String)"(?<gname>abc)(def)").matcher((CharSequence)"abcdef"), "gnameX");
        RegExTest.checkExpectedNPE(Pattern.compile((String)"(?<gname>abc)(def)").matcher((CharSequence)"abcdef"));
        RegExTest.report("NamedGroupCapture");
    }

    private static void nonBmpClassComplementTest() {
        Pattern p = Pattern.compile((String)"\\P{Lu}");
        Matcher m = p.matcher((CharSequence)new String(new int[]{119808}, 0, 1));
        if (m.find() && m.start() == 1) {
            ++failCount;
        }
        if ((m = (p = Pattern.compile((String)"\\P{Lu}")).matcher((CharSequence)new String(new int[]{119808}, 0, 1))).find()) {
            ++failCount;
        }
        if (!m.hitEnd()) {
            ++failCount;
        }
        if ((m = (p = Pattern.compile((String)"\\P{InMathematicalAlphanumericSymbols}")).matcher((CharSequence)new String(new int[]{119808}, 0, 1))).find() && m.start() == 1) {
            ++failCount;
        }
        RegExTest.report("NonBmpClassComplement");
    }

    private static void unicodePropertiesTest() {
        if (!(Pattern.compile((String)"\\p{IsLu}").matcher((CharSequence)"A").matches() && Pattern.compile((String)"\\p{Lu}").matcher((CharSequence)"A").matches() && Pattern.compile((String)"\\p{gc=Lu}").matcher((CharSequence)"A").matches() && Pattern.compile((String)"\\p{general_category=Lu}").matcher((CharSequence)"A").matches() && Pattern.compile((String)"\\p{IsLatin}").matcher((CharSequence)"B").matches() && Pattern.compile((String)"\\p{sc=Latin}").matcher((CharSequence)"B").matches() && Pattern.compile((String)"\\p{script=Latin}").matcher((CharSequence)"B").matches() && Pattern.compile((String)"\\p{InBasicLatin}").matcher((CharSequence)"c").matches() && Pattern.compile((String)"\\p{blk=BasicLatin}").matcher((CharSequence)"c").matches() && Pattern.compile((String)"\\p{block=BasicLatin}").matcher((CharSequence)"c").matches())) {
            ++failCount;
        }
        Matcher common = Pattern.compile((String)"\\p{script=Common}").matcher((CharSequence)"");
        Matcher unknown = Pattern.compile((String)"\\p{IsUnknown}").matcher((CharSequence)"");
        Matcher lastSM = common;
        Character.UnicodeScript lastScript = Character.UnicodeScript.of(0);
        Matcher latin = Pattern.compile((String)"\\p{block=basic_latin}").matcher((CharSequence)"");
        Matcher greek = Pattern.compile((String)"\\p{InGreek}").matcher((CharSequence)"");
        Matcher lastBM = latin;
        Character.UnicodeBlock lastBlock = Character.UnicodeBlock.of(0);
        for (int cp = 1; cp < 0x10FFFF; ++cp) {
            Matcher m;
            if (cp >= 196608 && (cp & 0x70) == 0) continue;
            Character.UnicodeScript script = Character.UnicodeScript.of(cp);
            String str = new String(Character.toChars(cp));
            if (script == lastScript) {
                m = lastSM;
                m.reset((CharSequence)str);
            } else {
                m = Pattern.compile((String)("\\p{Is" + script.name() + "}")).matcher((CharSequence)str);
            }
            if (!m.matches()) {
                ++failCount;
            }
            Matcher other = script == Character.UnicodeScript.COMMON ? unknown : common;
            other.reset((CharSequence)str);
            if (other.matches()) {
                ++failCount;
            }
            lastSM = m;
            lastScript = script;
            Character.UnicodeBlock block = Character.UnicodeBlock.of(cp);
            if (block == null) continue;
            if (block == lastBlock) {
                m = lastBM;
                m.reset((CharSequence)str);
            } else {
                m = Pattern.compile((String)("\\p{block=" + block.toString() + "}")).matcher((CharSequence)str);
            }
            if (!m.matches()) {
                ++failCount;
            }
            other = block == Character.UnicodeBlock.BASIC_LATIN ? greek : latin;
            other.reset((CharSequence)str);
            if (other.matches()) {
                ++failCount;
            }
            lastBM = m;
            lastBlock = block;
        }
        RegExTest.report("unicodeProperties");
    }

    private static void unicodeHexNotationTest() {
        RegExTest.checkExpectedFail("\\x{-23}");
        RegExTest.checkExpectedFail("\\x{110000}");
        RegExTest.checkExpectedFail("\\x{}");
        RegExTest.checkExpectedFail("\\x{AB[ef]");
        RegExTest.check("^\\x{1033c}$", "\ud800\udf3c", true);
        RegExTest.check("^\\xF0\\x90\\x8C\\xBC$", "\ud800\udf3c", false);
        RegExTest.check("^\\x{D800}\\x{DF3c}+$", "\ud800\udf3c", false);
        RegExTest.check("^\\xF0\\x90\\x8C\\xBC$", "\ud800\udf3c", false);
        RegExTest.check("^[\\x{D800}\\x{DF3c}]+$", "\ud800\udf3c", false);
        RegExTest.check("^[\\xF0\\x90\\x8C\\xBC]+$", "\ud800\udf3c", false);
        RegExTest.check("^[\\x{D800}\\x{DF3C}]+$", "\ud800\udf3c", false);
        RegExTest.check("^[\\x{DF3C}\\x{D800}]+$", "\ud800\udf3c", false);
        RegExTest.check("^[\\x{D800}\\x{DF3C}]+$", "\udf3c\ud800", true);
        RegExTest.check("^[\\x{DF3C}\\x{D800}]+$", "\udf3c\ud800", true);
        for (int cp = 0; cp <= 0x10FFFF; ++cp) {
            String s = "A" + new String(Character.toChars(cp)) + "B";
            String hexUTF16 = cp <= 65535 ? String.format("\\u%04x", cp) : String.format("\\u%04x\\u%04x", Character.toChars(cp)[0], (int)Character.toChars(cp)[1]);
            String hexCodePoint = "\\x{" + Integer.toHexString(cp) + "}";
            if (!Pattern.matches((String)("A" + hexUTF16 + "B"), (CharSequence)s)) {
                ++failCount;
            }
            if (!Pattern.matches((String)("A[" + hexUTF16 + "]B"), (CharSequence)s)) {
                ++failCount;
            }
            if (!Pattern.matches((String)("A" + hexCodePoint + "B"), (CharSequence)s)) {
                ++failCount;
            }
            if (Pattern.matches((String)("A[" + hexCodePoint + "]B"), (CharSequence)s)) continue;
            ++failCount;
        }
        RegExTest.report("unicodeHexNotation");
    }

    private static void unicodeClassesTest() {
        Matcher lower = Pattern.compile((String)"\\p{Lower}").matcher((CharSequence)"");
        Matcher upper = Pattern.compile((String)"\\p{Upper}").matcher((CharSequence)"");
        Matcher ASCII = Pattern.compile((String)"\\p{ASCII}").matcher((CharSequence)"");
        Matcher alpha = Pattern.compile((String)"\\p{Alpha}").matcher((CharSequence)"");
        Matcher digit = Pattern.compile((String)"\\p{Digit}").matcher((CharSequence)"");
        Matcher alnum = Pattern.compile((String)"\\p{Alnum}").matcher((CharSequence)"");
        Matcher punct = Pattern.compile((String)"\\p{Punct}").matcher((CharSequence)"");
        Matcher graph = Pattern.compile((String)"\\p{Graph}").matcher((CharSequence)"");
        Matcher print = Pattern.compile((String)"\\p{Print}").matcher((CharSequence)"");
        Matcher blank = Pattern.compile((String)"\\p{Blank}").matcher((CharSequence)"");
        Matcher cntrl = Pattern.compile((String)"\\p{Cntrl}").matcher((CharSequence)"");
        Matcher xdigit = Pattern.compile((String)"\\p{XDigit}").matcher((CharSequence)"");
        Matcher space = Pattern.compile((String)"\\p{Space}").matcher((CharSequence)"");
        Matcher bound = Pattern.compile((String)"\\b").matcher((CharSequence)"");
        Matcher word = Pattern.compile((String)"\\w++").matcher((CharSequence)"");
        Matcher lowerU = Pattern.compile((String)"\\p{Lower}", (int)256).matcher((CharSequence)"");
        Matcher upperU = Pattern.compile((String)"\\p{Upper}", (int)256).matcher((CharSequence)"");
        Matcher ASCIIU = Pattern.compile((String)"\\p{ASCII}", (int)256).matcher((CharSequence)"");
        Matcher alphaU = Pattern.compile((String)"\\p{Alpha}", (int)256).matcher((CharSequence)"");
        Matcher digitU = Pattern.compile((String)"\\p{Digit}", (int)256).matcher((CharSequence)"");
        Matcher alnumU = Pattern.compile((String)"\\p{Alnum}", (int)256).matcher((CharSequence)"");
        Matcher punctU = Pattern.compile((String)"\\p{Punct}", (int)256).matcher((CharSequence)"");
        Matcher graphU = Pattern.compile((String)"\\p{Graph}", (int)256).matcher((CharSequence)"");
        Matcher printU = Pattern.compile((String)"\\p{Print}", (int)256).matcher((CharSequence)"");
        Matcher blankU = Pattern.compile((String)"\\p{Blank}", (int)256).matcher((CharSequence)"");
        Matcher cntrlU = Pattern.compile((String)"\\p{Cntrl}", (int)256).matcher((CharSequence)"");
        Matcher xdigitU = Pattern.compile((String)"\\p{XDigit}", (int)256).matcher((CharSequence)"");
        Matcher spaceU = Pattern.compile((String)"\\p{Space}", (int)256).matcher((CharSequence)"");
        Matcher boundU = Pattern.compile((String)"\\b", (int)256).matcher((CharSequence)"");
        Matcher wordU = Pattern.compile((String)"\\w", (int)256).matcher((CharSequence)"");
        Matcher lowerEU = Pattern.compile((String)"(?U)\\p{Lower}", (int)256).matcher((CharSequence)"");
        Matcher graphEU = Pattern.compile((String)"(?U)\\p{Graph}", (int)256).matcher((CharSequence)"");
        Matcher wordEU = Pattern.compile((String)"(?U)\\w", (int)256).matcher((CharSequence)"");
        Matcher bwb = Pattern.compile((String)"\\b\\w\\b").matcher((CharSequence)"");
        Matcher bwbU = Pattern.compile((String)"\\b\\w++\\b", (int)256).matcher((CharSequence)"");
        Matcher bwbEU = Pattern.compile((String)"(?U)\\b\\w++\\b", (int)256).matcher((CharSequence)"");
        Matcher lowerP = Pattern.compile((String)"\\p{IsLowerCase}").matcher((CharSequence)"");
        Matcher upperP = Pattern.compile((String)"\\p{IsUpperCase}").matcher((CharSequence)"");
        Matcher titleP = Pattern.compile((String)"\\p{IsTitleCase}").matcher((CharSequence)"");
        Matcher letterP = Pattern.compile((String)"\\p{IsLetter}").matcher((CharSequence)"");
        Matcher alphaP = Pattern.compile((String)"\\p{IsAlphabetic}").matcher((CharSequence)"");
        Matcher ideogP = Pattern.compile((String)"\\p{IsIdeographic}").matcher((CharSequence)"");
        Matcher cntrlP = Pattern.compile((String)"\\p{IsControl}").matcher((CharSequence)"");
        Matcher spaceP = Pattern.compile((String)"\\p{IsWhiteSpace}").matcher((CharSequence)"");
        Matcher definedP = Pattern.compile((String)"\\p{IsAssigned}").matcher((CharSequence)"");
        Matcher nonCCPP = Pattern.compile((String)"\\p{IsNoncharacterCodePoint}").matcher((CharSequence)"");
        Matcher joinCrtl = Pattern.compile((String)"\\p{IsJoinControl}").matcher((CharSequence)"");
        Matcher lowerJ = Pattern.compile((String)"\\p{javaLowerCase}").matcher((CharSequence)"");
        Matcher upperJ = Pattern.compile((String)"\\p{javaUpperCase}").matcher((CharSequence)"");
        Matcher alphaJ = Pattern.compile((String)"\\p{javaAlphabetic}").matcher((CharSequence)"");
        Matcher ideogJ = Pattern.compile((String)"\\p{javaIdeographic}").matcher((CharSequence)"");
        for (int cp = 1; cp < 196608; ++cp) {
            String str = new String(Character.toChars(cp));
            int type = Character.getType(cp);
            if (POSIX_ASCII.isLower(cp) == lower.reset((CharSequence)str).matches() && Character.isLowerCase(cp) == lowerU.reset((CharSequence)str).matches() && Character.isLowerCase(cp) == lowerP.reset((CharSequence)str).matches() && Character.isLowerCase(cp) == lowerEU.reset((CharSequence)str).matches() && Character.isLowerCase(cp) == lowerJ.reset((CharSequence)str).matches() && POSIX_ASCII.isUpper(cp) == upper.reset((CharSequence)str).matches() && POSIX_Unicode.isUpper(cp) == upperU.reset((CharSequence)str).matches() && Character.isUpperCase(cp) == upperP.reset((CharSequence)str).matches() && Character.isUpperCase(cp) == upperJ.reset((CharSequence)str).matches() && POSIX_ASCII.isAlpha(cp) == alpha.reset((CharSequence)str).matches() && POSIX_Unicode.isAlpha(cp) == alphaU.reset((CharSequence)str).matches() && Character.isAlphabetic(cp) == alphaP.reset((CharSequence)str).matches() && Character.isAlphabetic(cp) == alphaJ.reset((CharSequence)str).matches() && POSIX_ASCII.isDigit(cp) == digit.reset((CharSequence)str).matches() && Character.isDigit(cp) == digitU.reset((CharSequence)str).matches() && POSIX_ASCII.isAlnum(cp) == alnum.reset((CharSequence)str).matches() && POSIX_Unicode.isAlnum(cp) == alnumU.reset((CharSequence)str).matches() && POSIX_ASCII.isPunct(cp) == punct.reset((CharSequence)str).matches() && POSIX_Unicode.isPunct(cp) == punctU.reset((CharSequence)str).matches() && POSIX_ASCII.isGraph(cp) == graph.reset((CharSequence)str).matches() && POSIX_Unicode.isGraph(cp) == graphU.reset((CharSequence)str).matches() && POSIX_Unicode.isGraph(cp) == graphEU.reset((CharSequence)str).matches() && POSIX_ASCII.isType(cp, 16384) == blank.reset((CharSequence)str).matches() && POSIX_Unicode.isBlank(cp) == blankU.reset((CharSequence)str).matches() && POSIX_ASCII.isPrint(cp) == print.reset((CharSequence)str).matches() && POSIX_Unicode.isPrint(cp) == printU.reset((CharSequence)str).matches() && POSIX_ASCII.isCntrl(cp) == cntrl.reset((CharSequence)str).matches() && POSIX_Unicode.isCntrl(cp) == cntrlU.reset((CharSequence)str).matches() && 15 == type == cntrlP.reset((CharSequence)str).matches() && POSIX_ASCII.isHexDigit(cp) == xdigit.reset((CharSequence)str).matches() && POSIX_Unicode.isHexDigit(cp) == xdigitU.reset((CharSequence)str).matches() && POSIX_ASCII.isSpace(cp) == space.reset((CharSequence)str).matches() && POSIX_Unicode.isSpace(cp) == spaceU.reset((CharSequence)str).matches() && POSIX_Unicode.isSpace(cp) == spaceP.reset((CharSequence)str).matches() && POSIX_ASCII.isWord(cp) == word.reset((CharSequence)str).matches() && POSIX_Unicode.isWord(cp) == wordU.reset((CharSequence)str).matches() && POSIX_Unicode.isWord(cp) == wordEU.reset((CharSequence)str).matches() && POSIX_ASCII.isWord(cp) == bwb.reset((CharSequence)str).matches() && POSIX_Unicode.isWord(cp) == bwbU.reset((CharSequence)str).matches() && Character.isTitleCase(cp) == titleP.reset((CharSequence)str).matches() && Character.isLetter(cp) == letterP.reset((CharSequence)str).matches() && Character.isIdeographic(cp) == ideogP.reset((CharSequence)str).matches() && Character.isIdeographic(cp) == ideogJ.reset((CharSequence)str).matches() && 0 == type != definedP.reset((CharSequence)str).matches() && POSIX_Unicode.isNoncharacterCodePoint(cp) == nonCCPP.reset((CharSequence)str).matches() && POSIX_Unicode.isJoinControl(cp) == joinCrtl.reset((CharSequence)str).matches()) continue;
            ++failCount;
        }
        RegExTest.twoFindIndexes(" \u0180sherman\u0400 ", bound, 1, 10);
        if (!bwbU.reset((CharSequence)"\u0180sherman\u0400").matches()) {
            ++failCount;
        }
        RegExTest.twoFindIndexes(" \u0180sh\u0345erman\u0400 ", bound, 1, 11);
        if (!bwbU.reset((CharSequence)"\u0180sh\u0345erman\u0400").matches()) {
            ++failCount;
        }
        RegExTest.twoFindIndexes(" \u0724\u0739\u0724 ", bound, 1, 4);
        if (!bwbU.reset((CharSequence)"\u0724\u0739\u0724").matches()) {
            ++failCount;
        }
        if (!bwbEU.reset((CharSequence)"\u0724\u0739\u0724").matches()) {
            ++failCount;
        }
        RegExTest.report("unicodePredefinedClasses");
    }

    private static void horizontalAndVerticalWSTest() {
        Matcher m;
        String c;
        int i;
        String hws = new String(new char[]{'\t', ' ', '\u00a0', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u202f', '\u205f', '\u3000'});
        String vws = new String(new char[]{'\n', '\u000b', '\f', '\r', '\u0085', '\u2028', '\u2029'});
        if (!Pattern.compile((String)"\\h+").matcher((CharSequence)hws).matches() || !Pattern.compile((String)"[\\h]+").matcher((CharSequence)hws).matches()) {
            ++failCount;
        }
        if (Pattern.compile((String)"\\H").matcher((CharSequence)hws).find() || Pattern.compile((String)"[\\H]").matcher((CharSequence)hws).find()) {
            ++failCount;
        }
        if (!Pattern.compile((String)"\\v+").matcher((CharSequence)vws).matches() || !Pattern.compile((String)"[\\v]+").matcher((CharSequence)vws).matches()) {
            ++failCount;
        }
        if (Pattern.compile((String)"\\V").matcher((CharSequence)vws).find() || Pattern.compile((String)"[\\V]").matcher((CharSequence)vws).find()) {
            ++failCount;
        }
        String prefix = "abcd";
        String suffix = "efgh";
        String ng = "A";
        for (i = 0; i < hws.length(); ++i) {
            c = String.valueOf(hws.charAt(i));
            m = Pattern.compile((String)"\\h").matcher((CharSequence)(prefix + c + suffix));
            if (!m.find() || !c.equals(m.group())) {
                ++failCount;
            }
            if (!(m = Pattern.compile((String)"[\\h]").matcher((CharSequence)(prefix + c + suffix))).find() || !c.equals(m.group())) {
                ++failCount;
            }
            if (!(m = Pattern.compile((String)"\\H").matcher((CharSequence)(hws.substring(0, i) + ng + hws.substring(i)))).find() || !ng.equals(m.group())) {
                ++failCount;
            }
            if ((m = Pattern.compile((String)"[\\H]").matcher((CharSequence)(hws.substring(0, i) + ng + hws.substring(i)))).find() && ng.equals(m.group())) continue;
            ++failCount;
        }
        for (i = 0; i < vws.length(); ++i) {
            c = String.valueOf(vws.charAt(i));
            m = Pattern.compile((String)"\\v").matcher((CharSequence)(prefix + c + suffix));
            if (!m.find() || !c.equals(m.group())) {
                ++failCount;
            }
            if (!(m = Pattern.compile((String)"[\\v]").matcher((CharSequence)(prefix + c + suffix))).find() || !c.equals(m.group())) {
                ++failCount;
            }
            if (!(m = Pattern.compile((String)"\\V").matcher((CharSequence)(vws.substring(0, i) + ng + vws.substring(i)))).find() || !ng.equals(m.group())) {
                ++failCount;
            }
            if ((m = Pattern.compile((String)"[\\V]").matcher((CharSequence)(vws.substring(0, i) + ng + vws.substring(i)))).find() && ng.equals(m.group())) continue;
            ++failCount;
        }
        if (!Pattern.compile((String)"[\\v-\\v]").matcher((CharSequence)String.valueOf('\u000b')).matches()) {
            ++failCount;
        }
        RegExTest.report("horizontalAndVerticalWSTest");
    }

    private static void linebreakTest() {
        String linebreaks = new String(new char[]{'\n', '\u000b', '\f', '\r', '\u0085', '\u2028', '\u2029'});
        String crnl = "\r\n";
        if (!Pattern.compile((String)"\\R+").matcher((CharSequence)linebreaks).matches() || !Pattern.compile((String)"\\R").matcher((CharSequence)crnl).matches() || Pattern.compile((String)"\\R\\R").matcher((CharSequence)crnl).matches()) {
            ++failCount;
        }
        RegExTest.report("linebreakTest");
    }

    private static void branchTest() {
        if (!(Pattern.compile((String)"(a)?bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)+bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)*bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)??bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)+?bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)*?bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)?+bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)++bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)*+bc|d").matcher((CharSequence)"d").find() && Pattern.compile((String)"(a)?bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)+bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)*bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)??bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)+?bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)*?bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)?+bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)++bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)*+bc|d").matcher((CharSequence)"d").matches() && Pattern.compile((String)"(a)?bc|de").matcher((CharSequence)"de").find() && Pattern.compile((String)"(a)??bc|de").matcher((CharSequence)"de").find() && Pattern.compile((String)"(a)?bc|de").matcher((CharSequence)"de").matches() && Pattern.compile((String)"(a)??bc|de").matcher((CharSequence)"de").matches())) {
            ++failCount;
        }
        RegExTest.report("branchTest");
    }

    private static void groupCurlyNotFoundSuppTest() {
        String input = "test this as \ud83d\ude0d";
        for (String pStr : new String[]{"test(.)+(@[a-zA-Z.]+)", "test(.)*(@[a-zA-Z.]+)", "test([^B])+(@[a-zA-Z.]+)", "test([^B])*(@[a-zA-Z.]+)", "test(\\P{IsControl})+(@[a-zA-Z.]+)", "test(\\P{IsControl})*(@[a-zA-Z.]+)"}) {
            Matcher m = Pattern.compile((String)pStr, (int)2).matcher((CharSequence)input);
            try {
                if (!m.find()) continue;
                ++failCount;
            }
            catch (Exception x) {
                ++failCount;
            }
        }
        RegExTest.report("GroupCurly NotFoundSupp");
    }

    private static void groupCurlyBackoffTest() {
        if (!"abc1c".matches("(\\w)+1\\1") || "abc11".matches("(\\w)+1\\1")) {
            ++failCount;
        }
        RegExTest.report("GroupCurly backoff");
    }
}

