/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.std.RedBlackTree;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import java.util.Iterator;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;

public class RedBlackTreeTest {
    @Test
    public void testAddAndGet() {
        Rnd rnd = new Rnd();
        TreeSet<Long> control = new TreeSet<Long>();
        try (RedBlackTree tree = new RedBlackTree(new RedBlackTree.LongComparator(){
            private long left;

            public int compare(long y) {
                return Long.compare(this.left, y);
            }

            public void setLeft(long left) {
                this.left = left;
            }
        }, 1024);){
            for (int i = 0; i < 10000; ++i) {
                long l = rnd.nextLong();
                tree.add(l);
                control.add(l);
            }
            Iterator controlIterator = control.iterator();
            RedBlackTree.LongIterator iterator = tree.iterator();
            while (iterator.hasNext()) {
                Assert.assertTrue((boolean)controlIterator.hasNext());
                Assert.assertEquals((long)((Long)controlIterator.next()), (long)iterator.next());
            }
            tree.clear();
            Assert.assertFalse((boolean)tree.iterator().hasNext());
        }
    }

    @Test
    public void testNonUnique() {
        try (RedBlackTree set = new RedBlackTree(new RedBlackTree.LongComparator(){
            private long left;

            public int compare(long y) {
                return Long.compare(this.left, y);
            }

            public void setLeft(long left) {
                this.left = left;
            }
        }, 1024);){
            set.add(200L);
            set.add(200L);
            set.add(100L);
            set.add(100L);
            RedBlackTree.LongIterator iterator = set.iterator();
            StringBuilder b = new StringBuilder();
            while (iterator.hasNext()) {
                b.append(iterator.next()).append(',');
            }
            TestUtils.assertEquals((CharSequence)"100,100,200,200,", b);
        }
    }
}

