/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.ql.RecordSource;
import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.MetadataTypeResolver;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.ql.map.RecordKeyCopierCompiler;
import com.questdb.ql.map.TypeListResolver;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.IntList;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.factory.ReaderFactory;
import org.junit.Assert;
import org.junit.Test;

public class RecordKeyCopierCompilerTest
extends AbstractOptimiserTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompiler() throws Exception {
        try (JournalWriter w = compiler.createWriter(FACTORY_CONTAINER.getFactory(), (CharSequence)"create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING, y BOOLEAN) timestamp(t) partition by MONTH record hint 100");){
            JournalEntryWriter ew = w.entryWriter();
            IntList keyColumns = new IntList();
            ew.putInt(0, 12345);
            keyColumns.add(0);
            ew.put(1, (byte)-128);
            keyColumns.add(1);
            ew.putShort(2, (short)6500);
            keyColumns.add(2);
            ew.putLong(3, 123456789L);
            keyColumns.add(3);
            ew.putFloat(4, 0.345f);
            keyColumns.add(4);
            ew.putDouble(5, 0.123456789);
            keyColumns.add(5);
            ew.putDate(6, 10000000000L);
            keyColumns.add(6);
            ew.putSym(9, (CharSequence)"xyz");
            keyColumns.add(9);
            ew.putStr(10, (CharSequence)"abc");
            keyColumns.add(10);
            ew.putBool(11, true);
            keyColumns.add(11);
            ew.append();
            w.commit();
            try (RecordSource src = this.compileSource("x");){
                RecordKeyCopierCompiler cc = new RecordKeyCopierCompiler(new BytecodeAssembler());
                RecordKeyCopier copier = cc.compile(src.getMetadata(), keyColumns);
                IntList valueTypes = new IntList();
                valueTypes.add(6);
                MetadataTypeResolver metadataTypeResolver = new MetadataTypeResolver();
                TypeListResolver typeListResolver = new TypeListResolver();
                try (DirectMap map = new DirectMap(1024, (ColumnTypeResolver)metadataTypeResolver.of(src.getMetadata(), keyColumns), (ColumnTypeResolver)typeListResolver.of(valueTypes));){
                    RecordCursor cursor = src.prepareCursor((ReaderFactory)FACTORY_CONTAINER.getFactory());
                    try {
                        DirectMap.KeyWriter kw;
                        Record r;
                        while (cursor.hasNext()) {
                            r = (Record)cursor.next();
                            kw = map.keyWriter();
                            copier.copy(r, kw);
                            DirectMapValues val = map.getOrCreateValues();
                            val.putDouble(0, 5000.01);
                        }
                        cursor.toTop();
                        while (cursor.hasNext()) {
                            r = (Record)cursor.next();
                            kw = map.keyWriter();
                            copier.copy(r, kw);
                            Assert.assertEquals((double)map.getValues().getDouble(0), (double)5000.01, (double)1.0E-8);
                        }
                    }
                    finally {
                        cursor.releaseCursor();
                    }
                }
            }
        }
    }
}

